package ccc

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListMedias invokes the ccc.ListMedias API synchronously
// api document: https://help.aliyun.com/api/ccc/listmedias.html
func (client *Client) ListMedias(request *ListMediasRequest) (response *ListMediasResponse, err error) {
	response = CreateListMediasResponse()
	err = client.DoAction(request, response)
	return
}

// ListMediasWithChan invokes the ccc.ListMedias API asynchronously
// api document: https://help.aliyun.com/api/ccc/listmedias.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) ListMediasWithChan(request *ListMediasRequest) (<-chan *ListMediasResponse, <-chan error) {
	responseChan := make(chan *ListMediasResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListMedias(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListMediasWithCallback invokes the ccc.ListMedias API asynchronously
// api document: https://help.aliyun.com/api/ccc/listmedias.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) ListMediasWithCallback(request *ListMediasRequest, callback func(response *ListMediasResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListMediasResponse
		var err error
		defer close(result)
		response, err = client.ListMedias(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListMediasRequest is the request struct for api ListMedias
type ListMediasRequest struct {
	*requests.RpcRequest
	InstanceId string           `position:"Query" name:"InstanceId"`
	PageSize   requests.Integer `position:"Query" name:"PageSize"`
	NamePrefix string           `position:"Query" name:"NamePrefix"`
	PageNumber requests.Integer `position:"Query" name:"PageNumber"`
}

// ListMediasResponse is the response struct for api ListMedias
type ListMediasResponse struct {
	*responses.BaseResponse
	RequestId      string `json:"RequestId" xml:"RequestId"`
	Success        bool   `json:"Success" xml:"Success"`
	Code           string `json:"Code" xml:"Code"`
	Message        string `json:"Message" xml:"Message"`
	HttpStatusCode int    `json:"HttpStatusCode" xml:"HttpStatusCode"`
	Medias         Medias `json:"Medias" xml:"Medias"`
}

// CreateListMediasRequest creates a request to invoke ListMedias API
func CreateListMediasRequest() (request *ListMediasRequest) {
	request = &ListMediasRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("CCC", "2017-07-05", "ListMedias", "", "")
	return
}

// CreateListMediasResponse creates a response to parse from ListMedias response
func CreateListMediasResponse() (response *ListMediasResponse) {
	response = &ListMediasResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
