package ccc

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetJobDataUploadParams invokes the ccc.GetJobDataUploadParams API synchronously
// api document: https://help.aliyun.com/api/ccc/getjobdatauploadparams.html
func (client *Client) GetJobDataUploadParams(request *GetJobDataUploadParamsRequest) (response *GetJobDataUploadParamsResponse, err error) {
	response = CreateGetJobDataUploadParamsResponse()
	err = client.DoAction(request, response)
	return
}

// GetJobDataUploadParamsWithChan invokes the ccc.GetJobDataUploadParams API asynchronously
// api document: https://help.aliyun.com/api/ccc/getjobdatauploadparams.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) GetJobDataUploadParamsWithChan(request *GetJobDataUploadParamsRequest) (<-chan *GetJobDataUploadParamsResponse, <-chan error) {
	responseChan := make(chan *GetJobDataUploadParamsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetJobDataUploadParams(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetJobDataUploadParamsWithCallback invokes the ccc.GetJobDataUploadParams API asynchronously
// api document: https://help.aliyun.com/api/ccc/getjobdatauploadparams.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) GetJobDataUploadParamsWithCallback(request *GetJobDataUploadParamsRequest, callback func(response *GetJobDataUploadParamsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetJobDataUploadParamsResponse
		var err error
		defer close(result)
		response, err = client.GetJobDataUploadParams(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetJobDataUploadParamsRequest is the request struct for api GetJobDataUploadParams
type GetJobDataUploadParamsRequest struct {
	*requests.RpcRequest
	InstanceId string `position:"Query" name:"InstanceId"`
	FileName   string `position:"Query" name:"FileName"`
}

// GetJobDataUploadParamsResponse is the response struct for api GetJobDataUploadParams
type GetJobDataUploadParamsResponse struct {
	*responses.BaseResponse
	RequestId      string       `json:"RequestId" xml:"RequestId"`
	Success        bool         `json:"Success" xml:"Success"`
	Code           string       `json:"Code" xml:"Code"`
	Message        string       `json:"Message" xml:"Message"`
	HttpStatusCode int          `json:"HttpStatusCode" xml:"HttpStatusCode"`
	UploadParams   UploadParams `json:"UploadParams" xml:"UploadParams"`
}

// CreateGetJobDataUploadParamsRequest creates a request to invoke GetJobDataUploadParams API
func CreateGetJobDataUploadParamsRequest() (request *GetJobDataUploadParamsRequest) {
	request = &GetJobDataUploadParamsRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("CCC", "2017-07-05", "GetJobDataUploadParams", "", "")
	return
}

// CreateGetJobDataUploadParamsResponse creates a response to parse from GetJobDataUploadParams response
func CreateGetJobDataUploadParamsResponse() (response *GetJobDataUploadParamsResponse) {
	response = &GetJobDataUploadParamsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
