package ccc

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// AddBulkPhoneNumbers invokes the ccc.AddBulkPhoneNumbers API synchronously
// api document: https://help.aliyun.com/api/ccc/addbulkphonenumbers.html
func (client *Client) AddBulkPhoneNumbers(request *AddBulkPhoneNumbersRequest) (response *AddBulkPhoneNumbersResponse, err error) {
	response = CreateAddBulkPhoneNumbersResponse()
	err = client.DoAction(request, response)
	return
}

// AddBulkPhoneNumbersWithChan invokes the ccc.AddBulkPhoneNumbers API asynchronously
// api document: https://help.aliyun.com/api/ccc/addbulkphonenumbers.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) AddBulkPhoneNumbersWithChan(request *AddBulkPhoneNumbersRequest) (<-chan *AddBulkPhoneNumbersResponse, <-chan error) {
	responseChan := make(chan *AddBulkPhoneNumbersResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.AddBulkPhoneNumbers(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// AddBulkPhoneNumbersWithCallback invokes the ccc.AddBulkPhoneNumbers API asynchronously
// api document: https://help.aliyun.com/api/ccc/addbulkphonenumbers.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) AddBulkPhoneNumbersWithCallback(request *AddBulkPhoneNumbersRequest, callback func(response *AddBulkPhoneNumbersResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *AddBulkPhoneNumbersResponse
		var err error
		defer close(result)
		response, err = client.AddBulkPhoneNumbers(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// AddBulkPhoneNumbersRequest is the request struct for api AddBulkPhoneNumbers
type AddBulkPhoneNumbersRequest struct {
	*requests.RpcRequest
	ContactFlowId string    `position:"Query" name:"ContactFlowId"`
	InstanceId    string    `position:"Query" name:"InstanceId"`
	Usage         string    `position:"Query" name:"Usage"`
	SkillGroupId  *[]string `position:"Query" name:"SkillGroupId"  type:"Repeated"`
	PhoneNumber   *[]string `position:"Query" name:"PhoneNumber"  type:"Repeated"`
}

// AddBulkPhoneNumbersResponse is the response struct for api AddBulkPhoneNumbers
type AddBulkPhoneNumbersResponse struct {
	*responses.BaseResponse
	RequestId             string                            `json:"RequestId" xml:"RequestId"`
	Success               bool                              `json:"Success" xml:"Success"`
	Code                  string                            `json:"Code" xml:"Code"`
	Message               string                            `json:"Message" xml:"Message"`
	HttpStatusCode        int                               `json:"HttpStatusCode" xml:"HttpStatusCode"`
	ArrearagePhoneNumbers ArrearagePhoneNumbers             `json:"ArrearagePhoneNumbers" xml:"ArrearagePhoneNumbers"`
	FailedPhoneNumbers    FailedPhoneNumbers                `json:"FailedPhoneNumbers" xml:"FailedPhoneNumbers"`
	UserdPhoneNumbers     UserdPhoneNumbers                 `json:"UserdPhoneNumbers" xml:"UserdPhoneNumbers"`
	PhoneNumbers          PhoneNumbersInAddBulkPhoneNumbers `json:"PhoneNumbers" xml:"PhoneNumbers"`
}

// CreateAddBulkPhoneNumbersRequest creates a request to invoke AddBulkPhoneNumbers API
func CreateAddBulkPhoneNumbersRequest() (request *AddBulkPhoneNumbersRequest) {
	request = &AddBulkPhoneNumbersRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("CCC", "2017-07-05", "AddBulkPhoneNumbers", "", "")
	return
}

// CreateAddBulkPhoneNumbersResponse creates a response to parse from AddBulkPhoneNumbers response
func CreateAddBulkPhoneNumbersResponse() (response *AddBulkPhoneNumbersResponse) {
	response = &AddBulkPhoneNumbersResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
