package baas

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DownloadAll invokes the baas.DownloadAll API synchronously
// api document: https://help.aliyun.com/api/baas/downloadall.html
func (client *Client) DownloadAll(request *DownloadAllRequest) (response *DownloadAllResponse, err error) {
	response = CreateDownloadAllResponse()
	err = client.DoAction(request, response)
	return
}

// DownloadAllWithChan invokes the baas.DownloadAll API asynchronously
// api document: https://help.aliyun.com/api/baas/downloadall.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DownloadAllWithChan(request *DownloadAllRequest) (<-chan *DownloadAllResponse, <-chan error) {
	responseChan := make(chan *DownloadAllResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DownloadAll(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DownloadAllWithCallback invokes the baas.DownloadAll API asynchronously
// api document: https://help.aliyun.com/api/baas/downloadall.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DownloadAllWithCallback(request *DownloadAllRequest, callback func(response *DownloadAllResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DownloadAllResponse
		var err error
		defer close(result)
		response, err = client.DownloadAll(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DownloadAllRequest is the request struct for api DownloadAll
type DownloadAllRequest struct {
	*requests.RpcRequest
	Bizid string `position:"Body" name:"Bizid"`
}

// DownloadAllResponse is the response struct for api DownloadAll
type DownloadAllResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Result    Result `json:"Result" xml:"Result"`
}

// CreateDownloadAllRequest creates a request to invoke DownloadAll API
func CreateDownloadAllRequest() (request *DownloadAllRequest) {
	request = &DownloadAllRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Baas", "2018-07-31", "DownloadAll", "", "")
	return
}

// CreateDownloadAllResponse creates a response to parse from DownloadAll response
func CreateDownloadAllResponse() (response *DownloadAllResponse) {
	response = &DownloadAllResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
