// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package redshift

import (
	"fmt"
	"time"

	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/awsutil"
	"github.com/aws/aws-sdk-go/aws/request"
	"github.com/aws/aws-sdk-go/private/protocol"
	"github.com/aws/aws-sdk-go/private/protocol/query"
)

const opAcceptReservedNodeExchange = "AcceptReservedNodeExchange"

// AcceptReservedNodeExchangeRequest generates a "aws/request.Request" representing the
// client's request for the AcceptReservedNodeExchange operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See AcceptReservedNodeExchange for more information on using the AcceptReservedNodeExchange
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the AcceptReservedNodeExchangeRequest method.
//    req, resp := client.AcceptReservedNodeExchangeRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/AcceptReservedNodeExchange
func (c *Redshift) AcceptReservedNodeExchangeRequest(input *AcceptReservedNodeExchangeInput) (req *request.Request, output *AcceptReservedNodeExchangeOutput) {
	op := &request.Operation{
		Name:       opAcceptReservedNodeExchange,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &AcceptReservedNodeExchangeInput{}
	}

	output = &AcceptReservedNodeExchangeOutput{}
	req = c.newRequest(op, input, output)
	return
}

// AcceptReservedNodeExchange API operation for Amazon Redshift.
//
// Exchanges a DC1 Reserved Node for a DC2 Reserved Node with no changes to
// the configuration (term, payment type, or number of nodes) and no additional
// costs.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Redshift's
// API operation AcceptReservedNodeExchange for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeReservedNodeNotFoundFault "ReservedNodeNotFound"
//   The specified reserved compute node not found.
//
//   * ErrCodeInvalidReservedNodeStateFault "InvalidReservedNodeState"
//   Indicates that the Reserved Node being exchanged is not in an active state.
//
//   * ErrCodeReservedNodeAlreadyMigratedFault "ReservedNodeAlreadyMigrated"
//   Indicates that the reserved node has already been exchanged.
//
//   * ErrCodeReservedNodeOfferingNotFoundFault "ReservedNodeOfferingNotFound"
//   Specified offering does not exist.
//
//   * ErrCodeUnsupportedOperationFault "UnsupportedOperation"
//   The requested operation isn't supported.
//
//   * ErrCodeDependentServiceUnavailableFault "DependentServiceUnavailableFault"
//   Your request cannot be completed because a dependent internal service is
//   temporarily unavailable. Wait 30 to 60 seconds and try again.
//
//   * ErrCodeReservedNodeAlreadyExistsFault "ReservedNodeAlreadyExists"
//   User already has a reservation with the given identifier.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/AcceptReservedNodeExchange
func (c *Redshift) AcceptReservedNodeExchange(input *AcceptReservedNodeExchangeInput) (*AcceptReservedNodeExchangeOutput, error) {
	req, out := c.AcceptReservedNodeExchangeRequest(input)
	return out, req.Send()
}

// AcceptReservedNodeExchangeWithContext is the same as AcceptReservedNodeExchange with the addition of
// the ability to pass a context and additional request options.
//
// See AcceptReservedNodeExchange for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Redshift) AcceptReservedNodeExchangeWithContext(ctx aws.Context, input *AcceptReservedNodeExchangeInput, opts ...request.Option) (*AcceptReservedNodeExchangeOutput, error) {
	req, out := c.AcceptReservedNodeExchangeRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opAuthorizeClusterSecurityGroupIngress = "AuthorizeClusterSecurityGroupIngress"

// AuthorizeClusterSecurityGroupIngressRequest generates a "aws/request.Request" representing the
// client's request for the AuthorizeClusterSecurityGroupIngress operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See AuthorizeClusterSecurityGroupIngress for more information on using the AuthorizeClusterSecurityGroupIngress
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the AuthorizeClusterSecurityGroupIngressRequest method.
//    req, resp := client.AuthorizeClusterSecurityGroupIngressRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/AuthorizeClusterSecurityGroupIngress
func (c *Redshift) AuthorizeClusterSecurityGroupIngressRequest(input *AuthorizeClusterSecurityGroupIngressInput) (req *request.Request, output *AuthorizeClusterSecurityGroupIngressOutput) {
	op := &request.Operation{
		Name:       opAuthorizeClusterSecurityGroupIngress,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &AuthorizeClusterSecurityGroupIngressInput{}
	}

	output = &AuthorizeClusterSecurityGroupIngressOutput{}
	req = c.newRequest(op, input, output)
	return
}

// AuthorizeClusterSecurityGroupIngress API operation for Amazon Redshift.
//
// Adds an inbound (ingress) rule to an Amazon Redshift security group. Depending
// on whether the application accessing your cluster is running on the Internet
// or an Amazon EC2 instance, you can authorize inbound access to either a Classless
// Interdomain Routing (CIDR)/Internet Protocol (IP) range or to an Amazon EC2
// security group. You can add as many as 20 ingress rules to an Amazon Redshift
// security group.
//
// If you authorize access to an Amazon EC2 security group, specify EC2SecurityGroupName
// and EC2SecurityGroupOwnerId. The Amazon EC2 security group and Amazon Redshift
// cluster must be in the same AWS Region.
//
// If you authorize access to a CIDR/IP address range, specify CIDRIP. For an
// overview of CIDR blocks, see the Wikipedia article on Classless Inter-Domain
// Routing (http://en.wikipedia.org/wiki/Classless_Inter-Domain_Routing).
//
// You must also associate the security group with a cluster so that clients
// running on these IP addresses or the EC2 instance are authorized to connect
// to the cluster. For information about managing security groups, go to Working
// with Security Groups (https://docs.aws.amazon.com/redshift/latest/mgmt/working-with-security-groups.html)
// in the Amazon Redshift Cluster Management Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Redshift's
// API operation AuthorizeClusterSecurityGroupIngress for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeClusterSecurityGroupNotFoundFault "ClusterSecurityGroupNotFound"
//   The cluster security group name does not refer to an existing cluster security
//   group.
//
//   * ErrCodeInvalidClusterSecurityGroupStateFault "InvalidClusterSecurityGroupState"
//   The state of the cluster security group is not available.
//
//   * ErrCodeAuthorizationAlreadyExistsFault "AuthorizationAlreadyExists"
//   The specified CIDR block or EC2 security group is already authorized for
//   the specified cluster security group.
//
//   * ErrCodeAuthorizationQuotaExceededFault "AuthorizationQuotaExceeded"
//   The authorization quota for the cluster security group has been reached.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/AuthorizeClusterSecurityGroupIngress
func (c *Redshift) AuthorizeClusterSecurityGroupIngress(input *AuthorizeClusterSecurityGroupIngressInput) (*AuthorizeClusterSecurityGroupIngressOutput, error) {
	req, out := c.AuthorizeClusterSecurityGroupIngressRequest(input)
	return out, req.Send()
}

// AuthorizeClusterSecurityGroupIngressWithContext is the same as AuthorizeClusterSecurityGroupIngress with the addition of
// the ability to pass a context and additional request options.
//
// See AuthorizeClusterSecurityGroupIngress for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Redshift) AuthorizeClusterSecurityGroupIngressWithContext(ctx aws.Context, input *AuthorizeClusterSecurityGroupIngressInput, opts ...request.Option) (*AuthorizeClusterSecurityGroupIngressOutput, error) {
	req, out := c.AuthorizeClusterSecurityGroupIngressRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opAuthorizeSnapshotAccess = "AuthorizeSnapshotAccess"

// AuthorizeSnapshotAccessRequest generates a "aws/request.Request" representing the
// client's request for the AuthorizeSnapshotAccess operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See AuthorizeSnapshotAccess for more information on using the AuthorizeSnapshotAccess
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the AuthorizeSnapshotAccessRequest method.
//    req, resp := client.AuthorizeSnapshotAccessRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/AuthorizeSnapshotAccess
func (c *Redshift) AuthorizeSnapshotAccessRequest(input *AuthorizeSnapshotAccessInput) (req *request.Request, output *AuthorizeSnapshotAccessOutput) {
	op := &request.Operation{
		Name:       opAuthorizeSnapshotAccess,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &AuthorizeSnapshotAccessInput{}
	}

	output = &AuthorizeSnapshotAccessOutput{}
	req = c.newRequest(op, input, output)
	return
}

// AuthorizeSnapshotAccess API operation for Amazon Redshift.
//
// Authorizes the specified AWS customer account to restore the specified snapshot.
//
// For more information about working with snapshots, go to Amazon Redshift
// Snapshots (https://docs.aws.amazon.com/redshift/latest/mgmt/working-with-snapshots.html)
// in the Amazon Redshift Cluster Management Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Redshift's
// API operation AuthorizeSnapshotAccess for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeClusterSnapshotNotFoundFault "ClusterSnapshotNotFound"
//   The snapshot identifier does not refer to an existing cluster snapshot.
//
//   * ErrCodeAuthorizationAlreadyExistsFault "AuthorizationAlreadyExists"
//   The specified CIDR block or EC2 security group is already authorized for
//   the specified cluster security group.
//
//   * ErrCodeAuthorizationQuotaExceededFault "AuthorizationQuotaExceeded"
//   The authorization quota for the cluster security group has been reached.
//
//   * ErrCodeDependentServiceRequestThrottlingFault "DependentServiceRequestThrottlingFault"
//   The request cannot be completed because a dependent service is throttling
//   requests made by Amazon Redshift on your behalf. Wait and retry the request.
//
//   * ErrCodeInvalidClusterSnapshotStateFault "InvalidClusterSnapshotState"
//   The specified cluster snapshot is not in the available state, or other accounts
//   are authorized to access the snapshot.
//
//   * ErrCodeLimitExceededFault "LimitExceededFault"
//   The encryption key has exceeded its grant limit in AWS KMS.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/AuthorizeSnapshotAccess
func (c *Redshift) AuthorizeSnapshotAccess(input *AuthorizeSnapshotAccessInput) (*AuthorizeSnapshotAccessOutput, error) {
	req, out := c.AuthorizeSnapshotAccessRequest(input)
	return out, req.Send()
}

// AuthorizeSnapshotAccessWithContext is the same as AuthorizeSnapshotAccess with the addition of
// the ability to pass a context and additional request options.
//
// See AuthorizeSnapshotAccess for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Redshift) AuthorizeSnapshotAccessWithContext(ctx aws.Context, input *AuthorizeSnapshotAccessInput, opts ...request.Option) (*AuthorizeSnapshotAccessOutput, error) {
	req, out := c.AuthorizeSnapshotAccessRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opBatchDeleteClusterSnapshots = "BatchDeleteClusterSnapshots"

// BatchDeleteClusterSnapshotsRequest generates a "aws/request.Request" representing the
// client's request for the BatchDeleteClusterSnapshots operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See BatchDeleteClusterSnapshots for more information on using the BatchDeleteClusterSnapshots
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the BatchDeleteClusterSnapshotsRequest method.
//    req, resp := client.BatchDeleteClusterSnapshotsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/BatchDeleteClusterSnapshots
func (c *Redshift) BatchDeleteClusterSnapshotsRequest(input *BatchDeleteClusterSnapshotsInput) (req *request.Request, output *BatchDeleteClusterSnapshotsOutput) {
	op := &request.Operation{
		Name:       opBatchDeleteClusterSnapshots,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &BatchDeleteClusterSnapshotsInput{}
	}

	output = &BatchDeleteClusterSnapshotsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// BatchDeleteClusterSnapshots API operation for Amazon Redshift.
//
// Deletes a set of cluster snapshots.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Redshift's
// API operation BatchDeleteClusterSnapshots for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeBatchDeleteRequestSizeExceededFault "BatchDeleteRequestSizeExceeded"
//   The maximum number for a batch delete of snapshots has been reached. The
//   limit is 100.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/BatchDeleteClusterSnapshots
func (c *Redshift) BatchDeleteClusterSnapshots(input *BatchDeleteClusterSnapshotsInput) (*BatchDeleteClusterSnapshotsOutput, error) {
	req, out := c.BatchDeleteClusterSnapshotsRequest(input)
	return out, req.Send()
}

// BatchDeleteClusterSnapshotsWithContext is the same as BatchDeleteClusterSnapshots with the addition of
// the ability to pass a context and additional request options.
//
// See BatchDeleteClusterSnapshots for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Redshift) BatchDeleteClusterSnapshotsWithContext(ctx aws.Context, input *BatchDeleteClusterSnapshotsInput, opts ...request.Option) (*BatchDeleteClusterSnapshotsOutput, error) {
	req, out := c.BatchDeleteClusterSnapshotsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opBatchModifyClusterSnapshots = "BatchModifyClusterSnapshots"

// BatchModifyClusterSnapshotsRequest generates a "aws/request.Request" representing the
// client's request for the BatchModifyClusterSnapshots operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See BatchModifyClusterSnapshots for more information on using the BatchModifyClusterSnapshots
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the BatchModifyClusterSnapshotsRequest method.
//    req, resp := client.BatchModifyClusterSnapshotsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/BatchModifyClusterSnapshots
func (c *Redshift) BatchModifyClusterSnapshotsRequest(input *BatchModifyClusterSnapshotsInput) (req *request.Request, output *BatchModifyClusterSnapshotsOutput) {
	op := &request.Operation{
		Name:       opBatchModifyClusterSnapshots,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &BatchModifyClusterSnapshotsInput{}
	}

	output = &BatchModifyClusterSnapshotsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// BatchModifyClusterSnapshots API operation for Amazon Redshift.
//
// Modifies the settings for a set of cluster snapshots.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Redshift's
// API operation BatchModifyClusterSnapshots for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidRetentionPeriodFault "InvalidRetentionPeriodFault"
//   The retention period specified is either in the past or is not a valid value.
//
//   The value must be either -1 or an integer between 1 and 3,653.
//
//   * ErrCodeBatchModifyClusterSnapshotsLimitExceededFault "BatchModifyClusterSnapshotsLimitExceededFault"
//   The maximum number for snapshot identifiers has been reached. The limit is
//   100.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/BatchModifyClusterSnapshots
func (c *Redshift) BatchModifyClusterSnapshots(input *BatchModifyClusterSnapshotsInput) (*BatchModifyClusterSnapshotsOutput, error) {
	req, out := c.BatchModifyClusterSnapshotsRequest(input)
	return out, req.Send()
}

// BatchModifyClusterSnapshotsWithContext is the same as BatchModifyClusterSnapshots with the addition of
// the ability to pass a context and additional request options.
//
// See BatchModifyClusterSnapshots for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Redshift) BatchModifyClusterSnapshotsWithContext(ctx aws.Context, input *BatchModifyClusterSnapshotsInput, opts ...request.Option) (*BatchModifyClusterSnapshotsOutput, error) {
	req, out := c.BatchModifyClusterSnapshotsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCancelResize = "CancelResize"

// CancelResizeRequest generates a "aws/request.Request" representing the
// client's request for the CancelResize operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CancelResize for more information on using the CancelResize
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CancelResizeRequest method.
//    req, resp := client.CancelResizeRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/CancelResize
func (c *Redshift) CancelResizeRequest(input *CancelResizeInput) (req *request.Request, output *CancelResizeOutput) {
	op := &request.Operation{
		Name:       opCancelResize,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CancelResizeInput{}
	}

	output = &CancelResizeOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CancelResize API operation for Amazon Redshift.
//
// Cancels a resize operation for a cluster.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Redshift's
// API operation CancelResize for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeClusterNotFoundFault "ClusterNotFound"
//   The ClusterIdentifier parameter does not refer to an existing cluster.
//
//   * ErrCodeResizeNotFoundFault "ResizeNotFound"
//   A resize operation for the specified cluster is not found.
//
//   * ErrCodeInvalidClusterStateFault "InvalidClusterState"
//   The specified cluster is not in the available state.
//
//   * ErrCodeUnsupportedOperationFault "UnsupportedOperation"
//   The requested operation isn't supported.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/CancelResize
func (c *Redshift) CancelResize(input *CancelResizeInput) (*CancelResizeOutput, error) {
	req, out := c.CancelResizeRequest(input)
	return out, req.Send()
}

// CancelResizeWithContext is the same as CancelResize with the addition of
// the ability to pass a context and additional request options.
//
// See CancelResize for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Redshift) CancelResizeWithContext(ctx aws.Context, input *CancelResizeInput, opts ...request.Option) (*CancelResizeOutput, error) {
	req, out := c.CancelResizeRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCopyClusterSnapshot = "CopyClusterSnapshot"

// CopyClusterSnapshotRequest generates a "aws/request.Request" representing the
// client's request for the CopyClusterSnapshot operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CopyClusterSnapshot for more information on using the CopyClusterSnapshot
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CopyClusterSnapshotRequest method.
//    req, resp := client.CopyClusterSnapshotRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/CopyClusterSnapshot
func (c *Redshift) CopyClusterSnapshotRequest(input *CopyClusterSnapshotInput) (req *request.Request, output *CopyClusterSnapshotOutput) {
	op := &request.Operation{
		Name:       opCopyClusterSnapshot,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CopyClusterSnapshotInput{}
	}

	output = &CopyClusterSnapshotOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CopyClusterSnapshot API operation for Amazon Redshift.
//
// Copies the specified automated cluster snapshot to a new manual cluster snapshot.
// The source must be an automated snapshot and it must be in the available
// state.
//
// When you delete a cluster, Amazon Redshift deletes any automated snapshots
// of the cluster. Also, when the retention period of the snapshot expires,
// Amazon Redshift automatically deletes it. If you want to keep an automated
// snapshot for a longer period, you can make a manual copy of the snapshot.
// Manual snapshots are retained until you delete them.
//
// For more information about working with snapshots, go to Amazon Redshift
// Snapshots (https://docs.aws.amazon.com/redshift/latest/mgmt/working-with-snapshots.html)
// in the Amazon Redshift Cluster Management Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Redshift's
// API operation CopyClusterSnapshot for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeClusterSnapshotAlreadyExistsFault "ClusterSnapshotAlreadyExists"
//   The value specified as a snapshot identifier is already used by an existing
//   snapshot.
//
//   * ErrCodeClusterSnapshotNotFoundFault "ClusterSnapshotNotFound"
//   The snapshot identifier does not refer to an existing cluster snapshot.
//
//   * ErrCodeInvalidClusterSnapshotStateFault "InvalidClusterSnapshotState"
//   The specified cluster snapshot is not in the available state, or other accounts
//   are authorized to access the snapshot.
//
//   * ErrCodeClusterSnapshotQuotaExceededFault "ClusterSnapshotQuotaExceeded"
//   The request would result in the user exceeding the allowed number of cluster
//   snapshots.
//
//   * ErrCodeInvalidRetentionPeriodFault "InvalidRetentionPeriodFault"
//   The retention period specified is either in the past or is not a valid value.
//
//   The value must be either -1 or an integer between 1 and 3,653.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/CopyClusterSnapshot
func (c *Redshift) CopyClusterSnapshot(input *CopyClusterSnapshotInput) (*CopyClusterSnapshotOutput, error) {
	req, out := c.CopyClusterSnapshotRequest(input)
	return out, req.Send()
}

// CopyClusterSnapshotWithContext is the same as CopyClusterSnapshot with the addition of
// the ability to pass a context and additional request options.
//
// See CopyClusterSnapshot for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Redshift) CopyClusterSnapshotWithContext(ctx aws.Context, input *CopyClusterSnapshotInput, opts ...request.Option) (*CopyClusterSnapshotOutput, error) {
	req, out := c.CopyClusterSnapshotRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateCluster = "CreateCluster"

// CreateClusterRequest generates a "aws/request.Request" representing the
// client's request for the CreateCluster operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateCluster for more information on using the CreateCluster
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateClusterRequest method.
//    req, resp := client.CreateClusterRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/CreateCluster
func (c *Redshift) CreateClusterRequest(input *CreateClusterInput) (req *request.Request, output *CreateClusterOutput) {
	op := &request.Operation{
		Name:       opCreateCluster,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateClusterInput{}
	}

	output = &CreateClusterOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateCluster API operation for Amazon Redshift.
//
// Creates a new cluster with the specified parameters.
//
// To create a cluster in Virtual Private Cloud (VPC), you must provide a cluster
// subnet group name. The cluster subnet group identifies the subnets of your
// VPC that Amazon Redshift uses when creating the cluster. For more information
// about managing clusters, go to Amazon Redshift Clusters (https://docs.aws.amazon.com/redshift/latest/mgmt/working-with-clusters.html)
// in the Amazon Redshift Cluster Management Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Redshift's
// API operation CreateCluster for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeClusterAlreadyExistsFault "ClusterAlreadyExists"
//   The account already has a cluster with the given identifier.
//
//   * ErrCodeInsufficientClusterCapacityFault "InsufficientClusterCapacity"
//   The number of nodes specified exceeds the allotted capacity of the cluster.
//
//   * ErrCodeClusterParameterGroupNotFoundFault "ClusterParameterGroupNotFound"
//   The parameter group name does not refer to an existing parameter group.
//
//   * ErrCodeClusterSecurityGroupNotFoundFault "ClusterSecurityGroupNotFound"
//   The cluster security group name does not refer to an existing cluster security
//   group.
//
//   * ErrCodeClusterQuotaExceededFault "ClusterQuotaExceeded"
//   The request would exceed the allowed number of cluster instances for this
//   account. For information about increasing your quota, go to Limits in Amazon
//   Redshift (https://docs.aws.amazon.com/redshift/latest/mgmt/amazon-redshift-limits.html)
//   in the Amazon Redshift Cluster Management Guide.
//
//   * ErrCodeNumberOfNodesQuotaExceededFault "NumberOfNodesQuotaExceeded"
//   The operation would exceed the number of nodes allotted to the account. For
//   information about increasing your quota, go to Limits in Amazon Redshift
//   (https://docs.aws.amazon.com/redshift/latest/mgmt/amazon-redshift-limits.html)
//   in the Amazon Redshift Cluster Management Guide.
//
//   * ErrCodeNumberOfNodesPerClusterLimitExceededFault "NumberOfNodesPerClusterLimitExceeded"
//   The operation would exceed the number of nodes allowed for a cluster.
//
//   * ErrCodeClusterSubnetGroupNotFoundFault "ClusterSubnetGroupNotFoundFault"
//   The cluster subnet group name does not refer to an existing cluster subnet
//   group.
//
//   * ErrCodeInvalidVPCNetworkStateFault "InvalidVPCNetworkStateFault"
//   The cluster subnet group does not cover all Availability Zones.
//
//   * ErrCodeInvalidClusterSubnetGroupStateFault "InvalidClusterSubnetGroupStateFault"
//   The cluster subnet group cannot be deleted because it is in use.
//
//   * ErrCodeInvalidSubnet "InvalidSubnet"
//   The requested subnet is not valid, or not all of the subnets are in the same
//   VPC.
//
//   * ErrCodeUnauthorizedOperation "UnauthorizedOperation"
//   Your account is not authorized to perform the requested operation.
//
//   * ErrCodeHsmClientCertificateNotFoundFault "HsmClientCertificateNotFoundFault"
//   There is no Amazon Redshift HSM client certificate with the specified identifier.
//
//   * ErrCodeHsmConfigurationNotFoundFault "HsmConfigurationNotFoundFault"
//   There is no Amazon Redshift HSM configuration with the specified identifier.
//
//   * ErrCodeInvalidElasticIpFault "InvalidElasticIpFault"
//   The Elastic IP (EIP) is invalid or cannot be found.
//
//   * ErrCodeTagLimitExceededFault "TagLimitExceededFault"
//   You have exceeded the number of tags allowed.
//
//   * ErrCodeInvalidTagFault "InvalidTagFault"
//   The tag is invalid.
//
//   * ErrCodeLimitExceededFault "LimitExceededFault"
//   The encryption key has exceeded its grant limit in AWS KMS.
//
//   * ErrCodeDependentServiceRequestThrottlingFault "DependentServiceRequestThrottlingFault"
//   The request cannot be completed because a dependent service is throttling
//   requests made by Amazon Redshift on your behalf. Wait and retry the request.
//
//   * ErrCodeInvalidClusterTrackFault "InvalidClusterTrack"
//   The provided cluster track name is not valid.
//
//   * ErrCodeSnapshotScheduleNotFoundFault "SnapshotScheduleNotFound"
//   We could not find the specified snapshot schedule.
//
//   * ErrCodeInvalidRetentionPeriodFault "InvalidRetentionPeriodFault"
//   The retention period specified is either in the past or is not a valid value.
//
//   The value must be either -1 or an integer between 1 and 3,653.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/CreateCluster
func (c *Redshift) CreateCluster(input *CreateClusterInput) (*CreateClusterOutput, error) {
	req, out := c.CreateClusterRequest(input)
	return out, req.Send()
}

// CreateClusterWithContext is the same as CreateCluster with the addition of
// the ability to pass a context and additional request options.
//
// See CreateCluster for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Redshift) CreateClusterWithContext(ctx aws.Context, input *CreateClusterInput, opts ...request.Option) (*CreateClusterOutput, error) {
	req, out := c.CreateClusterRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateClusterParameterGroup = "CreateClusterParameterGroup"

// CreateClusterParameterGroupRequest generates a "aws/request.Request" representing the
// client's request for the CreateClusterParameterGroup operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateClusterParameterGroup for more information on using the CreateClusterParameterGroup
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateClusterParameterGroupRequest method.
//    req, resp := client.CreateClusterParameterGroupRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/CreateClusterParameterGroup
func (c *Redshift) CreateClusterParameterGroupRequest(input *CreateClusterParameterGroupInput) (req *request.Request, output *CreateClusterParameterGroupOutput) {
	op := &request.Operation{
		Name:       opCreateClusterParameterGroup,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateClusterParameterGroupInput{}
	}

	output = &CreateClusterParameterGroupOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateClusterParameterGroup API operation for Amazon Redshift.
//
// Creates an Amazon Redshift parameter group.
//
// Creating parameter groups is independent of creating clusters. You can associate
// a cluster with a parameter group when you create the cluster. You can also
// associate an existing cluster with a parameter group after the cluster is
// created by using ModifyCluster.
//
// Parameters in the parameter group define specific behavior that applies to
// the databases you create on the cluster. For more information about parameters
// and parameter groups, go to Amazon Redshift Parameter Groups (https://docs.aws.amazon.com/redshift/latest/mgmt/working-with-parameter-groups.html)
// in the Amazon Redshift Cluster Management Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Redshift's
// API operation CreateClusterParameterGroup for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeClusterParameterGroupQuotaExceededFault "ClusterParameterGroupQuotaExceeded"
//   The request would result in the user exceeding the allowed number of cluster
//   parameter groups. For information about increasing your quota, go to Limits
//   in Amazon Redshift (https://docs.aws.amazon.com/redshift/latest/mgmt/amazon-redshift-limits.html)
//   in the Amazon Redshift Cluster Management Guide.
//
//   * ErrCodeClusterParameterGroupAlreadyExistsFault "ClusterParameterGroupAlreadyExists"
//   A cluster parameter group with the same name already exists.
//
//   * ErrCodeTagLimitExceededFault "TagLimitExceededFault"
//   You have exceeded the number of tags allowed.
//
//   * ErrCodeInvalidTagFault "InvalidTagFault"
//   The tag is invalid.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/CreateClusterParameterGroup
func (c *Redshift) CreateClusterParameterGroup(input *CreateClusterParameterGroupInput) (*CreateClusterParameterGroupOutput, error) {
	req, out := c.CreateClusterParameterGroupRequest(input)
	return out, req.Send()
}

// CreateClusterParameterGroupWithContext is the same as CreateClusterParameterGroup with the addition of
// the ability to pass a context and additional request options.
//
// See CreateClusterParameterGroup for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Redshift) CreateClusterParameterGroupWithContext(ctx aws.Context, input *CreateClusterParameterGroupInput, opts ...request.Option) (*CreateClusterParameterGroupOutput, error) {
	req, out := c.CreateClusterParameterGroupRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateClusterSecurityGroup = "CreateClusterSecurityGroup"

// CreateClusterSecurityGroupRequest generates a "aws/request.Request" representing the
// client's request for the CreateClusterSecurityGroup operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateClusterSecurityGroup for more information on using the CreateClusterSecurityGroup
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateClusterSecurityGroupRequest method.
//    req, resp := client.CreateClusterSecurityGroupRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/CreateClusterSecurityGroup
func (c *Redshift) CreateClusterSecurityGroupRequest(input *CreateClusterSecurityGroupInput) (req *request.Request, output *CreateClusterSecurityGroupOutput) {
	op := &request.Operation{
		Name:       opCreateClusterSecurityGroup,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateClusterSecurityGroupInput{}
	}

	output = &CreateClusterSecurityGroupOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateClusterSecurityGroup API operation for Amazon Redshift.
//
// Creates a new Amazon Redshift security group. You use security groups to
// control access to non-VPC clusters.
//
// For information about managing security groups, go to Amazon Redshift Cluster
// Security Groups (https://docs.aws.amazon.com/redshift/latest/mgmt/working-with-security-groups.html)
// in the Amazon Redshift Cluster Management Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Redshift's
// API operation CreateClusterSecurityGroup for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeClusterSecurityGroupAlreadyExistsFault "ClusterSecurityGroupAlreadyExists"
//   A cluster security group with the same name already exists.
//
//   * ErrCodeClusterSecurityGroupQuotaExceededFault "QuotaExceeded.ClusterSecurityGroup"
//   The request would result in the user exceeding the allowed number of cluster
//   security groups. For information about increasing your quota, go to Limits
//   in Amazon Redshift (https://docs.aws.amazon.com/redshift/latest/mgmt/amazon-redshift-limits.html)
//   in the Amazon Redshift Cluster Management Guide.
//
//   * ErrCodeTagLimitExceededFault "TagLimitExceededFault"
//   You have exceeded the number of tags allowed.
//
//   * ErrCodeInvalidTagFault "InvalidTagFault"
//   The tag is invalid.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/CreateClusterSecurityGroup
func (c *Redshift) CreateClusterSecurityGroup(input *CreateClusterSecurityGroupInput) (*CreateClusterSecurityGroupOutput, error) {
	req, out := c.CreateClusterSecurityGroupRequest(input)
	return out, req.Send()
}

// CreateClusterSecurityGroupWithContext is the same as CreateClusterSecurityGroup with the addition of
// the ability to pass a context and additional request options.
//
// See CreateClusterSecurityGroup for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Redshift) CreateClusterSecurityGroupWithContext(ctx aws.Context, input *CreateClusterSecurityGroupInput, opts ...request.Option) (*CreateClusterSecurityGroupOutput, error) {
	req, out := c.CreateClusterSecurityGroupRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateClusterSnapshot = "CreateClusterSnapshot"

// CreateClusterSnapshotRequest generates a "aws/request.Request" representing the
// client's request for the CreateClusterSnapshot operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateClusterSnapshot for more information on using the CreateClusterSnapshot
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateClusterSnapshotRequest method.
//    req, resp := client.CreateClusterSnapshotRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/CreateClusterSnapshot
func (c *Redshift) CreateClusterSnapshotRequest(input *CreateClusterSnapshotInput) (req *request.Request, output *CreateClusterSnapshotOutput) {
	op := &request.Operation{
		Name:       opCreateClusterSnapshot,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateClusterSnapshotInput{}
	}

	output = &CreateClusterSnapshotOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateClusterSnapshot API operation for Amazon Redshift.
//
// Creates a manual snapshot of the specified cluster. The cluster must be in
// the available state.
//
// For more information about working with snapshots, go to Amazon Redshift
// Snapshots (https://docs.aws.amazon.com/redshift/latest/mgmt/working-with-snapshots.html)
// in the Amazon Redshift Cluster Management Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Redshift's
// API operation CreateClusterSnapshot for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeClusterSnapshotAlreadyExistsFault "ClusterSnapshotAlreadyExists"
//   The value specified as a snapshot identifier is already used by an existing
//   snapshot.
//
//   * ErrCodeInvalidClusterStateFault "InvalidClusterState"
//   The specified cluster is not in the available state.
//
//   * ErrCodeClusterNotFoundFault "ClusterNotFound"
//   The ClusterIdentifier parameter does not refer to an existing cluster.
//
//   * ErrCodeClusterSnapshotQuotaExceededFault "ClusterSnapshotQuotaExceeded"
//   The request would result in the user exceeding the allowed number of cluster
//   snapshots.
//
//   * ErrCodeTagLimitExceededFault "TagLimitExceededFault"
//   You have exceeded the number of tags allowed.
//
//   * ErrCodeInvalidTagFault "InvalidTagFault"
//   The tag is invalid.
//
//   * ErrCodeInvalidRetentionPeriodFault "InvalidRetentionPeriodFault"
//   The retention period specified is either in the past or is not a valid value.
//
//   The value must be either -1 or an integer between 1 and 3,653.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/CreateClusterSnapshot
func (c *Redshift) CreateClusterSnapshot(input *CreateClusterSnapshotInput) (*CreateClusterSnapshotOutput, error) {
	req, out := c.CreateClusterSnapshotRequest(input)
	return out, req.Send()
}

// CreateClusterSnapshotWithContext is the same as CreateClusterSnapshot with the addition of
// the ability to pass a context and additional request options.
//
// See CreateClusterSnapshot for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Redshift) CreateClusterSnapshotWithContext(ctx aws.Context, input *CreateClusterSnapshotInput, opts ...request.Option) (*CreateClusterSnapshotOutput, error) {
	req, out := c.CreateClusterSnapshotRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateClusterSubnetGroup = "CreateClusterSubnetGroup"

// CreateClusterSubnetGroupRequest generates a "aws/request.Request" representing the
// client's request for the CreateClusterSubnetGroup operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateClusterSubnetGroup for more information on using the CreateClusterSubnetGroup
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateClusterSubnetGroupRequest method.
//    req, resp := client.CreateClusterSubnetGroupRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/CreateClusterSubnetGroup
func (c *Redshift) CreateClusterSubnetGroupRequest(input *CreateClusterSubnetGroupInput) (req *request.Request, output *CreateClusterSubnetGroupOutput) {
	op := &request.Operation{
		Name:       opCreateClusterSubnetGroup,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateClusterSubnetGroupInput{}
	}

	output = &CreateClusterSubnetGroupOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateClusterSubnetGroup API operation for Amazon Redshift.
//
// Creates a new Amazon Redshift subnet group. You must provide a list of one
// or more subnets in your existing Amazon Virtual Private Cloud (Amazon VPC)
// when creating Amazon Redshift subnet group.
//
// For information about subnet groups, go to Amazon Redshift Cluster Subnet
// Groups (https://docs.aws.amazon.com/redshift/latest/mgmt/working-with-cluster-subnet-groups.html)
// in the Amazon Redshift Cluster Management Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Redshift's
// API operation CreateClusterSubnetGroup for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeClusterSubnetGroupAlreadyExistsFault "ClusterSubnetGroupAlreadyExists"
//   A ClusterSubnetGroupName is already used by an existing cluster subnet group.
//
//   * ErrCodeClusterSubnetGroupQuotaExceededFault "ClusterSubnetGroupQuotaExceeded"
//   The request would result in user exceeding the allowed number of cluster
//   subnet groups. For information about increasing your quota, go to Limits
//   in Amazon Redshift (https://docs.aws.amazon.com/redshift/latest/mgmt/amazon-redshift-limits.html)
//   in the Amazon Redshift Cluster Management Guide.
//
//   * ErrCodeClusterSubnetQuotaExceededFault "ClusterSubnetQuotaExceededFault"
//   The request would result in user exceeding the allowed number of subnets
//   in a cluster subnet groups. For information about increasing your quota,
//   go to Limits in Amazon Redshift (https://docs.aws.amazon.com/redshift/latest/mgmt/amazon-redshift-limits.html)
//   in the Amazon Redshift Cluster Management Guide.
//
//   * ErrCodeInvalidSubnet "InvalidSubnet"
//   The requested subnet is not valid, or not all of the subnets are in the same
//   VPC.
//
//   * ErrCodeUnauthorizedOperation "UnauthorizedOperation"
//   Your account is not authorized to perform the requested operation.
//
//   * ErrCodeTagLimitExceededFault "TagLimitExceededFault"
//   You have exceeded the number of tags allowed.
//
//   * ErrCodeInvalidTagFault "InvalidTagFault"
//   The tag is invalid.
//
//   * ErrCodeDependentServiceRequestThrottlingFault "DependentServiceRequestThrottlingFault"
//   The request cannot be completed because a dependent service is throttling
//   requests made by Amazon Redshift on your behalf. Wait and retry the request.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/CreateClusterSubnetGroup
func (c *Redshift) CreateClusterSubnetGroup(input *CreateClusterSubnetGroupInput) (*CreateClusterSubnetGroupOutput, error) {
	req, out := c.CreateClusterSubnetGroupRequest(input)
	return out, req.Send()
}

// CreateClusterSubnetGroupWithContext is the same as CreateClusterSubnetGroup with the addition of
// the ability to pass a context and additional request options.
//
// See CreateClusterSubnetGroup for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Redshift) CreateClusterSubnetGroupWithContext(ctx aws.Context, input *CreateClusterSubnetGroupInput, opts ...request.Option) (*CreateClusterSubnetGroupOutput, error) {
	req, out := c.CreateClusterSubnetGroupRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateEventSubscription = "CreateEventSubscription"

// CreateEventSubscriptionRequest generates a "aws/request.Request" representing the
// client's request for the CreateEventSubscription operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateEventSubscription for more information on using the CreateEventSubscription
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateEventSubscriptionRequest method.
//    req, resp := client.CreateEventSubscriptionRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/CreateEventSubscription
func (c *Redshift) CreateEventSubscriptionRequest(input *CreateEventSubscriptionInput) (req *request.Request, output *CreateEventSubscriptionOutput) {
	op := &request.Operation{
		Name:       opCreateEventSubscription,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateEventSubscriptionInput{}
	}

	output = &CreateEventSubscriptionOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateEventSubscription API operation for Amazon Redshift.
//
// Creates an Amazon Redshift event notification subscription. This action requires
// an ARN (Amazon Resource Name) of an Amazon SNS topic created by either the
// Amazon Redshift console, the Amazon SNS console, or the Amazon SNS API. To
// obtain an ARN with Amazon SNS, you must create a topic in Amazon SNS and
// subscribe to the topic. The ARN is displayed in the SNS console.
//
// You can specify the source type, and lists of Amazon Redshift source IDs,
// event categories, and event severities. Notifications will be sent for all
// events you want that match those criteria. For example, you can specify source
// type = cluster, source ID = my-cluster-1 and mycluster2, event categories
// = Availability, Backup, and severity = ERROR. The subscription will only
// send notifications for those ERROR events in the Availability and Backup
// categories for the specified clusters.
//
// If you specify both the source type and source IDs, such as source type =
// cluster and source identifier = my-cluster-1, notifications will be sent
// for all the cluster events for my-cluster-1. If you specify a source type
// but do not specify a source identifier, you will receive notice of the events
// for the objects of that type in your AWS account. If you do not specify either
// the SourceType nor the SourceIdentifier, you will be notified of events generated
// from all Amazon Redshift sources belonging to your AWS account. You must
// specify a source type if you specify a source ID.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Redshift's
// API operation CreateEventSubscription for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeEventSubscriptionQuotaExceededFault "EventSubscriptionQuotaExceeded"
//   The request would exceed the allowed number of event subscriptions for this
//   account. For information about increasing your quota, go to Limits in Amazon
//   Redshift (https://docs.aws.amazon.com/redshift/latest/mgmt/amazon-redshift-limits.html)
//   in the Amazon Redshift Cluster Management Guide.
//
//   * ErrCodeSubscriptionAlreadyExistFault "SubscriptionAlreadyExist"
//   There is already an existing event notification subscription with the specified
//   name.
//
//   * ErrCodeSNSInvalidTopicFault "SNSInvalidTopic"
//   Amazon SNS has responded that there is a problem with the specified Amazon
//   SNS topic.
//
//   * ErrCodeSNSNoAuthorizationFault "SNSNoAuthorization"
//   You do not have permission to publish to the specified Amazon SNS topic.
//
//   * ErrCodeSNSTopicArnNotFoundFault "SNSTopicArnNotFound"
//   An Amazon SNS topic with the specified Amazon Resource Name (ARN) does not
//   exist.
//
//   * ErrCodeSubscriptionEventIdNotFoundFault "SubscriptionEventIdNotFound"
//   An Amazon Redshift event with the specified event ID does not exist.
//
//   * ErrCodeSubscriptionCategoryNotFoundFault "SubscriptionCategoryNotFound"
//   The value specified for the event category was not one of the allowed values,
//   or it specified a category that does not apply to the specified source type.
//   The allowed values are Configuration, Management, Monitoring, and Security.
//
//   * ErrCodeSubscriptionSeverityNotFoundFault "SubscriptionSeverityNotFound"
//   The value specified for the event severity was not one of the allowed values,
//   or it specified a severity that does not apply to the specified source type.
//   The allowed values are ERROR and INFO.
//
//   * ErrCodeSourceNotFoundFault "SourceNotFound"
//   The specified Amazon Redshift event source could not be found.
//
//   * ErrCodeTagLimitExceededFault "TagLimitExceededFault"
//   You have exceeded the number of tags allowed.
//
//   * ErrCodeInvalidTagFault "InvalidTagFault"
//   The tag is invalid.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/CreateEventSubscription
func (c *Redshift) CreateEventSubscription(input *CreateEventSubscriptionInput) (*CreateEventSubscriptionOutput, error) {
	req, out := c.CreateEventSubscriptionRequest(input)
	return out, req.Send()
}

// CreateEventSubscriptionWithContext is the same as CreateEventSubscription with the addition of
// the ability to pass a context and additional request options.
//
// See CreateEventSubscription for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Redshift) CreateEventSubscriptionWithContext(ctx aws.Context, input *CreateEventSubscriptionInput, opts ...request.Option) (*CreateEventSubscriptionOutput, error) {
	req, out := c.CreateEventSubscriptionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateHsmClientCertificate = "CreateHsmClientCertificate"

// CreateHsmClientCertificateRequest generates a "aws/request.Request" representing the
// client's request for the CreateHsmClientCertificate operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateHsmClientCertificate for more information on using the CreateHsmClientCertificate
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateHsmClientCertificateRequest method.
//    req, resp := client.CreateHsmClientCertificateRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/CreateHsmClientCertificate
func (c *Redshift) CreateHsmClientCertificateRequest(input *CreateHsmClientCertificateInput) (req *request.Request, output *CreateHsmClientCertificateOutput) {
	op := &request.Operation{
		Name:       opCreateHsmClientCertificate,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateHsmClientCertificateInput{}
	}

	output = &CreateHsmClientCertificateOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateHsmClientCertificate API operation for Amazon Redshift.
//
// Creates an HSM client certificate that an Amazon Redshift cluster will use
// to connect to the client's HSM in order to store and retrieve the keys used
// to encrypt the cluster databases.
//
// The command returns a public key, which you must store in the HSM. In addition
// to creating the HSM certificate, you must create an Amazon Redshift HSM configuration
// that provides a cluster the information needed to store and use encryption
// keys in the HSM. For more information, go to Hardware Security Modules (https://docs.aws.amazon.com/redshift/latest/mgmt/working-with-HSM.html)
// in the Amazon Redshift Cluster Management Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Redshift's
// API operation CreateHsmClientCertificate for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeHsmClientCertificateAlreadyExistsFault "HsmClientCertificateAlreadyExistsFault"
//   There is already an existing Amazon Redshift HSM client certificate with
//   the specified identifier.
//
//   * ErrCodeHsmClientCertificateQuotaExceededFault "HsmClientCertificateQuotaExceededFault"
//   The quota for HSM client certificates has been reached. For information about
//   increasing your quota, go to Limits in Amazon Redshift (https://docs.aws.amazon.com/redshift/latest/mgmt/amazon-redshift-limits.html)
//   in the Amazon Redshift Cluster Management Guide.
//
//   * ErrCodeTagLimitExceededFault "TagLimitExceededFault"
//   You have exceeded the number of tags allowed.
//
//   * ErrCodeInvalidTagFault "InvalidTagFault"
//   The tag is invalid.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/CreateHsmClientCertificate
func (c *Redshift) CreateHsmClientCertificate(input *CreateHsmClientCertificateInput) (*CreateHsmClientCertificateOutput, error) {
	req, out := c.CreateHsmClientCertificateRequest(input)
	return out, req.Send()
}

// CreateHsmClientCertificateWithContext is the same as CreateHsmClientCertificate with the addition of
// the ability to pass a context and additional request options.
//
// See CreateHsmClientCertificate for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Redshift) CreateHsmClientCertificateWithContext(ctx aws.Context, input *CreateHsmClientCertificateInput, opts ...request.Option) (*CreateHsmClientCertificateOutput, error) {
	req, out := c.CreateHsmClientCertificateRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateHsmConfiguration = "CreateHsmConfiguration"

// CreateHsmConfigurationRequest generates a "aws/request.Request" representing the
// client's request for the CreateHsmConfiguration operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateHsmConfiguration for more information on using the CreateHsmConfiguration
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateHsmConfigurationRequest method.
//    req, resp := client.CreateHsmConfigurationRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/CreateHsmConfiguration
func (c *Redshift) CreateHsmConfigurationRequest(input *CreateHsmConfigurationInput) (req *request.Request, output *CreateHsmConfigurationOutput) {
	op := &request.Operation{
		Name:       opCreateHsmConfiguration,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateHsmConfigurationInput{}
	}

	output = &CreateHsmConfigurationOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateHsmConfiguration API operation for Amazon Redshift.
//
// Creates an HSM configuration that contains the information required by an
// Amazon Redshift cluster to store and use database encryption keys in a Hardware
// Security Module (HSM). After creating the HSM configuration, you can specify
// it as a parameter when creating a cluster. The cluster will then store its
// encryption keys in the HSM.
//
// In addition to creating an HSM configuration, you must also create an HSM
// client certificate. For more information, go to Hardware Security Modules
// (https://docs.aws.amazon.com/redshift/latest/mgmt/working-with-HSM.html)
// in the Amazon Redshift Cluster Management Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Redshift's
// API operation CreateHsmConfiguration for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeHsmConfigurationAlreadyExistsFault "HsmConfigurationAlreadyExistsFault"
//   There is already an existing Amazon Redshift HSM configuration with the specified
//   identifier.
//
//   * ErrCodeHsmConfigurationQuotaExceededFault "HsmConfigurationQuotaExceededFault"
//   The quota for HSM configurations has been reached. For information about
//   increasing your quota, go to Limits in Amazon Redshift (https://docs.aws.amazon.com/redshift/latest/mgmt/amazon-redshift-limits.html)
//   in the Amazon Redshift Cluster Management Guide.
//
//   * ErrCodeTagLimitExceededFault "TagLimitExceededFault"
//   You have exceeded the number of tags allowed.
//
//   * ErrCodeInvalidTagFault "InvalidTagFault"
//   The tag is invalid.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/CreateHsmConfiguration
func (c *Redshift) CreateHsmConfiguration(input *CreateHsmConfigurationInput) (*CreateHsmConfigurationOutput, error) {
	req, out := c.CreateHsmConfigurationRequest(input)
	return out, req.Send()
}

// CreateHsmConfigurationWithContext is the same as CreateHsmConfiguration with the addition of
// the ability to pass a context and additional request options.
//
// See CreateHsmConfiguration for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Redshift) CreateHsmConfigurationWithContext(ctx aws.Context, input *CreateHsmConfigurationInput, opts ...request.Option) (*CreateHsmConfigurationOutput, error) {
	req, out := c.CreateHsmConfigurationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateScheduledAction = "CreateScheduledAction"

// CreateScheduledActionRequest generates a "aws/request.Request" representing the
// client's request for the CreateScheduledAction operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateScheduledAction for more information on using the CreateScheduledAction
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateScheduledActionRequest method.
//    req, resp := client.CreateScheduledActionRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/CreateScheduledAction
func (c *Redshift) CreateScheduledActionRequest(input *CreateScheduledActionInput) (req *request.Request, output *CreateScheduledActionOutput) {
	op := &request.Operation{
		Name:       opCreateScheduledAction,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateScheduledActionInput{}
	}

	output = &CreateScheduledActionOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateScheduledAction API operation for Amazon Redshift.
//
// Creates a scheduled action. A scheduled action contains a schedule and an
// Amazon Redshift API action. For example, you can create a schedule of when
// to run the ResizeCluster API operation.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Redshift's
// API operation CreateScheduledAction for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeScheduledActionAlreadyExistsFault "ScheduledActionAlreadyExists"
//   The scheduled action already exists.
//
//   * ErrCodeScheduledActionQuotaExceededFault "ScheduledActionQuotaExceeded"
//   The quota for scheduled actions exceeded.
//
//   * ErrCodeScheduledActionTypeUnsupportedFault "ScheduledActionTypeUnsupported"
//   The action type specified for a scheduled action is not supported.
//
//   * ErrCodeInvalidScheduleFault "InvalidSchedule"
//   The schedule you submitted isn't valid.
//
//   * ErrCodeInvalidScheduledActionFault "InvalidScheduledAction"
//   The scheduled action is not valid.
//
//   * ErrCodeUnauthorizedOperation "UnauthorizedOperation"
//   Your account is not authorized to perform the requested operation.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/CreateScheduledAction
func (c *Redshift) CreateScheduledAction(input *CreateScheduledActionInput) (*CreateScheduledActionOutput, error) {
	req, out := c.CreateScheduledActionRequest(input)
	return out, req.Send()
}

// CreateScheduledActionWithContext is the same as CreateScheduledAction with the addition of
// the ability to pass a context and additional request options.
//
// See CreateScheduledAction for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Redshift) CreateScheduledActionWithContext(ctx aws.Context, input *CreateScheduledActionInput, opts ...request.Option) (*CreateScheduledActionOutput, error) {
	req, out := c.CreateScheduledActionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateSnapshotCopyGrant = "CreateSnapshotCopyGrant"

// CreateSnapshotCopyGrantRequest generates a "aws/request.Request" representing the
// client's request for the CreateSnapshotCopyGrant operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateSnapshotCopyGrant for more information on using the CreateSnapshotCopyGrant
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateSnapshotCopyGrantRequest method.
//    req, resp := client.CreateSnapshotCopyGrantRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/CreateSnapshotCopyGrant
func (c *Redshift) CreateSnapshotCopyGrantRequest(input *CreateSnapshotCopyGrantInput) (req *request.Request, output *CreateSnapshotCopyGrantOutput) {
	op := &request.Operation{
		Name:       opCreateSnapshotCopyGrant,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateSnapshotCopyGrantInput{}
	}

	output = &CreateSnapshotCopyGrantOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateSnapshotCopyGrant API operation for Amazon Redshift.
//
// Creates a snapshot copy grant that permits Amazon Redshift to use a customer
// master key (CMK) from AWS Key Management Service (AWS KMS) to encrypt copied
// snapshots in a destination region.
//
// For more information about managing snapshot copy grants, go to Amazon Redshift
// Database Encryption (https://docs.aws.amazon.com/redshift/latest/mgmt/working-with-db-encryption.html)
// in the Amazon Redshift Cluster Management Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Redshift's
// API operation CreateSnapshotCopyGrant for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeSnapshotCopyGrantAlreadyExistsFault "SnapshotCopyGrantAlreadyExistsFault"
//   The snapshot copy grant can't be created because a grant with the same name
//   already exists.
//
//   * ErrCodeSnapshotCopyGrantQuotaExceededFault "SnapshotCopyGrantQuotaExceededFault"
//   The AWS account has exceeded the maximum number of snapshot copy grants in
//   this region.
//
//   * ErrCodeLimitExceededFault "LimitExceededFault"
//   The encryption key has exceeded its grant limit in AWS KMS.
//
//   * ErrCodeTagLimitExceededFault "TagLimitExceededFault"
//   You have exceeded the number of tags allowed.
//
//   * ErrCodeInvalidTagFault "InvalidTagFault"
//   The tag is invalid.
//
//   * ErrCodeDependentServiceRequestThrottlingFault "DependentServiceRequestThrottlingFault"
//   The request cannot be completed because a dependent service is throttling
//   requests made by Amazon Redshift on your behalf. Wait and retry the request.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/CreateSnapshotCopyGrant
func (c *Redshift) CreateSnapshotCopyGrant(input *CreateSnapshotCopyGrantInput) (*CreateSnapshotCopyGrantOutput, error) {
	req, out := c.CreateSnapshotCopyGrantRequest(input)
	return out, req.Send()
}

// CreateSnapshotCopyGrantWithContext is the same as CreateSnapshotCopyGrant with the addition of
// the ability to pass a context and additional request options.
//
// See CreateSnapshotCopyGrant for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Redshift) CreateSnapshotCopyGrantWithContext(ctx aws.Context, input *CreateSnapshotCopyGrantInput, opts ...request.Option) (*CreateSnapshotCopyGrantOutput, error) {
	req, out := c.CreateSnapshotCopyGrantRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateSnapshotSchedule = "CreateSnapshotSchedule"

// CreateSnapshotScheduleRequest generates a "aws/request.Request" representing the
// client's request for the CreateSnapshotSchedule operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateSnapshotSchedule for more information on using the CreateSnapshotSchedule
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateSnapshotScheduleRequest method.
//    req, resp := client.CreateSnapshotScheduleRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/CreateSnapshotSchedule
func (c *Redshift) CreateSnapshotScheduleRequest(input *CreateSnapshotScheduleInput) (req *request.Request, output *CreateSnapshotScheduleOutput) {
	op := &request.Operation{
		Name:       opCreateSnapshotSchedule,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateSnapshotScheduleInput{}
	}

	output = &CreateSnapshotScheduleOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateSnapshotSchedule API operation for Amazon Redshift.
//
// Creates a snapshot schedule with the rate of every 12 hours.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Redshift's
// API operation CreateSnapshotSchedule for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeSnapshotScheduleAlreadyExistsFault "SnapshotScheduleAlreadyExists"
//   The specified snapshot schedule already exists.
//
//   * ErrCodeInvalidScheduleFault "InvalidSchedule"
//   The schedule you submitted isn't valid.
//
//   * ErrCodeSnapshotScheduleQuotaExceededFault "SnapshotScheduleQuotaExceeded"
//   You have exceeded the quota of snapshot schedules.
//
//   * ErrCodeTagLimitExceededFault "TagLimitExceededFault"
//   You have exceeded the number of tags allowed.
//
//   * ErrCodeScheduleDefinitionTypeUnsupportedFault "ScheduleDefinitionTypeUnsupported"
//   The definition you submitted is not supported.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/CreateSnapshotSchedule
func (c *Redshift) CreateSnapshotSchedule(input *CreateSnapshotScheduleInput) (*CreateSnapshotScheduleOutput, error) {
	req, out := c.CreateSnapshotScheduleRequest(input)
	return out, req.Send()
}

// CreateSnapshotScheduleWithContext is the same as CreateSnapshotSchedule with the addition of
// the ability to pass a context and additional request options.
//
// See CreateSnapshotSchedule for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Redshift) CreateSnapshotScheduleWithContext(ctx aws.Context, input *CreateSnapshotScheduleInput, opts ...request.Option) (*CreateSnapshotScheduleOutput, error) {
	req, out := c.CreateSnapshotScheduleRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateTags = "CreateTags"

// CreateTagsRequest generates a "aws/request.Request" representing the
// client's request for the CreateTags operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateTags for more information on using the CreateTags
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateTagsRequest method.
//    req, resp := client.CreateTagsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/CreateTags
func (c *Redshift) CreateTagsRequest(input *CreateTagsInput) (req *request.Request, output *CreateTagsOutput) {
	op := &request.Operation{
		Name:       opCreateTags,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateTagsInput{}
	}

	output = &CreateTagsOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(query.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// CreateTags API operation for Amazon Redshift.
//
// Adds tags to a cluster.
//
// A resource can have up to 50 tags. If you try to create more than 50 tags
// for a resource, you will receive an error and the attempt will fail.
//
// If you specify a key that already exists for the resource, the value for
// that key will be updated with the new value.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Redshift's
// API operation CreateTags for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeTagLimitExceededFault "TagLimitExceededFault"
//   You have exceeded the number of tags allowed.
//
//   * ErrCodeResourceNotFoundFault "ResourceNotFoundFault"
//   The resource could not be found.
//
//   * ErrCodeInvalidTagFault "InvalidTagFault"
//   The tag is invalid.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/CreateTags
func (c *Redshift) CreateTags(input *CreateTagsInput) (*CreateTagsOutput, error) {
	req, out := c.CreateTagsRequest(input)
	return out, req.Send()
}

// CreateTagsWithContext is the same as CreateTags with the addition of
// the ability to pass a context and additional request options.
//
// See CreateTags for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Redshift) CreateTagsWithContext(ctx aws.Context, input *CreateTagsInput, opts ...request.Option) (*CreateTagsOutput, error) {
	req, out := c.CreateTagsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteCluster = "DeleteCluster"

// DeleteClusterRequest generates a "aws/request.Request" representing the
// client's request for the DeleteCluster operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteCluster for more information on using the DeleteCluster
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteClusterRequest method.
//    req, resp := client.DeleteClusterRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/DeleteCluster
func (c *Redshift) DeleteClusterRequest(input *DeleteClusterInput) (req *request.Request, output *DeleteClusterOutput) {
	op := &request.Operation{
		Name:       opDeleteCluster,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteClusterInput{}
	}

	output = &DeleteClusterOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteCluster API operation for Amazon Redshift.
//
// Deletes a previously provisioned cluster without its final snapshot being
// created. A successful response from the web service indicates that the request
// was received correctly. Use DescribeClusters to monitor the status of the
// deletion. The delete operation cannot be canceled or reverted once submitted.
// For more information about managing clusters, go to Amazon Redshift Clusters
// (https://docs.aws.amazon.com/redshift/latest/mgmt/working-with-clusters.html)
// in the Amazon Redshift Cluster Management Guide.
//
// If you want to shut down the cluster and retain it for future use, set SkipFinalClusterSnapshot
// to false and specify a name for FinalClusterSnapshotIdentifier. You can later
// restore this snapshot to resume using the cluster. If a final cluster snapshot
// is requested, the status of the cluster will be "final-snapshot" while the
// snapshot is being taken, then it's "deleting" once Amazon Redshift begins
// deleting the cluster.
//
// For more information about managing clusters, go to Amazon Redshift Clusters
// (https://docs.aws.amazon.com/redshift/latest/mgmt/working-with-clusters.html)
// in the Amazon Redshift Cluster Management Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Redshift's
// API operation DeleteCluster for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeClusterNotFoundFault "ClusterNotFound"
//   The ClusterIdentifier parameter does not refer to an existing cluster.
//
//   * ErrCodeInvalidClusterStateFault "InvalidClusterState"
//   The specified cluster is not in the available state.
//
//   * ErrCodeClusterSnapshotAlreadyExistsFault "ClusterSnapshotAlreadyExists"
//   The value specified as a snapshot identifier is already used by an existing
//   snapshot.
//
//   * ErrCodeClusterSnapshotQuotaExceededFault "ClusterSnapshotQuotaExceeded"
//   The request would result in the user exceeding the allowed number of cluster
//   snapshots.
//
//   * ErrCodeInvalidRetentionPeriodFault "InvalidRetentionPeriodFault"
//   The retention period specified is either in the past or is not a valid value.
//
//   The value must be either -1 or an integer between 1 and 3,653.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/DeleteCluster
func (c *Redshift) DeleteCluster(input *DeleteClusterInput) (*DeleteClusterOutput, error) {
	req, out := c.DeleteClusterRequest(input)
	return out, req.Send()
}

// DeleteClusterWithContext is the same as DeleteCluster with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteCluster for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Redshift) DeleteClusterWithContext(ctx aws.Context, input *DeleteClusterInput, opts ...request.Option) (*DeleteClusterOutput, error) {
	req, out := c.DeleteClusterRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteClusterParameterGroup = "DeleteClusterParameterGroup"

// DeleteClusterParameterGroupRequest generates a "aws/request.Request" representing the
// client's request for the DeleteClusterParameterGroup operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteClusterParameterGroup for more information on using the DeleteClusterParameterGroup
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteClusterParameterGroupRequest method.
//    req, resp := client.DeleteClusterParameterGroupRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/DeleteClusterParameterGroup
func (c *Redshift) DeleteClusterParameterGroupRequest(input *DeleteClusterParameterGroupInput) (req *request.Request, output *DeleteClusterParameterGroupOutput) {
	op := &request.Operation{
		Name:       opDeleteClusterParameterGroup,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteClusterParameterGroupInput{}
	}

	output = &DeleteClusterParameterGroupOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(query.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteClusterParameterGroup API operation for Amazon Redshift.
//
// Deletes a specified Amazon Redshift parameter group.
//
// You cannot delete a parameter group if it is associated with a cluster.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Redshift's
// API operation DeleteClusterParameterGroup for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidClusterParameterGroupStateFault "InvalidClusterParameterGroupState"
//   The cluster parameter group action can not be completed because another task
//   is in progress that involves the parameter group. Wait a few moments and
//   try the operation again.
//
//   * ErrCodeClusterParameterGroupNotFoundFault "ClusterParameterGroupNotFound"
//   The parameter group name does not refer to an existing parameter group.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/DeleteClusterParameterGroup
func (c *Redshift) DeleteClusterParameterGroup(input *DeleteClusterParameterGroupInput) (*DeleteClusterParameterGroupOutput, error) {
	req, out := c.DeleteClusterParameterGroupRequest(input)
	return out, req.Send()
}

// DeleteClusterParameterGroupWithContext is the same as DeleteClusterParameterGroup with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteClusterParameterGroup for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Redshift) DeleteClusterParameterGroupWithContext(ctx aws.Context, input *DeleteClusterParameterGroupInput, opts ...request.Option) (*DeleteClusterParameterGroupOutput, error) {
	req, out := c.DeleteClusterParameterGroupRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteClusterSecurityGroup = "DeleteClusterSecurityGroup"

// DeleteClusterSecurityGroupRequest generates a "aws/request.Request" representing the
// client's request for the DeleteClusterSecurityGroup operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteClusterSecurityGroup for more information on using the DeleteClusterSecurityGroup
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteClusterSecurityGroupRequest method.
//    req, resp := client.DeleteClusterSecurityGroupRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/DeleteClusterSecurityGroup
func (c *Redshift) DeleteClusterSecurityGroupRequest(input *DeleteClusterSecurityGroupInput) (req *request.Request, output *DeleteClusterSecurityGroupOutput) {
	op := &request.Operation{
		Name:       opDeleteClusterSecurityGroup,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteClusterSecurityGroupInput{}
	}

	output = &DeleteClusterSecurityGroupOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(query.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteClusterSecurityGroup API operation for Amazon Redshift.
//
// Deletes an Amazon Redshift security group.
//
// You cannot delete a security group that is associated with any clusters.
// You cannot delete the default security group.
//
// For information about managing security groups, go to Amazon Redshift Cluster
// Security Groups (https://docs.aws.amazon.com/redshift/latest/mgmt/working-with-security-groups.html)
// in the Amazon Redshift Cluster Management Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Redshift's
// API operation DeleteClusterSecurityGroup for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidClusterSecurityGroupStateFault "InvalidClusterSecurityGroupState"
//   The state of the cluster security group is not available.
//
//   * ErrCodeClusterSecurityGroupNotFoundFault "ClusterSecurityGroupNotFound"
//   The cluster security group name does not refer to an existing cluster security
//   group.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/DeleteClusterSecurityGroup
func (c *Redshift) DeleteClusterSecurityGroup(input *DeleteClusterSecurityGroupInput) (*DeleteClusterSecurityGroupOutput, error) {
	req, out := c.DeleteClusterSecurityGroupRequest(input)
	return out, req.Send()
}

// DeleteClusterSecurityGroupWithContext is the same as DeleteClusterSecurityGroup with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteClusterSecurityGroup for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Redshift) DeleteClusterSecurityGroupWithContext(ctx aws.Context, input *DeleteClusterSecurityGroupInput, opts ...request.Option) (*DeleteClusterSecurityGroupOutput, error) {
	req, out := c.DeleteClusterSecurityGroupRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteClusterSnapshot = "DeleteClusterSnapshot"

// DeleteClusterSnapshotRequest generates a "aws/request.Request" representing the
// client's request for the DeleteClusterSnapshot operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteClusterSnapshot for more information on using the DeleteClusterSnapshot
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteClusterSnapshotRequest method.
//    req, resp := client.DeleteClusterSnapshotRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/DeleteClusterSnapshot
func (c *Redshift) DeleteClusterSnapshotRequest(input *DeleteClusterSnapshotInput) (req *request.Request, output *DeleteClusterSnapshotOutput) {
	op := &request.Operation{
		Name:       opDeleteClusterSnapshot,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteClusterSnapshotInput{}
	}

	output = &DeleteClusterSnapshotOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteClusterSnapshot API operation for Amazon Redshift.
//
// Deletes the specified manual snapshot. The snapshot must be in the available
// state, with no other users authorized to access the snapshot.
//
// Unlike automated snapshots, manual snapshots are retained even after you
// delete your cluster. Amazon Redshift does not delete your manual snapshots.
// You must delete manual snapshot explicitly to avoid getting charged. If other
// accounts are authorized to access the snapshot, you must revoke all of the
// authorizations before you can delete the snapshot.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Redshift's
// API operation DeleteClusterSnapshot for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidClusterSnapshotStateFault "InvalidClusterSnapshotState"
//   The specified cluster snapshot is not in the available state, or other accounts
//   are authorized to access the snapshot.
//
//   * ErrCodeClusterSnapshotNotFoundFault "ClusterSnapshotNotFound"
//   The snapshot identifier does not refer to an existing cluster snapshot.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/DeleteClusterSnapshot
func (c *Redshift) DeleteClusterSnapshot(input *DeleteClusterSnapshotInput) (*DeleteClusterSnapshotOutput, error) {
	req, out := c.DeleteClusterSnapshotRequest(input)
	return out, req.Send()
}

// DeleteClusterSnapshotWithContext is the same as DeleteClusterSnapshot with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteClusterSnapshot for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Redshift) DeleteClusterSnapshotWithContext(ctx aws.Context, input *DeleteClusterSnapshotInput, opts ...request.Option) (*DeleteClusterSnapshotOutput, error) {
	req, out := c.DeleteClusterSnapshotRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteClusterSubnetGroup = "DeleteClusterSubnetGroup"

// DeleteClusterSubnetGroupRequest generates a "aws/request.Request" representing the
// client's request for the DeleteClusterSubnetGroup operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteClusterSubnetGroup for more information on using the DeleteClusterSubnetGroup
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteClusterSubnetGroupRequest method.
//    req, resp := client.DeleteClusterSubnetGroupRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/DeleteClusterSubnetGroup
func (c *Redshift) DeleteClusterSubnetGroupRequest(input *DeleteClusterSubnetGroupInput) (req *request.Request, output *DeleteClusterSubnetGroupOutput) {
	op := &request.Operation{
		Name:       opDeleteClusterSubnetGroup,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteClusterSubnetGroupInput{}
	}

	output = &DeleteClusterSubnetGroupOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(query.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteClusterSubnetGroup API operation for Amazon Redshift.
//
// Deletes the specified cluster subnet group.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Redshift's
// API operation DeleteClusterSubnetGroup for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidClusterSubnetGroupStateFault "InvalidClusterSubnetGroupStateFault"
//   The cluster subnet group cannot be deleted because it is in use.
//
//   * ErrCodeInvalidClusterSubnetStateFault "InvalidClusterSubnetStateFault"
//   The state of the subnet is invalid.
//
//   * ErrCodeClusterSubnetGroupNotFoundFault "ClusterSubnetGroupNotFoundFault"
//   The cluster subnet group name does not refer to an existing cluster subnet
//   group.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/DeleteClusterSubnetGroup
func (c *Redshift) DeleteClusterSubnetGroup(input *DeleteClusterSubnetGroupInput) (*DeleteClusterSubnetGroupOutput, error) {
	req, out := c.DeleteClusterSubnetGroupRequest(input)
	return out, req.Send()
}

// DeleteClusterSubnetGroupWithContext is the same as DeleteClusterSubnetGroup with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteClusterSubnetGroup for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Redshift) DeleteClusterSubnetGroupWithContext(ctx aws.Context, input *DeleteClusterSubnetGroupInput, opts ...request.Option) (*DeleteClusterSubnetGroupOutput, error) {
	req, out := c.DeleteClusterSubnetGroupRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteEventSubscription = "DeleteEventSubscription"

// DeleteEventSubscriptionRequest generates a "aws/request.Request" representing the
// client's request for the DeleteEventSubscription operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteEventSubscription for more information on using the DeleteEventSubscription
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteEventSubscriptionRequest method.
//    req, resp := client.DeleteEventSubscriptionRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/DeleteEventSubscription
func (c *Redshift) DeleteEventSubscriptionRequest(input *DeleteEventSubscriptionInput) (req *request.Request, output *DeleteEventSubscriptionOutput) {
	op := &request.Operation{
		Name:       opDeleteEventSubscription,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteEventSubscriptionInput{}
	}

	output = &DeleteEventSubscriptionOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(query.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteEventSubscription API operation for Amazon Redshift.
//
// Deletes an Amazon Redshift event notification subscription.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Redshift's
// API operation DeleteEventSubscription for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeSubscriptionNotFoundFault "SubscriptionNotFound"
//   An Amazon Redshift event notification subscription with the specified name
//   does not exist.
//
//   * ErrCodeInvalidSubscriptionStateFault "InvalidSubscriptionStateFault"
//   The subscription request is invalid because it is a duplicate request. This
//   subscription request is already in progress.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/DeleteEventSubscription
func (c *Redshift) DeleteEventSubscription(input *DeleteEventSubscriptionInput) (*DeleteEventSubscriptionOutput, error) {
	req, out := c.DeleteEventSubscriptionRequest(input)
	return out, req.Send()
}

// DeleteEventSubscriptionWithContext is the same as DeleteEventSubscription with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteEventSubscription for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Redshift) DeleteEventSubscriptionWithContext(ctx aws.Context, input *DeleteEventSubscriptionInput, opts ...request.Option) (*DeleteEventSubscriptionOutput, error) {
	req, out := c.DeleteEventSubscriptionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteHsmClientCertificate = "DeleteHsmClientCertificate"

// DeleteHsmClientCertificateRequest generates a "aws/request.Request" representing the
// client's request for the DeleteHsmClientCertificate operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteHsmClientCertificate for more information on using the DeleteHsmClientCertificate
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteHsmClientCertificateRequest method.
//    req, resp := client.DeleteHsmClientCertificateRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/DeleteHsmClientCertificate
func (c *Redshift) DeleteHsmClientCertificateRequest(input *DeleteHsmClientCertificateInput) (req *request.Request, output *DeleteHsmClientCertificateOutput) {
	op := &request.Operation{
		Name:       opDeleteHsmClientCertificate,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteHsmClientCertificateInput{}
	}

	output = &DeleteHsmClientCertificateOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(query.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteHsmClientCertificate API operation for Amazon Redshift.
//
// Deletes the specified HSM client certificate.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Redshift's
// API operation DeleteHsmClientCertificate for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidHsmClientCertificateStateFault "InvalidHsmClientCertificateStateFault"
//   The specified HSM client certificate is not in the available state, or it
//   is still in use by one or more Amazon Redshift clusters.
//
//   * ErrCodeHsmClientCertificateNotFoundFault "HsmClientCertificateNotFoundFault"
//   There is no Amazon Redshift HSM client certificate with the specified identifier.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/DeleteHsmClientCertificate
func (c *Redshift) DeleteHsmClientCertificate(input *DeleteHsmClientCertificateInput) (*DeleteHsmClientCertificateOutput, error) {
	req, out := c.DeleteHsmClientCertificateRequest(input)
	return out, req.Send()
}

// DeleteHsmClientCertificateWithContext is the same as DeleteHsmClientCertificate with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteHsmClientCertificate for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Redshift) DeleteHsmClientCertificateWithContext(ctx aws.Context, input *DeleteHsmClientCertificateInput, opts ...request.Option) (*DeleteHsmClientCertificateOutput, error) {
	req, out := c.DeleteHsmClientCertificateRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteHsmConfiguration = "DeleteHsmConfiguration"

// DeleteHsmConfigurationRequest generates a "aws/request.Request" representing the
// client's request for the DeleteHsmConfiguration operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteHsmConfiguration for more information on using the DeleteHsmConfiguration
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteHsmConfigurationRequest method.
//    req, resp := client.DeleteHsmConfigurationRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/DeleteHsmConfiguration
func (c *Redshift) DeleteHsmConfigurationRequest(input *DeleteHsmConfigurationInput) (req *request.Request, output *DeleteHsmConfigurationOutput) {
	op := &request.Operation{
		Name:       opDeleteHsmConfiguration,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteHsmConfigurationInput{}
	}

	output = &DeleteHsmConfigurationOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(query.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteHsmConfiguration API operation for Amazon Redshift.
//
// Deletes the specified Amazon Redshift HSM configuration.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Redshift's
// API operation DeleteHsmConfiguration for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidHsmConfigurationStateFault "InvalidHsmConfigurationStateFault"
//   The specified HSM configuration is not in the available state, or it is still
//   in use by one or more Amazon Redshift clusters.
//
//   * ErrCodeHsmConfigurationNotFoundFault "HsmConfigurationNotFoundFault"
//   There is no Amazon Redshift HSM configuration with the specified identifier.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/DeleteHsmConfiguration
func (c *Redshift) DeleteHsmConfiguration(input *DeleteHsmConfigurationInput) (*DeleteHsmConfigurationOutput, error) {
	req, out := c.DeleteHsmConfigurationRequest(input)
	return out, req.Send()
}

// DeleteHsmConfigurationWithContext is the same as DeleteHsmConfiguration with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteHsmConfiguration for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Redshift) DeleteHsmConfigurationWithContext(ctx aws.Context, input *DeleteHsmConfigurationInput, opts ...request.Option) (*DeleteHsmConfigurationOutput, error) {
	req, out := c.DeleteHsmConfigurationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteScheduledAction = "DeleteScheduledAction"

// DeleteScheduledActionRequest generates a "aws/request.Request" representing the
// client's request for the DeleteScheduledAction operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteScheduledAction for more information on using the DeleteScheduledAction
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteScheduledActionRequest method.
//    req, resp := client.DeleteScheduledActionRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/DeleteScheduledAction
func (c *Redshift) DeleteScheduledActionRequest(input *DeleteScheduledActionInput) (req *request.Request, output *DeleteScheduledActionOutput) {
	op := &request.Operation{
		Name:       opDeleteScheduledAction,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteScheduledActionInput{}
	}

	output = &DeleteScheduledActionOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(query.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteScheduledAction API operation for Amazon Redshift.
//
// Deletes a scheduled action.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Redshift's
// API operation DeleteScheduledAction for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeScheduledActionNotFoundFault "ScheduledActionNotFound"
//   The scheduled action cannot be found.
//
//   * ErrCodeUnauthorizedOperation "UnauthorizedOperation"
//   Your account is not authorized to perform the requested operation.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/DeleteScheduledAction
func (c *Redshift) DeleteScheduledAction(input *DeleteScheduledActionInput) (*DeleteScheduledActionOutput, error) {
	req, out := c.DeleteScheduledActionRequest(input)
	return out, req.Send()
}

// DeleteScheduledActionWithContext is the same as DeleteScheduledAction with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteScheduledAction for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Redshift) DeleteScheduledActionWithContext(ctx aws.Context, input *DeleteScheduledActionInput, opts ...request.Option) (*DeleteScheduledActionOutput, error) {
	req, out := c.DeleteScheduledActionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteSnapshotCopyGrant = "DeleteSnapshotCopyGrant"

// DeleteSnapshotCopyGrantRequest generates a "aws/request.Request" representing the
// client's request for the DeleteSnapshotCopyGrant operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteSnapshotCopyGrant for more information on using the DeleteSnapshotCopyGrant
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteSnapshotCopyGrantRequest method.
//    req, resp := client.DeleteSnapshotCopyGrantRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/DeleteSnapshotCopyGrant
func (c *Redshift) DeleteSnapshotCopyGrantRequest(input *DeleteSnapshotCopyGrantInput) (req *request.Request, output *DeleteSnapshotCopyGrantOutput) {
	op := &request.Operation{
		Name:       opDeleteSnapshotCopyGrant,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteSnapshotCopyGrantInput{}
	}

	output = &DeleteSnapshotCopyGrantOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(query.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteSnapshotCopyGrant API operation for Amazon Redshift.
//
// Deletes the specified snapshot copy grant.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Redshift's
// API operation DeleteSnapshotCopyGrant for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidSnapshotCopyGrantStateFault "InvalidSnapshotCopyGrantStateFault"
//   The snapshot copy grant can't be deleted because it is used by one or more
//   clusters.
//
//   * ErrCodeSnapshotCopyGrantNotFoundFault "SnapshotCopyGrantNotFoundFault"
//   The specified snapshot copy grant can't be found. Make sure that the name
//   is typed correctly and that the grant exists in the destination region.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/DeleteSnapshotCopyGrant
func (c *Redshift) DeleteSnapshotCopyGrant(input *DeleteSnapshotCopyGrantInput) (*DeleteSnapshotCopyGrantOutput, error) {
	req, out := c.DeleteSnapshotCopyGrantRequest(input)
	return out, req.Send()
}

// DeleteSnapshotCopyGrantWithContext is the same as DeleteSnapshotCopyGrant with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteSnapshotCopyGrant for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Redshift) DeleteSnapshotCopyGrantWithContext(ctx aws.Context, input *DeleteSnapshotCopyGrantInput, opts ...request.Option) (*DeleteSnapshotCopyGrantOutput, error) {
	req, out := c.DeleteSnapshotCopyGrantRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteSnapshotSchedule = "DeleteSnapshotSchedule"

// DeleteSnapshotScheduleRequest generates a "aws/request.Request" representing the
// client's request for the DeleteSnapshotSchedule operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteSnapshotSchedule for more information on using the DeleteSnapshotSchedule
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteSnapshotScheduleRequest method.
//    req, resp := client.DeleteSnapshotScheduleRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/DeleteSnapshotSchedule
func (c *Redshift) DeleteSnapshotScheduleRequest(input *DeleteSnapshotScheduleInput) (req *request.Request, output *DeleteSnapshotScheduleOutput) {
	op := &request.Operation{
		Name:       opDeleteSnapshotSchedule,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteSnapshotScheduleInput{}
	}

	output = &DeleteSnapshotScheduleOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(query.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteSnapshotSchedule API operation for Amazon Redshift.
//
// Deletes a snapshot schedule.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Redshift's
// API operation DeleteSnapshotSchedule for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidClusterSnapshotScheduleStateFault "InvalidClusterSnapshotScheduleState"
//   The cluster snapshot schedule state is not valid.
//
//   * ErrCodeSnapshotScheduleNotFoundFault "SnapshotScheduleNotFound"
//   We could not find the specified snapshot schedule.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/DeleteSnapshotSchedule
func (c *Redshift) DeleteSnapshotSchedule(input *DeleteSnapshotScheduleInput) (*DeleteSnapshotScheduleOutput, error) {
	req, out := c.DeleteSnapshotScheduleRequest(input)
	return out, req.Send()
}

// DeleteSnapshotScheduleWithContext is the same as DeleteSnapshotSchedule with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteSnapshotSchedule for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Redshift) DeleteSnapshotScheduleWithContext(ctx aws.Context, input *DeleteSnapshotScheduleInput, opts ...request.Option) (*DeleteSnapshotScheduleOutput, error) {
	req, out := c.DeleteSnapshotScheduleRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteTags = "DeleteTags"

// DeleteTagsRequest generates a "aws/request.Request" representing the
// client's request for the DeleteTags operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteTags for more information on using the DeleteTags
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteTagsRequest method.
//    req, resp := client.DeleteTagsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/DeleteTags
func (c *Redshift) DeleteTagsRequest(input *DeleteTagsInput) (req *request.Request, output *DeleteTagsOutput) {
	op := &request.Operation{
		Name:       opDeleteTags,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteTagsInput{}
	}

	output = &DeleteTagsOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(query.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteTags API operation for Amazon Redshift.
//
// Deletes tags from a resource. You must provide the ARN of the resource from
// which you want to delete the tag or tags.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Redshift's
// API operation DeleteTags for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeResourceNotFoundFault "ResourceNotFoundFault"
//   The resource could not be found.
//
//   * ErrCodeInvalidTagFault "InvalidTagFault"
//   The tag is invalid.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/DeleteTags
func (c *Redshift) DeleteTags(input *DeleteTagsInput) (*DeleteTagsOutput, error) {
	req, out := c.DeleteTagsRequest(input)
	return out, req.Send()
}

// DeleteTagsWithContext is the same as DeleteTags with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteTags for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Redshift) DeleteTagsWithContext(ctx aws.Context, input *DeleteTagsInput, opts ...request.Option) (*DeleteTagsOutput, error) {
	req, out := c.DeleteTagsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeAccountAttributes = "DescribeAccountAttributes"

// DescribeAccountAttributesRequest generates a "aws/request.Request" representing the
// client's request for the DescribeAccountAttributes operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeAccountAttributes for more information on using the DescribeAccountAttributes
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeAccountAttributesRequest method.
//    req, resp := client.DescribeAccountAttributesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/DescribeAccountAttributes
func (c *Redshift) DescribeAccountAttributesRequest(input *DescribeAccountAttributesInput) (req *request.Request, output *DescribeAccountAttributesOutput) {
	op := &request.Operation{
		Name:       opDescribeAccountAttributes,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeAccountAttributesInput{}
	}

	output = &DescribeAccountAttributesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeAccountAttributes API operation for Amazon Redshift.
//
// Returns a list of attributes attached to an account
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Redshift's
// API operation DescribeAccountAttributes for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/DescribeAccountAttributes
func (c *Redshift) DescribeAccountAttributes(input *DescribeAccountAttributesInput) (*DescribeAccountAttributesOutput, error) {
	req, out := c.DescribeAccountAttributesRequest(input)
	return out, req.Send()
}

// DescribeAccountAttributesWithContext is the same as DescribeAccountAttributes with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeAccountAttributes for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Redshift) DescribeAccountAttributesWithContext(ctx aws.Context, input *DescribeAccountAttributesInput, opts ...request.Option) (*DescribeAccountAttributesOutput, error) {
	req, out := c.DescribeAccountAttributesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeClusterDbRevisions = "DescribeClusterDbRevisions"

// DescribeClusterDbRevisionsRequest generates a "aws/request.Request" representing the
// client's request for the DescribeClusterDbRevisions operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeClusterDbRevisions for more information on using the DescribeClusterDbRevisions
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeClusterDbRevisionsRequest method.
//    req, resp := client.DescribeClusterDbRevisionsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/DescribeClusterDbRevisions
func (c *Redshift) DescribeClusterDbRevisionsRequest(input *DescribeClusterDbRevisionsInput) (req *request.Request, output *DescribeClusterDbRevisionsOutput) {
	op := &request.Operation{
		Name:       opDescribeClusterDbRevisions,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeClusterDbRevisionsInput{}
	}

	output = &DescribeClusterDbRevisionsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeClusterDbRevisions API operation for Amazon Redshift.
//
// Returns an array of ClusterDbRevision objects.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Redshift's
// API operation DescribeClusterDbRevisions for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeClusterNotFoundFault "ClusterNotFound"
//   The ClusterIdentifier parameter does not refer to an existing cluster.
//
//   * ErrCodeInvalidClusterStateFault "InvalidClusterState"
//   The specified cluster is not in the available state.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/DescribeClusterDbRevisions
func (c *Redshift) DescribeClusterDbRevisions(input *DescribeClusterDbRevisionsInput) (*DescribeClusterDbRevisionsOutput, error) {
	req, out := c.DescribeClusterDbRevisionsRequest(input)
	return out, req.Send()
}

// DescribeClusterDbRevisionsWithContext is the same as DescribeClusterDbRevisions with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeClusterDbRevisions for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Redshift) DescribeClusterDbRevisionsWithContext(ctx aws.Context, input *DescribeClusterDbRevisionsInput, opts ...request.Option) (*DescribeClusterDbRevisionsOutput, error) {
	req, out := c.DescribeClusterDbRevisionsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeClusterParameterGroups = "DescribeClusterParameterGroups"

// DescribeClusterParameterGroupsRequest generates a "aws/request.Request" representing the
// client's request for the DescribeClusterParameterGroups operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeClusterParameterGroups for more information on using the DescribeClusterParameterGroups
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeClusterParameterGroupsRequest method.
//    req, resp := client.DescribeClusterParameterGroupsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/DescribeClusterParameterGroups
func (c *Redshift) DescribeClusterParameterGroupsRequest(input *DescribeClusterParameterGroupsInput) (req *request.Request, output *DescribeClusterParameterGroupsOutput) {
	op := &request.Operation{
		Name:       opDescribeClusterParameterGroups,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"Marker"},
			OutputTokens:    []string{"Marker"},
			LimitToken:      "MaxRecords",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &DescribeClusterParameterGroupsInput{}
	}

	output = &DescribeClusterParameterGroupsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeClusterParameterGroups API operation for Amazon Redshift.
//
// Returns a list of Amazon Redshift parameter groups, including parameter groups
// you created and the default parameter group. For each parameter group, the
// response includes the parameter group name, description, and parameter group
// family name. You can optionally specify a name to retrieve the description
// of a specific parameter group.
//
// For more information about parameters and parameter groups, go to Amazon
// Redshift Parameter Groups (https://docs.aws.amazon.com/redshift/latest/mgmt/working-with-parameter-groups.html)
// in the Amazon Redshift Cluster Management Guide.
//
// If you specify both tag keys and tag values in the same request, Amazon Redshift
// returns all parameter groups that match any combination of the specified
// keys and values. For example, if you have owner and environment for tag keys,
// and admin and test for tag values, all parameter groups that have any combination
// of those values are returned.
//
// If both tag keys and values are omitted from the request, parameter groups
// are returned regardless of whether they have tag keys or values associated
// with them.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Redshift's
// API operation DescribeClusterParameterGroups for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeClusterParameterGroupNotFoundFault "ClusterParameterGroupNotFound"
//   The parameter group name does not refer to an existing parameter group.
//
//   * ErrCodeInvalidTagFault "InvalidTagFault"
//   The tag is invalid.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/DescribeClusterParameterGroups
func (c *Redshift) DescribeClusterParameterGroups(input *DescribeClusterParameterGroupsInput) (*DescribeClusterParameterGroupsOutput, error) {
	req, out := c.DescribeClusterParameterGroupsRequest(input)
	return out, req.Send()
}

// DescribeClusterParameterGroupsWithContext is the same as DescribeClusterParameterGroups with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeClusterParameterGroups for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Redshift) DescribeClusterParameterGroupsWithContext(ctx aws.Context, input *DescribeClusterParameterGroupsInput, opts ...request.Option) (*DescribeClusterParameterGroupsOutput, error) {
	req, out := c.DescribeClusterParameterGroupsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// DescribeClusterParameterGroupsPages iterates over the pages of a DescribeClusterParameterGroups operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See DescribeClusterParameterGroups method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a DescribeClusterParameterGroups operation.
//    pageNum := 0
//    err := client.DescribeClusterParameterGroupsPages(params,
//        func(page *redshift.DescribeClusterParameterGroupsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *Redshift) DescribeClusterParameterGroupsPages(input *DescribeClusterParameterGroupsInput, fn func(*DescribeClusterParameterGroupsOutput, bool) bool) error {
	return c.DescribeClusterParameterGroupsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// DescribeClusterParameterGroupsPagesWithContext same as DescribeClusterParameterGroupsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Redshift) DescribeClusterParameterGroupsPagesWithContext(ctx aws.Context, input *DescribeClusterParameterGroupsInput, fn func(*DescribeClusterParameterGroupsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *DescribeClusterParameterGroupsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.DescribeClusterParameterGroupsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*DescribeClusterParameterGroupsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opDescribeClusterParameters = "DescribeClusterParameters"

// DescribeClusterParametersRequest generates a "aws/request.Request" representing the
// client's request for the DescribeClusterParameters operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeClusterParameters for more information on using the DescribeClusterParameters
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeClusterParametersRequest method.
//    req, resp := client.DescribeClusterParametersRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/DescribeClusterParameters
func (c *Redshift) DescribeClusterParametersRequest(input *DescribeClusterParametersInput) (req *request.Request, output *DescribeClusterParametersOutput) {
	op := &request.Operation{
		Name:       opDescribeClusterParameters,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"Marker"},
			OutputTokens:    []string{"Marker"},
			LimitToken:      "MaxRecords",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &DescribeClusterParametersInput{}
	}

	output = &DescribeClusterParametersOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeClusterParameters API operation for Amazon Redshift.
//
// Returns a detailed list of parameters contained within the specified Amazon
// Redshift parameter group. For each parameter the response includes information
// such as parameter name, description, data type, value, whether the parameter
// value is modifiable, and so on.
//
// You can specify source filter to retrieve parameters of only specific type.
// For example, to retrieve parameters that were modified by a user action such
// as from ModifyClusterParameterGroup, you can specify source equal to user.
//
// For more information about parameters and parameter groups, go to Amazon
// Redshift Parameter Groups (https://docs.aws.amazon.com/redshift/latest/mgmt/working-with-parameter-groups.html)
// in the Amazon Redshift Cluster Management Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Redshift's
// API operation DescribeClusterParameters for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeClusterParameterGroupNotFoundFault "ClusterParameterGroupNotFound"
//   The parameter group name does not refer to an existing parameter group.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/DescribeClusterParameters
func (c *Redshift) DescribeClusterParameters(input *DescribeClusterParametersInput) (*DescribeClusterParametersOutput, error) {
	req, out := c.DescribeClusterParametersRequest(input)
	return out, req.Send()
}

// DescribeClusterParametersWithContext is the same as DescribeClusterParameters with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeClusterParameters for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Redshift) DescribeClusterParametersWithContext(ctx aws.Context, input *DescribeClusterParametersInput, opts ...request.Option) (*DescribeClusterParametersOutput, error) {
	req, out := c.DescribeClusterParametersRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// DescribeClusterParametersPages iterates over the pages of a DescribeClusterParameters operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See DescribeClusterParameters method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a DescribeClusterParameters operation.
//    pageNum := 0
//    err := client.DescribeClusterParametersPages(params,
//        func(page *redshift.DescribeClusterParametersOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *Redshift) DescribeClusterParametersPages(input *DescribeClusterParametersInput, fn func(*DescribeClusterParametersOutput, bool) bool) error {
	return c.DescribeClusterParametersPagesWithContext(aws.BackgroundContext(), input, fn)
}

// DescribeClusterParametersPagesWithContext same as DescribeClusterParametersPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Redshift) DescribeClusterParametersPagesWithContext(ctx aws.Context, input *DescribeClusterParametersInput, fn func(*DescribeClusterParametersOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *DescribeClusterParametersInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.DescribeClusterParametersRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*DescribeClusterParametersOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opDescribeClusterSecurityGroups = "DescribeClusterSecurityGroups"

// DescribeClusterSecurityGroupsRequest generates a "aws/request.Request" representing the
// client's request for the DescribeClusterSecurityGroups operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeClusterSecurityGroups for more information on using the DescribeClusterSecurityGroups
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeClusterSecurityGroupsRequest method.
//    req, resp := client.DescribeClusterSecurityGroupsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/DescribeClusterSecurityGroups
func (c *Redshift) DescribeClusterSecurityGroupsRequest(input *DescribeClusterSecurityGroupsInput) (req *request.Request, output *DescribeClusterSecurityGroupsOutput) {
	op := &request.Operation{
		Name:       opDescribeClusterSecurityGroups,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"Marker"},
			OutputTokens:    []string{"Marker"},
			LimitToken:      "MaxRecords",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &DescribeClusterSecurityGroupsInput{}
	}

	output = &DescribeClusterSecurityGroupsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeClusterSecurityGroups API operation for Amazon Redshift.
//
// Returns information about Amazon Redshift security groups. If the name of
// a security group is specified, the response will contain only information
// about only that security group.
//
// For information about managing security groups, go to Amazon Redshift Cluster
// Security Groups (https://docs.aws.amazon.com/redshift/latest/mgmt/working-with-security-groups.html)
// in the Amazon Redshift Cluster Management Guide.
//
// If you specify both tag keys and tag values in the same request, Amazon Redshift
// returns all security groups that match any combination of the specified keys
// and values. For example, if you have owner and environment for tag keys,
// and admin and test for tag values, all security groups that have any combination
// of those values are returned.
//
// If both tag keys and values are omitted from the request, security groups
// are returned regardless of whether they have tag keys or values associated
// with them.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Redshift's
// API operation DescribeClusterSecurityGroups for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeClusterSecurityGroupNotFoundFault "ClusterSecurityGroupNotFound"
//   The cluster security group name does not refer to an existing cluster security
//   group.
//
//   * ErrCodeInvalidTagFault "InvalidTagFault"
//   The tag is invalid.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/DescribeClusterSecurityGroups
func (c *Redshift) DescribeClusterSecurityGroups(input *DescribeClusterSecurityGroupsInput) (*DescribeClusterSecurityGroupsOutput, error) {
	req, out := c.DescribeClusterSecurityGroupsRequest(input)
	return out, req.Send()
}

// DescribeClusterSecurityGroupsWithContext is the same as DescribeClusterSecurityGroups with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeClusterSecurityGroups for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Redshift) DescribeClusterSecurityGroupsWithContext(ctx aws.Context, input *DescribeClusterSecurityGroupsInput, opts ...request.Option) (*DescribeClusterSecurityGroupsOutput, error) {
	req, out := c.DescribeClusterSecurityGroupsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// DescribeClusterSecurityGroupsPages iterates over the pages of a DescribeClusterSecurityGroups operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See DescribeClusterSecurityGroups method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a DescribeClusterSecurityGroups operation.
//    pageNum := 0
//    err := client.DescribeClusterSecurityGroupsPages(params,
//        func(page *redshift.DescribeClusterSecurityGroupsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *Redshift) DescribeClusterSecurityGroupsPages(input *DescribeClusterSecurityGroupsInput, fn func(*DescribeClusterSecurityGroupsOutput, bool) bool) error {
	return c.DescribeClusterSecurityGroupsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// DescribeClusterSecurityGroupsPagesWithContext same as DescribeClusterSecurityGroupsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Redshift) DescribeClusterSecurityGroupsPagesWithContext(ctx aws.Context, input *DescribeClusterSecurityGroupsInput, fn func(*DescribeClusterSecurityGroupsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *DescribeClusterSecurityGroupsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.DescribeClusterSecurityGroupsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*DescribeClusterSecurityGroupsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opDescribeClusterSnapshots = "DescribeClusterSnapshots"

// DescribeClusterSnapshotsRequest generates a "aws/request.Request" representing the
// client's request for the DescribeClusterSnapshots operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeClusterSnapshots for more information on using the DescribeClusterSnapshots
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeClusterSnapshotsRequest method.
//    req, resp := client.DescribeClusterSnapshotsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/DescribeClusterSnapshots
func (c *Redshift) DescribeClusterSnapshotsRequest(input *DescribeClusterSnapshotsInput) (req *request.Request, output *DescribeClusterSnapshotsOutput) {
	op := &request.Operation{
		Name:       opDescribeClusterSnapshots,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"Marker"},
			OutputTokens:    []string{"Marker"},
			LimitToken:      "MaxRecords",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &DescribeClusterSnapshotsInput{}
	}

	output = &DescribeClusterSnapshotsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeClusterSnapshots API operation for Amazon Redshift.
//
// Returns one or more snapshot objects, which contain metadata about your cluster
// snapshots. By default, this operation returns information about all snapshots
// of all clusters that are owned by you AWS customer account. No information
// is returned for snapshots owned by inactive AWS customer accounts.
//
// If you specify both tag keys and tag values in the same request, Amazon Redshift
// returns all snapshots that match any combination of the specified keys and
// values. For example, if you have owner and environment for tag keys, and
// admin and test for tag values, all snapshots that have any combination of
// those values are returned. Only snapshots that you own are returned in the
// response; shared snapshots are not returned with the tag key and tag value
// request parameters.
//
// If both tag keys and values are omitted from the request, snapshots are returned
// regardless of whether they have tag keys or values associated with them.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Redshift's
// API operation DescribeClusterSnapshots for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeClusterNotFoundFault "ClusterNotFound"
//   The ClusterIdentifier parameter does not refer to an existing cluster.
//
//   * ErrCodeClusterSnapshotNotFoundFault "ClusterSnapshotNotFound"
//   The snapshot identifier does not refer to an existing cluster snapshot.
//
//   * ErrCodeInvalidTagFault "InvalidTagFault"
//   The tag is invalid.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/DescribeClusterSnapshots
func (c *Redshift) DescribeClusterSnapshots(input *DescribeClusterSnapshotsInput) (*DescribeClusterSnapshotsOutput, error) {
	req, out := c.DescribeClusterSnapshotsRequest(input)
	return out, req.Send()
}

// DescribeClusterSnapshotsWithContext is the same as DescribeClusterSnapshots with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeClusterSnapshots for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Redshift) DescribeClusterSnapshotsWithContext(ctx aws.Context, input *DescribeClusterSnapshotsInput, opts ...request.Option) (*DescribeClusterSnapshotsOutput, error) {
	req, out := c.DescribeClusterSnapshotsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// DescribeClusterSnapshotsPages iterates over the pages of a DescribeClusterSnapshots operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See DescribeClusterSnapshots method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a DescribeClusterSnapshots operation.
//    pageNum := 0
//    err := client.DescribeClusterSnapshotsPages(params,
//        func(page *redshift.DescribeClusterSnapshotsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *Redshift) DescribeClusterSnapshotsPages(input *DescribeClusterSnapshotsInput, fn func(*DescribeClusterSnapshotsOutput, bool) bool) error {
	return c.DescribeClusterSnapshotsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// DescribeClusterSnapshotsPagesWithContext same as DescribeClusterSnapshotsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Redshift) DescribeClusterSnapshotsPagesWithContext(ctx aws.Context, input *DescribeClusterSnapshotsInput, fn func(*DescribeClusterSnapshotsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *DescribeClusterSnapshotsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.DescribeClusterSnapshotsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*DescribeClusterSnapshotsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opDescribeClusterSubnetGroups = "DescribeClusterSubnetGroups"

// DescribeClusterSubnetGroupsRequest generates a "aws/request.Request" representing the
// client's request for the DescribeClusterSubnetGroups operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeClusterSubnetGroups for more information on using the DescribeClusterSubnetGroups
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeClusterSubnetGroupsRequest method.
//    req, resp := client.DescribeClusterSubnetGroupsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/DescribeClusterSubnetGroups
func (c *Redshift) DescribeClusterSubnetGroupsRequest(input *DescribeClusterSubnetGroupsInput) (req *request.Request, output *DescribeClusterSubnetGroupsOutput) {
	op := &request.Operation{
		Name:       opDescribeClusterSubnetGroups,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"Marker"},
			OutputTokens:    []string{"Marker"},
			LimitToken:      "MaxRecords",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &DescribeClusterSubnetGroupsInput{}
	}

	output = &DescribeClusterSubnetGroupsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeClusterSubnetGroups API operation for Amazon Redshift.
//
// Returns one or more cluster subnet group objects, which contain metadata
// about your cluster subnet groups. By default, this operation returns information
// about all cluster subnet groups that are defined in you AWS account.
//
// If you specify both tag keys and tag values in the same request, Amazon Redshift
// returns all subnet groups that match any combination of the specified keys
// and values. For example, if you have owner and environment for tag keys,
// and admin and test for tag values, all subnet groups that have any combination
// of those values are returned.
//
// If both tag keys and values are omitted from the request, subnet groups are
// returned regardless of whether they have tag keys or values associated with
// them.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Redshift's
// API operation DescribeClusterSubnetGroups for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeClusterSubnetGroupNotFoundFault "ClusterSubnetGroupNotFoundFault"
//   The cluster subnet group name does not refer to an existing cluster subnet
//   group.
//
//   * ErrCodeInvalidTagFault "InvalidTagFault"
//   The tag is invalid.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/DescribeClusterSubnetGroups
func (c *Redshift) DescribeClusterSubnetGroups(input *DescribeClusterSubnetGroupsInput) (*DescribeClusterSubnetGroupsOutput, error) {
	req, out := c.DescribeClusterSubnetGroupsRequest(input)
	return out, req.Send()
}

// DescribeClusterSubnetGroupsWithContext is the same as DescribeClusterSubnetGroups with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeClusterSubnetGroups for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Redshift) DescribeClusterSubnetGroupsWithContext(ctx aws.Context, input *DescribeClusterSubnetGroupsInput, opts ...request.Option) (*DescribeClusterSubnetGroupsOutput, error) {
	req, out := c.DescribeClusterSubnetGroupsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// DescribeClusterSubnetGroupsPages iterates over the pages of a DescribeClusterSubnetGroups operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See DescribeClusterSubnetGroups method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a DescribeClusterSubnetGroups operation.
//    pageNum := 0
//    err := client.DescribeClusterSubnetGroupsPages(params,
//        func(page *redshift.DescribeClusterSubnetGroupsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *Redshift) DescribeClusterSubnetGroupsPages(input *DescribeClusterSubnetGroupsInput, fn func(*DescribeClusterSubnetGroupsOutput, bool) bool) error {
	return c.DescribeClusterSubnetGroupsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// DescribeClusterSubnetGroupsPagesWithContext same as DescribeClusterSubnetGroupsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Redshift) DescribeClusterSubnetGroupsPagesWithContext(ctx aws.Context, input *DescribeClusterSubnetGroupsInput, fn func(*DescribeClusterSubnetGroupsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *DescribeClusterSubnetGroupsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.DescribeClusterSubnetGroupsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*DescribeClusterSubnetGroupsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opDescribeClusterTracks = "DescribeClusterTracks"

// DescribeClusterTracksRequest generates a "aws/request.Request" representing the
// client's request for the DescribeClusterTracks operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeClusterTracks for more information on using the DescribeClusterTracks
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeClusterTracksRequest method.
//    req, resp := client.DescribeClusterTracksRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/DescribeClusterTracks
func (c *Redshift) DescribeClusterTracksRequest(input *DescribeClusterTracksInput) (req *request.Request, output *DescribeClusterTracksOutput) {
	op := &request.Operation{
		Name:       opDescribeClusterTracks,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeClusterTracksInput{}
	}

	output = &DescribeClusterTracksOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeClusterTracks API operation for Amazon Redshift.
//
// Returns a list of all the available maintenance tracks.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Redshift's
// API operation DescribeClusterTracks for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidClusterTrackFault "InvalidClusterTrack"
//   The provided cluster track name is not valid.
//
//   * ErrCodeUnauthorizedOperation "UnauthorizedOperation"
//   Your account is not authorized to perform the requested operation.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/DescribeClusterTracks
func (c *Redshift) DescribeClusterTracks(input *DescribeClusterTracksInput) (*DescribeClusterTracksOutput, error) {
	req, out := c.DescribeClusterTracksRequest(input)
	return out, req.Send()
}

// DescribeClusterTracksWithContext is the same as DescribeClusterTracks with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeClusterTracks for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Redshift) DescribeClusterTracksWithContext(ctx aws.Context, input *DescribeClusterTracksInput, opts ...request.Option) (*DescribeClusterTracksOutput, error) {
	req, out := c.DescribeClusterTracksRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeClusterVersions = "DescribeClusterVersions"

// DescribeClusterVersionsRequest generates a "aws/request.Request" representing the
// client's request for the DescribeClusterVersions operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeClusterVersions for more information on using the DescribeClusterVersions
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeClusterVersionsRequest method.
//    req, resp := client.DescribeClusterVersionsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/DescribeClusterVersions
func (c *Redshift) DescribeClusterVersionsRequest(input *DescribeClusterVersionsInput) (req *request.Request, output *DescribeClusterVersionsOutput) {
	op := &request.Operation{
		Name:       opDescribeClusterVersions,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"Marker"},
			OutputTokens:    []string{"Marker"},
			LimitToken:      "MaxRecords",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &DescribeClusterVersionsInput{}
	}

	output = &DescribeClusterVersionsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeClusterVersions API operation for Amazon Redshift.
//
// Returns descriptions of the available Amazon Redshift cluster versions. You
// can call this operation even before creating any clusters to learn more about
// the Amazon Redshift versions. For more information about managing clusters,
// go to Amazon Redshift Clusters (https://docs.aws.amazon.com/redshift/latest/mgmt/working-with-clusters.html)
// in the Amazon Redshift Cluster Management Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Redshift's
// API operation DescribeClusterVersions for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/DescribeClusterVersions
func (c *Redshift) DescribeClusterVersions(input *DescribeClusterVersionsInput) (*DescribeClusterVersionsOutput, error) {
	req, out := c.DescribeClusterVersionsRequest(input)
	return out, req.Send()
}

// DescribeClusterVersionsWithContext is the same as DescribeClusterVersions with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeClusterVersions for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Redshift) DescribeClusterVersionsWithContext(ctx aws.Context, input *DescribeClusterVersionsInput, opts ...request.Option) (*DescribeClusterVersionsOutput, error) {
	req, out := c.DescribeClusterVersionsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// DescribeClusterVersionsPages iterates over the pages of a DescribeClusterVersions operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See DescribeClusterVersions method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a DescribeClusterVersions operation.
//    pageNum := 0
//    err := client.DescribeClusterVersionsPages(params,
//        func(page *redshift.DescribeClusterVersionsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *Redshift) DescribeClusterVersionsPages(input *DescribeClusterVersionsInput, fn func(*DescribeClusterVersionsOutput, bool) bool) error {
	return c.DescribeClusterVersionsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// DescribeClusterVersionsPagesWithContext same as DescribeClusterVersionsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Redshift) DescribeClusterVersionsPagesWithContext(ctx aws.Context, input *DescribeClusterVersionsInput, fn func(*DescribeClusterVersionsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *DescribeClusterVersionsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.DescribeClusterVersionsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*DescribeClusterVersionsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opDescribeClusters = "DescribeClusters"

// DescribeClustersRequest generates a "aws/request.Request" representing the
// client's request for the DescribeClusters operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeClusters for more information on using the DescribeClusters
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeClustersRequest method.
//    req, resp := client.DescribeClustersRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/DescribeClusters
func (c *Redshift) DescribeClustersRequest(input *DescribeClustersInput) (req *request.Request, output *DescribeClustersOutput) {
	op := &request.Operation{
		Name:       opDescribeClusters,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"Marker"},
			OutputTokens:    []string{"Marker"},
			LimitToken:      "MaxRecords",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &DescribeClustersInput{}
	}

	output = &DescribeClustersOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeClusters API operation for Amazon Redshift.
//
// Returns properties of provisioned clusters including general cluster properties,
// cluster database properties, maintenance and backup properties, and security
// and access properties. This operation supports pagination. For more information
// about managing clusters, go to Amazon Redshift Clusters (https://docs.aws.amazon.com/redshift/latest/mgmt/working-with-clusters.html)
// in the Amazon Redshift Cluster Management Guide.
//
// If you specify both tag keys and tag values in the same request, Amazon Redshift
// returns all clusters that match any combination of the specified keys and
// values. For example, if you have owner and environment for tag keys, and
// admin and test for tag values, all clusters that have any combination of
// those values are returned.
//
// If both tag keys and values are omitted from the request, clusters are returned
// regardless of whether they have tag keys or values associated with them.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Redshift's
// API operation DescribeClusters for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeClusterNotFoundFault "ClusterNotFound"
//   The ClusterIdentifier parameter does not refer to an existing cluster.
//
//   * ErrCodeInvalidTagFault "InvalidTagFault"
//   The tag is invalid.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/DescribeClusters
func (c *Redshift) DescribeClusters(input *DescribeClustersInput) (*DescribeClustersOutput, error) {
	req, out := c.DescribeClustersRequest(input)
	return out, req.Send()
}

// DescribeClustersWithContext is the same as DescribeClusters with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeClusters for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Redshift) DescribeClustersWithContext(ctx aws.Context, input *DescribeClustersInput, opts ...request.Option) (*DescribeClustersOutput, error) {
	req, out := c.DescribeClustersRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// DescribeClustersPages iterates over the pages of a DescribeClusters operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See DescribeClusters method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a DescribeClusters operation.
//    pageNum := 0
//    err := client.DescribeClustersPages(params,
//        func(page *redshift.DescribeClustersOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *Redshift) DescribeClustersPages(input *DescribeClustersInput, fn func(*DescribeClustersOutput, bool) bool) error {
	return c.DescribeClustersPagesWithContext(aws.BackgroundContext(), input, fn)
}

// DescribeClustersPagesWithContext same as DescribeClustersPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Redshift) DescribeClustersPagesWithContext(ctx aws.Context, input *DescribeClustersInput, fn func(*DescribeClustersOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *DescribeClustersInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.DescribeClustersRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*DescribeClustersOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opDescribeDefaultClusterParameters = "DescribeDefaultClusterParameters"

// DescribeDefaultClusterParametersRequest generates a "aws/request.Request" representing the
// client's request for the DescribeDefaultClusterParameters operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeDefaultClusterParameters for more information on using the DescribeDefaultClusterParameters
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeDefaultClusterParametersRequest method.
//    req, resp := client.DescribeDefaultClusterParametersRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/DescribeDefaultClusterParameters
func (c *Redshift) DescribeDefaultClusterParametersRequest(input *DescribeDefaultClusterParametersInput) (req *request.Request, output *DescribeDefaultClusterParametersOutput) {
	op := &request.Operation{
		Name:       opDescribeDefaultClusterParameters,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"Marker"},
			OutputTokens:    []string{"DefaultClusterParameters.Marker"},
			LimitToken:      "MaxRecords",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &DescribeDefaultClusterParametersInput{}
	}

	output = &DescribeDefaultClusterParametersOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeDefaultClusterParameters API operation for Amazon Redshift.
//
// Returns a list of parameter settings for the specified parameter group family.
//
// For more information about parameters and parameter groups, go to Amazon
// Redshift Parameter Groups (https://docs.aws.amazon.com/redshift/latest/mgmt/working-with-parameter-groups.html)
// in the Amazon Redshift Cluster Management Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Redshift's
// API operation DescribeDefaultClusterParameters for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/DescribeDefaultClusterParameters
func (c *Redshift) DescribeDefaultClusterParameters(input *DescribeDefaultClusterParametersInput) (*DescribeDefaultClusterParametersOutput, error) {
	req, out := c.DescribeDefaultClusterParametersRequest(input)
	return out, req.Send()
}

// DescribeDefaultClusterParametersWithContext is the same as DescribeDefaultClusterParameters with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeDefaultClusterParameters for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Redshift) DescribeDefaultClusterParametersWithContext(ctx aws.Context, input *DescribeDefaultClusterParametersInput, opts ...request.Option) (*DescribeDefaultClusterParametersOutput, error) {
	req, out := c.DescribeDefaultClusterParametersRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// DescribeDefaultClusterParametersPages iterates over the pages of a DescribeDefaultClusterParameters operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See DescribeDefaultClusterParameters method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a DescribeDefaultClusterParameters operation.
//    pageNum := 0
//    err := client.DescribeDefaultClusterParametersPages(params,
//        func(page *redshift.DescribeDefaultClusterParametersOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *Redshift) DescribeDefaultClusterParametersPages(input *DescribeDefaultClusterParametersInput, fn func(*DescribeDefaultClusterParametersOutput, bool) bool) error {
	return c.DescribeDefaultClusterParametersPagesWithContext(aws.BackgroundContext(), input, fn)
}

// DescribeDefaultClusterParametersPagesWithContext same as DescribeDefaultClusterParametersPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Redshift) DescribeDefaultClusterParametersPagesWithContext(ctx aws.Context, input *DescribeDefaultClusterParametersInput, fn func(*DescribeDefaultClusterParametersOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *DescribeDefaultClusterParametersInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.DescribeDefaultClusterParametersRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*DescribeDefaultClusterParametersOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opDescribeEventCategories = "DescribeEventCategories"

// DescribeEventCategoriesRequest generates a "aws/request.Request" representing the
// client's request for the DescribeEventCategories operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeEventCategories for more information on using the DescribeEventCategories
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeEventCategoriesRequest method.
//    req, resp := client.DescribeEventCategoriesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/DescribeEventCategories
func (c *Redshift) DescribeEventCategoriesRequest(input *DescribeEventCategoriesInput) (req *request.Request, output *DescribeEventCategoriesOutput) {
	op := &request.Operation{
		Name:       opDescribeEventCategories,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeEventCategoriesInput{}
	}

	output = &DescribeEventCategoriesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeEventCategories API operation for Amazon Redshift.
//
// Displays a list of event categories for all event source types, or for a
// specified source type. For a list of the event categories and source types,
// go to Amazon Redshift Event Notifications (https://docs.aws.amazon.com/redshift/latest/mgmt/working-with-event-notifications.html).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Redshift's
// API operation DescribeEventCategories for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/DescribeEventCategories
func (c *Redshift) DescribeEventCategories(input *DescribeEventCategoriesInput) (*DescribeEventCategoriesOutput, error) {
	req, out := c.DescribeEventCategoriesRequest(input)
	return out, req.Send()
}

// DescribeEventCategoriesWithContext is the same as DescribeEventCategories with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeEventCategories for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Redshift) DescribeEventCategoriesWithContext(ctx aws.Context, input *DescribeEventCategoriesInput, opts ...request.Option) (*DescribeEventCategoriesOutput, error) {
	req, out := c.DescribeEventCategoriesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeEventSubscriptions = "DescribeEventSubscriptions"

// DescribeEventSubscriptionsRequest generates a "aws/request.Request" representing the
// client's request for the DescribeEventSubscriptions operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeEventSubscriptions for more information on using the DescribeEventSubscriptions
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeEventSubscriptionsRequest method.
//    req, resp := client.DescribeEventSubscriptionsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/DescribeEventSubscriptions
func (c *Redshift) DescribeEventSubscriptionsRequest(input *DescribeEventSubscriptionsInput) (req *request.Request, output *DescribeEventSubscriptionsOutput) {
	op := &request.Operation{
		Name:       opDescribeEventSubscriptions,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"Marker"},
			OutputTokens:    []string{"Marker"},
			LimitToken:      "MaxRecords",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &DescribeEventSubscriptionsInput{}
	}

	output = &DescribeEventSubscriptionsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeEventSubscriptions API operation for Amazon Redshift.
//
// Lists descriptions of all the Amazon Redshift event notification subscriptions
// for a customer account. If you specify a subscription name, lists the description
// for that subscription.
//
// If you specify both tag keys and tag values in the same request, Amazon Redshift
// returns all event notification subscriptions that match any combination of
// the specified keys and values. For example, if you have owner and environment
// for tag keys, and admin and test for tag values, all subscriptions that have
// any combination of those values are returned.
//
// If both tag keys and values are omitted from the request, subscriptions are
// returned regardless of whether they have tag keys or values associated with
// them.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Redshift's
// API operation DescribeEventSubscriptions for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeSubscriptionNotFoundFault "SubscriptionNotFound"
//   An Amazon Redshift event notification subscription with the specified name
//   does not exist.
//
//   * ErrCodeInvalidTagFault "InvalidTagFault"
//   The tag is invalid.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/DescribeEventSubscriptions
func (c *Redshift) DescribeEventSubscriptions(input *DescribeEventSubscriptionsInput) (*DescribeEventSubscriptionsOutput, error) {
	req, out := c.DescribeEventSubscriptionsRequest(input)
	return out, req.Send()
}

// DescribeEventSubscriptionsWithContext is the same as DescribeEventSubscriptions with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeEventSubscriptions for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Redshift) DescribeEventSubscriptionsWithContext(ctx aws.Context, input *DescribeEventSubscriptionsInput, opts ...request.Option) (*DescribeEventSubscriptionsOutput, error) {
	req, out := c.DescribeEventSubscriptionsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// DescribeEventSubscriptionsPages iterates over the pages of a DescribeEventSubscriptions operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See DescribeEventSubscriptions method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a DescribeEventSubscriptions operation.
//    pageNum := 0
//    err := client.DescribeEventSubscriptionsPages(params,
//        func(page *redshift.DescribeEventSubscriptionsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *Redshift) DescribeEventSubscriptionsPages(input *DescribeEventSubscriptionsInput, fn func(*DescribeEventSubscriptionsOutput, bool) bool) error {
	return c.DescribeEventSubscriptionsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// DescribeEventSubscriptionsPagesWithContext same as DescribeEventSubscriptionsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Redshift) DescribeEventSubscriptionsPagesWithContext(ctx aws.Context, input *DescribeEventSubscriptionsInput, fn func(*DescribeEventSubscriptionsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *DescribeEventSubscriptionsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.DescribeEventSubscriptionsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*DescribeEventSubscriptionsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opDescribeEvents = "DescribeEvents"

// DescribeEventsRequest generates a "aws/request.Request" representing the
// client's request for the DescribeEvents operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeEvents for more information on using the DescribeEvents
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeEventsRequest method.
//    req, resp := client.DescribeEventsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/DescribeEvents
func (c *Redshift) DescribeEventsRequest(input *DescribeEventsInput) (req *request.Request, output *DescribeEventsOutput) {
	op := &request.Operation{
		Name:       opDescribeEvents,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"Marker"},
			OutputTokens:    []string{"Marker"},
			LimitToken:      "MaxRecords",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &DescribeEventsInput{}
	}

	output = &DescribeEventsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeEvents API operation for Amazon Redshift.
//
// Returns events related to clusters, security groups, snapshots, and parameter
// groups for the past 14 days. Events specific to a particular cluster, security
// group, snapshot or parameter group can be obtained by providing the name
// as a parameter. By default, the past hour of events are returned.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Redshift's
// API operation DescribeEvents for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/DescribeEvents
func (c *Redshift) DescribeEvents(input *DescribeEventsInput) (*DescribeEventsOutput, error) {
	req, out := c.DescribeEventsRequest(input)
	return out, req.Send()
}

// DescribeEventsWithContext is the same as DescribeEvents with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeEvents for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Redshift) DescribeEventsWithContext(ctx aws.Context, input *DescribeEventsInput, opts ...request.Option) (*DescribeEventsOutput, error) {
	req, out := c.DescribeEventsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// DescribeEventsPages iterates over the pages of a DescribeEvents operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See DescribeEvents method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a DescribeEvents operation.
//    pageNum := 0
//    err := client.DescribeEventsPages(params,
//        func(page *redshift.DescribeEventsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *Redshift) DescribeEventsPages(input *DescribeEventsInput, fn func(*DescribeEventsOutput, bool) bool) error {
	return c.DescribeEventsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// DescribeEventsPagesWithContext same as DescribeEventsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Redshift) DescribeEventsPagesWithContext(ctx aws.Context, input *DescribeEventsInput, fn func(*DescribeEventsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *DescribeEventsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.DescribeEventsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*DescribeEventsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opDescribeHsmClientCertificates = "DescribeHsmClientCertificates"

// DescribeHsmClientCertificatesRequest generates a "aws/request.Request" representing the
// client's request for the DescribeHsmClientCertificates operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeHsmClientCertificates for more information on using the DescribeHsmClientCertificates
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeHsmClientCertificatesRequest method.
//    req, resp := client.DescribeHsmClientCertificatesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/DescribeHsmClientCertificates
func (c *Redshift) DescribeHsmClientCertificatesRequest(input *DescribeHsmClientCertificatesInput) (req *request.Request, output *DescribeHsmClientCertificatesOutput) {
	op := &request.Operation{
		Name:       opDescribeHsmClientCertificates,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"Marker"},
			OutputTokens:    []string{"Marker"},
			LimitToken:      "MaxRecords",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &DescribeHsmClientCertificatesInput{}
	}

	output = &DescribeHsmClientCertificatesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeHsmClientCertificates API operation for Amazon Redshift.
//
// Returns information about the specified HSM client certificate. If no certificate
// ID is specified, returns information about all the HSM certificates owned
// by your AWS customer account.
//
// If you specify both tag keys and tag values in the same request, Amazon Redshift
// returns all HSM client certificates that match any combination of the specified
// keys and values. For example, if you have owner and environment for tag keys,
// and admin and test for tag values, all HSM client certificates that have
// any combination of those values are returned.
//
// If both tag keys and values are omitted from the request, HSM client certificates
// are returned regardless of whether they have tag keys or values associated
// with them.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Redshift's
// API operation DescribeHsmClientCertificates for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeHsmClientCertificateNotFoundFault "HsmClientCertificateNotFoundFault"
//   There is no Amazon Redshift HSM client certificate with the specified identifier.
//
//   * ErrCodeInvalidTagFault "InvalidTagFault"
//   The tag is invalid.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/DescribeHsmClientCertificates
func (c *Redshift) DescribeHsmClientCertificates(input *DescribeHsmClientCertificatesInput) (*DescribeHsmClientCertificatesOutput, error) {
	req, out := c.DescribeHsmClientCertificatesRequest(input)
	return out, req.Send()
}

// DescribeHsmClientCertificatesWithContext is the same as DescribeHsmClientCertificates with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeHsmClientCertificates for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Redshift) DescribeHsmClientCertificatesWithContext(ctx aws.Context, input *DescribeHsmClientCertificatesInput, opts ...request.Option) (*DescribeHsmClientCertificatesOutput, error) {
	req, out := c.DescribeHsmClientCertificatesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// DescribeHsmClientCertificatesPages iterates over the pages of a DescribeHsmClientCertificates operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See DescribeHsmClientCertificates method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a DescribeHsmClientCertificates operation.
//    pageNum := 0
//    err := client.DescribeHsmClientCertificatesPages(params,
//        func(page *redshift.DescribeHsmClientCertificatesOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *Redshift) DescribeHsmClientCertificatesPages(input *DescribeHsmClientCertificatesInput, fn func(*DescribeHsmClientCertificatesOutput, bool) bool) error {
	return c.DescribeHsmClientCertificatesPagesWithContext(aws.BackgroundContext(), input, fn)
}

// DescribeHsmClientCertificatesPagesWithContext same as DescribeHsmClientCertificatesPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Redshift) DescribeHsmClientCertificatesPagesWithContext(ctx aws.Context, input *DescribeHsmClientCertificatesInput, fn func(*DescribeHsmClientCertificatesOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *DescribeHsmClientCertificatesInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.DescribeHsmClientCertificatesRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*DescribeHsmClientCertificatesOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opDescribeHsmConfigurations = "DescribeHsmConfigurations"

// DescribeHsmConfigurationsRequest generates a "aws/request.Request" representing the
// client's request for the DescribeHsmConfigurations operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeHsmConfigurations for more information on using the DescribeHsmConfigurations
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeHsmConfigurationsRequest method.
//    req, resp := client.DescribeHsmConfigurationsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/DescribeHsmConfigurations
func (c *Redshift) DescribeHsmConfigurationsRequest(input *DescribeHsmConfigurationsInput) (req *request.Request, output *DescribeHsmConfigurationsOutput) {
	op := &request.Operation{
		Name:       opDescribeHsmConfigurations,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"Marker"},
			OutputTokens:    []string{"Marker"},
			LimitToken:      "MaxRecords",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &DescribeHsmConfigurationsInput{}
	}

	output = &DescribeHsmConfigurationsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeHsmConfigurations API operation for Amazon Redshift.
//
// Returns information about the specified Amazon Redshift HSM configuration.
// If no configuration ID is specified, returns information about all the HSM
// configurations owned by your AWS customer account.
//
// If you specify both tag keys and tag values in the same request, Amazon Redshift
// returns all HSM connections that match any combination of the specified keys
// and values. For example, if you have owner and environment for tag keys,
// and admin and test for tag values, all HSM connections that have any combination
// of those values are returned.
//
// If both tag keys and values are omitted from the request, HSM connections
// are returned regardless of whether they have tag keys or values associated
// with them.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Redshift's
// API operation DescribeHsmConfigurations for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeHsmConfigurationNotFoundFault "HsmConfigurationNotFoundFault"
//   There is no Amazon Redshift HSM configuration with the specified identifier.
//
//   * ErrCodeInvalidTagFault "InvalidTagFault"
//   The tag is invalid.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/DescribeHsmConfigurations
func (c *Redshift) DescribeHsmConfigurations(input *DescribeHsmConfigurationsInput) (*DescribeHsmConfigurationsOutput, error) {
	req, out := c.DescribeHsmConfigurationsRequest(input)
	return out, req.Send()
}

// DescribeHsmConfigurationsWithContext is the same as DescribeHsmConfigurations with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeHsmConfigurations for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Redshift) DescribeHsmConfigurationsWithContext(ctx aws.Context, input *DescribeHsmConfigurationsInput, opts ...request.Option) (*DescribeHsmConfigurationsOutput, error) {
	req, out := c.DescribeHsmConfigurationsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// DescribeHsmConfigurationsPages iterates over the pages of a DescribeHsmConfigurations operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See DescribeHsmConfigurations method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a DescribeHsmConfigurations operation.
//    pageNum := 0
//    err := client.DescribeHsmConfigurationsPages(params,
//        func(page *redshift.DescribeHsmConfigurationsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *Redshift) DescribeHsmConfigurationsPages(input *DescribeHsmConfigurationsInput, fn func(*DescribeHsmConfigurationsOutput, bool) bool) error {
	return c.DescribeHsmConfigurationsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// DescribeHsmConfigurationsPagesWithContext same as DescribeHsmConfigurationsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Redshift) DescribeHsmConfigurationsPagesWithContext(ctx aws.Context, input *DescribeHsmConfigurationsInput, fn func(*DescribeHsmConfigurationsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *DescribeHsmConfigurationsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.DescribeHsmConfigurationsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*DescribeHsmConfigurationsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opDescribeLoggingStatus = "DescribeLoggingStatus"

// DescribeLoggingStatusRequest generates a "aws/request.Request" representing the
// client's request for the DescribeLoggingStatus operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeLoggingStatus for more information on using the DescribeLoggingStatus
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeLoggingStatusRequest method.
//    req, resp := client.DescribeLoggingStatusRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/DescribeLoggingStatus
func (c *Redshift) DescribeLoggingStatusRequest(input *DescribeLoggingStatusInput) (req *request.Request, output *LoggingStatus) {
	op := &request.Operation{
		Name:       opDescribeLoggingStatus,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeLoggingStatusInput{}
	}

	output = &LoggingStatus{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeLoggingStatus API operation for Amazon Redshift.
//
// Describes whether information, such as queries and connection attempts, is
// being logged for the specified Amazon Redshift cluster.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Redshift's
// API operation DescribeLoggingStatus for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeClusterNotFoundFault "ClusterNotFound"
//   The ClusterIdentifier parameter does not refer to an existing cluster.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/DescribeLoggingStatus
func (c *Redshift) DescribeLoggingStatus(input *DescribeLoggingStatusInput) (*LoggingStatus, error) {
	req, out := c.DescribeLoggingStatusRequest(input)
	return out, req.Send()
}

// DescribeLoggingStatusWithContext is the same as DescribeLoggingStatus with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeLoggingStatus for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Redshift) DescribeLoggingStatusWithContext(ctx aws.Context, input *DescribeLoggingStatusInput, opts ...request.Option) (*LoggingStatus, error) {
	req, out := c.DescribeLoggingStatusRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeNodeConfigurationOptions = "DescribeNodeConfigurationOptions"

// DescribeNodeConfigurationOptionsRequest generates a "aws/request.Request" representing the
// client's request for the DescribeNodeConfigurationOptions operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeNodeConfigurationOptions for more information on using the DescribeNodeConfigurationOptions
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeNodeConfigurationOptionsRequest method.
//    req, resp := client.DescribeNodeConfigurationOptionsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/DescribeNodeConfigurationOptions
func (c *Redshift) DescribeNodeConfigurationOptionsRequest(input *DescribeNodeConfigurationOptionsInput) (req *request.Request, output *DescribeNodeConfigurationOptionsOutput) {
	op := &request.Operation{
		Name:       opDescribeNodeConfigurationOptions,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"Marker"},
			OutputTokens:    []string{"Marker"},
			LimitToken:      "MaxRecords",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &DescribeNodeConfigurationOptionsInput{}
	}

	output = &DescribeNodeConfigurationOptionsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeNodeConfigurationOptions API operation for Amazon Redshift.
//
// Returns properties of possible node configurations such as node type, number
// of nodes, and disk usage for the specified action type.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Redshift's
// API operation DescribeNodeConfigurationOptions for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeClusterSnapshotNotFoundFault "ClusterSnapshotNotFound"
//   The snapshot identifier does not refer to an existing cluster snapshot.
//
//   * ErrCodeInvalidClusterSnapshotStateFault "InvalidClusterSnapshotState"
//   The specified cluster snapshot is not in the available state, or other accounts
//   are authorized to access the snapshot.
//
//   * ErrCodeClusterNotFoundFault "ClusterNotFound"
//   The ClusterIdentifier parameter does not refer to an existing cluster.
//
//   * ErrCodeAccessToSnapshotDeniedFault "AccessToSnapshotDenied"
//   The owner of the specified snapshot has not authorized your account to access
//   the snapshot.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/DescribeNodeConfigurationOptions
func (c *Redshift) DescribeNodeConfigurationOptions(input *DescribeNodeConfigurationOptionsInput) (*DescribeNodeConfigurationOptionsOutput, error) {
	req, out := c.DescribeNodeConfigurationOptionsRequest(input)
	return out, req.Send()
}

// DescribeNodeConfigurationOptionsWithContext is the same as DescribeNodeConfigurationOptions with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeNodeConfigurationOptions for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Redshift) DescribeNodeConfigurationOptionsWithContext(ctx aws.Context, input *DescribeNodeConfigurationOptionsInput, opts ...request.Option) (*DescribeNodeConfigurationOptionsOutput, error) {
	req, out := c.DescribeNodeConfigurationOptionsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// DescribeNodeConfigurationOptionsPages iterates over the pages of a DescribeNodeConfigurationOptions operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See DescribeNodeConfigurationOptions method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a DescribeNodeConfigurationOptions operation.
//    pageNum := 0
//    err := client.DescribeNodeConfigurationOptionsPages(params,
//        func(page *redshift.DescribeNodeConfigurationOptionsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *Redshift) DescribeNodeConfigurationOptionsPages(input *DescribeNodeConfigurationOptionsInput, fn func(*DescribeNodeConfigurationOptionsOutput, bool) bool) error {
	return c.DescribeNodeConfigurationOptionsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// DescribeNodeConfigurationOptionsPagesWithContext same as DescribeNodeConfigurationOptionsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Redshift) DescribeNodeConfigurationOptionsPagesWithContext(ctx aws.Context, input *DescribeNodeConfigurationOptionsInput, fn func(*DescribeNodeConfigurationOptionsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *DescribeNodeConfigurationOptionsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.DescribeNodeConfigurationOptionsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*DescribeNodeConfigurationOptionsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opDescribeOrderableClusterOptions = "DescribeOrderableClusterOptions"

// DescribeOrderableClusterOptionsRequest generates a "aws/request.Request" representing the
// client's request for the DescribeOrderableClusterOptions operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeOrderableClusterOptions for more information on using the DescribeOrderableClusterOptions
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeOrderableClusterOptionsRequest method.
//    req, resp := client.DescribeOrderableClusterOptionsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/DescribeOrderableClusterOptions
func (c *Redshift) DescribeOrderableClusterOptionsRequest(input *DescribeOrderableClusterOptionsInput) (req *request.Request, output *DescribeOrderableClusterOptionsOutput) {
	op := &request.Operation{
		Name:       opDescribeOrderableClusterOptions,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"Marker"},
			OutputTokens:    []string{"Marker"},
			LimitToken:      "MaxRecords",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &DescribeOrderableClusterOptionsInput{}
	}

	output = &DescribeOrderableClusterOptionsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeOrderableClusterOptions API operation for Amazon Redshift.
//
// Returns a list of orderable cluster options. Before you create a new cluster
// you can use this operation to find what options are available, such as the
// EC2 Availability Zones (AZ) in the specific AWS Region that you can specify,
// and the node types you can request. The node types differ by available storage,
// memory, CPU and price. With the cost involved you might want to obtain a
// list of cluster options in the specific region and specify values when creating
// a cluster. For more information about managing clusters, go to Amazon Redshift
// Clusters (https://docs.aws.amazon.com/redshift/latest/mgmt/working-with-clusters.html)
// in the Amazon Redshift Cluster Management Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Redshift's
// API operation DescribeOrderableClusterOptions for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/DescribeOrderableClusterOptions
func (c *Redshift) DescribeOrderableClusterOptions(input *DescribeOrderableClusterOptionsInput) (*DescribeOrderableClusterOptionsOutput, error) {
	req, out := c.DescribeOrderableClusterOptionsRequest(input)
	return out, req.Send()
}

// DescribeOrderableClusterOptionsWithContext is the same as DescribeOrderableClusterOptions with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeOrderableClusterOptions for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Redshift) DescribeOrderableClusterOptionsWithContext(ctx aws.Context, input *DescribeOrderableClusterOptionsInput, opts ...request.Option) (*DescribeOrderableClusterOptionsOutput, error) {
	req, out := c.DescribeOrderableClusterOptionsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// DescribeOrderableClusterOptionsPages iterates over the pages of a DescribeOrderableClusterOptions operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See DescribeOrderableClusterOptions method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a DescribeOrderableClusterOptions operation.
//    pageNum := 0
//    err := client.DescribeOrderableClusterOptionsPages(params,
//        func(page *redshift.DescribeOrderableClusterOptionsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *Redshift) DescribeOrderableClusterOptionsPages(input *DescribeOrderableClusterOptionsInput, fn func(*DescribeOrderableClusterOptionsOutput, bool) bool) error {
	return c.DescribeOrderableClusterOptionsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// DescribeOrderableClusterOptionsPagesWithContext same as DescribeOrderableClusterOptionsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Redshift) DescribeOrderableClusterOptionsPagesWithContext(ctx aws.Context, input *DescribeOrderableClusterOptionsInput, fn func(*DescribeOrderableClusterOptionsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *DescribeOrderableClusterOptionsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.DescribeOrderableClusterOptionsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*DescribeOrderableClusterOptionsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opDescribeReservedNodeOfferings = "DescribeReservedNodeOfferings"

// DescribeReservedNodeOfferingsRequest generates a "aws/request.Request" representing the
// client's request for the DescribeReservedNodeOfferings operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeReservedNodeOfferings for more information on using the DescribeReservedNodeOfferings
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeReservedNodeOfferingsRequest method.
//    req, resp := client.DescribeReservedNodeOfferingsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/DescribeReservedNodeOfferings
func (c *Redshift) DescribeReservedNodeOfferingsRequest(input *DescribeReservedNodeOfferingsInput) (req *request.Request, output *DescribeReservedNodeOfferingsOutput) {
	op := &request.Operation{
		Name:       opDescribeReservedNodeOfferings,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"Marker"},
			OutputTokens:    []string{"Marker"},
			LimitToken:      "MaxRecords",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &DescribeReservedNodeOfferingsInput{}
	}

	output = &DescribeReservedNodeOfferingsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeReservedNodeOfferings API operation for Amazon Redshift.
//
// Returns a list of the available reserved node offerings by Amazon Redshift
// with their descriptions including the node type, the fixed and recurring
// costs of reserving the node and duration the node will be reserved for you.
// These descriptions help you determine which reserve node offering you want
// to purchase. You then use the unique offering ID in you call to PurchaseReservedNodeOffering
// to reserve one or more nodes for your Amazon Redshift cluster.
//
// For more information about reserved node offerings, go to Purchasing Reserved
// Nodes (https://docs.aws.amazon.com/redshift/latest/mgmt/purchase-reserved-node-instance.html)
// in the Amazon Redshift Cluster Management Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Redshift's
// API operation DescribeReservedNodeOfferings for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeReservedNodeOfferingNotFoundFault "ReservedNodeOfferingNotFound"
//   Specified offering does not exist.
//
//   * ErrCodeUnsupportedOperationFault "UnsupportedOperation"
//   The requested operation isn't supported.
//
//   * ErrCodeDependentServiceUnavailableFault "DependentServiceUnavailableFault"
//   Your request cannot be completed because a dependent internal service is
//   temporarily unavailable. Wait 30 to 60 seconds and try again.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/DescribeReservedNodeOfferings
func (c *Redshift) DescribeReservedNodeOfferings(input *DescribeReservedNodeOfferingsInput) (*DescribeReservedNodeOfferingsOutput, error) {
	req, out := c.DescribeReservedNodeOfferingsRequest(input)
	return out, req.Send()
}

// DescribeReservedNodeOfferingsWithContext is the same as DescribeReservedNodeOfferings with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeReservedNodeOfferings for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Redshift) DescribeReservedNodeOfferingsWithContext(ctx aws.Context, input *DescribeReservedNodeOfferingsInput, opts ...request.Option) (*DescribeReservedNodeOfferingsOutput, error) {
	req, out := c.DescribeReservedNodeOfferingsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// DescribeReservedNodeOfferingsPages iterates over the pages of a DescribeReservedNodeOfferings operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See DescribeReservedNodeOfferings method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a DescribeReservedNodeOfferings operation.
//    pageNum := 0
//    err := client.DescribeReservedNodeOfferingsPages(params,
//        func(page *redshift.DescribeReservedNodeOfferingsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *Redshift) DescribeReservedNodeOfferingsPages(input *DescribeReservedNodeOfferingsInput, fn func(*DescribeReservedNodeOfferingsOutput, bool) bool) error {
	return c.DescribeReservedNodeOfferingsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// DescribeReservedNodeOfferingsPagesWithContext same as DescribeReservedNodeOfferingsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Redshift) DescribeReservedNodeOfferingsPagesWithContext(ctx aws.Context, input *DescribeReservedNodeOfferingsInput, fn func(*DescribeReservedNodeOfferingsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *DescribeReservedNodeOfferingsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.DescribeReservedNodeOfferingsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*DescribeReservedNodeOfferingsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opDescribeReservedNodes = "DescribeReservedNodes"

// DescribeReservedNodesRequest generates a "aws/request.Request" representing the
// client's request for the DescribeReservedNodes operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeReservedNodes for more information on using the DescribeReservedNodes
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeReservedNodesRequest method.
//    req, resp := client.DescribeReservedNodesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/DescribeReservedNodes
func (c *Redshift) DescribeReservedNodesRequest(input *DescribeReservedNodesInput) (req *request.Request, output *DescribeReservedNodesOutput) {
	op := &request.Operation{
		Name:       opDescribeReservedNodes,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"Marker"},
			OutputTokens:    []string{"Marker"},
			LimitToken:      "MaxRecords",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &DescribeReservedNodesInput{}
	}

	output = &DescribeReservedNodesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeReservedNodes API operation for Amazon Redshift.
//
// Returns the descriptions of the reserved nodes.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Redshift's
// API operation DescribeReservedNodes for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeReservedNodeNotFoundFault "ReservedNodeNotFound"
//   The specified reserved compute node not found.
//
//   * ErrCodeDependentServiceUnavailableFault "DependentServiceUnavailableFault"
//   Your request cannot be completed because a dependent internal service is
//   temporarily unavailable. Wait 30 to 60 seconds and try again.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/DescribeReservedNodes
func (c *Redshift) DescribeReservedNodes(input *DescribeReservedNodesInput) (*DescribeReservedNodesOutput, error) {
	req, out := c.DescribeReservedNodesRequest(input)
	return out, req.Send()
}

// DescribeReservedNodesWithContext is the same as DescribeReservedNodes with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeReservedNodes for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Redshift) DescribeReservedNodesWithContext(ctx aws.Context, input *DescribeReservedNodesInput, opts ...request.Option) (*DescribeReservedNodesOutput, error) {
	req, out := c.DescribeReservedNodesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// DescribeReservedNodesPages iterates over the pages of a DescribeReservedNodes operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See DescribeReservedNodes method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a DescribeReservedNodes operation.
//    pageNum := 0
//    err := client.DescribeReservedNodesPages(params,
//        func(page *redshift.DescribeReservedNodesOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *Redshift) DescribeReservedNodesPages(input *DescribeReservedNodesInput, fn func(*DescribeReservedNodesOutput, bool) bool) error {
	return c.DescribeReservedNodesPagesWithContext(aws.BackgroundContext(), input, fn)
}

// DescribeReservedNodesPagesWithContext same as DescribeReservedNodesPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Redshift) DescribeReservedNodesPagesWithContext(ctx aws.Context, input *DescribeReservedNodesInput, fn func(*DescribeReservedNodesOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *DescribeReservedNodesInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.DescribeReservedNodesRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*DescribeReservedNodesOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opDescribeResize = "DescribeResize"

// DescribeResizeRequest generates a "aws/request.Request" representing the
// client's request for the DescribeResize operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeResize for more information on using the DescribeResize
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeResizeRequest method.
//    req, resp := client.DescribeResizeRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/DescribeResize
func (c *Redshift) DescribeResizeRequest(input *DescribeResizeInput) (req *request.Request, output *DescribeResizeOutput) {
	op := &request.Operation{
		Name:       opDescribeResize,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeResizeInput{}
	}

	output = &DescribeResizeOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeResize API operation for Amazon Redshift.
//
// Returns information about the last resize operation for the specified cluster.
// If no resize operation has ever been initiated for the specified cluster,
// a HTTP 404 error is returned. If a resize operation was initiated and completed,
// the status of the resize remains as SUCCEEDED until the next resize.
//
// A resize operation can be requested using ModifyCluster and specifying a
// different number or type of nodes for the cluster.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Redshift's
// API operation DescribeResize for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeClusterNotFoundFault "ClusterNotFound"
//   The ClusterIdentifier parameter does not refer to an existing cluster.
//
//   * ErrCodeResizeNotFoundFault "ResizeNotFound"
//   A resize operation for the specified cluster is not found.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/DescribeResize
func (c *Redshift) DescribeResize(input *DescribeResizeInput) (*DescribeResizeOutput, error) {
	req, out := c.DescribeResizeRequest(input)
	return out, req.Send()
}

// DescribeResizeWithContext is the same as DescribeResize with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeResize for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Redshift) DescribeResizeWithContext(ctx aws.Context, input *DescribeResizeInput, opts ...request.Option) (*DescribeResizeOutput, error) {
	req, out := c.DescribeResizeRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeScheduledActions = "DescribeScheduledActions"

// DescribeScheduledActionsRequest generates a "aws/request.Request" representing the
// client's request for the DescribeScheduledActions operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeScheduledActions for more information on using the DescribeScheduledActions
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeScheduledActionsRequest method.
//    req, resp := client.DescribeScheduledActionsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/DescribeScheduledActions
func (c *Redshift) DescribeScheduledActionsRequest(input *DescribeScheduledActionsInput) (req *request.Request, output *DescribeScheduledActionsOutput) {
	op := &request.Operation{
		Name:       opDescribeScheduledActions,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"Marker"},
			OutputTokens:    []string{"Marker"},
			LimitToken:      "MaxRecords",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &DescribeScheduledActionsInput{}
	}

	output = &DescribeScheduledActionsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeScheduledActions API operation for Amazon Redshift.
//
// Describes properties of scheduled actions.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Redshift's
// API operation DescribeScheduledActions for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeScheduledActionNotFoundFault "ScheduledActionNotFound"
//   The scheduled action cannot be found.
//
//   * ErrCodeUnauthorizedOperation "UnauthorizedOperation"
//   Your account is not authorized to perform the requested operation.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/DescribeScheduledActions
func (c *Redshift) DescribeScheduledActions(input *DescribeScheduledActionsInput) (*DescribeScheduledActionsOutput, error) {
	req, out := c.DescribeScheduledActionsRequest(input)
	return out, req.Send()
}

// DescribeScheduledActionsWithContext is the same as DescribeScheduledActions with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeScheduledActions for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Redshift) DescribeScheduledActionsWithContext(ctx aws.Context, input *DescribeScheduledActionsInput, opts ...request.Option) (*DescribeScheduledActionsOutput, error) {
	req, out := c.DescribeScheduledActionsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// DescribeScheduledActionsPages iterates over the pages of a DescribeScheduledActions operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See DescribeScheduledActions method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a DescribeScheduledActions operation.
//    pageNum := 0
//    err := client.DescribeScheduledActionsPages(params,
//        func(page *redshift.DescribeScheduledActionsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *Redshift) DescribeScheduledActionsPages(input *DescribeScheduledActionsInput, fn func(*DescribeScheduledActionsOutput, bool) bool) error {
	return c.DescribeScheduledActionsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// DescribeScheduledActionsPagesWithContext same as DescribeScheduledActionsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Redshift) DescribeScheduledActionsPagesWithContext(ctx aws.Context, input *DescribeScheduledActionsInput, fn func(*DescribeScheduledActionsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *DescribeScheduledActionsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.DescribeScheduledActionsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*DescribeScheduledActionsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opDescribeSnapshotCopyGrants = "DescribeSnapshotCopyGrants"

// DescribeSnapshotCopyGrantsRequest generates a "aws/request.Request" representing the
// client's request for the DescribeSnapshotCopyGrants operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeSnapshotCopyGrants for more information on using the DescribeSnapshotCopyGrants
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeSnapshotCopyGrantsRequest method.
//    req, resp := client.DescribeSnapshotCopyGrantsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/DescribeSnapshotCopyGrants
func (c *Redshift) DescribeSnapshotCopyGrantsRequest(input *DescribeSnapshotCopyGrantsInput) (req *request.Request, output *DescribeSnapshotCopyGrantsOutput) {
	op := &request.Operation{
		Name:       opDescribeSnapshotCopyGrants,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeSnapshotCopyGrantsInput{}
	}

	output = &DescribeSnapshotCopyGrantsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeSnapshotCopyGrants API operation for Amazon Redshift.
//
// Returns a list of snapshot copy grants owned by the AWS account in the destination
// region.
//
// For more information about managing snapshot copy grants, go to Amazon Redshift
// Database Encryption (https://docs.aws.amazon.com/redshift/latest/mgmt/working-with-db-encryption.html)
// in the Amazon Redshift Cluster Management Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Redshift's
// API operation DescribeSnapshotCopyGrants for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeSnapshotCopyGrantNotFoundFault "SnapshotCopyGrantNotFoundFault"
//   The specified snapshot copy grant can't be found. Make sure that the name
//   is typed correctly and that the grant exists in the destination region.
//
//   * ErrCodeInvalidTagFault "InvalidTagFault"
//   The tag is invalid.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/DescribeSnapshotCopyGrants
func (c *Redshift) DescribeSnapshotCopyGrants(input *DescribeSnapshotCopyGrantsInput) (*DescribeSnapshotCopyGrantsOutput, error) {
	req, out := c.DescribeSnapshotCopyGrantsRequest(input)
	return out, req.Send()
}

// DescribeSnapshotCopyGrantsWithContext is the same as DescribeSnapshotCopyGrants with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeSnapshotCopyGrants for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Redshift) DescribeSnapshotCopyGrantsWithContext(ctx aws.Context, input *DescribeSnapshotCopyGrantsInput, opts ...request.Option) (*DescribeSnapshotCopyGrantsOutput, error) {
	req, out := c.DescribeSnapshotCopyGrantsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeSnapshotSchedules = "DescribeSnapshotSchedules"

// DescribeSnapshotSchedulesRequest generates a "aws/request.Request" representing the
// client's request for the DescribeSnapshotSchedules operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeSnapshotSchedules for more information on using the DescribeSnapshotSchedules
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeSnapshotSchedulesRequest method.
//    req, resp := client.DescribeSnapshotSchedulesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/DescribeSnapshotSchedules
func (c *Redshift) DescribeSnapshotSchedulesRequest(input *DescribeSnapshotSchedulesInput) (req *request.Request, output *DescribeSnapshotSchedulesOutput) {
	op := &request.Operation{
		Name:       opDescribeSnapshotSchedules,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeSnapshotSchedulesInput{}
	}

	output = &DescribeSnapshotSchedulesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeSnapshotSchedules API operation for Amazon Redshift.
//
// Returns a list of snapshot schedules.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Redshift's
// API operation DescribeSnapshotSchedules for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/DescribeSnapshotSchedules
func (c *Redshift) DescribeSnapshotSchedules(input *DescribeSnapshotSchedulesInput) (*DescribeSnapshotSchedulesOutput, error) {
	req, out := c.DescribeSnapshotSchedulesRequest(input)
	return out, req.Send()
}

// DescribeSnapshotSchedulesWithContext is the same as DescribeSnapshotSchedules with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeSnapshotSchedules for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Redshift) DescribeSnapshotSchedulesWithContext(ctx aws.Context, input *DescribeSnapshotSchedulesInput, opts ...request.Option) (*DescribeSnapshotSchedulesOutput, error) {
	req, out := c.DescribeSnapshotSchedulesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeStorage = "DescribeStorage"

// DescribeStorageRequest generates a "aws/request.Request" representing the
// client's request for the DescribeStorage operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeStorage for more information on using the DescribeStorage
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeStorageRequest method.
//    req, resp := client.DescribeStorageRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/DescribeStorage
func (c *Redshift) DescribeStorageRequest(input *DescribeStorageInput) (req *request.Request, output *DescribeStorageOutput) {
	op := &request.Operation{
		Name:       opDescribeStorage,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeStorageInput{}
	}

	output = &DescribeStorageOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeStorage API operation for Amazon Redshift.
//
// Returns account level backups storage size and provisional storage.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Redshift's
// API operation DescribeStorage for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/DescribeStorage
func (c *Redshift) DescribeStorage(input *DescribeStorageInput) (*DescribeStorageOutput, error) {
	req, out := c.DescribeStorageRequest(input)
	return out, req.Send()
}

// DescribeStorageWithContext is the same as DescribeStorage with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeStorage for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Redshift) DescribeStorageWithContext(ctx aws.Context, input *DescribeStorageInput, opts ...request.Option) (*DescribeStorageOutput, error) {
	req, out := c.DescribeStorageRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeTableRestoreStatus = "DescribeTableRestoreStatus"

// DescribeTableRestoreStatusRequest generates a "aws/request.Request" representing the
// client's request for the DescribeTableRestoreStatus operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeTableRestoreStatus for more information on using the DescribeTableRestoreStatus
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeTableRestoreStatusRequest method.
//    req, resp := client.DescribeTableRestoreStatusRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/DescribeTableRestoreStatus
func (c *Redshift) DescribeTableRestoreStatusRequest(input *DescribeTableRestoreStatusInput) (req *request.Request, output *DescribeTableRestoreStatusOutput) {
	op := &request.Operation{
		Name:       opDescribeTableRestoreStatus,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeTableRestoreStatusInput{}
	}

	output = &DescribeTableRestoreStatusOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeTableRestoreStatus API operation for Amazon Redshift.
//
// Lists the status of one or more table restore requests made using the RestoreTableFromClusterSnapshot
// API action. If you don't specify a value for the TableRestoreRequestId parameter,
// then DescribeTableRestoreStatus returns the status of all table restore requests
// ordered by the date and time of the request in ascending order. Otherwise
// DescribeTableRestoreStatus returns the status of the table specified by TableRestoreRequestId.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Redshift's
// API operation DescribeTableRestoreStatus for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeTableRestoreNotFoundFault "TableRestoreNotFoundFault"
//   The specified TableRestoreRequestId value was not found.
//
//   * ErrCodeClusterNotFoundFault "ClusterNotFound"
//   The ClusterIdentifier parameter does not refer to an existing cluster.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/DescribeTableRestoreStatus
func (c *Redshift) DescribeTableRestoreStatus(input *DescribeTableRestoreStatusInput) (*DescribeTableRestoreStatusOutput, error) {
	req, out := c.DescribeTableRestoreStatusRequest(input)
	return out, req.Send()
}

// DescribeTableRestoreStatusWithContext is the same as DescribeTableRestoreStatus with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeTableRestoreStatus for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Redshift) DescribeTableRestoreStatusWithContext(ctx aws.Context, input *DescribeTableRestoreStatusInput, opts ...request.Option) (*DescribeTableRestoreStatusOutput, error) {
	req, out := c.DescribeTableRestoreStatusRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeTags = "DescribeTags"

// DescribeTagsRequest generates a "aws/request.Request" representing the
// client's request for the DescribeTags operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeTags for more information on using the DescribeTags
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeTagsRequest method.
//    req, resp := client.DescribeTagsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/DescribeTags
func (c *Redshift) DescribeTagsRequest(input *DescribeTagsInput) (req *request.Request, output *DescribeTagsOutput) {
	op := &request.Operation{
		Name:       opDescribeTags,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeTagsInput{}
	}

	output = &DescribeTagsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeTags API operation for Amazon Redshift.
//
// Returns a list of tags. You can return tags from a specific resource by specifying
// an ARN, or you can return all tags for a given type of resource, such as
// clusters, snapshots, and so on.
//
// The following are limitations for DescribeTags:
//
//    * You cannot specify an ARN and a resource-type value together in the
//    same request.
//
//    * You cannot use the MaxRecords and Marker parameters together with the
//    ARN parameter.
//
//    * The MaxRecords parameter can be a range from 10 to 50 results to return
//    in a request.
//
// If you specify both tag keys and tag values in the same request, Amazon Redshift
// returns all resources that match any combination of the specified keys and
// values. For example, if you have owner and environment for tag keys, and
// admin and test for tag values, all resources that have any combination of
// those values are returned.
//
// If both tag keys and values are omitted from the request, resources are returned
// regardless of whether they have tag keys or values associated with them.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Redshift's
// API operation DescribeTags for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeResourceNotFoundFault "ResourceNotFoundFault"
//   The resource could not be found.
//
//   * ErrCodeInvalidTagFault "InvalidTagFault"
//   The tag is invalid.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/DescribeTags
func (c *Redshift) DescribeTags(input *DescribeTagsInput) (*DescribeTagsOutput, error) {
	req, out := c.DescribeTagsRequest(input)
	return out, req.Send()
}

// DescribeTagsWithContext is the same as DescribeTags with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeTags for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Redshift) DescribeTagsWithContext(ctx aws.Context, input *DescribeTagsInput, opts ...request.Option) (*DescribeTagsOutput, error) {
	req, out := c.DescribeTagsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDisableLogging = "DisableLogging"

// DisableLoggingRequest generates a "aws/request.Request" representing the
// client's request for the DisableLogging operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DisableLogging for more information on using the DisableLogging
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DisableLoggingRequest method.
//    req, resp := client.DisableLoggingRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/DisableLogging
func (c *Redshift) DisableLoggingRequest(input *DisableLoggingInput) (req *request.Request, output *LoggingStatus) {
	op := &request.Operation{
		Name:       opDisableLogging,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DisableLoggingInput{}
	}

	output = &LoggingStatus{}
	req = c.newRequest(op, input, output)
	return
}

// DisableLogging API operation for Amazon Redshift.
//
// Stops logging information, such as queries and connection attempts, for the
// specified Amazon Redshift cluster.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Redshift's
// API operation DisableLogging for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeClusterNotFoundFault "ClusterNotFound"
//   The ClusterIdentifier parameter does not refer to an existing cluster.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/DisableLogging
func (c *Redshift) DisableLogging(input *DisableLoggingInput) (*LoggingStatus, error) {
	req, out := c.DisableLoggingRequest(input)
	return out, req.Send()
}

// DisableLoggingWithContext is the same as DisableLogging with the addition of
// the ability to pass a context and additional request options.
//
// See DisableLogging for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Redshift) DisableLoggingWithContext(ctx aws.Context, input *DisableLoggingInput, opts ...request.Option) (*LoggingStatus, error) {
	req, out := c.DisableLoggingRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDisableSnapshotCopy = "DisableSnapshotCopy"

// DisableSnapshotCopyRequest generates a "aws/request.Request" representing the
// client's request for the DisableSnapshotCopy operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DisableSnapshotCopy for more information on using the DisableSnapshotCopy
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DisableSnapshotCopyRequest method.
//    req, resp := client.DisableSnapshotCopyRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/DisableSnapshotCopy
func (c *Redshift) DisableSnapshotCopyRequest(input *DisableSnapshotCopyInput) (req *request.Request, output *DisableSnapshotCopyOutput) {
	op := &request.Operation{
		Name:       opDisableSnapshotCopy,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DisableSnapshotCopyInput{}
	}

	output = &DisableSnapshotCopyOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DisableSnapshotCopy API operation for Amazon Redshift.
//
// Disables the automatic copying of snapshots from one region to another region
// for a specified cluster.
//
// If your cluster and its snapshots are encrypted using a customer master key
// (CMK) from AWS KMS, use DeleteSnapshotCopyGrant to delete the grant that
// grants Amazon Redshift permission to the CMK in the destination region.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Redshift's
// API operation DisableSnapshotCopy for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeClusterNotFoundFault "ClusterNotFound"
//   The ClusterIdentifier parameter does not refer to an existing cluster.
//
//   * ErrCodeSnapshotCopyAlreadyDisabledFault "SnapshotCopyAlreadyDisabledFault"
//   The cluster already has cross-region snapshot copy disabled.
//
//   * ErrCodeInvalidClusterStateFault "InvalidClusterState"
//   The specified cluster is not in the available state.
//
//   * ErrCodeUnauthorizedOperation "UnauthorizedOperation"
//   Your account is not authorized to perform the requested operation.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/DisableSnapshotCopy
func (c *Redshift) DisableSnapshotCopy(input *DisableSnapshotCopyInput) (*DisableSnapshotCopyOutput, error) {
	req, out := c.DisableSnapshotCopyRequest(input)
	return out, req.Send()
}

// DisableSnapshotCopyWithContext is the same as DisableSnapshotCopy with the addition of
// the ability to pass a context and additional request options.
//
// See DisableSnapshotCopy for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Redshift) DisableSnapshotCopyWithContext(ctx aws.Context, input *DisableSnapshotCopyInput, opts ...request.Option) (*DisableSnapshotCopyOutput, error) {
	req, out := c.DisableSnapshotCopyRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opEnableLogging = "EnableLogging"

// EnableLoggingRequest generates a "aws/request.Request" representing the
// client's request for the EnableLogging operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See EnableLogging for more information on using the EnableLogging
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the EnableLoggingRequest method.
//    req, resp := client.EnableLoggingRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/EnableLogging
func (c *Redshift) EnableLoggingRequest(input *EnableLoggingInput) (req *request.Request, output *LoggingStatus) {
	op := &request.Operation{
		Name:       opEnableLogging,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &EnableLoggingInput{}
	}

	output = &LoggingStatus{}
	req = c.newRequest(op, input, output)
	return
}

// EnableLogging API operation for Amazon Redshift.
//
// Starts logging information, such as queries and connection attempts, for
// the specified Amazon Redshift cluster.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Redshift's
// API operation EnableLogging for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeClusterNotFoundFault "ClusterNotFound"
//   The ClusterIdentifier parameter does not refer to an existing cluster.
//
//   * ErrCodeBucketNotFoundFault "BucketNotFoundFault"
//   Could not find the specified S3 bucket.
//
//   * ErrCodeInsufficientS3BucketPolicyFault "InsufficientS3BucketPolicyFault"
//   The cluster does not have read bucket or put object permissions on the S3
//   bucket specified when enabling logging.
//
//   * ErrCodeInvalidS3KeyPrefixFault "InvalidS3KeyPrefixFault"
//   The string specified for the logging S3 key prefix does not comply with the
//   documented constraints.
//
//   * ErrCodeInvalidS3BucketNameFault "InvalidS3BucketNameFault"
//   The S3 bucket name is invalid. For more information about naming rules, go
//   to Bucket Restrictions and Limitations (https://docs.aws.amazon.com/AmazonS3/latest/dev/BucketRestrictions.html)
//   in the Amazon Simple Storage Service (S3) Developer Guide.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/EnableLogging
func (c *Redshift) EnableLogging(input *EnableLoggingInput) (*LoggingStatus, error) {
	req, out := c.EnableLoggingRequest(input)
	return out, req.Send()
}

// EnableLoggingWithContext is the same as EnableLogging with the addition of
// the ability to pass a context and additional request options.
//
// See EnableLogging for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Redshift) EnableLoggingWithContext(ctx aws.Context, input *EnableLoggingInput, opts ...request.Option) (*LoggingStatus, error) {
	req, out := c.EnableLoggingRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opEnableSnapshotCopy = "EnableSnapshotCopy"

// EnableSnapshotCopyRequest generates a "aws/request.Request" representing the
// client's request for the EnableSnapshotCopy operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See EnableSnapshotCopy for more information on using the EnableSnapshotCopy
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the EnableSnapshotCopyRequest method.
//    req, resp := client.EnableSnapshotCopyRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/EnableSnapshotCopy
func (c *Redshift) EnableSnapshotCopyRequest(input *EnableSnapshotCopyInput) (req *request.Request, output *EnableSnapshotCopyOutput) {
	op := &request.Operation{
		Name:       opEnableSnapshotCopy,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &EnableSnapshotCopyInput{}
	}

	output = &EnableSnapshotCopyOutput{}
	req = c.newRequest(op, input, output)
	return
}

// EnableSnapshotCopy API operation for Amazon Redshift.
//
// Enables the automatic copy of snapshots from one region to another region
// for a specified cluster.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Redshift's
// API operation EnableSnapshotCopy for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeIncompatibleOrderableOptions "IncompatibleOrderableOptions"
//   The specified options are incompatible.
//
//   * ErrCodeInvalidClusterStateFault "InvalidClusterState"
//   The specified cluster is not in the available state.
//
//   * ErrCodeClusterNotFoundFault "ClusterNotFound"
//   The ClusterIdentifier parameter does not refer to an existing cluster.
//
//   * ErrCodeCopyToRegionDisabledFault "CopyToRegionDisabledFault"
//   Cross-region snapshot copy was temporarily disabled. Try your request again.
//
//   * ErrCodeSnapshotCopyAlreadyEnabledFault "SnapshotCopyAlreadyEnabledFault"
//   The cluster already has cross-region snapshot copy enabled.
//
//   * ErrCodeUnknownSnapshotCopyRegionFault "UnknownSnapshotCopyRegionFault"
//   The specified region is incorrect or does not exist.
//
//   * ErrCodeUnauthorizedOperation "UnauthorizedOperation"
//   Your account is not authorized to perform the requested operation.
//
//   * ErrCodeSnapshotCopyGrantNotFoundFault "SnapshotCopyGrantNotFoundFault"
//   The specified snapshot copy grant can't be found. Make sure that the name
//   is typed correctly and that the grant exists in the destination region.
//
//   * ErrCodeLimitExceededFault "LimitExceededFault"
//   The encryption key has exceeded its grant limit in AWS KMS.
//
//   * ErrCodeDependentServiceRequestThrottlingFault "DependentServiceRequestThrottlingFault"
//   The request cannot be completed because a dependent service is throttling
//   requests made by Amazon Redshift on your behalf. Wait and retry the request.
//
//   * ErrCodeInvalidRetentionPeriodFault "InvalidRetentionPeriodFault"
//   The retention period specified is either in the past or is not a valid value.
//
//   The value must be either -1 or an integer between 1 and 3,653.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/EnableSnapshotCopy
func (c *Redshift) EnableSnapshotCopy(input *EnableSnapshotCopyInput) (*EnableSnapshotCopyOutput, error) {
	req, out := c.EnableSnapshotCopyRequest(input)
	return out, req.Send()
}

// EnableSnapshotCopyWithContext is the same as EnableSnapshotCopy with the addition of
// the ability to pass a context and additional request options.
//
// See EnableSnapshotCopy for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Redshift) EnableSnapshotCopyWithContext(ctx aws.Context, input *EnableSnapshotCopyInput, opts ...request.Option) (*EnableSnapshotCopyOutput, error) {
	req, out := c.EnableSnapshotCopyRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetClusterCredentials = "GetClusterCredentials"

// GetClusterCredentialsRequest generates a "aws/request.Request" representing the
// client's request for the GetClusterCredentials operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetClusterCredentials for more information on using the GetClusterCredentials
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetClusterCredentialsRequest method.
//    req, resp := client.GetClusterCredentialsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/GetClusterCredentials
func (c *Redshift) GetClusterCredentialsRequest(input *GetClusterCredentialsInput) (req *request.Request, output *GetClusterCredentialsOutput) {
	op := &request.Operation{
		Name:       opGetClusterCredentials,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetClusterCredentialsInput{}
	}

	output = &GetClusterCredentialsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetClusterCredentials API operation for Amazon Redshift.
//
// Returns a database user name and temporary password with temporary authorization
// to log on to an Amazon Redshift database. The action returns the database
// user name prefixed with IAM: if AutoCreate is False or IAMA: if AutoCreate
// is True. You can optionally specify one or more database user groups that
// the user will join at log on. By default, the temporary credentials expire
// in 900 seconds. You can optionally specify a duration between 900 seconds
// (15 minutes) and 3600 seconds (60 minutes). For more information, see Using
// IAM Authentication to Generate Database User Credentials (https://docs.aws.amazon.com/redshift/latest/mgmt/generating-user-credentials.html)
// in the Amazon Redshift Cluster Management Guide.
//
// The AWS Identity and Access Management (IAM)user or role that executes GetClusterCredentials
// must have an IAM policy attached that allows access to all necessary actions
// and resources. For more information about permissions, see Resource Policies
// for GetClusterCredentials (https://docs.aws.amazon.com/redshift/latest/mgmt/redshift-iam-access-control-identity-based.html#redshift-policy-resources.getclustercredentials-resources)
// in the Amazon Redshift Cluster Management Guide.
//
// If the DbGroups parameter is specified, the IAM policy must allow the redshift:JoinGroup
// action with access to the listed dbgroups.
//
// In addition, if the AutoCreate parameter is set to True, then the policy
// must include the redshift:CreateClusterUser privilege.
//
// If the DbName parameter is specified, the IAM policy must allow access to
// the resource dbname for the specified database name.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Redshift's
// API operation GetClusterCredentials for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeClusterNotFoundFault "ClusterNotFound"
//   The ClusterIdentifier parameter does not refer to an existing cluster.
//
//   * ErrCodeUnsupportedOperationFault "UnsupportedOperation"
//   The requested operation isn't supported.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/GetClusterCredentials
func (c *Redshift) GetClusterCredentials(input *GetClusterCredentialsInput) (*GetClusterCredentialsOutput, error) {
	req, out := c.GetClusterCredentialsRequest(input)
	return out, req.Send()
}

// GetClusterCredentialsWithContext is the same as GetClusterCredentials with the addition of
// the ability to pass a context and additional request options.
//
// See GetClusterCredentials for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Redshift) GetClusterCredentialsWithContext(ctx aws.Context, input *GetClusterCredentialsInput, opts ...request.Option) (*GetClusterCredentialsOutput, error) {
	req, out := c.GetClusterCredentialsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetReservedNodeExchangeOfferings = "GetReservedNodeExchangeOfferings"

// GetReservedNodeExchangeOfferingsRequest generates a "aws/request.Request" representing the
// client's request for the GetReservedNodeExchangeOfferings operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetReservedNodeExchangeOfferings for more information on using the GetReservedNodeExchangeOfferings
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetReservedNodeExchangeOfferingsRequest method.
//    req, resp := client.GetReservedNodeExchangeOfferingsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/GetReservedNodeExchangeOfferings
func (c *Redshift) GetReservedNodeExchangeOfferingsRequest(input *GetReservedNodeExchangeOfferingsInput) (req *request.Request, output *GetReservedNodeExchangeOfferingsOutput) {
	op := &request.Operation{
		Name:       opGetReservedNodeExchangeOfferings,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetReservedNodeExchangeOfferingsInput{}
	}

	output = &GetReservedNodeExchangeOfferingsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetReservedNodeExchangeOfferings API operation for Amazon Redshift.
//
// Returns an array of DC2 ReservedNodeOfferings that matches the payment type,
// term, and usage price of the given DC1 reserved node.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Redshift's
// API operation GetReservedNodeExchangeOfferings for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeReservedNodeNotFoundFault "ReservedNodeNotFound"
//   The specified reserved compute node not found.
//
//   * ErrCodeInvalidReservedNodeStateFault "InvalidReservedNodeState"
//   Indicates that the Reserved Node being exchanged is not in an active state.
//
//   * ErrCodeReservedNodeAlreadyMigratedFault "ReservedNodeAlreadyMigrated"
//   Indicates that the reserved node has already been exchanged.
//
//   * ErrCodeReservedNodeOfferingNotFoundFault "ReservedNodeOfferingNotFound"
//   Specified offering does not exist.
//
//   * ErrCodeUnsupportedOperationFault "UnsupportedOperation"
//   The requested operation isn't supported.
//
//   * ErrCodeDependentServiceUnavailableFault "DependentServiceUnavailableFault"
//   Your request cannot be completed because a dependent internal service is
//   temporarily unavailable. Wait 30 to 60 seconds and try again.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/GetReservedNodeExchangeOfferings
func (c *Redshift) GetReservedNodeExchangeOfferings(input *GetReservedNodeExchangeOfferingsInput) (*GetReservedNodeExchangeOfferingsOutput, error) {
	req, out := c.GetReservedNodeExchangeOfferingsRequest(input)
	return out, req.Send()
}

// GetReservedNodeExchangeOfferingsWithContext is the same as GetReservedNodeExchangeOfferings with the addition of
// the ability to pass a context and additional request options.
//
// See GetReservedNodeExchangeOfferings for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Redshift) GetReservedNodeExchangeOfferingsWithContext(ctx aws.Context, input *GetReservedNodeExchangeOfferingsInput, opts ...request.Option) (*GetReservedNodeExchangeOfferingsOutput, error) {
	req, out := c.GetReservedNodeExchangeOfferingsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opModifyCluster = "ModifyCluster"

// ModifyClusterRequest generates a "aws/request.Request" representing the
// client's request for the ModifyCluster operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ModifyCluster for more information on using the ModifyCluster
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ModifyClusterRequest method.
//    req, resp := client.ModifyClusterRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/ModifyCluster
func (c *Redshift) ModifyClusterRequest(input *ModifyClusterInput) (req *request.Request, output *ModifyClusterOutput) {
	op := &request.Operation{
		Name:       opModifyCluster,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ModifyClusterInput{}
	}

	output = &ModifyClusterOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ModifyCluster API operation for Amazon Redshift.
//
// Modifies the settings for a cluster.
//
// You can also change node type and the number of nodes to scale up or down
// the cluster. When resizing a cluster, you must specify both the number of
// nodes and the node type even if one of the parameters does not change.
//
// You can add another security or parameter group, or change the master user
// password. Resetting a cluster password or modifying the security groups associated
// with a cluster do not need a reboot. However, modifying a parameter group
// requires a reboot for parameters to take effect. For more information about
// managing clusters, go to Amazon Redshift Clusters (https://docs.aws.amazon.com/redshift/latest/mgmt/working-with-clusters.html)
// in the Amazon Redshift Cluster Management Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Redshift's
// API operation ModifyCluster for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidClusterStateFault "InvalidClusterState"
//   The specified cluster is not in the available state.
//
//   * ErrCodeInvalidClusterSecurityGroupStateFault "InvalidClusterSecurityGroupState"
//   The state of the cluster security group is not available.
//
//   * ErrCodeClusterNotFoundFault "ClusterNotFound"
//   The ClusterIdentifier parameter does not refer to an existing cluster.
//
//   * ErrCodeNumberOfNodesQuotaExceededFault "NumberOfNodesQuotaExceeded"
//   The operation would exceed the number of nodes allotted to the account. For
//   information about increasing your quota, go to Limits in Amazon Redshift
//   (https://docs.aws.amazon.com/redshift/latest/mgmt/amazon-redshift-limits.html)
//   in the Amazon Redshift Cluster Management Guide.
//
//   * ErrCodeNumberOfNodesPerClusterLimitExceededFault "NumberOfNodesPerClusterLimitExceeded"
//   The operation would exceed the number of nodes allowed for a cluster.
//
//   * ErrCodeClusterSecurityGroupNotFoundFault "ClusterSecurityGroupNotFound"
//   The cluster security group name does not refer to an existing cluster security
//   group.
//
//   * ErrCodeClusterParameterGroupNotFoundFault "ClusterParameterGroupNotFound"
//   The parameter group name does not refer to an existing parameter group.
//
//   * ErrCodeInsufficientClusterCapacityFault "InsufficientClusterCapacity"
//   The number of nodes specified exceeds the allotted capacity of the cluster.
//
//   * ErrCodeUnsupportedOptionFault "UnsupportedOptionFault"
//   A request option was specified that is not supported.
//
//   * ErrCodeUnauthorizedOperation "UnauthorizedOperation"
//   Your account is not authorized to perform the requested operation.
//
//   * ErrCodeHsmClientCertificateNotFoundFault "HsmClientCertificateNotFoundFault"
//   There is no Amazon Redshift HSM client certificate with the specified identifier.
//
//   * ErrCodeHsmConfigurationNotFoundFault "HsmConfigurationNotFoundFault"
//   There is no Amazon Redshift HSM configuration with the specified identifier.
//
//   * ErrCodeClusterAlreadyExistsFault "ClusterAlreadyExists"
//   The account already has a cluster with the given identifier.
//
//   * ErrCodeLimitExceededFault "LimitExceededFault"
//   The encryption key has exceeded its grant limit in AWS KMS.
//
//   * ErrCodeDependentServiceRequestThrottlingFault "DependentServiceRequestThrottlingFault"
//   The request cannot be completed because a dependent service is throttling
//   requests made by Amazon Redshift on your behalf. Wait and retry the request.
//
//   * ErrCodeInvalidElasticIpFault "InvalidElasticIpFault"
//   The Elastic IP (EIP) is invalid or cannot be found.
//
//   * ErrCodeTableLimitExceededFault "TableLimitExceeded"
//   The number of tables in the cluster exceeds the limit for the requested new
//   cluster node type.
//
//   * ErrCodeInvalidClusterTrackFault "InvalidClusterTrack"
//   The provided cluster track name is not valid.
//
//   * ErrCodeInvalidRetentionPeriodFault "InvalidRetentionPeriodFault"
//   The retention period specified is either in the past or is not a valid value.
//
//   The value must be either -1 or an integer between 1 and 3,653.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/ModifyCluster
func (c *Redshift) ModifyCluster(input *ModifyClusterInput) (*ModifyClusterOutput, error) {
	req, out := c.ModifyClusterRequest(input)
	return out, req.Send()
}

// ModifyClusterWithContext is the same as ModifyCluster with the addition of
// the ability to pass a context and additional request options.
//
// See ModifyCluster for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Redshift) ModifyClusterWithContext(ctx aws.Context, input *ModifyClusterInput, opts ...request.Option) (*ModifyClusterOutput, error) {
	req, out := c.ModifyClusterRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opModifyClusterDbRevision = "ModifyClusterDbRevision"

// ModifyClusterDbRevisionRequest generates a "aws/request.Request" representing the
// client's request for the ModifyClusterDbRevision operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ModifyClusterDbRevision for more information on using the ModifyClusterDbRevision
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ModifyClusterDbRevisionRequest method.
//    req, resp := client.ModifyClusterDbRevisionRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/ModifyClusterDbRevision
func (c *Redshift) ModifyClusterDbRevisionRequest(input *ModifyClusterDbRevisionInput) (req *request.Request, output *ModifyClusterDbRevisionOutput) {
	op := &request.Operation{
		Name:       opModifyClusterDbRevision,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ModifyClusterDbRevisionInput{}
	}

	output = &ModifyClusterDbRevisionOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ModifyClusterDbRevision API operation for Amazon Redshift.
//
// Modifies the database revision of a cluster. The database revision is a unique
// revision of the database running in a cluster.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Redshift's
// API operation ModifyClusterDbRevision for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeClusterNotFoundFault "ClusterNotFound"
//   The ClusterIdentifier parameter does not refer to an existing cluster.
//
//   * ErrCodeClusterOnLatestRevisionFault "ClusterOnLatestRevision"
//   Cluster is already on the latest database revision.
//
//   * ErrCodeInvalidClusterStateFault "InvalidClusterState"
//   The specified cluster is not in the available state.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/ModifyClusterDbRevision
func (c *Redshift) ModifyClusterDbRevision(input *ModifyClusterDbRevisionInput) (*ModifyClusterDbRevisionOutput, error) {
	req, out := c.ModifyClusterDbRevisionRequest(input)
	return out, req.Send()
}

// ModifyClusterDbRevisionWithContext is the same as ModifyClusterDbRevision with the addition of
// the ability to pass a context and additional request options.
//
// See ModifyClusterDbRevision for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Redshift) ModifyClusterDbRevisionWithContext(ctx aws.Context, input *ModifyClusterDbRevisionInput, opts ...request.Option) (*ModifyClusterDbRevisionOutput, error) {
	req, out := c.ModifyClusterDbRevisionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opModifyClusterIamRoles = "ModifyClusterIamRoles"

// ModifyClusterIamRolesRequest generates a "aws/request.Request" representing the
// client's request for the ModifyClusterIamRoles operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ModifyClusterIamRoles for more information on using the ModifyClusterIamRoles
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ModifyClusterIamRolesRequest method.
//    req, resp := client.ModifyClusterIamRolesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/ModifyClusterIamRoles
func (c *Redshift) ModifyClusterIamRolesRequest(input *ModifyClusterIamRolesInput) (req *request.Request, output *ModifyClusterIamRolesOutput) {
	op := &request.Operation{
		Name:       opModifyClusterIamRoles,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ModifyClusterIamRolesInput{}
	}

	output = &ModifyClusterIamRolesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ModifyClusterIamRoles API operation for Amazon Redshift.
//
// Modifies the list of AWS Identity and Access Management (IAM) roles that
// can be used by the cluster to access other AWS services.
//
// A cluster can have up to 10 IAM roles associated at any time.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Redshift's
// API operation ModifyClusterIamRoles for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidClusterStateFault "InvalidClusterState"
//   The specified cluster is not in the available state.
//
//   * ErrCodeClusterNotFoundFault "ClusterNotFound"
//   The ClusterIdentifier parameter does not refer to an existing cluster.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/ModifyClusterIamRoles
func (c *Redshift) ModifyClusterIamRoles(input *ModifyClusterIamRolesInput) (*ModifyClusterIamRolesOutput, error) {
	req, out := c.ModifyClusterIamRolesRequest(input)
	return out, req.Send()
}

// ModifyClusterIamRolesWithContext is the same as ModifyClusterIamRoles with the addition of
// the ability to pass a context and additional request options.
//
// See ModifyClusterIamRoles for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Redshift) ModifyClusterIamRolesWithContext(ctx aws.Context, input *ModifyClusterIamRolesInput, opts ...request.Option) (*ModifyClusterIamRolesOutput, error) {
	req, out := c.ModifyClusterIamRolesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opModifyClusterMaintenance = "ModifyClusterMaintenance"

// ModifyClusterMaintenanceRequest generates a "aws/request.Request" representing the
// client's request for the ModifyClusterMaintenance operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ModifyClusterMaintenance for more information on using the ModifyClusterMaintenance
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ModifyClusterMaintenanceRequest method.
//    req, resp := client.ModifyClusterMaintenanceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/ModifyClusterMaintenance
func (c *Redshift) ModifyClusterMaintenanceRequest(input *ModifyClusterMaintenanceInput) (req *request.Request, output *ModifyClusterMaintenanceOutput) {
	op := &request.Operation{
		Name:       opModifyClusterMaintenance,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ModifyClusterMaintenanceInput{}
	}

	output = &ModifyClusterMaintenanceOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ModifyClusterMaintenance API operation for Amazon Redshift.
//
// Modifies the maintenance settings of a cluster.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Redshift's
// API operation ModifyClusterMaintenance for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeClusterNotFoundFault "ClusterNotFound"
//   The ClusterIdentifier parameter does not refer to an existing cluster.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/ModifyClusterMaintenance
func (c *Redshift) ModifyClusterMaintenance(input *ModifyClusterMaintenanceInput) (*ModifyClusterMaintenanceOutput, error) {
	req, out := c.ModifyClusterMaintenanceRequest(input)
	return out, req.Send()
}

// ModifyClusterMaintenanceWithContext is the same as ModifyClusterMaintenance with the addition of
// the ability to pass a context and additional request options.
//
// See ModifyClusterMaintenance for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Redshift) ModifyClusterMaintenanceWithContext(ctx aws.Context, input *ModifyClusterMaintenanceInput, opts ...request.Option) (*ModifyClusterMaintenanceOutput, error) {
	req, out := c.ModifyClusterMaintenanceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opModifyClusterParameterGroup = "ModifyClusterParameterGroup"

// ModifyClusterParameterGroupRequest generates a "aws/request.Request" representing the
// client's request for the ModifyClusterParameterGroup operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ModifyClusterParameterGroup for more information on using the ModifyClusterParameterGroup
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ModifyClusterParameterGroupRequest method.
//    req, resp := client.ModifyClusterParameterGroupRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/ModifyClusterParameterGroup
func (c *Redshift) ModifyClusterParameterGroupRequest(input *ModifyClusterParameterGroupInput) (req *request.Request, output *ClusterParameterGroupNameMessage) {
	op := &request.Operation{
		Name:       opModifyClusterParameterGroup,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ModifyClusterParameterGroupInput{}
	}

	output = &ClusterParameterGroupNameMessage{}
	req = c.newRequest(op, input, output)
	return
}

// ModifyClusterParameterGroup API operation for Amazon Redshift.
//
// Modifies the parameters of a parameter group.
//
// For more information about parameters and parameter groups, go to Amazon
// Redshift Parameter Groups (https://docs.aws.amazon.com/redshift/latest/mgmt/working-with-parameter-groups.html)
// in the Amazon Redshift Cluster Management Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Redshift's
// API operation ModifyClusterParameterGroup for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeClusterParameterGroupNotFoundFault "ClusterParameterGroupNotFound"
//   The parameter group name does not refer to an existing parameter group.
//
//   * ErrCodeInvalidClusterParameterGroupStateFault "InvalidClusterParameterGroupState"
//   The cluster parameter group action can not be completed because another task
//   is in progress that involves the parameter group. Wait a few moments and
//   try the operation again.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/ModifyClusterParameterGroup
func (c *Redshift) ModifyClusterParameterGroup(input *ModifyClusterParameterGroupInput) (*ClusterParameterGroupNameMessage, error) {
	req, out := c.ModifyClusterParameterGroupRequest(input)
	return out, req.Send()
}

// ModifyClusterParameterGroupWithContext is the same as ModifyClusterParameterGroup with the addition of
// the ability to pass a context and additional request options.
//
// See ModifyClusterParameterGroup for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Redshift) ModifyClusterParameterGroupWithContext(ctx aws.Context, input *ModifyClusterParameterGroupInput, opts ...request.Option) (*ClusterParameterGroupNameMessage, error) {
	req, out := c.ModifyClusterParameterGroupRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opModifyClusterSnapshot = "ModifyClusterSnapshot"

// ModifyClusterSnapshotRequest generates a "aws/request.Request" representing the
// client's request for the ModifyClusterSnapshot operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ModifyClusterSnapshot for more information on using the ModifyClusterSnapshot
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ModifyClusterSnapshotRequest method.
//    req, resp := client.ModifyClusterSnapshotRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/ModifyClusterSnapshot
func (c *Redshift) ModifyClusterSnapshotRequest(input *ModifyClusterSnapshotInput) (req *request.Request, output *ModifyClusterSnapshotOutput) {
	op := &request.Operation{
		Name:       opModifyClusterSnapshot,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ModifyClusterSnapshotInput{}
	}

	output = &ModifyClusterSnapshotOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ModifyClusterSnapshot API operation for Amazon Redshift.
//
// Modifies the settings for a snapshot.
//
// This exanmple modifies the manual retention period setting for a cluster
// snapshot.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Redshift's
// API operation ModifyClusterSnapshot for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidClusterSnapshotStateFault "InvalidClusterSnapshotState"
//   The specified cluster snapshot is not in the available state, or other accounts
//   are authorized to access the snapshot.
//
//   * ErrCodeClusterSnapshotNotFoundFault "ClusterSnapshotNotFound"
//   The snapshot identifier does not refer to an existing cluster snapshot.
//
//   * ErrCodeInvalidRetentionPeriodFault "InvalidRetentionPeriodFault"
//   The retention period specified is either in the past or is not a valid value.
//
//   The value must be either -1 or an integer between 1 and 3,653.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/ModifyClusterSnapshot
func (c *Redshift) ModifyClusterSnapshot(input *ModifyClusterSnapshotInput) (*ModifyClusterSnapshotOutput, error) {
	req, out := c.ModifyClusterSnapshotRequest(input)
	return out, req.Send()
}

// ModifyClusterSnapshotWithContext is the same as ModifyClusterSnapshot with the addition of
// the ability to pass a context and additional request options.
//
// See ModifyClusterSnapshot for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Redshift) ModifyClusterSnapshotWithContext(ctx aws.Context, input *ModifyClusterSnapshotInput, opts ...request.Option) (*ModifyClusterSnapshotOutput, error) {
	req, out := c.ModifyClusterSnapshotRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opModifyClusterSnapshotSchedule = "ModifyClusterSnapshotSchedule"

// ModifyClusterSnapshotScheduleRequest generates a "aws/request.Request" representing the
// client's request for the ModifyClusterSnapshotSchedule operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ModifyClusterSnapshotSchedule for more information on using the ModifyClusterSnapshotSchedule
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ModifyClusterSnapshotScheduleRequest method.
//    req, resp := client.ModifyClusterSnapshotScheduleRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/ModifyClusterSnapshotSchedule
func (c *Redshift) ModifyClusterSnapshotScheduleRequest(input *ModifyClusterSnapshotScheduleInput) (req *request.Request, output *ModifyClusterSnapshotScheduleOutput) {
	op := &request.Operation{
		Name:       opModifyClusterSnapshotSchedule,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ModifyClusterSnapshotScheduleInput{}
	}

	output = &ModifyClusterSnapshotScheduleOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(query.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// ModifyClusterSnapshotSchedule API operation for Amazon Redshift.
//
// Modifies a snapshot schedule for a cluster.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Redshift's
// API operation ModifyClusterSnapshotSchedule for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeClusterNotFoundFault "ClusterNotFound"
//   The ClusterIdentifier parameter does not refer to an existing cluster.
//
//   * ErrCodeSnapshotScheduleNotFoundFault "SnapshotScheduleNotFound"
//   We could not find the specified snapshot schedule.
//
//   * ErrCodeInvalidClusterSnapshotScheduleStateFault "InvalidClusterSnapshotScheduleState"
//   The cluster snapshot schedule state is not valid.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/ModifyClusterSnapshotSchedule
func (c *Redshift) ModifyClusterSnapshotSchedule(input *ModifyClusterSnapshotScheduleInput) (*ModifyClusterSnapshotScheduleOutput, error) {
	req, out := c.ModifyClusterSnapshotScheduleRequest(input)
	return out, req.Send()
}

// ModifyClusterSnapshotScheduleWithContext is the same as ModifyClusterSnapshotSchedule with the addition of
// the ability to pass a context and additional request options.
//
// See ModifyClusterSnapshotSchedule for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Redshift) ModifyClusterSnapshotScheduleWithContext(ctx aws.Context, input *ModifyClusterSnapshotScheduleInput, opts ...request.Option) (*ModifyClusterSnapshotScheduleOutput, error) {
	req, out := c.ModifyClusterSnapshotScheduleRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opModifyClusterSubnetGroup = "ModifyClusterSubnetGroup"

// ModifyClusterSubnetGroupRequest generates a "aws/request.Request" representing the
// client's request for the ModifyClusterSubnetGroup operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ModifyClusterSubnetGroup for more information on using the ModifyClusterSubnetGroup
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ModifyClusterSubnetGroupRequest method.
//    req, resp := client.ModifyClusterSubnetGroupRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/ModifyClusterSubnetGroup
func (c *Redshift) ModifyClusterSubnetGroupRequest(input *ModifyClusterSubnetGroupInput) (req *request.Request, output *ModifyClusterSubnetGroupOutput) {
	op := &request.Operation{
		Name:       opModifyClusterSubnetGroup,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ModifyClusterSubnetGroupInput{}
	}

	output = &ModifyClusterSubnetGroupOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ModifyClusterSubnetGroup API operation for Amazon Redshift.
//
// Modifies a cluster subnet group to include the specified list of VPC subnets.
// The operation replaces the existing list of subnets with the new list of
// subnets.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Redshift's
// API operation ModifyClusterSubnetGroup for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeClusterSubnetGroupNotFoundFault "ClusterSubnetGroupNotFoundFault"
//   The cluster subnet group name does not refer to an existing cluster subnet
//   group.
//
//   * ErrCodeClusterSubnetQuotaExceededFault "ClusterSubnetQuotaExceededFault"
//   The request would result in user exceeding the allowed number of subnets
//   in a cluster subnet groups. For information about increasing your quota,
//   go to Limits in Amazon Redshift (https://docs.aws.amazon.com/redshift/latest/mgmt/amazon-redshift-limits.html)
//   in the Amazon Redshift Cluster Management Guide.
//
//   * ErrCodeSubnetAlreadyInUse "SubnetAlreadyInUse"
//   A specified subnet is already in use by another cluster.
//
//   * ErrCodeInvalidSubnet "InvalidSubnet"
//   The requested subnet is not valid, or not all of the subnets are in the same
//   VPC.
//
//   * ErrCodeUnauthorizedOperation "UnauthorizedOperation"
//   Your account is not authorized to perform the requested operation.
//
//   * ErrCodeDependentServiceRequestThrottlingFault "DependentServiceRequestThrottlingFault"
//   The request cannot be completed because a dependent service is throttling
//   requests made by Amazon Redshift on your behalf. Wait and retry the request.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/ModifyClusterSubnetGroup
func (c *Redshift) ModifyClusterSubnetGroup(input *ModifyClusterSubnetGroupInput) (*ModifyClusterSubnetGroupOutput, error) {
	req, out := c.ModifyClusterSubnetGroupRequest(input)
	return out, req.Send()
}

// ModifyClusterSubnetGroupWithContext is the same as ModifyClusterSubnetGroup with the addition of
// the ability to pass a context and additional request options.
//
// See ModifyClusterSubnetGroup for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Redshift) ModifyClusterSubnetGroupWithContext(ctx aws.Context, input *ModifyClusterSubnetGroupInput, opts ...request.Option) (*ModifyClusterSubnetGroupOutput, error) {
	req, out := c.ModifyClusterSubnetGroupRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opModifyEventSubscription = "ModifyEventSubscription"

// ModifyEventSubscriptionRequest generates a "aws/request.Request" representing the
// client's request for the ModifyEventSubscription operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ModifyEventSubscription for more information on using the ModifyEventSubscription
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ModifyEventSubscriptionRequest method.
//    req, resp := client.ModifyEventSubscriptionRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/ModifyEventSubscription
func (c *Redshift) ModifyEventSubscriptionRequest(input *ModifyEventSubscriptionInput) (req *request.Request, output *ModifyEventSubscriptionOutput) {
	op := &request.Operation{
		Name:       opModifyEventSubscription,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ModifyEventSubscriptionInput{}
	}

	output = &ModifyEventSubscriptionOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ModifyEventSubscription API operation for Amazon Redshift.
//
// Modifies an existing Amazon Redshift event notification subscription.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Redshift's
// API operation ModifyEventSubscription for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeSubscriptionNotFoundFault "SubscriptionNotFound"
//   An Amazon Redshift event notification subscription with the specified name
//   does not exist.
//
//   * ErrCodeSNSInvalidTopicFault "SNSInvalidTopic"
//   Amazon SNS has responded that there is a problem with the specified Amazon
//   SNS topic.
//
//   * ErrCodeSNSNoAuthorizationFault "SNSNoAuthorization"
//   You do not have permission to publish to the specified Amazon SNS topic.
//
//   * ErrCodeSNSTopicArnNotFoundFault "SNSTopicArnNotFound"
//   An Amazon SNS topic with the specified Amazon Resource Name (ARN) does not
//   exist.
//
//   * ErrCodeSubscriptionEventIdNotFoundFault "SubscriptionEventIdNotFound"
//   An Amazon Redshift event with the specified event ID does not exist.
//
//   * ErrCodeSubscriptionCategoryNotFoundFault "SubscriptionCategoryNotFound"
//   The value specified for the event category was not one of the allowed values,
//   or it specified a category that does not apply to the specified source type.
//   The allowed values are Configuration, Management, Monitoring, and Security.
//
//   * ErrCodeSubscriptionSeverityNotFoundFault "SubscriptionSeverityNotFound"
//   The value specified for the event severity was not one of the allowed values,
//   or it specified a severity that does not apply to the specified source type.
//   The allowed values are ERROR and INFO.
//
//   * ErrCodeSourceNotFoundFault "SourceNotFound"
//   The specified Amazon Redshift event source could not be found.
//
//   * ErrCodeInvalidSubscriptionStateFault "InvalidSubscriptionStateFault"
//   The subscription request is invalid because it is a duplicate request. This
//   subscription request is already in progress.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/ModifyEventSubscription
func (c *Redshift) ModifyEventSubscription(input *ModifyEventSubscriptionInput) (*ModifyEventSubscriptionOutput, error) {
	req, out := c.ModifyEventSubscriptionRequest(input)
	return out, req.Send()
}

// ModifyEventSubscriptionWithContext is the same as ModifyEventSubscription with the addition of
// the ability to pass a context and additional request options.
//
// See ModifyEventSubscription for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Redshift) ModifyEventSubscriptionWithContext(ctx aws.Context, input *ModifyEventSubscriptionInput, opts ...request.Option) (*ModifyEventSubscriptionOutput, error) {
	req, out := c.ModifyEventSubscriptionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opModifyScheduledAction = "ModifyScheduledAction"

// ModifyScheduledActionRequest generates a "aws/request.Request" representing the
// client's request for the ModifyScheduledAction operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ModifyScheduledAction for more information on using the ModifyScheduledAction
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ModifyScheduledActionRequest method.
//    req, resp := client.ModifyScheduledActionRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/ModifyScheduledAction
func (c *Redshift) ModifyScheduledActionRequest(input *ModifyScheduledActionInput) (req *request.Request, output *ModifyScheduledActionOutput) {
	op := &request.Operation{
		Name:       opModifyScheduledAction,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ModifyScheduledActionInput{}
	}

	output = &ModifyScheduledActionOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ModifyScheduledAction API operation for Amazon Redshift.
//
// Modifies a scheduled action.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Redshift's
// API operation ModifyScheduledAction for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeScheduledActionNotFoundFault "ScheduledActionNotFound"
//   The scheduled action cannot be found.
//
//   * ErrCodeScheduledActionTypeUnsupportedFault "ScheduledActionTypeUnsupported"
//   The action type specified for a scheduled action is not supported.
//
//   * ErrCodeInvalidScheduleFault "InvalidSchedule"
//   The schedule you submitted isn't valid.
//
//   * ErrCodeInvalidScheduledActionFault "InvalidScheduledAction"
//   The scheduled action is not valid.
//
//   * ErrCodeUnauthorizedOperation "UnauthorizedOperation"
//   Your account is not authorized to perform the requested operation.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/ModifyScheduledAction
func (c *Redshift) ModifyScheduledAction(input *ModifyScheduledActionInput) (*ModifyScheduledActionOutput, error) {
	req, out := c.ModifyScheduledActionRequest(input)
	return out, req.Send()
}

// ModifyScheduledActionWithContext is the same as ModifyScheduledAction with the addition of
// the ability to pass a context and additional request options.
//
// See ModifyScheduledAction for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Redshift) ModifyScheduledActionWithContext(ctx aws.Context, input *ModifyScheduledActionInput, opts ...request.Option) (*ModifyScheduledActionOutput, error) {
	req, out := c.ModifyScheduledActionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opModifySnapshotCopyRetentionPeriod = "ModifySnapshotCopyRetentionPeriod"

// ModifySnapshotCopyRetentionPeriodRequest generates a "aws/request.Request" representing the
// client's request for the ModifySnapshotCopyRetentionPeriod operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ModifySnapshotCopyRetentionPeriod for more information on using the ModifySnapshotCopyRetentionPeriod
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ModifySnapshotCopyRetentionPeriodRequest method.
//    req, resp := client.ModifySnapshotCopyRetentionPeriodRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/ModifySnapshotCopyRetentionPeriod
func (c *Redshift) ModifySnapshotCopyRetentionPeriodRequest(input *ModifySnapshotCopyRetentionPeriodInput) (req *request.Request, output *ModifySnapshotCopyRetentionPeriodOutput) {
	op := &request.Operation{
		Name:       opModifySnapshotCopyRetentionPeriod,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ModifySnapshotCopyRetentionPeriodInput{}
	}

	output = &ModifySnapshotCopyRetentionPeriodOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ModifySnapshotCopyRetentionPeriod API operation for Amazon Redshift.
//
// Modifies the number of days to retain snapshots in the destination AWS Region
// after they are copied from the source AWS Region. By default, this operation
// only changes the retention period of copied automated snapshots. The retention
// periods for both new and existing copied automated snapshots are updated
// with the new retention period. You can set the manual option to change only
// the retention periods of copied manual snapshots. If you set this option,
// only newly copied manual snapshots have the new retention period.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Redshift's
// API operation ModifySnapshotCopyRetentionPeriod for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeClusterNotFoundFault "ClusterNotFound"
//   The ClusterIdentifier parameter does not refer to an existing cluster.
//
//   * ErrCodeSnapshotCopyDisabledFault "SnapshotCopyDisabledFault"
//   Cross-region snapshot copy was temporarily disabled. Try your request again.
//
//   * ErrCodeUnauthorizedOperation "UnauthorizedOperation"
//   Your account is not authorized to perform the requested operation.
//
//   * ErrCodeInvalidClusterStateFault "InvalidClusterState"
//   The specified cluster is not in the available state.
//
//   * ErrCodeInvalidRetentionPeriodFault "InvalidRetentionPeriodFault"
//   The retention period specified is either in the past or is not a valid value.
//
//   The value must be either -1 or an integer between 1 and 3,653.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/ModifySnapshotCopyRetentionPeriod
func (c *Redshift) ModifySnapshotCopyRetentionPeriod(input *ModifySnapshotCopyRetentionPeriodInput) (*ModifySnapshotCopyRetentionPeriodOutput, error) {
	req, out := c.ModifySnapshotCopyRetentionPeriodRequest(input)
	return out, req.Send()
}

// ModifySnapshotCopyRetentionPeriodWithContext is the same as ModifySnapshotCopyRetentionPeriod with the addition of
// the ability to pass a context and additional request options.
//
// See ModifySnapshotCopyRetentionPeriod for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Redshift) ModifySnapshotCopyRetentionPeriodWithContext(ctx aws.Context, input *ModifySnapshotCopyRetentionPeriodInput, opts ...request.Option) (*ModifySnapshotCopyRetentionPeriodOutput, error) {
	req, out := c.ModifySnapshotCopyRetentionPeriodRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opModifySnapshotSchedule = "ModifySnapshotSchedule"

// ModifySnapshotScheduleRequest generates a "aws/request.Request" representing the
// client's request for the ModifySnapshotSchedule operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ModifySnapshotSchedule for more information on using the ModifySnapshotSchedule
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ModifySnapshotScheduleRequest method.
//    req, resp := client.ModifySnapshotScheduleRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/ModifySnapshotSchedule
func (c *Redshift) ModifySnapshotScheduleRequest(input *ModifySnapshotScheduleInput) (req *request.Request, output *ModifySnapshotScheduleOutput) {
	op := &request.Operation{
		Name:       opModifySnapshotSchedule,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ModifySnapshotScheduleInput{}
	}

	output = &ModifySnapshotScheduleOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ModifySnapshotSchedule API operation for Amazon Redshift.
//
// Modifies a snapshot schedule. Any schedule associated with a cluster is modified
// asynchronously.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Redshift's
// API operation ModifySnapshotSchedule for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidScheduleFault "InvalidSchedule"
//   The schedule you submitted isn't valid.
//
//   * ErrCodeSnapshotScheduleNotFoundFault "SnapshotScheduleNotFound"
//   We could not find the specified snapshot schedule.
//
//   * ErrCodeSnapshotScheduleUpdateInProgressFault "SnapshotScheduleUpdateInProgress"
//   The specified snapshot schedule is already being updated.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/ModifySnapshotSchedule
func (c *Redshift) ModifySnapshotSchedule(input *ModifySnapshotScheduleInput) (*ModifySnapshotScheduleOutput, error) {
	req, out := c.ModifySnapshotScheduleRequest(input)
	return out, req.Send()
}

// ModifySnapshotScheduleWithContext is the same as ModifySnapshotSchedule with the addition of
// the ability to pass a context and additional request options.
//
// See ModifySnapshotSchedule for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Redshift) ModifySnapshotScheduleWithContext(ctx aws.Context, input *ModifySnapshotScheduleInput, opts ...request.Option) (*ModifySnapshotScheduleOutput, error) {
	req, out := c.ModifySnapshotScheduleRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opPurchaseReservedNodeOffering = "PurchaseReservedNodeOffering"

// PurchaseReservedNodeOfferingRequest generates a "aws/request.Request" representing the
// client's request for the PurchaseReservedNodeOffering operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See PurchaseReservedNodeOffering for more information on using the PurchaseReservedNodeOffering
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the PurchaseReservedNodeOfferingRequest method.
//    req, resp := client.PurchaseReservedNodeOfferingRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/PurchaseReservedNodeOffering
func (c *Redshift) PurchaseReservedNodeOfferingRequest(input *PurchaseReservedNodeOfferingInput) (req *request.Request, output *PurchaseReservedNodeOfferingOutput) {
	op := &request.Operation{
		Name:       opPurchaseReservedNodeOffering,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &PurchaseReservedNodeOfferingInput{}
	}

	output = &PurchaseReservedNodeOfferingOutput{}
	req = c.newRequest(op, input, output)
	return
}

// PurchaseReservedNodeOffering API operation for Amazon Redshift.
//
// Allows you to purchase reserved nodes. Amazon Redshift offers a predefined
// set of reserved node offerings. You can purchase one or more of the offerings.
// You can call the DescribeReservedNodeOfferings API to obtain the available
// reserved node offerings. You can call this API by providing a specific reserved
// node offering and the number of nodes you want to reserve.
//
// For more information about reserved node offerings, go to Purchasing Reserved
// Nodes (https://docs.aws.amazon.com/redshift/latest/mgmt/purchase-reserved-node-instance.html)
// in the Amazon Redshift Cluster Management Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Redshift's
// API operation PurchaseReservedNodeOffering for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeReservedNodeOfferingNotFoundFault "ReservedNodeOfferingNotFound"
//   Specified offering does not exist.
//
//   * ErrCodeReservedNodeAlreadyExistsFault "ReservedNodeAlreadyExists"
//   User already has a reservation with the given identifier.
//
//   * ErrCodeReservedNodeQuotaExceededFault "ReservedNodeQuotaExceeded"
//   Request would exceed the user's compute node quota. For information about
//   increasing your quota, go to Limits in Amazon Redshift (https://docs.aws.amazon.com/redshift/latest/mgmt/amazon-redshift-limits.html)
//   in the Amazon Redshift Cluster Management Guide.
//
//   * ErrCodeUnsupportedOperationFault "UnsupportedOperation"
//   The requested operation isn't supported.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/PurchaseReservedNodeOffering
func (c *Redshift) PurchaseReservedNodeOffering(input *PurchaseReservedNodeOfferingInput) (*PurchaseReservedNodeOfferingOutput, error) {
	req, out := c.PurchaseReservedNodeOfferingRequest(input)
	return out, req.Send()
}

// PurchaseReservedNodeOfferingWithContext is the same as PurchaseReservedNodeOffering with the addition of
// the ability to pass a context and additional request options.
//
// See PurchaseReservedNodeOffering for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Redshift) PurchaseReservedNodeOfferingWithContext(ctx aws.Context, input *PurchaseReservedNodeOfferingInput, opts ...request.Option) (*PurchaseReservedNodeOfferingOutput, error) {
	req, out := c.PurchaseReservedNodeOfferingRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opRebootCluster = "RebootCluster"

// RebootClusterRequest generates a "aws/request.Request" representing the
// client's request for the RebootCluster operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See RebootCluster for more information on using the RebootCluster
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the RebootClusterRequest method.
//    req, resp := client.RebootClusterRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/RebootCluster
func (c *Redshift) RebootClusterRequest(input *RebootClusterInput) (req *request.Request, output *RebootClusterOutput) {
	op := &request.Operation{
		Name:       opRebootCluster,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &RebootClusterInput{}
	}

	output = &RebootClusterOutput{}
	req = c.newRequest(op, input, output)
	return
}

// RebootCluster API operation for Amazon Redshift.
//
// Reboots a cluster. This action is taken as soon as possible. It results in
// a momentary outage to the cluster, during which the cluster status is set
// to rebooting. A cluster event is created when the reboot is completed. Any
// pending cluster modifications (see ModifyCluster) are applied at this reboot.
// For more information about managing clusters, go to Amazon Redshift Clusters
// (https://docs.aws.amazon.com/redshift/latest/mgmt/working-with-clusters.html)
// in the Amazon Redshift Cluster Management Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Redshift's
// API operation RebootCluster for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidClusterStateFault "InvalidClusterState"
//   The specified cluster is not in the available state.
//
//   * ErrCodeClusterNotFoundFault "ClusterNotFound"
//   The ClusterIdentifier parameter does not refer to an existing cluster.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/RebootCluster
func (c *Redshift) RebootCluster(input *RebootClusterInput) (*RebootClusterOutput, error) {
	req, out := c.RebootClusterRequest(input)
	return out, req.Send()
}

// RebootClusterWithContext is the same as RebootCluster with the addition of
// the ability to pass a context and additional request options.
//
// See RebootCluster for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Redshift) RebootClusterWithContext(ctx aws.Context, input *RebootClusterInput, opts ...request.Option) (*RebootClusterOutput, error) {
	req, out := c.RebootClusterRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opResetClusterParameterGroup = "ResetClusterParameterGroup"

// ResetClusterParameterGroupRequest generates a "aws/request.Request" representing the
// client's request for the ResetClusterParameterGroup operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ResetClusterParameterGroup for more information on using the ResetClusterParameterGroup
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ResetClusterParameterGroupRequest method.
//    req, resp := client.ResetClusterParameterGroupRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/ResetClusterParameterGroup
func (c *Redshift) ResetClusterParameterGroupRequest(input *ResetClusterParameterGroupInput) (req *request.Request, output *ClusterParameterGroupNameMessage) {
	op := &request.Operation{
		Name:       opResetClusterParameterGroup,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ResetClusterParameterGroupInput{}
	}

	output = &ClusterParameterGroupNameMessage{}
	req = c.newRequest(op, input, output)
	return
}

// ResetClusterParameterGroup API operation for Amazon Redshift.
//
// Sets one or more parameters of the specified parameter group to their default
// values and sets the source values of the parameters to "engine-default".
// To reset the entire parameter group specify the ResetAllParameters parameter.
// For parameter changes to take effect you must reboot any associated clusters.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Redshift's
// API operation ResetClusterParameterGroup for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidClusterParameterGroupStateFault "InvalidClusterParameterGroupState"
//   The cluster parameter group action can not be completed because another task
//   is in progress that involves the parameter group. Wait a few moments and
//   try the operation again.
//
//   * ErrCodeClusterParameterGroupNotFoundFault "ClusterParameterGroupNotFound"
//   The parameter group name does not refer to an existing parameter group.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/ResetClusterParameterGroup
func (c *Redshift) ResetClusterParameterGroup(input *ResetClusterParameterGroupInput) (*ClusterParameterGroupNameMessage, error) {
	req, out := c.ResetClusterParameterGroupRequest(input)
	return out, req.Send()
}

// ResetClusterParameterGroupWithContext is the same as ResetClusterParameterGroup with the addition of
// the ability to pass a context and additional request options.
//
// See ResetClusterParameterGroup for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Redshift) ResetClusterParameterGroupWithContext(ctx aws.Context, input *ResetClusterParameterGroupInput, opts ...request.Option) (*ClusterParameterGroupNameMessage, error) {
	req, out := c.ResetClusterParameterGroupRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opResizeCluster = "ResizeCluster"

// ResizeClusterRequest generates a "aws/request.Request" representing the
// client's request for the ResizeCluster operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ResizeCluster for more information on using the ResizeCluster
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ResizeClusterRequest method.
//    req, resp := client.ResizeClusterRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/ResizeCluster
func (c *Redshift) ResizeClusterRequest(input *ResizeClusterInput) (req *request.Request, output *ResizeClusterOutput) {
	op := &request.Operation{
		Name:       opResizeCluster,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ResizeClusterInput{}
	}

	output = &ResizeClusterOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ResizeCluster API operation for Amazon Redshift.
//
// Changes the size of the cluster. You can change the cluster's type, or change
// the number or type of nodes. The default behavior is to use the elastic resize
// method. With an elastic resize, your cluster is available for read and write
// operations more quickly than with the classic resize method.
//
// Elastic resize operations have the following restrictions:
//
//    * You can only resize clusters of the following types: dc2.large dc2.8xlarge
//    ds2.xlarge ds2.8xlarge ra3.16xlarge
//
//    * The type of nodes that you add must match the node type for the cluster.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Redshift's
// API operation ResizeCluster for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidClusterStateFault "InvalidClusterState"
//   The specified cluster is not in the available state.
//
//   * ErrCodeClusterNotFoundFault "ClusterNotFound"
//   The ClusterIdentifier parameter does not refer to an existing cluster.
//
//   * ErrCodeNumberOfNodesQuotaExceededFault "NumberOfNodesQuotaExceeded"
//   The operation would exceed the number of nodes allotted to the account. For
//   information about increasing your quota, go to Limits in Amazon Redshift
//   (https://docs.aws.amazon.com/redshift/latest/mgmt/amazon-redshift-limits.html)
//   in the Amazon Redshift Cluster Management Guide.
//
//   * ErrCodeNumberOfNodesPerClusterLimitExceededFault "NumberOfNodesPerClusterLimitExceeded"
//   The operation would exceed the number of nodes allowed for a cluster.
//
//   * ErrCodeInsufficientClusterCapacityFault "InsufficientClusterCapacity"
//   The number of nodes specified exceeds the allotted capacity of the cluster.
//
//   * ErrCodeUnsupportedOptionFault "UnsupportedOptionFault"
//   A request option was specified that is not supported.
//
//   * ErrCodeUnsupportedOperationFault "UnsupportedOperation"
//   The requested operation isn't supported.
//
//   * ErrCodeUnauthorizedOperation "UnauthorizedOperation"
//   Your account is not authorized to perform the requested operation.
//
//   * ErrCodeLimitExceededFault "LimitExceededFault"
//   The encryption key has exceeded its grant limit in AWS KMS.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/ResizeCluster
func (c *Redshift) ResizeCluster(input *ResizeClusterInput) (*ResizeClusterOutput, error) {
	req, out := c.ResizeClusterRequest(input)
	return out, req.Send()
}

// ResizeClusterWithContext is the same as ResizeCluster with the addition of
// the ability to pass a context and additional request options.
//
// See ResizeCluster for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Redshift) ResizeClusterWithContext(ctx aws.Context, input *ResizeClusterInput, opts ...request.Option) (*ResizeClusterOutput, error) {
	req, out := c.ResizeClusterRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opRestoreFromClusterSnapshot = "RestoreFromClusterSnapshot"

// RestoreFromClusterSnapshotRequest generates a "aws/request.Request" representing the
// client's request for the RestoreFromClusterSnapshot operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See RestoreFromClusterSnapshot for more information on using the RestoreFromClusterSnapshot
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the RestoreFromClusterSnapshotRequest method.
//    req, resp := client.RestoreFromClusterSnapshotRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/RestoreFromClusterSnapshot
func (c *Redshift) RestoreFromClusterSnapshotRequest(input *RestoreFromClusterSnapshotInput) (req *request.Request, output *RestoreFromClusterSnapshotOutput) {
	op := &request.Operation{
		Name:       opRestoreFromClusterSnapshot,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &RestoreFromClusterSnapshotInput{}
	}

	output = &RestoreFromClusterSnapshotOutput{}
	req = c.newRequest(op, input, output)
	return
}

// RestoreFromClusterSnapshot API operation for Amazon Redshift.
//
// Creates a new cluster from a snapshot. By default, Amazon Redshift creates
// the resulting cluster with the same configuration as the original cluster
// from which the snapshot was created, except that the new cluster is created
// with the default cluster security and parameter groups. After Amazon Redshift
// creates the cluster, you can use the ModifyCluster API to associate a different
// security group and different parameter group with the restored cluster. If
// you are using a DS node type, you can also choose to change to another DS
// node type of the same size during restore.
//
// If you restore a cluster into a VPC, you must provide a cluster subnet group
// where you want the cluster restored.
//
// For more information about working with snapshots, go to Amazon Redshift
// Snapshots (https://docs.aws.amazon.com/redshift/latest/mgmt/working-with-snapshots.html)
// in the Amazon Redshift Cluster Management Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Redshift's
// API operation RestoreFromClusterSnapshot for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeAccessToSnapshotDeniedFault "AccessToSnapshotDenied"
//   The owner of the specified snapshot has not authorized your account to access
//   the snapshot.
//
//   * ErrCodeClusterAlreadyExistsFault "ClusterAlreadyExists"
//   The account already has a cluster with the given identifier.
//
//   * ErrCodeClusterSnapshotNotFoundFault "ClusterSnapshotNotFound"
//   The snapshot identifier does not refer to an existing cluster snapshot.
//
//   * ErrCodeClusterQuotaExceededFault "ClusterQuotaExceeded"
//   The request would exceed the allowed number of cluster instances for this
//   account. For information about increasing your quota, go to Limits in Amazon
//   Redshift (https://docs.aws.amazon.com/redshift/latest/mgmt/amazon-redshift-limits.html)
//   in the Amazon Redshift Cluster Management Guide.
//
//   * ErrCodeInsufficientClusterCapacityFault "InsufficientClusterCapacity"
//   The number of nodes specified exceeds the allotted capacity of the cluster.
//
//   * ErrCodeInvalidClusterSnapshotStateFault "InvalidClusterSnapshotState"
//   The specified cluster snapshot is not in the available state, or other accounts
//   are authorized to access the snapshot.
//
//   * ErrCodeInvalidRestoreFault "InvalidRestore"
//   The restore is invalid.
//
//   * ErrCodeNumberOfNodesQuotaExceededFault "NumberOfNodesQuotaExceeded"
//   The operation would exceed the number of nodes allotted to the account. For
//   information about increasing your quota, go to Limits in Amazon Redshift
//   (https://docs.aws.amazon.com/redshift/latest/mgmt/amazon-redshift-limits.html)
//   in the Amazon Redshift Cluster Management Guide.
//
//   * ErrCodeNumberOfNodesPerClusterLimitExceededFault "NumberOfNodesPerClusterLimitExceeded"
//   The operation would exceed the number of nodes allowed for a cluster.
//
//   * ErrCodeInvalidVPCNetworkStateFault "InvalidVPCNetworkStateFault"
//   The cluster subnet group does not cover all Availability Zones.
//
//   * ErrCodeInvalidClusterSubnetGroupStateFault "InvalidClusterSubnetGroupStateFault"
//   The cluster subnet group cannot be deleted because it is in use.
//
//   * ErrCodeInvalidSubnet "InvalidSubnet"
//   The requested subnet is not valid, or not all of the subnets are in the same
//   VPC.
//
//   * ErrCodeClusterSubnetGroupNotFoundFault "ClusterSubnetGroupNotFoundFault"
//   The cluster subnet group name does not refer to an existing cluster subnet
//   group.
//
//   * ErrCodeUnauthorizedOperation "UnauthorizedOperation"
//   Your account is not authorized to perform the requested operation.
//
//   * ErrCodeHsmClientCertificateNotFoundFault "HsmClientCertificateNotFoundFault"
//   There is no Amazon Redshift HSM client certificate with the specified identifier.
//
//   * ErrCodeHsmConfigurationNotFoundFault "HsmConfigurationNotFoundFault"
//   There is no Amazon Redshift HSM configuration with the specified identifier.
//
//   * ErrCodeInvalidElasticIpFault "InvalidElasticIpFault"
//   The Elastic IP (EIP) is invalid or cannot be found.
//
//   * ErrCodeClusterParameterGroupNotFoundFault "ClusterParameterGroupNotFound"
//   The parameter group name does not refer to an existing parameter group.
//
//   * ErrCodeClusterSecurityGroupNotFoundFault "ClusterSecurityGroupNotFound"
//   The cluster security group name does not refer to an existing cluster security
//   group.
//
//   * ErrCodeLimitExceededFault "LimitExceededFault"
//   The encryption key has exceeded its grant limit in AWS KMS.
//
//   * ErrCodeDependentServiceRequestThrottlingFault "DependentServiceRequestThrottlingFault"
//   The request cannot be completed because a dependent service is throttling
//   requests made by Amazon Redshift on your behalf. Wait and retry the request.
//
//   * ErrCodeInvalidClusterTrackFault "InvalidClusterTrack"
//   The provided cluster track name is not valid.
//
//   * ErrCodeSnapshotScheduleNotFoundFault "SnapshotScheduleNotFound"
//   We could not find the specified snapshot schedule.
//
//   * ErrCodeTagLimitExceededFault "TagLimitExceededFault"
//   You have exceeded the number of tags allowed.
//
//   * ErrCodeInvalidTagFault "InvalidTagFault"
//   The tag is invalid.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/RestoreFromClusterSnapshot
func (c *Redshift) RestoreFromClusterSnapshot(input *RestoreFromClusterSnapshotInput) (*RestoreFromClusterSnapshotOutput, error) {
	req, out := c.RestoreFromClusterSnapshotRequest(input)
	return out, req.Send()
}

// RestoreFromClusterSnapshotWithContext is the same as RestoreFromClusterSnapshot with the addition of
// the ability to pass a context and additional request options.
//
// See RestoreFromClusterSnapshot for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Redshift) RestoreFromClusterSnapshotWithContext(ctx aws.Context, input *RestoreFromClusterSnapshotInput, opts ...request.Option) (*RestoreFromClusterSnapshotOutput, error) {
	req, out := c.RestoreFromClusterSnapshotRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opRestoreTableFromClusterSnapshot = "RestoreTableFromClusterSnapshot"

// RestoreTableFromClusterSnapshotRequest generates a "aws/request.Request" representing the
// client's request for the RestoreTableFromClusterSnapshot operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See RestoreTableFromClusterSnapshot for more information on using the RestoreTableFromClusterSnapshot
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the RestoreTableFromClusterSnapshotRequest method.
//    req, resp := client.RestoreTableFromClusterSnapshotRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/RestoreTableFromClusterSnapshot
func (c *Redshift) RestoreTableFromClusterSnapshotRequest(input *RestoreTableFromClusterSnapshotInput) (req *request.Request, output *RestoreTableFromClusterSnapshotOutput) {
	op := &request.Operation{
		Name:       opRestoreTableFromClusterSnapshot,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &RestoreTableFromClusterSnapshotInput{}
	}

	output = &RestoreTableFromClusterSnapshotOutput{}
	req = c.newRequest(op, input, output)
	return
}

// RestoreTableFromClusterSnapshot API operation for Amazon Redshift.
//
// Creates a new table from a table in an Amazon Redshift cluster snapshot.
// You must create the new table within the Amazon Redshift cluster that the
// snapshot was taken from.
//
// You cannot use RestoreTableFromClusterSnapshot to restore a table with the
// same name as an existing table in an Amazon Redshift cluster. That is, you
// cannot overwrite an existing table in a cluster with a restored table. If
// you want to replace your original table with a new, restored table, then
// rename or drop your original table before you call RestoreTableFromClusterSnapshot.
// When you have renamed your original table, then you can pass the original
// name of the table as the NewTableName parameter value in the call to RestoreTableFromClusterSnapshot.
// This way, you can replace the original table with the table created from
// the snapshot.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Redshift's
// API operation RestoreTableFromClusterSnapshot for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeClusterSnapshotNotFoundFault "ClusterSnapshotNotFound"
//   The snapshot identifier does not refer to an existing cluster snapshot.
//
//   * ErrCodeInProgressTableRestoreQuotaExceededFault "InProgressTableRestoreQuotaExceededFault"
//   You have exceeded the allowed number of table restore requests. Wait for
//   your current table restore requests to complete before making a new request.
//
//   * ErrCodeInvalidClusterSnapshotStateFault "InvalidClusterSnapshotState"
//   The specified cluster snapshot is not in the available state, or other accounts
//   are authorized to access the snapshot.
//
//   * ErrCodeInvalidTableRestoreArgumentFault "InvalidTableRestoreArgument"
//   The value specified for the sourceDatabaseName, sourceSchemaName, or sourceTableName
//   parameter, or a combination of these, doesn't exist in the snapshot.
//
//   * ErrCodeClusterNotFoundFault "ClusterNotFound"
//   The ClusterIdentifier parameter does not refer to an existing cluster.
//
//   * ErrCodeInvalidClusterStateFault "InvalidClusterState"
//   The specified cluster is not in the available state.
//
//   * ErrCodeUnsupportedOperationFault "UnsupportedOperation"
//   The requested operation isn't supported.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/RestoreTableFromClusterSnapshot
func (c *Redshift) RestoreTableFromClusterSnapshot(input *RestoreTableFromClusterSnapshotInput) (*RestoreTableFromClusterSnapshotOutput, error) {
	req, out := c.RestoreTableFromClusterSnapshotRequest(input)
	return out, req.Send()
}

// RestoreTableFromClusterSnapshotWithContext is the same as RestoreTableFromClusterSnapshot with the addition of
// the ability to pass a context and additional request options.
//
// See RestoreTableFromClusterSnapshot for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Redshift) RestoreTableFromClusterSnapshotWithContext(ctx aws.Context, input *RestoreTableFromClusterSnapshotInput, opts ...request.Option) (*RestoreTableFromClusterSnapshotOutput, error) {
	req, out := c.RestoreTableFromClusterSnapshotRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opRevokeClusterSecurityGroupIngress = "RevokeClusterSecurityGroupIngress"

// RevokeClusterSecurityGroupIngressRequest generates a "aws/request.Request" representing the
// client's request for the RevokeClusterSecurityGroupIngress operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See RevokeClusterSecurityGroupIngress for more information on using the RevokeClusterSecurityGroupIngress
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the RevokeClusterSecurityGroupIngressRequest method.
//    req, resp := client.RevokeClusterSecurityGroupIngressRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/RevokeClusterSecurityGroupIngress
func (c *Redshift) RevokeClusterSecurityGroupIngressRequest(input *RevokeClusterSecurityGroupIngressInput) (req *request.Request, output *RevokeClusterSecurityGroupIngressOutput) {
	op := &request.Operation{
		Name:       opRevokeClusterSecurityGroupIngress,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &RevokeClusterSecurityGroupIngressInput{}
	}

	output = &RevokeClusterSecurityGroupIngressOutput{}
	req = c.newRequest(op, input, output)
	return
}

// RevokeClusterSecurityGroupIngress API operation for Amazon Redshift.
//
// Revokes an ingress rule in an Amazon Redshift security group for a previously
// authorized IP range or Amazon EC2 security group. To add an ingress rule,
// see AuthorizeClusterSecurityGroupIngress. For information about managing
// security groups, go to Amazon Redshift Cluster Security Groups (https://docs.aws.amazon.com/redshift/latest/mgmt/working-with-security-groups.html)
// in the Amazon Redshift Cluster Management Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Redshift's
// API operation RevokeClusterSecurityGroupIngress for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeClusterSecurityGroupNotFoundFault "ClusterSecurityGroupNotFound"
//   The cluster security group name does not refer to an existing cluster security
//   group.
//
//   * ErrCodeAuthorizationNotFoundFault "AuthorizationNotFound"
//   The specified CIDR IP range or EC2 security group is not authorized for the
//   specified cluster security group.
//
//   * ErrCodeInvalidClusterSecurityGroupStateFault "InvalidClusterSecurityGroupState"
//   The state of the cluster security group is not available.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/RevokeClusterSecurityGroupIngress
func (c *Redshift) RevokeClusterSecurityGroupIngress(input *RevokeClusterSecurityGroupIngressInput) (*RevokeClusterSecurityGroupIngressOutput, error) {
	req, out := c.RevokeClusterSecurityGroupIngressRequest(input)
	return out, req.Send()
}

// RevokeClusterSecurityGroupIngressWithContext is the same as RevokeClusterSecurityGroupIngress with the addition of
// the ability to pass a context and additional request options.
//
// See RevokeClusterSecurityGroupIngress for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Redshift) RevokeClusterSecurityGroupIngressWithContext(ctx aws.Context, input *RevokeClusterSecurityGroupIngressInput, opts ...request.Option) (*RevokeClusterSecurityGroupIngressOutput, error) {
	req, out := c.RevokeClusterSecurityGroupIngressRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opRevokeSnapshotAccess = "RevokeSnapshotAccess"

// RevokeSnapshotAccessRequest generates a "aws/request.Request" representing the
// client's request for the RevokeSnapshotAccess operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See RevokeSnapshotAccess for more information on using the RevokeSnapshotAccess
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the RevokeSnapshotAccessRequest method.
//    req, resp := client.RevokeSnapshotAccessRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/RevokeSnapshotAccess
func (c *Redshift) RevokeSnapshotAccessRequest(input *RevokeSnapshotAccessInput) (req *request.Request, output *RevokeSnapshotAccessOutput) {
	op := &request.Operation{
		Name:       opRevokeSnapshotAccess,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &RevokeSnapshotAccessInput{}
	}

	output = &RevokeSnapshotAccessOutput{}
	req = c.newRequest(op, input, output)
	return
}

// RevokeSnapshotAccess API operation for Amazon Redshift.
//
// Removes the ability of the specified AWS customer account to restore the
// specified snapshot. If the account is currently restoring the snapshot, the
// restore will run to completion.
//
// For more information about working with snapshots, go to Amazon Redshift
// Snapshots (https://docs.aws.amazon.com/redshift/latest/mgmt/working-with-snapshots.html)
// in the Amazon Redshift Cluster Management Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Redshift's
// API operation RevokeSnapshotAccess for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeAccessToSnapshotDeniedFault "AccessToSnapshotDenied"
//   The owner of the specified snapshot has not authorized your account to access
//   the snapshot.
//
//   * ErrCodeAuthorizationNotFoundFault "AuthorizationNotFound"
//   The specified CIDR IP range or EC2 security group is not authorized for the
//   specified cluster security group.
//
//   * ErrCodeClusterSnapshotNotFoundFault "ClusterSnapshotNotFound"
//   The snapshot identifier does not refer to an existing cluster snapshot.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/RevokeSnapshotAccess
func (c *Redshift) RevokeSnapshotAccess(input *RevokeSnapshotAccessInput) (*RevokeSnapshotAccessOutput, error) {
	req, out := c.RevokeSnapshotAccessRequest(input)
	return out, req.Send()
}

// RevokeSnapshotAccessWithContext is the same as RevokeSnapshotAccess with the addition of
// the ability to pass a context and additional request options.
//
// See RevokeSnapshotAccess for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Redshift) RevokeSnapshotAccessWithContext(ctx aws.Context, input *RevokeSnapshotAccessInput, opts ...request.Option) (*RevokeSnapshotAccessOutput, error) {
	req, out := c.RevokeSnapshotAccessRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opRotateEncryptionKey = "RotateEncryptionKey"

// RotateEncryptionKeyRequest generates a "aws/request.Request" representing the
// client's request for the RotateEncryptionKey operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See RotateEncryptionKey for more information on using the RotateEncryptionKey
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the RotateEncryptionKeyRequest method.
//    req, resp := client.RotateEncryptionKeyRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/RotateEncryptionKey
func (c *Redshift) RotateEncryptionKeyRequest(input *RotateEncryptionKeyInput) (req *request.Request, output *RotateEncryptionKeyOutput) {
	op := &request.Operation{
		Name:       opRotateEncryptionKey,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &RotateEncryptionKeyInput{}
	}

	output = &RotateEncryptionKeyOutput{}
	req = c.newRequest(op, input, output)
	return
}

// RotateEncryptionKey API operation for Amazon Redshift.
//
// Rotates the encryption keys for a cluster.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Redshift's
// API operation RotateEncryptionKey for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeClusterNotFoundFault "ClusterNotFound"
//   The ClusterIdentifier parameter does not refer to an existing cluster.
//
//   * ErrCodeInvalidClusterStateFault "InvalidClusterState"
//   The specified cluster is not in the available state.
//
//   * ErrCodeDependentServiceRequestThrottlingFault "DependentServiceRequestThrottlingFault"
//   The request cannot be completed because a dependent service is throttling
//   requests made by Amazon Redshift on your behalf. Wait and retry the request.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/RotateEncryptionKey
func (c *Redshift) RotateEncryptionKey(input *RotateEncryptionKeyInput) (*RotateEncryptionKeyOutput, error) {
	req, out := c.RotateEncryptionKeyRequest(input)
	return out, req.Send()
}

// RotateEncryptionKeyWithContext is the same as RotateEncryptionKey with the addition of
// the ability to pass a context and additional request options.
//
// See RotateEncryptionKey for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Redshift) RotateEncryptionKeyWithContext(ctx aws.Context, input *RotateEncryptionKeyInput, opts ...request.Option) (*RotateEncryptionKeyOutput, error) {
	req, out := c.RotateEncryptionKeyRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

type AcceptReservedNodeExchangeInput struct {
	_ struct{} `type:"structure"`

	// A string representing the node identifier of the DC1 Reserved Node to be
	// exchanged.
	//
	// ReservedNodeId is a required field
	ReservedNodeId *string `type:"string" required:"true"`

	// The unique identifier of the DC2 Reserved Node offering to be used for the
	// exchange. You can obtain the value for the parameter by calling GetReservedNodeExchangeOfferings
	//
	// TargetReservedNodeOfferingId is a required field
	TargetReservedNodeOfferingId *string `type:"string" required:"true"`
}

// String returns the string representation
func (s AcceptReservedNodeExchangeInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AcceptReservedNodeExchangeInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AcceptReservedNodeExchangeInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AcceptReservedNodeExchangeInput"}
	if s.ReservedNodeId == nil {
		invalidParams.Add(request.NewErrParamRequired("ReservedNodeId"))
	}
	if s.TargetReservedNodeOfferingId == nil {
		invalidParams.Add(request.NewErrParamRequired("TargetReservedNodeOfferingId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetReservedNodeId sets the ReservedNodeId field's value.
func (s *AcceptReservedNodeExchangeInput) SetReservedNodeId(v string) *AcceptReservedNodeExchangeInput {
	s.ReservedNodeId = &v
	return s
}

// SetTargetReservedNodeOfferingId sets the TargetReservedNodeOfferingId field's value.
func (s *AcceptReservedNodeExchangeInput) SetTargetReservedNodeOfferingId(v string) *AcceptReservedNodeExchangeInput {
	s.TargetReservedNodeOfferingId = &v
	return s
}

type AcceptReservedNodeExchangeOutput struct {
	_ struct{} `type:"structure"`

	// Describes a reserved node. You can call the DescribeReservedNodeOfferings
	// API to obtain the available reserved node offerings.
	ExchangedReservedNode *ReservedNode `type:"structure"`
}

// String returns the string representation
func (s AcceptReservedNodeExchangeOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AcceptReservedNodeExchangeOutput) GoString() string {
	return s.String()
}

// SetExchangedReservedNode sets the ExchangedReservedNode field's value.
func (s *AcceptReservedNodeExchangeOutput) SetExchangedReservedNode(v *ReservedNode) *AcceptReservedNodeExchangeOutput {
	s.ExchangedReservedNode = v
	return s
}

// A name value pair that describes an aspect of an account.
type AccountAttribute struct {
	_ struct{} `type:"structure"`

	// The name of the attribute.
	AttributeName *string `type:"string"`

	// A list of attribute values.
	AttributeValues []*AttributeValueTarget `locationNameList:"AttributeValueTarget" type:"list"`
}

// String returns the string representation
func (s AccountAttribute) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AccountAttribute) GoString() string {
	return s.String()
}

// SetAttributeName sets the AttributeName field's value.
func (s *AccountAttribute) SetAttributeName(v string) *AccountAttribute {
	s.AttributeName = &v
	return s
}

// SetAttributeValues sets the AttributeValues field's value.
func (s *AccountAttribute) SetAttributeValues(v []*AttributeValueTarget) *AccountAttribute {
	s.AttributeValues = v
	return s
}

// Describes an AWS customer account authorized to restore a snapshot.
type AccountWithRestoreAccess struct {
	_ struct{} `type:"structure"`

	// The identifier of an AWS support account authorized to restore a snapshot.
	// For AWS support, the identifier is amazon-redshift-support.
	AccountAlias *string `type:"string"`

	// The identifier of an AWS customer account authorized to restore a snapshot.
	AccountId *string `type:"string"`
}

// String returns the string representation
func (s AccountWithRestoreAccess) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AccountWithRestoreAccess) GoString() string {
	return s.String()
}

// SetAccountAlias sets the AccountAlias field's value.
func (s *AccountWithRestoreAccess) SetAccountAlias(v string) *AccountWithRestoreAccess {
	s.AccountAlias = &v
	return s
}

// SetAccountId sets the AccountId field's value.
func (s *AccountWithRestoreAccess) SetAccountId(v string) *AccountWithRestoreAccess {
	s.AccountId = &v
	return s
}

// Describes an attribute value.
type AttributeValueTarget struct {
	_ struct{} `type:"structure"`

	// The value of the attribute.
	AttributeValue *string `type:"string"`
}

// String returns the string representation
func (s AttributeValueTarget) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AttributeValueTarget) GoString() string {
	return s.String()
}

// SetAttributeValue sets the AttributeValue field's value.
func (s *AttributeValueTarget) SetAttributeValue(v string) *AttributeValueTarget {
	s.AttributeValue = &v
	return s
}

type AuthorizeClusterSecurityGroupIngressInput struct {
	_ struct{} `type:"structure"`

	// The IP range to be added the Amazon Redshift security group.
	CIDRIP *string `type:"string"`

	// The name of the security group to which the ingress rule is added.
	//
	// ClusterSecurityGroupName is a required field
	ClusterSecurityGroupName *string `type:"string" required:"true"`

	// The EC2 security group to be added the Amazon Redshift security group.
	EC2SecurityGroupName *string `type:"string"`

	// The AWS account number of the owner of the security group specified by the
	// EC2SecurityGroupName parameter. The AWS Access Key ID is not an acceptable
	// value.
	//
	// Example: 111122223333
	EC2SecurityGroupOwnerId *string `type:"string"`
}

// String returns the string representation
func (s AuthorizeClusterSecurityGroupIngressInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AuthorizeClusterSecurityGroupIngressInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AuthorizeClusterSecurityGroupIngressInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AuthorizeClusterSecurityGroupIngressInput"}
	if s.ClusterSecurityGroupName == nil {
		invalidParams.Add(request.NewErrParamRequired("ClusterSecurityGroupName"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCIDRIP sets the CIDRIP field's value.
func (s *AuthorizeClusterSecurityGroupIngressInput) SetCIDRIP(v string) *AuthorizeClusterSecurityGroupIngressInput {
	s.CIDRIP = &v
	return s
}

// SetClusterSecurityGroupName sets the ClusterSecurityGroupName field's value.
func (s *AuthorizeClusterSecurityGroupIngressInput) SetClusterSecurityGroupName(v string) *AuthorizeClusterSecurityGroupIngressInput {
	s.ClusterSecurityGroupName = &v
	return s
}

// SetEC2SecurityGroupName sets the EC2SecurityGroupName field's value.
func (s *AuthorizeClusterSecurityGroupIngressInput) SetEC2SecurityGroupName(v string) *AuthorizeClusterSecurityGroupIngressInput {
	s.EC2SecurityGroupName = &v
	return s
}

// SetEC2SecurityGroupOwnerId sets the EC2SecurityGroupOwnerId field's value.
func (s *AuthorizeClusterSecurityGroupIngressInput) SetEC2SecurityGroupOwnerId(v string) *AuthorizeClusterSecurityGroupIngressInput {
	s.EC2SecurityGroupOwnerId = &v
	return s
}

type AuthorizeClusterSecurityGroupIngressOutput struct {
	_ struct{} `type:"structure"`

	// Describes a security group.
	ClusterSecurityGroup *ClusterSecurityGroup `type:"structure"`
}

// String returns the string representation
func (s AuthorizeClusterSecurityGroupIngressOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AuthorizeClusterSecurityGroupIngressOutput) GoString() string {
	return s.String()
}

// SetClusterSecurityGroup sets the ClusterSecurityGroup field's value.
func (s *AuthorizeClusterSecurityGroupIngressOutput) SetClusterSecurityGroup(v *ClusterSecurityGroup) *AuthorizeClusterSecurityGroupIngressOutput {
	s.ClusterSecurityGroup = v
	return s
}

type AuthorizeSnapshotAccessInput struct {
	_ struct{} `type:"structure"`

	// The identifier of the AWS customer account authorized to restore the specified
	// snapshot.
	//
	// To share a snapshot with AWS support, specify amazon-redshift-support.
	//
	// AccountWithRestoreAccess is a required field
	AccountWithRestoreAccess *string `type:"string" required:"true"`

	// The identifier of the cluster the snapshot was created from. This parameter
	// is required if your IAM user has a policy containing a snapshot resource
	// element that specifies anything other than * for the cluster name.
	SnapshotClusterIdentifier *string `type:"string"`

	// The identifier of the snapshot the account is authorized to restore.
	//
	// SnapshotIdentifier is a required field
	SnapshotIdentifier *string `type:"string" required:"true"`
}

// String returns the string representation
func (s AuthorizeSnapshotAccessInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AuthorizeSnapshotAccessInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AuthorizeSnapshotAccessInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AuthorizeSnapshotAccessInput"}
	if s.AccountWithRestoreAccess == nil {
		invalidParams.Add(request.NewErrParamRequired("AccountWithRestoreAccess"))
	}
	if s.SnapshotIdentifier == nil {
		invalidParams.Add(request.NewErrParamRequired("SnapshotIdentifier"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAccountWithRestoreAccess sets the AccountWithRestoreAccess field's value.
func (s *AuthorizeSnapshotAccessInput) SetAccountWithRestoreAccess(v string) *AuthorizeSnapshotAccessInput {
	s.AccountWithRestoreAccess = &v
	return s
}

// SetSnapshotClusterIdentifier sets the SnapshotClusterIdentifier field's value.
func (s *AuthorizeSnapshotAccessInput) SetSnapshotClusterIdentifier(v string) *AuthorizeSnapshotAccessInput {
	s.SnapshotClusterIdentifier = &v
	return s
}

// SetSnapshotIdentifier sets the SnapshotIdentifier field's value.
func (s *AuthorizeSnapshotAccessInput) SetSnapshotIdentifier(v string) *AuthorizeSnapshotAccessInput {
	s.SnapshotIdentifier = &v
	return s
}

type AuthorizeSnapshotAccessOutput struct {
	_ struct{} `type:"structure"`

	// Describes a snapshot.
	Snapshot *Snapshot `type:"structure"`
}

// String returns the string representation
func (s AuthorizeSnapshotAccessOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AuthorizeSnapshotAccessOutput) GoString() string {
	return s.String()
}

// SetSnapshot sets the Snapshot field's value.
func (s *AuthorizeSnapshotAccessOutput) SetSnapshot(v *Snapshot) *AuthorizeSnapshotAccessOutput {
	s.Snapshot = v
	return s
}

// Describes an availability zone.
type AvailabilityZone struct {
	_ struct{} `type:"structure"`

	// The name of the availability zone.
	Name *string `type:"string"`

	SupportedPlatforms []*SupportedPlatform `locationNameList:"SupportedPlatform" type:"list"`
}

// String returns the string representation
func (s AvailabilityZone) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AvailabilityZone) GoString() string {
	return s.String()
}

// SetName sets the Name field's value.
func (s *AvailabilityZone) SetName(v string) *AvailabilityZone {
	s.Name = &v
	return s
}

// SetSupportedPlatforms sets the SupportedPlatforms field's value.
func (s *AvailabilityZone) SetSupportedPlatforms(v []*SupportedPlatform) *AvailabilityZone {
	s.SupportedPlatforms = v
	return s
}

type BatchDeleteClusterSnapshotsInput struct {
	_ struct{} `type:"structure"`

	// A list of identifiers for the snapshots that you want to delete.
	//
	// Identifiers is a required field
	Identifiers []*DeleteClusterSnapshotMessage `locationNameList:"DeleteClusterSnapshotMessage" type:"list" required:"true"`
}

// String returns the string representation
func (s BatchDeleteClusterSnapshotsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s BatchDeleteClusterSnapshotsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *BatchDeleteClusterSnapshotsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "BatchDeleteClusterSnapshotsInput"}
	if s.Identifiers == nil {
		invalidParams.Add(request.NewErrParamRequired("Identifiers"))
	}
	if s.Identifiers != nil {
		for i, v := range s.Identifiers {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Identifiers", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetIdentifiers sets the Identifiers field's value.
func (s *BatchDeleteClusterSnapshotsInput) SetIdentifiers(v []*DeleteClusterSnapshotMessage) *BatchDeleteClusterSnapshotsInput {
	s.Identifiers = v
	return s
}

type BatchDeleteClusterSnapshotsOutput struct {
	_ struct{} `type:"structure"`

	// A list of any errors returned.
	Errors []*SnapshotErrorMessage `locationNameList:"SnapshotErrorMessage" type:"list"`

	// A list of the snapshot identifiers that were deleted.
	Resources []*string `locationNameList:"String" type:"list"`
}

// String returns the string representation
func (s BatchDeleteClusterSnapshotsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s BatchDeleteClusterSnapshotsOutput) GoString() string {
	return s.String()
}

// SetErrors sets the Errors field's value.
func (s *BatchDeleteClusterSnapshotsOutput) SetErrors(v []*SnapshotErrorMessage) *BatchDeleteClusterSnapshotsOutput {
	s.Errors = v
	return s
}

// SetResources sets the Resources field's value.
func (s *BatchDeleteClusterSnapshotsOutput) SetResources(v []*string) *BatchDeleteClusterSnapshotsOutput {
	s.Resources = v
	return s
}

type BatchModifyClusterSnapshotsInput struct {
	_ struct{} `type:"structure"`

	// A boolean value indicating whether to override an exception if the retention
	// period has passed.
	Force *bool `type:"boolean"`

	// The number of days that a manual snapshot is retained. If you specify the
	// value -1, the manual snapshot is retained indefinitely.
	//
	// The number must be either -1 or an integer between 1 and 3,653.
	//
	// If you decrease the manual snapshot retention period from its current value,
	// existing manual snapshots that fall outside of the new retention period will
	// return an error. If you want to suppress the errors and delete the snapshots,
	// use the force option.
	ManualSnapshotRetentionPeriod *int64 `type:"integer"`

	// A list of snapshot identifiers you want to modify.
	//
	// SnapshotIdentifierList is a required field
	SnapshotIdentifierList []*string `locationNameList:"String" type:"list" required:"true"`
}

// String returns the string representation
func (s BatchModifyClusterSnapshotsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s BatchModifyClusterSnapshotsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *BatchModifyClusterSnapshotsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "BatchModifyClusterSnapshotsInput"}
	if s.SnapshotIdentifierList == nil {
		invalidParams.Add(request.NewErrParamRequired("SnapshotIdentifierList"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetForce sets the Force field's value.
func (s *BatchModifyClusterSnapshotsInput) SetForce(v bool) *BatchModifyClusterSnapshotsInput {
	s.Force = &v
	return s
}

// SetManualSnapshotRetentionPeriod sets the ManualSnapshotRetentionPeriod field's value.
func (s *BatchModifyClusterSnapshotsInput) SetManualSnapshotRetentionPeriod(v int64) *BatchModifyClusterSnapshotsInput {
	s.ManualSnapshotRetentionPeriod = &v
	return s
}

// SetSnapshotIdentifierList sets the SnapshotIdentifierList field's value.
func (s *BatchModifyClusterSnapshotsInput) SetSnapshotIdentifierList(v []*string) *BatchModifyClusterSnapshotsInput {
	s.SnapshotIdentifierList = v
	return s
}

type BatchModifyClusterSnapshotsOutput struct {
	_ struct{} `type:"structure"`

	// A list of any errors returned.
	Errors []*SnapshotErrorMessage `locationNameList:"SnapshotErrorMessage" type:"list"`

	// A list of the snapshots that were modified.
	Resources []*string `locationNameList:"String" type:"list"`
}

// String returns the string representation
func (s BatchModifyClusterSnapshotsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s BatchModifyClusterSnapshotsOutput) GoString() string {
	return s.String()
}

// SetErrors sets the Errors field's value.
func (s *BatchModifyClusterSnapshotsOutput) SetErrors(v []*SnapshotErrorMessage) *BatchModifyClusterSnapshotsOutput {
	s.Errors = v
	return s
}

// SetResources sets the Resources field's value.
func (s *BatchModifyClusterSnapshotsOutput) SetResources(v []*string) *BatchModifyClusterSnapshotsOutput {
	s.Resources = v
	return s
}

type CancelResizeInput struct {
	_ struct{} `type:"structure"`

	// The unique identifier for the cluster that you want to cancel a resize operation
	// for.
	//
	// ClusterIdentifier is a required field
	ClusterIdentifier *string `type:"string" required:"true"`
}

// String returns the string representation
func (s CancelResizeInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CancelResizeInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CancelResizeInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CancelResizeInput"}
	if s.ClusterIdentifier == nil {
		invalidParams.Add(request.NewErrParamRequired("ClusterIdentifier"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClusterIdentifier sets the ClusterIdentifier field's value.
func (s *CancelResizeInput) SetClusterIdentifier(v string) *CancelResizeInput {
	s.ClusterIdentifier = &v
	return s
}

// Describes the result of a cluster resize operation.
type CancelResizeOutput struct {
	_ struct{} `type:"structure"`

	// The average rate of the resize operation over the last few minutes, measured
	// in megabytes per second. After the resize operation completes, this value
	// shows the average rate of the entire resize operation.
	AvgResizeRateInMegaBytesPerSecond *float64 `type:"double"`

	// The percent of data transferred from source cluster to target cluster.
	DataTransferProgressPercent *float64 `type:"double"`

	// The amount of seconds that have elapsed since the resize operation began.
	// After the resize operation completes, this value shows the total actual time,
	// in seconds, for the resize operation.
	ElapsedTimeInSeconds *int64 `type:"long"`

	// The estimated time remaining, in seconds, until the resize operation is complete.
	// This value is calculated based on the average resize rate and the estimated
	// amount of data remaining to be processed. Once the resize operation is complete,
	// this value will be 0.
	EstimatedTimeToCompletionInSeconds *int64 `type:"long"`

	// The names of tables that have been completely imported .
	//
	// Valid Values: List of table names.
	ImportTablesCompleted []*string `type:"list"`

	// The names of tables that are being currently imported.
	//
	// Valid Values: List of table names.
	ImportTablesInProgress []*string `type:"list"`

	// The names of tables that have not been yet imported.
	//
	// Valid Values: List of table names
	ImportTablesNotStarted []*string `type:"list"`

	// An optional string to provide additional details about the resize action.
	Message *string `type:"string"`

	// While the resize operation is in progress, this value shows the current amount
	// of data, in megabytes, that has been processed so far. When the resize operation
	// is complete, this value shows the total amount of data, in megabytes, on
	// the cluster, which may be more or less than TotalResizeDataInMegaBytes (the
	// estimated total amount of data before resize).
	ProgressInMegaBytes *int64 `type:"long"`

	// An enum with possible values of ClassicResize and ElasticResize. These values
	// describe the type of resize operation being performed.
	ResizeType *string `type:"string"`

	// The status of the resize operation.
	//
	// Valid Values: NONE | IN_PROGRESS | FAILED | SUCCEEDED | CANCELLING
	Status *string `type:"string"`

	// The cluster type after the resize operation is complete.
	//
	// Valid Values: multi-node | single-node
	TargetClusterType *string `type:"string"`

	// The type of encryption for the cluster after the resize is complete.
	//
	// Possible values are KMS and None. In the China region possible values are:
	// Legacy and None.
	TargetEncryptionType *string `type:"string"`

	// The node type that the cluster will have after the resize operation is complete.
	TargetNodeType *string `type:"string"`

	// The number of nodes that the cluster will have after the resize operation
	// is complete.
	TargetNumberOfNodes *int64 `type:"integer"`

	// The estimated total amount of data, in megabytes, on the cluster before the
	// resize operation began.
	TotalResizeDataInMegaBytes *int64 `type:"long"`
}

// String returns the string representation
func (s CancelResizeOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CancelResizeOutput) GoString() string {
	return s.String()
}

// SetAvgResizeRateInMegaBytesPerSecond sets the AvgResizeRateInMegaBytesPerSecond field's value.
func (s *CancelResizeOutput) SetAvgResizeRateInMegaBytesPerSecond(v float64) *CancelResizeOutput {
	s.AvgResizeRateInMegaBytesPerSecond = &v
	return s
}

// SetDataTransferProgressPercent sets the DataTransferProgressPercent field's value.
func (s *CancelResizeOutput) SetDataTransferProgressPercent(v float64) *CancelResizeOutput {
	s.DataTransferProgressPercent = &v
	return s
}

// SetElapsedTimeInSeconds sets the ElapsedTimeInSeconds field's value.
func (s *CancelResizeOutput) SetElapsedTimeInSeconds(v int64) *CancelResizeOutput {
	s.ElapsedTimeInSeconds = &v
	return s
}

// SetEstimatedTimeToCompletionInSeconds sets the EstimatedTimeToCompletionInSeconds field's value.
func (s *CancelResizeOutput) SetEstimatedTimeToCompletionInSeconds(v int64) *CancelResizeOutput {
	s.EstimatedTimeToCompletionInSeconds = &v
	return s
}

// SetImportTablesCompleted sets the ImportTablesCompleted field's value.
func (s *CancelResizeOutput) SetImportTablesCompleted(v []*string) *CancelResizeOutput {
	s.ImportTablesCompleted = v
	return s
}

// SetImportTablesInProgress sets the ImportTablesInProgress field's value.
func (s *CancelResizeOutput) SetImportTablesInProgress(v []*string) *CancelResizeOutput {
	s.ImportTablesInProgress = v
	return s
}

// SetImportTablesNotStarted sets the ImportTablesNotStarted field's value.
func (s *CancelResizeOutput) SetImportTablesNotStarted(v []*string) *CancelResizeOutput {
	s.ImportTablesNotStarted = v
	return s
}

// SetMessage sets the Message field's value.
func (s *CancelResizeOutput) SetMessage(v string) *CancelResizeOutput {
	s.Message = &v
	return s
}

// SetProgressInMegaBytes sets the ProgressInMegaBytes field's value.
func (s *CancelResizeOutput) SetProgressInMegaBytes(v int64) *CancelResizeOutput {
	s.ProgressInMegaBytes = &v
	return s
}

// SetResizeType sets the ResizeType field's value.
func (s *CancelResizeOutput) SetResizeType(v string) *CancelResizeOutput {
	s.ResizeType = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *CancelResizeOutput) SetStatus(v string) *CancelResizeOutput {
	s.Status = &v
	return s
}

// SetTargetClusterType sets the TargetClusterType field's value.
func (s *CancelResizeOutput) SetTargetClusterType(v string) *CancelResizeOutput {
	s.TargetClusterType = &v
	return s
}

// SetTargetEncryptionType sets the TargetEncryptionType field's value.
func (s *CancelResizeOutput) SetTargetEncryptionType(v string) *CancelResizeOutput {
	s.TargetEncryptionType = &v
	return s
}

// SetTargetNodeType sets the TargetNodeType field's value.
func (s *CancelResizeOutput) SetTargetNodeType(v string) *CancelResizeOutput {
	s.TargetNodeType = &v
	return s
}

// SetTargetNumberOfNodes sets the TargetNumberOfNodes field's value.
func (s *CancelResizeOutput) SetTargetNumberOfNodes(v int64) *CancelResizeOutput {
	s.TargetNumberOfNodes = &v
	return s
}

// SetTotalResizeDataInMegaBytes sets the TotalResizeDataInMegaBytes field's value.
func (s *CancelResizeOutput) SetTotalResizeDataInMegaBytes(v int64) *CancelResizeOutput {
	s.TotalResizeDataInMegaBytes = &v
	return s
}

// Describes a cluster.
type Cluster struct {
	_ struct{} `type:"structure"`

	// A boolean value that, if true, indicates that major version upgrades will
	// be applied automatically to the cluster during the maintenance window.
	AllowVersionUpgrade *bool `type:"boolean"`

	// The number of days that automatic cluster snapshots are retained.
	AutomatedSnapshotRetentionPeriod *int64 `type:"integer"`

	// The name of the Availability Zone in which the cluster is located.
	AvailabilityZone *string `type:"string"`

	// The availability status of the cluster for queries. Possible values are the
	// following:
	//
	//    * Available - The cluster is available for queries.
	//
	//    * Unavailable - The cluster is not available for queries.
	//
	//    * Maintenance - The cluster is intermittently available for queries due
	//    to maintenance activities.
	//
	//    * Modifying - The cluster is intermittently available for queries due
	//    to changes that modify the cluster.
	//
	//    * Failed - The cluster failed and is not available for queries.
	ClusterAvailabilityStatus *string `type:"string"`

	// The date and time that the cluster was created.
	ClusterCreateTime *time.Time `type:"timestamp"`

	// The unique identifier of the cluster.
	ClusterIdentifier *string `type:"string"`

	// The nodes in the cluster.
	ClusterNodes []*ClusterNode `type:"list"`

	// The list of cluster parameter groups that are associated with this cluster.
	// Each parameter group in the list is returned with its status.
	ClusterParameterGroups []*ClusterParameterGroupStatus `locationNameList:"ClusterParameterGroup" type:"list"`

	// The public key for the cluster.
	ClusterPublicKey *string `type:"string"`

	// The specific revision number of the database in the cluster.
	ClusterRevisionNumber *string `type:"string"`

	// A list of cluster security group that are associated with the cluster. Each
	// security group is represented by an element that contains ClusterSecurityGroup.Name
	// and ClusterSecurityGroup.Status subelements.
	//
	// Cluster security groups are used when the cluster is not created in an Amazon
	// Virtual Private Cloud (VPC). Clusters that are created in a VPC use VPC security
	// groups, which are listed by the VpcSecurityGroups parameter.
	ClusterSecurityGroups []*ClusterSecurityGroupMembership `locationNameList:"ClusterSecurityGroup" type:"list"`

	// A value that returns the destination region and retention period that are
	// configured for cross-region snapshot copy.
	ClusterSnapshotCopyStatus *ClusterSnapshotCopyStatus `type:"structure"`

	// The current state of the cluster. Possible values are the following:
	//
	//    * available
	//
	//    * available, prep-for-resize
	//
	//    * available, resize-cleanup
	//
	//    * cancelling-resize
	//
	//    * creating
	//
	//    * deleting
	//
	//    * final-snapshot
	//
	//    * hardware-failure
	//
	//    * incompatible-hsm
	//
	//    * incompatible-network
	//
	//    * incompatible-parameters
	//
	//    * incompatible-restore
	//
	//    * modifying
	//
	//    * rebooting
	//
	//    * renaming
	//
	//    * resizing
	//
	//    * rotating-keys
	//
	//    * storage-full
	//
	//    * updating-hsm
	ClusterStatus *string `type:"string"`

	// The name of the subnet group that is associated with the cluster. This parameter
	// is valid only when the cluster is in a VPC.
	ClusterSubnetGroupName *string `type:"string"`

	// The version ID of the Amazon Redshift engine that is running on the cluster.
	ClusterVersion *string `type:"string"`

	// The name of the initial database that was created when the cluster was created.
	// This same name is returned for the life of the cluster. If an initial database
	// was not specified, a database named devdev was created by default.
	DBName *string `type:"string"`

	// Describes the status of a cluster while it is in the process of resizing
	// with an incremental resize.
	DataTransferProgress *DataTransferProgress `type:"structure"`

	// Describes a group of DeferredMaintenanceWindow objects.
	DeferredMaintenanceWindows []*DeferredMaintenanceWindow `locationNameList:"DeferredMaintenanceWindow" type:"list"`

	// The status of the elastic IP (EIP) address.
	ElasticIpStatus *ElasticIpStatus `type:"structure"`

	// The number of nodes that you can resize the cluster to with the elastic resize
	// method.
	ElasticResizeNumberOfNodeOptions *string `type:"string"`

	// A boolean value that, if true, indicates that data in the cluster is encrypted
	// at rest.
	Encrypted *bool `type:"boolean"`

	// The connection endpoint.
	Endpoint *Endpoint `type:"structure"`

	// An option that specifies whether to create the cluster with enhanced VPC
	// routing enabled. To create a cluster that uses enhanced VPC routing, the
	// cluster must be in a VPC. For more information, see Enhanced VPC Routing
	// (https://docs.aws.amazon.com/redshift/latest/mgmt/enhanced-vpc-routing.html)
	// in the Amazon Redshift Cluster Management Guide.
	//
	// If this option is true, enhanced VPC routing is enabled.
	//
	// Default: false
	EnhancedVpcRouting *bool `type:"boolean"`

	// The date and time when the next snapshot is expected to be taken for clusters
	// with a valid snapshot schedule and backups enabled.
	ExpectedNextSnapshotScheduleTime *time.Time `type:"timestamp"`

	// The status of next expected snapshot for clusters having a valid snapshot
	// schedule and backups enabled. Possible values are the following:
	//
	//    * OnTrack - The next snapshot is expected to be taken on time.
	//
	//    * Pending - The next snapshot is pending to be taken.
	ExpectedNextSnapshotScheduleTimeStatus *string `type:"string"`

	// A value that reports whether the Amazon Redshift cluster has finished applying
	// any hardware security module (HSM) settings changes specified in a modify
	// cluster command.
	//
	// Values: active, applying
	HsmStatus *HsmStatus `type:"structure"`

	// A list of AWS Identity and Access Management (IAM) roles that can be used
	// by the cluster to access other AWS services.
	IamRoles []*ClusterIamRole `locationNameList:"ClusterIamRole" type:"list"`

	// The AWS Key Management Service (AWS KMS) key ID of the encryption key used
	// to encrypt data in the cluster.
	KmsKeyId *string `type:"string"`

	// The name of the maintenance track for the cluster.
	MaintenanceTrackName *string `type:"string"`

	// The default number of days to retain a manual snapshot. If the value is -1,
	// the snapshot is retained indefinitely. This setting doesn't change the retention
	// period of existing snapshots.
	//
	// The value must be either -1 or an integer between 1 and 3,653.
	ManualSnapshotRetentionPeriod *int64 `type:"integer"`

	// The master user name for the cluster. This name is used to connect to the
	// database that is specified in the DBName parameter.
	MasterUsername *string `type:"string"`

	// The status of a modify operation, if any, initiated for the cluster.
	ModifyStatus *string `type:"string"`

	// The date and time in UTC when system maintenance can begin.
	NextMaintenanceWindowStartTime *time.Time `type:"timestamp"`

	// The node type for the nodes in the cluster.
	NodeType *string `type:"string"`

	// The number of compute nodes in the cluster.
	NumberOfNodes *int64 `type:"integer"`

	// Cluster operations that are waiting to be started.
	PendingActions []*string `type:"list"`

	// A value that, if present, indicates that changes to the cluster are pending.
	// Specific pending changes are identified by subelements.
	PendingModifiedValues *PendingModifiedValues `type:"structure"`

	// The weekly time range, in Universal Coordinated Time (UTC), during which
	// system maintenance can occur.
	PreferredMaintenanceWindow *string `type:"string"`

	// A boolean value that, if true, indicates that the cluster can be accessed
	// from a public network.
	PubliclyAccessible *bool `type:"boolean"`

	// Returns the following:
	//
	//    * AllowCancelResize: a boolean value indicating if the resize operation
	//    can be cancelled.
	//
	//    * ResizeType: Returns ClassicResize
	ResizeInfo *ResizeInfo `type:"structure"`

	// A value that describes the status of a cluster restore action. This parameter
	// returns null if the cluster was not created by restoring a snapshot.
	RestoreStatus *RestoreStatus `type:"structure"`

	// A unique identifier for the cluster snapshot schedule.
	SnapshotScheduleIdentifier *string `type:"string"`

	// The current state of the cluster snapshot schedule.
	SnapshotScheduleState *string `type:"string" enum:"ScheduleState"`

	// The list of tags for the cluster.
	Tags []*Tag `locationNameList:"Tag" type:"list"`

	// The identifier of the VPC the cluster is in, if the cluster is in a VPC.
	VpcId *string `type:"string"`

	// A list of Amazon Virtual Private Cloud (Amazon VPC) security groups that
	// are associated with the cluster. This parameter is returned only if the cluster
	// is in a VPC.
	VpcSecurityGroups []*VpcSecurityGroupMembership `locationNameList:"VpcSecurityGroup" type:"list"`
}

// String returns the string representation
func (s Cluster) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Cluster) GoString() string {
	return s.String()
}

// SetAllowVersionUpgrade sets the AllowVersionUpgrade field's value.
func (s *Cluster) SetAllowVersionUpgrade(v bool) *Cluster {
	s.AllowVersionUpgrade = &v
	return s
}

// SetAutomatedSnapshotRetentionPeriod sets the AutomatedSnapshotRetentionPeriod field's value.
func (s *Cluster) SetAutomatedSnapshotRetentionPeriod(v int64) *Cluster {
	s.AutomatedSnapshotRetentionPeriod = &v
	return s
}

// SetAvailabilityZone sets the AvailabilityZone field's value.
func (s *Cluster) SetAvailabilityZone(v string) *Cluster {
	s.AvailabilityZone = &v
	return s
}

// SetClusterAvailabilityStatus sets the ClusterAvailabilityStatus field's value.
func (s *Cluster) SetClusterAvailabilityStatus(v string) *Cluster {
	s.ClusterAvailabilityStatus = &v
	return s
}

// SetClusterCreateTime sets the ClusterCreateTime field's value.
func (s *Cluster) SetClusterCreateTime(v time.Time) *Cluster {
	s.ClusterCreateTime = &v
	return s
}

// SetClusterIdentifier sets the ClusterIdentifier field's value.
func (s *Cluster) SetClusterIdentifier(v string) *Cluster {
	s.ClusterIdentifier = &v
	return s
}

// SetClusterNodes sets the ClusterNodes field's value.
func (s *Cluster) SetClusterNodes(v []*ClusterNode) *Cluster {
	s.ClusterNodes = v
	return s
}

// SetClusterParameterGroups sets the ClusterParameterGroups field's value.
func (s *Cluster) SetClusterParameterGroups(v []*ClusterParameterGroupStatus) *Cluster {
	s.ClusterParameterGroups = v
	return s
}

// SetClusterPublicKey sets the ClusterPublicKey field's value.
func (s *Cluster) SetClusterPublicKey(v string) *Cluster {
	s.ClusterPublicKey = &v
	return s
}

// SetClusterRevisionNumber sets the ClusterRevisionNumber field's value.
func (s *Cluster) SetClusterRevisionNumber(v string) *Cluster {
	s.ClusterRevisionNumber = &v
	return s
}

// SetClusterSecurityGroups sets the ClusterSecurityGroups field's value.
func (s *Cluster) SetClusterSecurityGroups(v []*ClusterSecurityGroupMembership) *Cluster {
	s.ClusterSecurityGroups = v
	return s
}

// SetClusterSnapshotCopyStatus sets the ClusterSnapshotCopyStatus field's value.
func (s *Cluster) SetClusterSnapshotCopyStatus(v *ClusterSnapshotCopyStatus) *Cluster {
	s.ClusterSnapshotCopyStatus = v
	return s
}

// SetClusterStatus sets the ClusterStatus field's value.
func (s *Cluster) SetClusterStatus(v string) *Cluster {
	s.ClusterStatus = &v
	return s
}

// SetClusterSubnetGroupName sets the ClusterSubnetGroupName field's value.
func (s *Cluster) SetClusterSubnetGroupName(v string) *Cluster {
	s.ClusterSubnetGroupName = &v
	return s
}

// SetClusterVersion sets the ClusterVersion field's value.
func (s *Cluster) SetClusterVersion(v string) *Cluster {
	s.ClusterVersion = &v
	return s
}

// SetDBName sets the DBName field's value.
func (s *Cluster) SetDBName(v string) *Cluster {
	s.DBName = &v
	return s
}

// SetDataTransferProgress sets the DataTransferProgress field's value.
func (s *Cluster) SetDataTransferProgress(v *DataTransferProgress) *Cluster {
	s.DataTransferProgress = v
	return s
}

// SetDeferredMaintenanceWindows sets the DeferredMaintenanceWindows field's value.
func (s *Cluster) SetDeferredMaintenanceWindows(v []*DeferredMaintenanceWindow) *Cluster {
	s.DeferredMaintenanceWindows = v
	return s
}

// SetElasticIpStatus sets the ElasticIpStatus field's value.
func (s *Cluster) SetElasticIpStatus(v *ElasticIpStatus) *Cluster {
	s.ElasticIpStatus = v
	return s
}

// SetElasticResizeNumberOfNodeOptions sets the ElasticResizeNumberOfNodeOptions field's value.
func (s *Cluster) SetElasticResizeNumberOfNodeOptions(v string) *Cluster {
	s.ElasticResizeNumberOfNodeOptions = &v
	return s
}

// SetEncrypted sets the Encrypted field's value.
func (s *Cluster) SetEncrypted(v bool) *Cluster {
	s.Encrypted = &v
	return s
}

// SetEndpoint sets the Endpoint field's value.
func (s *Cluster) SetEndpoint(v *Endpoint) *Cluster {
	s.Endpoint = v
	return s
}

// SetEnhancedVpcRouting sets the EnhancedVpcRouting field's value.
func (s *Cluster) SetEnhancedVpcRouting(v bool) *Cluster {
	s.EnhancedVpcRouting = &v
	return s
}

// SetExpectedNextSnapshotScheduleTime sets the ExpectedNextSnapshotScheduleTime field's value.
func (s *Cluster) SetExpectedNextSnapshotScheduleTime(v time.Time) *Cluster {
	s.ExpectedNextSnapshotScheduleTime = &v
	return s
}

// SetExpectedNextSnapshotScheduleTimeStatus sets the ExpectedNextSnapshotScheduleTimeStatus field's value.
func (s *Cluster) SetExpectedNextSnapshotScheduleTimeStatus(v string) *Cluster {
	s.ExpectedNextSnapshotScheduleTimeStatus = &v
	return s
}

// SetHsmStatus sets the HsmStatus field's value.
func (s *Cluster) SetHsmStatus(v *HsmStatus) *Cluster {
	s.HsmStatus = v
	return s
}

// SetIamRoles sets the IamRoles field's value.
func (s *Cluster) SetIamRoles(v []*ClusterIamRole) *Cluster {
	s.IamRoles = v
	return s
}

// SetKmsKeyId sets the KmsKeyId field's value.
func (s *Cluster) SetKmsKeyId(v string) *Cluster {
	s.KmsKeyId = &v
	return s
}

// SetMaintenanceTrackName sets the MaintenanceTrackName field's value.
func (s *Cluster) SetMaintenanceTrackName(v string) *Cluster {
	s.MaintenanceTrackName = &v
	return s
}

// SetManualSnapshotRetentionPeriod sets the ManualSnapshotRetentionPeriod field's value.
func (s *Cluster) SetManualSnapshotRetentionPeriod(v int64) *Cluster {
	s.ManualSnapshotRetentionPeriod = &v
	return s
}

// SetMasterUsername sets the MasterUsername field's value.
func (s *Cluster) SetMasterUsername(v string) *Cluster {
	s.MasterUsername = &v
	return s
}

// SetModifyStatus sets the ModifyStatus field's value.
func (s *Cluster) SetModifyStatus(v string) *Cluster {
	s.ModifyStatus = &v
	return s
}

// SetNextMaintenanceWindowStartTime sets the NextMaintenanceWindowStartTime field's value.
func (s *Cluster) SetNextMaintenanceWindowStartTime(v time.Time) *Cluster {
	s.NextMaintenanceWindowStartTime = &v
	return s
}

// SetNodeType sets the NodeType field's value.
func (s *Cluster) SetNodeType(v string) *Cluster {
	s.NodeType = &v
	return s
}

// SetNumberOfNodes sets the NumberOfNodes field's value.
func (s *Cluster) SetNumberOfNodes(v int64) *Cluster {
	s.NumberOfNodes = &v
	return s
}

// SetPendingActions sets the PendingActions field's value.
func (s *Cluster) SetPendingActions(v []*string) *Cluster {
	s.PendingActions = v
	return s
}

// SetPendingModifiedValues sets the PendingModifiedValues field's value.
func (s *Cluster) SetPendingModifiedValues(v *PendingModifiedValues) *Cluster {
	s.PendingModifiedValues = v
	return s
}

// SetPreferredMaintenanceWindow sets the PreferredMaintenanceWindow field's value.
func (s *Cluster) SetPreferredMaintenanceWindow(v string) *Cluster {
	s.PreferredMaintenanceWindow = &v
	return s
}

// SetPubliclyAccessible sets the PubliclyAccessible field's value.
func (s *Cluster) SetPubliclyAccessible(v bool) *Cluster {
	s.PubliclyAccessible = &v
	return s
}

// SetResizeInfo sets the ResizeInfo field's value.
func (s *Cluster) SetResizeInfo(v *ResizeInfo) *Cluster {
	s.ResizeInfo = v
	return s
}

// SetRestoreStatus sets the RestoreStatus field's value.
func (s *Cluster) SetRestoreStatus(v *RestoreStatus) *Cluster {
	s.RestoreStatus = v
	return s
}

// SetSnapshotScheduleIdentifier sets the SnapshotScheduleIdentifier field's value.
func (s *Cluster) SetSnapshotScheduleIdentifier(v string) *Cluster {
	s.SnapshotScheduleIdentifier = &v
	return s
}

// SetSnapshotScheduleState sets the SnapshotScheduleState field's value.
func (s *Cluster) SetSnapshotScheduleState(v string) *Cluster {
	s.SnapshotScheduleState = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *Cluster) SetTags(v []*Tag) *Cluster {
	s.Tags = v
	return s
}

// SetVpcId sets the VpcId field's value.
func (s *Cluster) SetVpcId(v string) *Cluster {
	s.VpcId = &v
	return s
}

// SetVpcSecurityGroups sets the VpcSecurityGroups field's value.
func (s *Cluster) SetVpcSecurityGroups(v []*VpcSecurityGroupMembership) *Cluster {
	s.VpcSecurityGroups = v
	return s
}

type ClusterAssociatedToSchedule struct {
	_ struct{} `type:"structure"`

	ClusterIdentifier *string `type:"string"`

	ScheduleAssociationState *string `type:"string" enum:"ScheduleState"`
}

// String returns the string representation
func (s ClusterAssociatedToSchedule) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ClusterAssociatedToSchedule) GoString() string {
	return s.String()
}

// SetClusterIdentifier sets the ClusterIdentifier field's value.
func (s *ClusterAssociatedToSchedule) SetClusterIdentifier(v string) *ClusterAssociatedToSchedule {
	s.ClusterIdentifier = &v
	return s
}

// SetScheduleAssociationState sets the ScheduleAssociationState field's value.
func (s *ClusterAssociatedToSchedule) SetScheduleAssociationState(v string) *ClusterAssociatedToSchedule {
	s.ScheduleAssociationState = &v
	return s
}

// Describes a ClusterDbRevision.
type ClusterDbRevision struct {
	_ struct{} `type:"structure"`

	// The unique identifier of the cluster.
	ClusterIdentifier *string `type:"string"`

	// A string representing the current cluster version.
	CurrentDatabaseRevision *string `type:"string"`

	// The date on which the database revision was released.
	DatabaseRevisionReleaseDate *time.Time `type:"timestamp"`

	// A list of RevisionTarget objects, where each object describes the database
	// revision that a cluster can be updated to.
	RevisionTargets []*RevisionTarget `locationNameList:"RevisionTarget" type:"list"`
}

// String returns the string representation
func (s ClusterDbRevision) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ClusterDbRevision) GoString() string {
	return s.String()
}

// SetClusterIdentifier sets the ClusterIdentifier field's value.
func (s *ClusterDbRevision) SetClusterIdentifier(v string) *ClusterDbRevision {
	s.ClusterIdentifier = &v
	return s
}

// SetCurrentDatabaseRevision sets the CurrentDatabaseRevision field's value.
func (s *ClusterDbRevision) SetCurrentDatabaseRevision(v string) *ClusterDbRevision {
	s.CurrentDatabaseRevision = &v
	return s
}

// SetDatabaseRevisionReleaseDate sets the DatabaseRevisionReleaseDate field's value.
func (s *ClusterDbRevision) SetDatabaseRevisionReleaseDate(v time.Time) *ClusterDbRevision {
	s.DatabaseRevisionReleaseDate = &v
	return s
}

// SetRevisionTargets sets the RevisionTargets field's value.
func (s *ClusterDbRevision) SetRevisionTargets(v []*RevisionTarget) *ClusterDbRevision {
	s.RevisionTargets = v
	return s
}

// An AWS Identity and Access Management (IAM) role that can be used by the
// associated Amazon Redshift cluster to access other AWS services.
type ClusterIamRole struct {
	_ struct{} `type:"structure"`

	// A value that describes the status of the IAM role's association with an Amazon
	// Redshift cluster.
	//
	// The following are possible statuses and descriptions.
	//
	//    * in-sync: The role is available for use by the cluster.
	//
	//    * adding: The role is in the process of being associated with the cluster.
	//
	//    * removing: The role is in the process of being disassociated with the
	//    cluster.
	ApplyStatus *string `type:"string"`

	// The Amazon Resource Name (ARN) of the IAM role, for example, arn:aws:iam::123456789012:role/RedshiftCopyUnload.
	IamRoleArn *string `type:"string"`
}

// String returns the string representation
func (s ClusterIamRole) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ClusterIamRole) GoString() string {
	return s.String()
}

// SetApplyStatus sets the ApplyStatus field's value.
func (s *ClusterIamRole) SetApplyStatus(v string) *ClusterIamRole {
	s.ApplyStatus = &v
	return s
}

// SetIamRoleArn sets the IamRoleArn field's value.
func (s *ClusterIamRole) SetIamRoleArn(v string) *ClusterIamRole {
	s.IamRoleArn = &v
	return s
}

// The identifier of a node in a cluster.
type ClusterNode struct {
	_ struct{} `type:"structure"`

	// Whether the node is a leader node or a compute node.
	NodeRole *string `type:"string"`

	// The private IP address of a node within a cluster.
	PrivateIPAddress *string `type:"string"`

	// The public IP address of a node within a cluster.
	PublicIPAddress *string `type:"string"`
}

// String returns the string representation
func (s ClusterNode) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ClusterNode) GoString() string {
	return s.String()
}

// SetNodeRole sets the NodeRole field's value.
func (s *ClusterNode) SetNodeRole(v string) *ClusterNode {
	s.NodeRole = &v
	return s
}

// SetPrivateIPAddress sets the PrivateIPAddress field's value.
func (s *ClusterNode) SetPrivateIPAddress(v string) *ClusterNode {
	s.PrivateIPAddress = &v
	return s
}

// SetPublicIPAddress sets the PublicIPAddress field's value.
func (s *ClusterNode) SetPublicIPAddress(v string) *ClusterNode {
	s.PublicIPAddress = &v
	return s
}

// Describes a parameter group.
type ClusterParameterGroup struct {
	_ struct{} `type:"structure"`

	// The description of the parameter group.
	Description *string `type:"string"`

	// The name of the cluster parameter group family that this cluster parameter
	// group is compatible with.
	ParameterGroupFamily *string `type:"string"`

	// The name of the cluster parameter group.
	ParameterGroupName *string `type:"string"`

	// The list of tags for the cluster parameter group.
	Tags []*Tag `locationNameList:"Tag" type:"list"`
}

// String returns the string representation
func (s ClusterParameterGroup) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ClusterParameterGroup) GoString() string {
	return s.String()
}

// SetDescription sets the Description field's value.
func (s *ClusterParameterGroup) SetDescription(v string) *ClusterParameterGroup {
	s.Description = &v
	return s
}

// SetParameterGroupFamily sets the ParameterGroupFamily field's value.
func (s *ClusterParameterGroup) SetParameterGroupFamily(v string) *ClusterParameterGroup {
	s.ParameterGroupFamily = &v
	return s
}

// SetParameterGroupName sets the ParameterGroupName field's value.
func (s *ClusterParameterGroup) SetParameterGroupName(v string) *ClusterParameterGroup {
	s.ParameterGroupName = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *ClusterParameterGroup) SetTags(v []*Tag) *ClusterParameterGroup {
	s.Tags = v
	return s
}

type ClusterParameterGroupNameMessage struct {
	_ struct{} `type:"structure"`

	// The name of the cluster parameter group.
	ParameterGroupName *string `type:"string"`

	// The status of the parameter group. For example, if you made a change to a
	// parameter group name-value pair, then the change could be pending a reboot
	// of an associated cluster.
	ParameterGroupStatus *string `type:"string"`
}

// String returns the string representation
func (s ClusterParameterGroupNameMessage) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ClusterParameterGroupNameMessage) GoString() string {
	return s.String()
}

// SetParameterGroupName sets the ParameterGroupName field's value.
func (s *ClusterParameterGroupNameMessage) SetParameterGroupName(v string) *ClusterParameterGroupNameMessage {
	s.ParameterGroupName = &v
	return s
}

// SetParameterGroupStatus sets the ParameterGroupStatus field's value.
func (s *ClusterParameterGroupNameMessage) SetParameterGroupStatus(v string) *ClusterParameterGroupNameMessage {
	s.ParameterGroupStatus = &v
	return s
}

// Describes the status of a parameter group.
type ClusterParameterGroupStatus struct {
	_ struct{} `type:"structure"`

	// The list of parameter statuses.
	//
	// For more information about parameters and parameter groups, go to Amazon
	// Redshift Parameter Groups (https://docs.aws.amazon.com/redshift/latest/mgmt/working-with-parameter-groups.html)
	// in the Amazon Redshift Cluster Management Guide.
	ClusterParameterStatusList []*ClusterParameterStatus `type:"list"`

	// The status of parameter updates.
	ParameterApplyStatus *string `type:"string"`

	// The name of the cluster parameter group.
	ParameterGroupName *string `type:"string"`
}

// String returns the string representation
func (s ClusterParameterGroupStatus) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ClusterParameterGroupStatus) GoString() string {
	return s.String()
}

// SetClusterParameterStatusList sets the ClusterParameterStatusList field's value.
func (s *ClusterParameterGroupStatus) SetClusterParameterStatusList(v []*ClusterParameterStatus) *ClusterParameterGroupStatus {
	s.ClusterParameterStatusList = v
	return s
}

// SetParameterApplyStatus sets the ParameterApplyStatus field's value.
func (s *ClusterParameterGroupStatus) SetParameterApplyStatus(v string) *ClusterParameterGroupStatus {
	s.ParameterApplyStatus = &v
	return s
}

// SetParameterGroupName sets the ParameterGroupName field's value.
func (s *ClusterParameterGroupStatus) SetParameterGroupName(v string) *ClusterParameterGroupStatus {
	s.ParameterGroupName = &v
	return s
}

// Describes the status of a parameter group.
type ClusterParameterStatus struct {
	_ struct{} `type:"structure"`

	// The error that prevented the parameter from being applied to the database.
	ParameterApplyErrorDescription *string `type:"string"`

	// The status of the parameter that indicates whether the parameter is in sync
	// with the database, waiting for a cluster reboot, or encountered an error
	// when being applied.
	//
	// The following are possible statuses and descriptions.
	//
	//    * in-sync: The parameter value is in sync with the database.
	//
	//    * pending-reboot: The parameter value will be applied after the cluster
	//    reboots.
	//
	//    * applying: The parameter value is being applied to the database.
	//
	//    * invalid-parameter: Cannot apply the parameter value because it has an
	//    invalid value or syntax.
	//
	//    * apply-deferred: The parameter contains static property changes. The
	//    changes are deferred until the cluster reboots.
	//
	//    * apply-error: Cannot connect to the cluster. The parameter change will
	//    be applied after the cluster reboots.
	//
	//    * unknown-error: Cannot apply the parameter change right now. The change
	//    will be applied after the cluster reboots.
	ParameterApplyStatus *string `type:"string"`

	// The name of the parameter.
	ParameterName *string `type:"string"`
}

// String returns the string representation
func (s ClusterParameterStatus) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ClusterParameterStatus) GoString() string {
	return s.String()
}

// SetParameterApplyErrorDescription sets the ParameterApplyErrorDescription field's value.
func (s *ClusterParameterStatus) SetParameterApplyErrorDescription(v string) *ClusterParameterStatus {
	s.ParameterApplyErrorDescription = &v
	return s
}

// SetParameterApplyStatus sets the ParameterApplyStatus field's value.
func (s *ClusterParameterStatus) SetParameterApplyStatus(v string) *ClusterParameterStatus {
	s.ParameterApplyStatus = &v
	return s
}

// SetParameterName sets the ParameterName field's value.
func (s *ClusterParameterStatus) SetParameterName(v string) *ClusterParameterStatus {
	s.ParameterName = &v
	return s
}

// Describes a security group.
type ClusterSecurityGroup struct {
	_ struct{} `type:"structure"`

	// The name of the cluster security group to which the operation was applied.
	ClusterSecurityGroupName *string `type:"string"`

	// A description of the security group.
	Description *string `type:"string"`

	// A list of EC2 security groups that are permitted to access clusters associated
	// with this cluster security group.
	EC2SecurityGroups []*EC2SecurityGroup `locationNameList:"EC2SecurityGroup" type:"list"`

	// A list of IP ranges (CIDR blocks) that are permitted to access clusters associated
	// with this cluster security group.
	IPRanges []*IPRange `locationNameList:"IPRange" type:"list"`

	// The list of tags for the cluster security group.
	Tags []*Tag `locationNameList:"Tag" type:"list"`
}

// String returns the string representation
func (s ClusterSecurityGroup) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ClusterSecurityGroup) GoString() string {
	return s.String()
}

// SetClusterSecurityGroupName sets the ClusterSecurityGroupName field's value.
func (s *ClusterSecurityGroup) SetClusterSecurityGroupName(v string) *ClusterSecurityGroup {
	s.ClusterSecurityGroupName = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *ClusterSecurityGroup) SetDescription(v string) *ClusterSecurityGroup {
	s.Description = &v
	return s
}

// SetEC2SecurityGroups sets the EC2SecurityGroups field's value.
func (s *ClusterSecurityGroup) SetEC2SecurityGroups(v []*EC2SecurityGroup) *ClusterSecurityGroup {
	s.EC2SecurityGroups = v
	return s
}

// SetIPRanges sets the IPRanges field's value.
func (s *ClusterSecurityGroup) SetIPRanges(v []*IPRange) *ClusterSecurityGroup {
	s.IPRanges = v
	return s
}

// SetTags sets the Tags field's value.
func (s *ClusterSecurityGroup) SetTags(v []*Tag) *ClusterSecurityGroup {
	s.Tags = v
	return s
}

// Describes a cluster security group.
type ClusterSecurityGroupMembership struct {
	_ struct{} `type:"structure"`

	// The name of the cluster security group.
	ClusterSecurityGroupName *string `type:"string"`

	// The status of the cluster security group.
	Status *string `type:"string"`
}

// String returns the string representation
func (s ClusterSecurityGroupMembership) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ClusterSecurityGroupMembership) GoString() string {
	return s.String()
}

// SetClusterSecurityGroupName sets the ClusterSecurityGroupName field's value.
func (s *ClusterSecurityGroupMembership) SetClusterSecurityGroupName(v string) *ClusterSecurityGroupMembership {
	s.ClusterSecurityGroupName = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *ClusterSecurityGroupMembership) SetStatus(v string) *ClusterSecurityGroupMembership {
	s.Status = &v
	return s
}

// Returns the destination region and retention period that are configured for
// cross-region snapshot copy.
type ClusterSnapshotCopyStatus struct {
	_ struct{} `type:"structure"`

	// The destination region that snapshots are automatically copied to when cross-region
	// snapshot copy is enabled.
	DestinationRegion *string `type:"string"`

	// The number of days that automated snapshots are retained in the destination
	// region after they are copied from a source region. If the value is -1, the
	// manual snapshot is retained indefinitely.
	//
	// The value must be either -1 or an integer between 1 and 3,653.
	ManualSnapshotRetentionPeriod *int64 `type:"integer"`

	// The number of days that automated snapshots are retained in the destination
	// region after they are copied from a source region.
	RetentionPeriod *int64 `type:"long"`

	// The name of the snapshot copy grant.
	SnapshotCopyGrantName *string `type:"string"`
}

// String returns the string representation
func (s ClusterSnapshotCopyStatus) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ClusterSnapshotCopyStatus) GoString() string {
	return s.String()
}

// SetDestinationRegion sets the DestinationRegion field's value.
func (s *ClusterSnapshotCopyStatus) SetDestinationRegion(v string) *ClusterSnapshotCopyStatus {
	s.DestinationRegion = &v
	return s
}

// SetManualSnapshotRetentionPeriod sets the ManualSnapshotRetentionPeriod field's value.
func (s *ClusterSnapshotCopyStatus) SetManualSnapshotRetentionPeriod(v int64) *ClusterSnapshotCopyStatus {
	s.ManualSnapshotRetentionPeriod = &v
	return s
}

// SetRetentionPeriod sets the RetentionPeriod field's value.
func (s *ClusterSnapshotCopyStatus) SetRetentionPeriod(v int64) *ClusterSnapshotCopyStatus {
	s.RetentionPeriod = &v
	return s
}

// SetSnapshotCopyGrantName sets the SnapshotCopyGrantName field's value.
func (s *ClusterSnapshotCopyStatus) SetSnapshotCopyGrantName(v string) *ClusterSnapshotCopyStatus {
	s.SnapshotCopyGrantName = &v
	return s
}

// Describes a subnet group.
type ClusterSubnetGroup struct {
	_ struct{} `type:"structure"`

	// The name of the cluster subnet group.
	ClusterSubnetGroupName *string `type:"string"`

	// The description of the cluster subnet group.
	Description *string `type:"string"`

	// The status of the cluster subnet group. Possible values are Complete, Incomplete
	// and Invalid.
	SubnetGroupStatus *string `type:"string"`

	// A list of the VPC Subnet elements.
	Subnets []*Subnet `locationNameList:"Subnet" type:"list"`

	// The list of tags for the cluster subnet group.
	Tags []*Tag `locationNameList:"Tag" type:"list"`

	// The VPC ID of the cluster subnet group.
	VpcId *string `type:"string"`
}

// String returns the string representation
func (s ClusterSubnetGroup) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ClusterSubnetGroup) GoString() string {
	return s.String()
}

// SetClusterSubnetGroupName sets the ClusterSubnetGroupName field's value.
func (s *ClusterSubnetGroup) SetClusterSubnetGroupName(v string) *ClusterSubnetGroup {
	s.ClusterSubnetGroupName = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *ClusterSubnetGroup) SetDescription(v string) *ClusterSubnetGroup {
	s.Description = &v
	return s
}

// SetSubnetGroupStatus sets the SubnetGroupStatus field's value.
func (s *ClusterSubnetGroup) SetSubnetGroupStatus(v string) *ClusterSubnetGroup {
	s.SubnetGroupStatus = &v
	return s
}

// SetSubnets sets the Subnets field's value.
func (s *ClusterSubnetGroup) SetSubnets(v []*Subnet) *ClusterSubnetGroup {
	s.Subnets = v
	return s
}

// SetTags sets the Tags field's value.
func (s *ClusterSubnetGroup) SetTags(v []*Tag) *ClusterSubnetGroup {
	s.Tags = v
	return s
}

// SetVpcId sets the VpcId field's value.
func (s *ClusterSubnetGroup) SetVpcId(v string) *ClusterSubnetGroup {
	s.VpcId = &v
	return s
}

// Describes a cluster version, including the parameter group family and description
// of the version.
type ClusterVersion struct {
	_ struct{} `type:"structure"`

	// The name of the cluster parameter group family for the cluster.
	ClusterParameterGroupFamily *string `type:"string"`

	// The version number used by the cluster.
	ClusterVersion *string `type:"string"`

	// The description of the cluster version.
	Description *string `type:"string"`
}

// String returns the string representation
func (s ClusterVersion) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ClusterVersion) GoString() string {
	return s.String()
}

// SetClusterParameterGroupFamily sets the ClusterParameterGroupFamily field's value.
func (s *ClusterVersion) SetClusterParameterGroupFamily(v string) *ClusterVersion {
	s.ClusterParameterGroupFamily = &v
	return s
}

// SetClusterVersion sets the ClusterVersion field's value.
func (s *ClusterVersion) SetClusterVersion(v string) *ClusterVersion {
	s.ClusterVersion = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *ClusterVersion) SetDescription(v string) *ClusterVersion {
	s.Description = &v
	return s
}

type CopyClusterSnapshotInput struct {
	_ struct{} `type:"structure"`

	// The number of days that a manual snapshot is retained. If the value is -1,
	// the manual snapshot is retained indefinitely.
	//
	// The value must be either -1 or an integer between 1 and 3,653.
	//
	// The default value is -1.
	ManualSnapshotRetentionPeriod *int64 `type:"integer"`

	// The identifier of the cluster the source snapshot was created from. This
	// parameter is required if your IAM user has a policy containing a snapshot
	// resource element that specifies anything other than * for the cluster name.
	//
	// Constraints:
	//
	//    * Must be the identifier for a valid cluster.
	SourceSnapshotClusterIdentifier *string `type:"string"`

	// The identifier for the source snapshot.
	//
	// Constraints:
	//
	//    * Must be the identifier for a valid automated snapshot whose state is
	//    available.
	//
	// SourceSnapshotIdentifier is a required field
	SourceSnapshotIdentifier *string `type:"string" required:"true"`

	// The identifier given to the new manual snapshot.
	//
	// Constraints:
	//
	//    * Cannot be null, empty, or blank.
	//
	//    * Must contain from 1 to 255 alphanumeric characters or hyphens.
	//
	//    * First character must be a letter.
	//
	//    * Cannot end with a hyphen or contain two consecutive hyphens.
	//
	//    * Must be unique for the AWS account that is making the request.
	//
	// TargetSnapshotIdentifier is a required field
	TargetSnapshotIdentifier *string `type:"string" required:"true"`
}

// String returns the string representation
func (s CopyClusterSnapshotInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CopyClusterSnapshotInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CopyClusterSnapshotInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CopyClusterSnapshotInput"}
	if s.SourceSnapshotIdentifier == nil {
		invalidParams.Add(request.NewErrParamRequired("SourceSnapshotIdentifier"))
	}
	if s.TargetSnapshotIdentifier == nil {
		invalidParams.Add(request.NewErrParamRequired("TargetSnapshotIdentifier"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetManualSnapshotRetentionPeriod sets the ManualSnapshotRetentionPeriod field's value.
func (s *CopyClusterSnapshotInput) SetManualSnapshotRetentionPeriod(v int64) *CopyClusterSnapshotInput {
	s.ManualSnapshotRetentionPeriod = &v
	return s
}

// SetSourceSnapshotClusterIdentifier sets the SourceSnapshotClusterIdentifier field's value.
func (s *CopyClusterSnapshotInput) SetSourceSnapshotClusterIdentifier(v string) *CopyClusterSnapshotInput {
	s.SourceSnapshotClusterIdentifier = &v
	return s
}

// SetSourceSnapshotIdentifier sets the SourceSnapshotIdentifier field's value.
func (s *CopyClusterSnapshotInput) SetSourceSnapshotIdentifier(v string) *CopyClusterSnapshotInput {
	s.SourceSnapshotIdentifier = &v
	return s
}

// SetTargetSnapshotIdentifier sets the TargetSnapshotIdentifier field's value.
func (s *CopyClusterSnapshotInput) SetTargetSnapshotIdentifier(v string) *CopyClusterSnapshotInput {
	s.TargetSnapshotIdentifier = &v
	return s
}

type CopyClusterSnapshotOutput struct {
	_ struct{} `type:"structure"`

	// Describes a snapshot.
	Snapshot *Snapshot `type:"structure"`
}

// String returns the string representation
func (s CopyClusterSnapshotOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CopyClusterSnapshotOutput) GoString() string {
	return s.String()
}

// SetSnapshot sets the Snapshot field's value.
func (s *CopyClusterSnapshotOutput) SetSnapshot(v *Snapshot) *CopyClusterSnapshotOutput {
	s.Snapshot = v
	return s
}

type CreateClusterInput struct {
	_ struct{} `type:"structure"`

	// Reserved.
	AdditionalInfo *string `type:"string"`

	// If true, major version upgrades can be applied during the maintenance window
	// to the Amazon Redshift engine that is running on the cluster.
	//
	// When a new major version of the Amazon Redshift engine is released, you can
	// request that the service automatically apply upgrades during the maintenance
	// window to the Amazon Redshift engine that is running on your cluster.
	//
	// Default: true
	AllowVersionUpgrade *bool `type:"boolean"`

	// The number of days that automated snapshots are retained. If the value is
	// 0, automated snapshots are disabled. Even if automated snapshots are disabled,
	// you can still create manual snapshots when you want with CreateClusterSnapshot.
	//
	// Default: 1
	//
	// Constraints: Must be a value from 0 to 35.
	AutomatedSnapshotRetentionPeriod *int64 `type:"integer"`

	// The EC2 Availability Zone (AZ) in which you want Amazon Redshift to provision
	// the cluster. For example, if you have several EC2 instances running in a
	// specific Availability Zone, then you might want the cluster to be provisioned
	// in the same zone in order to decrease network latency.
	//
	// Default: A random, system-chosen Availability Zone in the region that is
	// specified by the endpoint.
	//
	// Example: us-east-2d
	//
	// Constraint: The specified Availability Zone must be in the same region as
	// the current endpoint.
	AvailabilityZone *string `type:"string"`

	// A unique identifier for the cluster. You use this identifier to refer to
	// the cluster for any subsequent cluster operations such as deleting or modifying.
	// The identifier also appears in the Amazon Redshift console.
	//
	// Constraints:
	//
	//    * Must contain from 1 to 63 alphanumeric characters or hyphens.
	//
	//    * Alphabetic characters must be lowercase.
	//
	//    * First character must be a letter.
	//
	//    * Cannot end with a hyphen or contain two consecutive hyphens.
	//
	//    * Must be unique for all clusters within an AWS account.
	//
	// Example: myexamplecluster
	//
	// ClusterIdentifier is a required field
	ClusterIdentifier *string `type:"string" required:"true"`

	// The name of the parameter group to be associated with this cluster.
	//
	// Default: The default Amazon Redshift cluster parameter group. For information
	// about the default parameter group, go to Working with Amazon Redshift Parameter
	// Groups (https://docs.aws.amazon.com/redshift/latest/mgmt/working-with-parameter-groups.html)
	//
	// Constraints:
	//
	//    * Must be 1 to 255 alphanumeric characters or hyphens.
	//
	//    * First character must be a letter.
	//
	//    * Cannot end with a hyphen or contain two consecutive hyphens.
	ClusterParameterGroupName *string `type:"string"`

	// A list of security groups to be associated with this cluster.
	//
	// Default: The default cluster security group for Amazon Redshift.
	ClusterSecurityGroups []*string `locationNameList:"ClusterSecurityGroupName" type:"list"`

	// The name of a cluster subnet group to be associated with this cluster.
	//
	// If this parameter is not provided the resulting cluster will be deployed
	// outside virtual private cloud (VPC).
	ClusterSubnetGroupName *string `type:"string"`

	// The type of the cluster. When cluster type is specified as
	//
	//    * single-node, the NumberOfNodes parameter is not required.
	//
	//    * multi-node, the NumberOfNodes parameter is required.
	//
	// Valid Values: multi-node | single-node
	//
	// Default: multi-node
	ClusterType *string `type:"string"`

	// The version of the Amazon Redshift engine software that you want to deploy
	// on the cluster.
	//
	// The version selected runs on all the nodes in the cluster.
	//
	// Constraints: Only version 1.0 is currently available.
	//
	// Example: 1.0
	ClusterVersion *string `type:"string"`

	// The name of the first database to be created when the cluster is created.
	//
	// To create additional databases after the cluster is created, connect to the
	// cluster with a SQL client and use SQL commands to create a database. For
	// more information, go to Create a Database (https://docs.aws.amazon.com/redshift/latest/dg/t_creating_database.html)
	// in the Amazon Redshift Database Developer Guide.
	//
	// Default: dev
	//
	// Constraints:
	//
	//    * Must contain 1 to 64 alphanumeric characters.
	//
	//    * Must contain only lowercase letters.
	//
	//    * Cannot be a word that is reserved by the service. A list of reserved
	//    words can be found in Reserved Words (https://docs.aws.amazon.com/redshift/latest/dg/r_pg_keywords.html)
	//    in the Amazon Redshift Database Developer Guide.
	DBName *string `type:"string"`

	// The Elastic IP (EIP) address for the cluster.
	//
	// Constraints: The cluster must be provisioned in EC2-VPC and publicly-accessible
	// through an Internet gateway. For more information about provisioning clusters
	// in EC2-VPC, go to Supported Platforms to Launch Your Cluster (https://docs.aws.amazon.com/redshift/latest/mgmt/working-with-clusters.html#cluster-platforms)
	// in the Amazon Redshift Cluster Management Guide.
	ElasticIp *string `type:"string"`

	// If true, the data in the cluster is encrypted at rest.
	//
	// Default: false
	Encrypted *bool `type:"boolean"`

	// An option that specifies whether to create the cluster with enhanced VPC
	// routing enabled. To create a cluster that uses enhanced VPC routing, the
	// cluster must be in a VPC. For more information, see Enhanced VPC Routing
	// (https://docs.aws.amazon.com/redshift/latest/mgmt/enhanced-vpc-routing.html)
	// in the Amazon Redshift Cluster Management Guide.
	//
	// If this option is true, enhanced VPC routing is enabled.
	//
	// Default: false
	EnhancedVpcRouting *bool `type:"boolean"`

	// Specifies the name of the HSM client certificate the Amazon Redshift cluster
	// uses to retrieve the data encryption keys stored in an HSM.
	HsmClientCertificateIdentifier *string `type:"string"`

	// Specifies the name of the HSM configuration that contains the information
	// the Amazon Redshift cluster can use to retrieve and store keys in an HSM.
	HsmConfigurationIdentifier *string `type:"string"`

	// A list of AWS Identity and Access Management (IAM) roles that can be used
	// by the cluster to access other AWS services. You must supply the IAM roles
	// in their Amazon Resource Name (ARN) format. You can supply up to 10 IAM roles
	// in a single request.
	//
	// A cluster can have up to 10 IAM roles associated with it at any time.
	IamRoles []*string `locationNameList:"IamRoleArn" type:"list"`

	// The AWS Key Management Service (KMS) key ID of the encryption key that you
	// want to use to encrypt data in the cluster.
	KmsKeyId *string `type:"string"`

	// An optional parameter for the name of the maintenance track for the cluster.
	// If you don't provide a maintenance track name, the cluster is assigned to
	// the current track.
	MaintenanceTrackName *string `type:"string"`

	// The default number of days to retain a manual snapshot. If the value is -1,
	// the snapshot is retained indefinitely. This setting doesn't change the retention
	// period of existing snapshots.
	//
	// The value must be either -1 or an integer between 1 and 3,653.
	ManualSnapshotRetentionPeriod *int64 `type:"integer"`

	// The password associated with the master user account for the cluster that
	// is being created.
	//
	// Constraints:
	//
	//    * Must be between 8 and 64 characters in length.
	//
	//    * Must contain at least one uppercase letter.
	//
	//    * Must contain at least one lowercase letter.
	//
	//    * Must contain one number.
	//
	//    * Can be any printable ASCII character (ASCII code 33 to 126) except '
	//    (single quote), " (double quote), \, /, @, or space.
	//
	// MasterUserPassword is a required field
	MasterUserPassword *string `type:"string" required:"true"`

	// The user name associated with the master user account for the cluster that
	// is being created.
	//
	// Constraints:
	//
	//    * Must be 1 - 128 alphanumeric characters. The user name can't be PUBLIC.
	//
	//    * First character must be a letter.
	//
	//    * Cannot be a reserved word. A list of reserved words can be found in
	//    Reserved Words (https://docs.aws.amazon.com/redshift/latest/dg/r_pg_keywords.html)
	//    in the Amazon Redshift Database Developer Guide.
	//
	// MasterUsername is a required field
	MasterUsername *string `type:"string" required:"true"`

	// The node type to be provisioned for the cluster. For information about node
	// types, go to Working with Clusters (https://docs.aws.amazon.com/redshift/latest/mgmt/working-with-clusters.html#how-many-nodes)
	// in the Amazon Redshift Cluster Management Guide.
	//
	// Valid Values: ds2.xlarge | ds2.8xlarge | dc1.large | dc1.8xlarge | dc2.large
	// | dc2.8xlarge | ra3.16xlarge
	//
	// NodeType is a required field
	NodeType *string `type:"string" required:"true"`

	// The number of compute nodes in the cluster. This parameter is required when
	// the ClusterType parameter is specified as multi-node.
	//
	// For information about determining how many nodes you need, go to Working
	// with Clusters (https://docs.aws.amazon.com/redshift/latest/mgmt/working-with-clusters.html#how-many-nodes)
	// in the Amazon Redshift Cluster Management Guide.
	//
	// If you don't specify this parameter, you get a single-node cluster. When
	// requesting a multi-node cluster, you must specify the number of nodes that
	// you want in the cluster.
	//
	// Default: 1
	//
	// Constraints: Value must be at least 1 and no more than 100.
	NumberOfNodes *int64 `type:"integer"`

	// The port number on which the cluster accepts incoming connections.
	//
	// The cluster is accessible only via the JDBC and ODBC connection strings.
	// Part of the connection string requires the port on which the cluster will
	// listen for incoming connections.
	//
	// Default: 5439
	//
	// Valid Values: 1150-65535
	Port *int64 `type:"integer"`

	// The weekly time range (in UTC) during which automated cluster maintenance
	// can occur.
	//
	// Format: ddd:hh24:mi-ddd:hh24:mi
	//
	// Default: A 30-minute window selected at random from an 8-hour block of time
	// per region, occurring on a random day of the week. For more information about
	// the time blocks for each region, see Maintenance Windows (https://docs.aws.amazon.com/redshift/latest/mgmt/working-with-clusters.html#rs-maintenance-windows)
	// in Amazon Redshift Cluster Management Guide.
	//
	// Valid Days: Mon | Tue | Wed | Thu | Fri | Sat | Sun
	//
	// Constraints: Minimum 30-minute window.
	PreferredMaintenanceWindow *string `type:"string"`

	// If true, the cluster can be accessed from a public network.
	PubliclyAccessible *bool `type:"boolean"`

	// A unique identifier for the snapshot schedule.
	SnapshotScheduleIdentifier *string `type:"string"`

	// A list of tag instances.
	Tags []*Tag `locationNameList:"Tag" type:"list"`

	// A list of Virtual Private Cloud (VPC) security groups to be associated with
	// the cluster.
	//
	// Default: The default VPC security group is associated with the cluster.
	VpcSecurityGroupIds []*string `locationNameList:"VpcSecurityGroupId" type:"list"`
}

// String returns the string representation
func (s CreateClusterInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateClusterInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateClusterInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateClusterInput"}
	if s.ClusterIdentifier == nil {
		invalidParams.Add(request.NewErrParamRequired("ClusterIdentifier"))
	}
	if s.MasterUserPassword == nil {
		invalidParams.Add(request.NewErrParamRequired("MasterUserPassword"))
	}
	if s.MasterUsername == nil {
		invalidParams.Add(request.NewErrParamRequired("MasterUsername"))
	}
	if s.NodeType == nil {
		invalidParams.Add(request.NewErrParamRequired("NodeType"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAdditionalInfo sets the AdditionalInfo field's value.
func (s *CreateClusterInput) SetAdditionalInfo(v string) *CreateClusterInput {
	s.AdditionalInfo = &v
	return s
}

// SetAllowVersionUpgrade sets the AllowVersionUpgrade field's value.
func (s *CreateClusterInput) SetAllowVersionUpgrade(v bool) *CreateClusterInput {
	s.AllowVersionUpgrade = &v
	return s
}

// SetAutomatedSnapshotRetentionPeriod sets the AutomatedSnapshotRetentionPeriod field's value.
func (s *CreateClusterInput) SetAutomatedSnapshotRetentionPeriod(v int64) *CreateClusterInput {
	s.AutomatedSnapshotRetentionPeriod = &v
	return s
}

// SetAvailabilityZone sets the AvailabilityZone field's value.
func (s *CreateClusterInput) SetAvailabilityZone(v string) *CreateClusterInput {
	s.AvailabilityZone = &v
	return s
}

// SetClusterIdentifier sets the ClusterIdentifier field's value.
func (s *CreateClusterInput) SetClusterIdentifier(v string) *CreateClusterInput {
	s.ClusterIdentifier = &v
	return s
}

// SetClusterParameterGroupName sets the ClusterParameterGroupName field's value.
func (s *CreateClusterInput) SetClusterParameterGroupName(v string) *CreateClusterInput {
	s.ClusterParameterGroupName = &v
	return s
}

// SetClusterSecurityGroups sets the ClusterSecurityGroups field's value.
func (s *CreateClusterInput) SetClusterSecurityGroups(v []*string) *CreateClusterInput {
	s.ClusterSecurityGroups = v
	return s
}

// SetClusterSubnetGroupName sets the ClusterSubnetGroupName field's value.
func (s *CreateClusterInput) SetClusterSubnetGroupName(v string) *CreateClusterInput {
	s.ClusterSubnetGroupName = &v
	return s
}

// SetClusterType sets the ClusterType field's value.
func (s *CreateClusterInput) SetClusterType(v string) *CreateClusterInput {
	s.ClusterType = &v
	return s
}

// SetClusterVersion sets the ClusterVersion field's value.
func (s *CreateClusterInput) SetClusterVersion(v string) *CreateClusterInput {
	s.ClusterVersion = &v
	return s
}

// SetDBName sets the DBName field's value.
func (s *CreateClusterInput) SetDBName(v string) *CreateClusterInput {
	s.DBName = &v
	return s
}

// SetElasticIp sets the ElasticIp field's value.
func (s *CreateClusterInput) SetElasticIp(v string) *CreateClusterInput {
	s.ElasticIp = &v
	return s
}

// SetEncrypted sets the Encrypted field's value.
func (s *CreateClusterInput) SetEncrypted(v bool) *CreateClusterInput {
	s.Encrypted = &v
	return s
}

// SetEnhancedVpcRouting sets the EnhancedVpcRouting field's value.
func (s *CreateClusterInput) SetEnhancedVpcRouting(v bool) *CreateClusterInput {
	s.EnhancedVpcRouting = &v
	return s
}

// SetHsmClientCertificateIdentifier sets the HsmClientCertificateIdentifier field's value.
func (s *CreateClusterInput) SetHsmClientCertificateIdentifier(v string) *CreateClusterInput {
	s.HsmClientCertificateIdentifier = &v
	return s
}

// SetHsmConfigurationIdentifier sets the HsmConfigurationIdentifier field's value.
func (s *CreateClusterInput) SetHsmConfigurationIdentifier(v string) *CreateClusterInput {
	s.HsmConfigurationIdentifier = &v
	return s
}

// SetIamRoles sets the IamRoles field's value.
func (s *CreateClusterInput) SetIamRoles(v []*string) *CreateClusterInput {
	s.IamRoles = v
	return s
}

// SetKmsKeyId sets the KmsKeyId field's value.
func (s *CreateClusterInput) SetKmsKeyId(v string) *CreateClusterInput {
	s.KmsKeyId = &v
	return s
}

// SetMaintenanceTrackName sets the MaintenanceTrackName field's value.
func (s *CreateClusterInput) SetMaintenanceTrackName(v string) *CreateClusterInput {
	s.MaintenanceTrackName = &v
	return s
}

// SetManualSnapshotRetentionPeriod sets the ManualSnapshotRetentionPeriod field's value.
func (s *CreateClusterInput) SetManualSnapshotRetentionPeriod(v int64) *CreateClusterInput {
	s.ManualSnapshotRetentionPeriod = &v
	return s
}

// SetMasterUserPassword sets the MasterUserPassword field's value.
func (s *CreateClusterInput) SetMasterUserPassword(v string) *CreateClusterInput {
	s.MasterUserPassword = &v
	return s
}

// SetMasterUsername sets the MasterUsername field's value.
func (s *CreateClusterInput) SetMasterUsername(v string) *CreateClusterInput {
	s.MasterUsername = &v
	return s
}

// SetNodeType sets the NodeType field's value.
func (s *CreateClusterInput) SetNodeType(v string) *CreateClusterInput {
	s.NodeType = &v
	return s
}

// SetNumberOfNodes sets the NumberOfNodes field's value.
func (s *CreateClusterInput) SetNumberOfNodes(v int64) *CreateClusterInput {
	s.NumberOfNodes = &v
	return s
}

// SetPort sets the Port field's value.
func (s *CreateClusterInput) SetPort(v int64) *CreateClusterInput {
	s.Port = &v
	return s
}

// SetPreferredMaintenanceWindow sets the PreferredMaintenanceWindow field's value.
func (s *CreateClusterInput) SetPreferredMaintenanceWindow(v string) *CreateClusterInput {
	s.PreferredMaintenanceWindow = &v
	return s
}

// SetPubliclyAccessible sets the PubliclyAccessible field's value.
func (s *CreateClusterInput) SetPubliclyAccessible(v bool) *CreateClusterInput {
	s.PubliclyAccessible = &v
	return s
}

// SetSnapshotScheduleIdentifier sets the SnapshotScheduleIdentifier field's value.
func (s *CreateClusterInput) SetSnapshotScheduleIdentifier(v string) *CreateClusterInput {
	s.SnapshotScheduleIdentifier = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateClusterInput) SetTags(v []*Tag) *CreateClusterInput {
	s.Tags = v
	return s
}

// SetVpcSecurityGroupIds sets the VpcSecurityGroupIds field's value.
func (s *CreateClusterInput) SetVpcSecurityGroupIds(v []*string) *CreateClusterInput {
	s.VpcSecurityGroupIds = v
	return s
}

type CreateClusterOutput struct {
	_ struct{} `type:"structure"`

	// Describes a cluster.
	Cluster *Cluster `type:"structure"`
}

// String returns the string representation
func (s CreateClusterOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateClusterOutput) GoString() string {
	return s.String()
}

// SetCluster sets the Cluster field's value.
func (s *CreateClusterOutput) SetCluster(v *Cluster) *CreateClusterOutput {
	s.Cluster = v
	return s
}

type CreateClusterParameterGroupInput struct {
	_ struct{} `type:"structure"`

	// A description of the parameter group.
	//
	// Description is a required field
	Description *string `type:"string" required:"true"`

	// The Amazon Redshift engine version to which the cluster parameter group applies.
	// The cluster engine version determines the set of parameters.
	//
	// To get a list of valid parameter group family names, you can call DescribeClusterParameterGroups.
	// By default, Amazon Redshift returns a list of all the parameter groups that
	// are owned by your AWS account, including the default parameter groups for
	// each Amazon Redshift engine version. The parameter group family names associated
	// with the default parameter groups provide you the valid values. For example,
	// a valid family name is "redshift-1.0".
	//
	// ParameterGroupFamily is a required field
	ParameterGroupFamily *string `type:"string" required:"true"`

	// The name of the cluster parameter group.
	//
	// Constraints:
	//
	//    * Must be 1 to 255 alphanumeric characters or hyphens
	//
	//    * First character must be a letter.
	//
	//    * Cannot end with a hyphen or contain two consecutive hyphens.
	//
	//    * Must be unique withing your AWS account.
	//
	// This value is stored as a lower-case string.
	//
	// ParameterGroupName is a required field
	ParameterGroupName *string `type:"string" required:"true"`

	// A list of tag instances.
	Tags []*Tag `locationNameList:"Tag" type:"list"`
}

// String returns the string representation
func (s CreateClusterParameterGroupInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateClusterParameterGroupInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateClusterParameterGroupInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateClusterParameterGroupInput"}
	if s.Description == nil {
		invalidParams.Add(request.NewErrParamRequired("Description"))
	}
	if s.ParameterGroupFamily == nil {
		invalidParams.Add(request.NewErrParamRequired("ParameterGroupFamily"))
	}
	if s.ParameterGroupName == nil {
		invalidParams.Add(request.NewErrParamRequired("ParameterGroupName"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDescription sets the Description field's value.
func (s *CreateClusterParameterGroupInput) SetDescription(v string) *CreateClusterParameterGroupInput {
	s.Description = &v
	return s
}

// SetParameterGroupFamily sets the ParameterGroupFamily field's value.
func (s *CreateClusterParameterGroupInput) SetParameterGroupFamily(v string) *CreateClusterParameterGroupInput {
	s.ParameterGroupFamily = &v
	return s
}

// SetParameterGroupName sets the ParameterGroupName field's value.
func (s *CreateClusterParameterGroupInput) SetParameterGroupName(v string) *CreateClusterParameterGroupInput {
	s.ParameterGroupName = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateClusterParameterGroupInput) SetTags(v []*Tag) *CreateClusterParameterGroupInput {
	s.Tags = v
	return s
}

type CreateClusterParameterGroupOutput struct {
	_ struct{} `type:"structure"`

	// Describes a parameter group.
	ClusterParameterGroup *ClusterParameterGroup `type:"structure"`
}

// String returns the string representation
func (s CreateClusterParameterGroupOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateClusterParameterGroupOutput) GoString() string {
	return s.String()
}

// SetClusterParameterGroup sets the ClusterParameterGroup field's value.
func (s *CreateClusterParameterGroupOutput) SetClusterParameterGroup(v *ClusterParameterGroup) *CreateClusterParameterGroupOutput {
	s.ClusterParameterGroup = v
	return s
}

type CreateClusterSecurityGroupInput struct {
	_ struct{} `type:"structure"`

	// The name for the security group. Amazon Redshift stores the value as a lowercase
	// string.
	//
	// Constraints:
	//
	//    * Must contain no more than 255 alphanumeric characters or hyphens.
	//
	//    * Must not be "Default".
	//
	//    * Must be unique for all security groups that are created by your AWS
	//    account.
	//
	// Example: examplesecuritygroup
	//
	// ClusterSecurityGroupName is a required field
	ClusterSecurityGroupName *string `type:"string" required:"true"`

	// A description for the security group.
	//
	// Description is a required field
	Description *string `type:"string" required:"true"`

	// A list of tag instances.
	Tags []*Tag `locationNameList:"Tag" type:"list"`
}

// String returns the string representation
func (s CreateClusterSecurityGroupInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateClusterSecurityGroupInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateClusterSecurityGroupInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateClusterSecurityGroupInput"}
	if s.ClusterSecurityGroupName == nil {
		invalidParams.Add(request.NewErrParamRequired("ClusterSecurityGroupName"))
	}
	if s.Description == nil {
		invalidParams.Add(request.NewErrParamRequired("Description"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClusterSecurityGroupName sets the ClusterSecurityGroupName field's value.
func (s *CreateClusterSecurityGroupInput) SetClusterSecurityGroupName(v string) *CreateClusterSecurityGroupInput {
	s.ClusterSecurityGroupName = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *CreateClusterSecurityGroupInput) SetDescription(v string) *CreateClusterSecurityGroupInput {
	s.Description = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateClusterSecurityGroupInput) SetTags(v []*Tag) *CreateClusterSecurityGroupInput {
	s.Tags = v
	return s
}

type CreateClusterSecurityGroupOutput struct {
	_ struct{} `type:"structure"`

	// Describes a security group.
	ClusterSecurityGroup *ClusterSecurityGroup `type:"structure"`
}

// String returns the string representation
func (s CreateClusterSecurityGroupOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateClusterSecurityGroupOutput) GoString() string {
	return s.String()
}

// SetClusterSecurityGroup sets the ClusterSecurityGroup field's value.
func (s *CreateClusterSecurityGroupOutput) SetClusterSecurityGroup(v *ClusterSecurityGroup) *CreateClusterSecurityGroupOutput {
	s.ClusterSecurityGroup = v
	return s
}

type CreateClusterSnapshotInput struct {
	_ struct{} `type:"structure"`

	// The cluster identifier for which you want a snapshot.
	//
	// ClusterIdentifier is a required field
	ClusterIdentifier *string `type:"string" required:"true"`

	// The number of days that a manual snapshot is retained. If the value is -1,
	// the manual snapshot is retained indefinitely.
	//
	// The value must be either -1 or an integer between 1 and 3,653.
	//
	// The default value is -1.
	ManualSnapshotRetentionPeriod *int64 `type:"integer"`

	// A unique identifier for the snapshot that you are requesting. This identifier
	// must be unique for all snapshots within the AWS account.
	//
	// Constraints:
	//
	//    * Cannot be null, empty, or blank
	//
	//    * Must contain from 1 to 255 alphanumeric characters or hyphens
	//
	//    * First character must be a letter
	//
	//    * Cannot end with a hyphen or contain two consecutive hyphens
	//
	// Example: my-snapshot-id
	//
	// SnapshotIdentifier is a required field
	SnapshotIdentifier *string `type:"string" required:"true"`

	// A list of tag instances.
	Tags []*Tag `locationNameList:"Tag" type:"list"`
}

// String returns the string representation
func (s CreateClusterSnapshotInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateClusterSnapshotInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateClusterSnapshotInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateClusterSnapshotInput"}
	if s.ClusterIdentifier == nil {
		invalidParams.Add(request.NewErrParamRequired("ClusterIdentifier"))
	}
	if s.SnapshotIdentifier == nil {
		invalidParams.Add(request.NewErrParamRequired("SnapshotIdentifier"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClusterIdentifier sets the ClusterIdentifier field's value.
func (s *CreateClusterSnapshotInput) SetClusterIdentifier(v string) *CreateClusterSnapshotInput {
	s.ClusterIdentifier = &v
	return s
}

// SetManualSnapshotRetentionPeriod sets the ManualSnapshotRetentionPeriod field's value.
func (s *CreateClusterSnapshotInput) SetManualSnapshotRetentionPeriod(v int64) *CreateClusterSnapshotInput {
	s.ManualSnapshotRetentionPeriod = &v
	return s
}

// SetSnapshotIdentifier sets the SnapshotIdentifier field's value.
func (s *CreateClusterSnapshotInput) SetSnapshotIdentifier(v string) *CreateClusterSnapshotInput {
	s.SnapshotIdentifier = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateClusterSnapshotInput) SetTags(v []*Tag) *CreateClusterSnapshotInput {
	s.Tags = v
	return s
}

type CreateClusterSnapshotOutput struct {
	_ struct{} `type:"structure"`

	// Describes a snapshot.
	Snapshot *Snapshot `type:"structure"`
}

// String returns the string representation
func (s CreateClusterSnapshotOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateClusterSnapshotOutput) GoString() string {
	return s.String()
}

// SetSnapshot sets the Snapshot field's value.
func (s *CreateClusterSnapshotOutput) SetSnapshot(v *Snapshot) *CreateClusterSnapshotOutput {
	s.Snapshot = v
	return s
}

type CreateClusterSubnetGroupInput struct {
	_ struct{} `type:"structure"`

	// The name for the subnet group. Amazon Redshift stores the value as a lowercase
	// string.
	//
	// Constraints:
	//
	//    * Must contain no more than 255 alphanumeric characters or hyphens.
	//
	//    * Must not be "Default".
	//
	//    * Must be unique for all subnet groups that are created by your AWS account.
	//
	// Example: examplesubnetgroup
	//
	// ClusterSubnetGroupName is a required field
	ClusterSubnetGroupName *string `type:"string" required:"true"`

	// A description for the subnet group.
	//
	// Description is a required field
	Description *string `type:"string" required:"true"`

	// An array of VPC subnet IDs. A maximum of 20 subnets can be modified in a
	// single request.
	//
	// SubnetIds is a required field
	SubnetIds []*string `locationNameList:"SubnetIdentifier" type:"list" required:"true"`

	// A list of tag instances.
	Tags []*Tag `locationNameList:"Tag" type:"list"`
}

// String returns the string representation
func (s CreateClusterSubnetGroupInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateClusterSubnetGroupInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateClusterSubnetGroupInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateClusterSubnetGroupInput"}
	if s.ClusterSubnetGroupName == nil {
		invalidParams.Add(request.NewErrParamRequired("ClusterSubnetGroupName"))
	}
	if s.Description == nil {
		invalidParams.Add(request.NewErrParamRequired("Description"))
	}
	if s.SubnetIds == nil {
		invalidParams.Add(request.NewErrParamRequired("SubnetIds"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClusterSubnetGroupName sets the ClusterSubnetGroupName field's value.
func (s *CreateClusterSubnetGroupInput) SetClusterSubnetGroupName(v string) *CreateClusterSubnetGroupInput {
	s.ClusterSubnetGroupName = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *CreateClusterSubnetGroupInput) SetDescription(v string) *CreateClusterSubnetGroupInput {
	s.Description = &v
	return s
}

// SetSubnetIds sets the SubnetIds field's value.
func (s *CreateClusterSubnetGroupInput) SetSubnetIds(v []*string) *CreateClusterSubnetGroupInput {
	s.SubnetIds = v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateClusterSubnetGroupInput) SetTags(v []*Tag) *CreateClusterSubnetGroupInput {
	s.Tags = v
	return s
}

type CreateClusterSubnetGroupOutput struct {
	_ struct{} `type:"structure"`

	// Describes a subnet group.
	ClusterSubnetGroup *ClusterSubnetGroup `type:"structure"`
}

// String returns the string representation
func (s CreateClusterSubnetGroupOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateClusterSubnetGroupOutput) GoString() string {
	return s.String()
}

// SetClusterSubnetGroup sets the ClusterSubnetGroup field's value.
func (s *CreateClusterSubnetGroupOutput) SetClusterSubnetGroup(v *ClusterSubnetGroup) *CreateClusterSubnetGroupOutput {
	s.ClusterSubnetGroup = v
	return s
}

type CreateEventSubscriptionInput struct {
	_ struct{} `type:"structure"`

	// A boolean value; set to true to activate the subscription, and set to false
	// to create the subscription but not activate it.
	Enabled *bool `type:"boolean"`

	// Specifies the Amazon Redshift event categories to be published by the event
	// notification subscription.
	//
	// Values: configuration, management, monitoring, security
	EventCategories []*string `locationNameList:"EventCategory" type:"list"`

	// Specifies the Amazon Redshift event severity to be published by the event
	// notification subscription.
	//
	// Values: ERROR, INFO
	Severity *string `type:"string"`

	// The Amazon Resource Name (ARN) of the Amazon SNS topic used to transmit the
	// event notifications. The ARN is created by Amazon SNS when you create a topic
	// and subscribe to it.
	//
	// SnsTopicArn is a required field
	SnsTopicArn *string `type:"string" required:"true"`

	// A list of one or more identifiers of Amazon Redshift source objects. All
	// of the objects must be of the same type as was specified in the source type
	// parameter. The event subscription will return only events generated by the
	// specified objects. If not specified, then events are returned for all objects
	// within the source type specified.
	//
	// Example: my-cluster-1, my-cluster-2
	//
	// Example: my-snapshot-20131010
	SourceIds []*string `locationNameList:"SourceId" type:"list"`

	// The type of source that will be generating the events. For example, if you
	// want to be notified of events generated by a cluster, you would set this
	// parameter to cluster. If this value is not specified, events are returned
	// for all Amazon Redshift objects in your AWS account. You must specify a source
	// type in order to specify source IDs.
	//
	// Valid values: cluster, cluster-parameter-group, cluster-security-group, cluster-snapshot,
	// and scheduled-action.
	SourceType *string `type:"string"`

	// The name of the event subscription to be created.
	//
	// Constraints:
	//
	//    * Cannot be null, empty, or blank.
	//
	//    * Must contain from 1 to 255 alphanumeric characters or hyphens.
	//
	//    * First character must be a letter.
	//
	//    * Cannot end with a hyphen or contain two consecutive hyphens.
	//
	// SubscriptionName is a required field
	SubscriptionName *string `type:"string" required:"true"`

	// A list of tag instances.
	Tags []*Tag `locationNameList:"Tag" type:"list"`
}

// String returns the string representation
func (s CreateEventSubscriptionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateEventSubscriptionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateEventSubscriptionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateEventSubscriptionInput"}
	if s.SnsTopicArn == nil {
		invalidParams.Add(request.NewErrParamRequired("SnsTopicArn"))
	}
	if s.SubscriptionName == nil {
		invalidParams.Add(request.NewErrParamRequired("SubscriptionName"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetEnabled sets the Enabled field's value.
func (s *CreateEventSubscriptionInput) SetEnabled(v bool) *CreateEventSubscriptionInput {
	s.Enabled = &v
	return s
}

// SetEventCategories sets the EventCategories field's value.
func (s *CreateEventSubscriptionInput) SetEventCategories(v []*string) *CreateEventSubscriptionInput {
	s.EventCategories = v
	return s
}

// SetSeverity sets the Severity field's value.
func (s *CreateEventSubscriptionInput) SetSeverity(v string) *CreateEventSubscriptionInput {
	s.Severity = &v
	return s
}

// SetSnsTopicArn sets the SnsTopicArn field's value.
func (s *CreateEventSubscriptionInput) SetSnsTopicArn(v string) *CreateEventSubscriptionInput {
	s.SnsTopicArn = &v
	return s
}

// SetSourceIds sets the SourceIds field's value.
func (s *CreateEventSubscriptionInput) SetSourceIds(v []*string) *CreateEventSubscriptionInput {
	s.SourceIds = v
	return s
}

// SetSourceType sets the SourceType field's value.
func (s *CreateEventSubscriptionInput) SetSourceType(v string) *CreateEventSubscriptionInput {
	s.SourceType = &v
	return s
}

// SetSubscriptionName sets the SubscriptionName field's value.
func (s *CreateEventSubscriptionInput) SetSubscriptionName(v string) *CreateEventSubscriptionInput {
	s.SubscriptionName = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateEventSubscriptionInput) SetTags(v []*Tag) *CreateEventSubscriptionInput {
	s.Tags = v
	return s
}

type CreateEventSubscriptionOutput struct {
	_ struct{} `type:"structure"`

	// Describes event subscriptions.
	EventSubscription *EventSubscription `type:"structure"`
}

// String returns the string representation
func (s CreateEventSubscriptionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateEventSubscriptionOutput) GoString() string {
	return s.String()
}

// SetEventSubscription sets the EventSubscription field's value.
func (s *CreateEventSubscriptionOutput) SetEventSubscription(v *EventSubscription) *CreateEventSubscriptionOutput {
	s.EventSubscription = v
	return s
}

type CreateHsmClientCertificateInput struct {
	_ struct{} `type:"structure"`

	// The identifier to be assigned to the new HSM client certificate that the
	// cluster will use to connect to the HSM to use the database encryption keys.
	//
	// HsmClientCertificateIdentifier is a required field
	HsmClientCertificateIdentifier *string `type:"string" required:"true"`

	// A list of tag instances.
	Tags []*Tag `locationNameList:"Tag" type:"list"`
}

// String returns the string representation
func (s CreateHsmClientCertificateInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateHsmClientCertificateInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateHsmClientCertificateInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateHsmClientCertificateInput"}
	if s.HsmClientCertificateIdentifier == nil {
		invalidParams.Add(request.NewErrParamRequired("HsmClientCertificateIdentifier"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetHsmClientCertificateIdentifier sets the HsmClientCertificateIdentifier field's value.
func (s *CreateHsmClientCertificateInput) SetHsmClientCertificateIdentifier(v string) *CreateHsmClientCertificateInput {
	s.HsmClientCertificateIdentifier = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateHsmClientCertificateInput) SetTags(v []*Tag) *CreateHsmClientCertificateInput {
	s.Tags = v
	return s
}

type CreateHsmClientCertificateOutput struct {
	_ struct{} `type:"structure"`

	// Returns information about an HSM client certificate. The certificate is stored
	// in a secure Hardware Storage Module (HSM), and used by the Amazon Redshift
	// cluster to encrypt data files.
	HsmClientCertificate *HsmClientCertificate `type:"structure"`
}

// String returns the string representation
func (s CreateHsmClientCertificateOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateHsmClientCertificateOutput) GoString() string {
	return s.String()
}

// SetHsmClientCertificate sets the HsmClientCertificate field's value.
func (s *CreateHsmClientCertificateOutput) SetHsmClientCertificate(v *HsmClientCertificate) *CreateHsmClientCertificateOutput {
	s.HsmClientCertificate = v
	return s
}

type CreateHsmConfigurationInput struct {
	_ struct{} `type:"structure"`

	// A text description of the HSM configuration to be created.
	//
	// Description is a required field
	Description *string `type:"string" required:"true"`

	// The identifier to be assigned to the new Amazon Redshift HSM configuration.
	//
	// HsmConfigurationIdentifier is a required field
	HsmConfigurationIdentifier *string `type:"string" required:"true"`

	// The IP address that the Amazon Redshift cluster must use to access the HSM.
	//
	// HsmIpAddress is a required field
	HsmIpAddress *string `type:"string" required:"true"`

	// The name of the partition in the HSM where the Amazon Redshift clusters will
	// store their database encryption keys.
	//
	// HsmPartitionName is a required field
	HsmPartitionName *string `type:"string" required:"true"`

	// The password required to access the HSM partition.
	//
	// HsmPartitionPassword is a required field
	HsmPartitionPassword *string `type:"string" required:"true"`

	// The HSMs public certificate file. When using Cloud HSM, the file name is
	// server.pem.
	//
	// HsmServerPublicCertificate is a required field
	HsmServerPublicCertificate *string `type:"string" required:"true"`

	// A list of tag instances.
	Tags []*Tag `locationNameList:"Tag" type:"list"`
}

// String returns the string representation
func (s CreateHsmConfigurationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateHsmConfigurationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateHsmConfigurationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateHsmConfigurationInput"}
	if s.Description == nil {
		invalidParams.Add(request.NewErrParamRequired("Description"))
	}
	if s.HsmConfigurationIdentifier == nil {
		invalidParams.Add(request.NewErrParamRequired("HsmConfigurationIdentifier"))
	}
	if s.HsmIpAddress == nil {
		invalidParams.Add(request.NewErrParamRequired("HsmIpAddress"))
	}
	if s.HsmPartitionName == nil {
		invalidParams.Add(request.NewErrParamRequired("HsmPartitionName"))
	}
	if s.HsmPartitionPassword == nil {
		invalidParams.Add(request.NewErrParamRequired("HsmPartitionPassword"))
	}
	if s.HsmServerPublicCertificate == nil {
		invalidParams.Add(request.NewErrParamRequired("HsmServerPublicCertificate"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDescription sets the Description field's value.
func (s *CreateHsmConfigurationInput) SetDescription(v string) *CreateHsmConfigurationInput {
	s.Description = &v
	return s
}

// SetHsmConfigurationIdentifier sets the HsmConfigurationIdentifier field's value.
func (s *CreateHsmConfigurationInput) SetHsmConfigurationIdentifier(v string) *CreateHsmConfigurationInput {
	s.HsmConfigurationIdentifier = &v
	return s
}

// SetHsmIpAddress sets the HsmIpAddress field's value.
func (s *CreateHsmConfigurationInput) SetHsmIpAddress(v string) *CreateHsmConfigurationInput {
	s.HsmIpAddress = &v
	return s
}

// SetHsmPartitionName sets the HsmPartitionName field's value.
func (s *CreateHsmConfigurationInput) SetHsmPartitionName(v string) *CreateHsmConfigurationInput {
	s.HsmPartitionName = &v
	return s
}

// SetHsmPartitionPassword sets the HsmPartitionPassword field's value.
func (s *CreateHsmConfigurationInput) SetHsmPartitionPassword(v string) *CreateHsmConfigurationInput {
	s.HsmPartitionPassword = &v
	return s
}

// SetHsmServerPublicCertificate sets the HsmServerPublicCertificate field's value.
func (s *CreateHsmConfigurationInput) SetHsmServerPublicCertificate(v string) *CreateHsmConfigurationInput {
	s.HsmServerPublicCertificate = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateHsmConfigurationInput) SetTags(v []*Tag) *CreateHsmConfigurationInput {
	s.Tags = v
	return s
}

type CreateHsmConfigurationOutput struct {
	_ struct{} `type:"structure"`

	// Returns information about an HSM configuration, which is an object that describes
	// to Amazon Redshift clusters the information they require to connect to an
	// HSM where they can store database encryption keys.
	HsmConfiguration *HsmConfiguration `type:"structure"`
}

// String returns the string representation
func (s CreateHsmConfigurationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateHsmConfigurationOutput) GoString() string {
	return s.String()
}

// SetHsmConfiguration sets the HsmConfiguration field's value.
func (s *CreateHsmConfigurationOutput) SetHsmConfiguration(v *HsmConfiguration) *CreateHsmConfigurationOutput {
	s.HsmConfiguration = v
	return s
}

type CreateScheduledActionInput struct {
	_ struct{} `type:"structure"`

	// If true, the schedule is enabled. If false, the scheduled action does not
	// trigger. For more information about state of the scheduled action, see ScheduledAction.
	Enable *bool `type:"boolean"`

	// The end time in UTC of the scheduled action. After this time, the scheduled
	// action does not trigger. For more information about this parameter, see ScheduledAction.
	EndTime *time.Time `type:"timestamp"`

	// The IAM role to assume to run the target action. For more information about
	// this parameter, see ScheduledAction.
	//
	// IamRole is a required field
	IamRole *string `type:"string" required:"true"`

	// The schedule in at( ) or cron( ) format. For more information about this
	// parameter, see ScheduledAction.
	//
	// Schedule is a required field
	Schedule *string `type:"string" required:"true"`

	// The description of the scheduled action.
	ScheduledActionDescription *string `type:"string"`

	// The name of the scheduled action. The name must be unique within an account.
	// For more information about this parameter, see ScheduledAction.
	//
	// ScheduledActionName is a required field
	ScheduledActionName *string `type:"string" required:"true"`

	// The start time in UTC of the scheduled action. Before this time, the scheduled
	// action does not trigger. For more information about this parameter, see ScheduledAction.
	StartTime *time.Time `type:"timestamp"`

	// A JSON format string of the Amazon Redshift API operation with input parameters.
	// For more information about this parameter, see ScheduledAction.
	//
	// TargetAction is a required field
	TargetAction *ScheduledActionType `type:"structure" required:"true"`
}

// String returns the string representation
func (s CreateScheduledActionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateScheduledActionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateScheduledActionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateScheduledActionInput"}
	if s.IamRole == nil {
		invalidParams.Add(request.NewErrParamRequired("IamRole"))
	}
	if s.Schedule == nil {
		invalidParams.Add(request.NewErrParamRequired("Schedule"))
	}
	if s.ScheduledActionName == nil {
		invalidParams.Add(request.NewErrParamRequired("ScheduledActionName"))
	}
	if s.TargetAction == nil {
		invalidParams.Add(request.NewErrParamRequired("TargetAction"))
	}
	if s.TargetAction != nil {
		if err := s.TargetAction.Validate(); err != nil {
			invalidParams.AddNested("TargetAction", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetEnable sets the Enable field's value.
func (s *CreateScheduledActionInput) SetEnable(v bool) *CreateScheduledActionInput {
	s.Enable = &v
	return s
}

// SetEndTime sets the EndTime field's value.
func (s *CreateScheduledActionInput) SetEndTime(v time.Time) *CreateScheduledActionInput {
	s.EndTime = &v
	return s
}

// SetIamRole sets the IamRole field's value.
func (s *CreateScheduledActionInput) SetIamRole(v string) *CreateScheduledActionInput {
	s.IamRole = &v
	return s
}

// SetSchedule sets the Schedule field's value.
func (s *CreateScheduledActionInput) SetSchedule(v string) *CreateScheduledActionInput {
	s.Schedule = &v
	return s
}

// SetScheduledActionDescription sets the ScheduledActionDescription field's value.
func (s *CreateScheduledActionInput) SetScheduledActionDescription(v string) *CreateScheduledActionInput {
	s.ScheduledActionDescription = &v
	return s
}

// SetScheduledActionName sets the ScheduledActionName field's value.
func (s *CreateScheduledActionInput) SetScheduledActionName(v string) *CreateScheduledActionInput {
	s.ScheduledActionName = &v
	return s
}

// SetStartTime sets the StartTime field's value.
func (s *CreateScheduledActionInput) SetStartTime(v time.Time) *CreateScheduledActionInput {
	s.StartTime = &v
	return s
}

// SetTargetAction sets the TargetAction field's value.
func (s *CreateScheduledActionInput) SetTargetAction(v *ScheduledActionType) *CreateScheduledActionInput {
	s.TargetAction = v
	return s
}

// Describes a scheduled action. You can use a scheduled action to trigger some
// Amazon Redshift API operations on a schedule. For information about which
// API operations can be scheduled, see ScheduledActionType.
type CreateScheduledActionOutput struct {
	_ struct{} `type:"structure"`

	// The end time in UTC when the schedule is no longer active. After this time,
	// the scheduled action does not trigger.
	EndTime *time.Time `type:"timestamp"`

	// The IAM role to assume to run the scheduled action. This IAM role must have
	// permission to run the Amazon Redshift API operation in the scheduled action.
	// This IAM role must allow the Amazon Redshift scheduler (Principal scheduler.redshift.amazonaws.com)
	// to assume permissions on your behalf. For more information about the IAM
	// role to use with the Amazon Redshift scheduler, see Using Identity-Based
	// Policies for Amazon Redshift (https://docs.aws.amazon.com/redshift/latest/mgmt/redshift-iam-access-control-identity-based.html)
	// in the Amazon Redshift Cluster Management Guide.
	IamRole *string `type:"string"`

	// List of times when the scheduled action will run.
	NextInvocations []*time.Time `locationNameList:"ScheduledActionTime" type:"list"`

	// The schedule for a one-time (at format) or recurring (cron format) scheduled
	// action. Schedule invocations must be separated by at least one hour.
	//
	// Format of at expressions is "at(yyyy-mm-ddThh:mm:ss)". For example, "at(2016-03-04T17:27:00)".
	//
	// Format of cron expressions is "cron(Minutes Hours Day-of-month Month Day-of-week
	// Year)". For example, "cron(0, 10, *, *, MON, *)". For more information, see
	// Cron Expressions (https://docs.aws.amazon.com/AmazonCloudWatch/latest/events/ScheduledEvents.html#CronExpressions)
	// in the Amazon CloudWatch Events User Guide.
	Schedule *string `type:"string"`

	// The description of the scheduled action.
	ScheduledActionDescription *string `type:"string"`

	// The name of the scheduled action.
	ScheduledActionName *string `type:"string"`

	// The start time in UTC when the schedule is active. Before this time, the
	// scheduled action does not trigger.
	StartTime *time.Time `type:"timestamp"`

	// The state of the scheduled action. For example, DISABLED.
	State *string `type:"string" enum:"ScheduledActionState"`

	// A JSON format string of the Amazon Redshift API operation with input parameters.
	//
	// "{\"ResizeCluster\":{\"NodeType\":\"ds2.8xlarge\",\"ClusterIdentifier\":\"my-test-cluster\",\"NumberOfNodes\":3}}".
	TargetAction *ScheduledActionType `type:"structure"`
}

// String returns the string representation
func (s CreateScheduledActionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateScheduledActionOutput) GoString() string {
	return s.String()
}

// SetEndTime sets the EndTime field's value.
func (s *CreateScheduledActionOutput) SetEndTime(v time.Time) *CreateScheduledActionOutput {
	s.EndTime = &v
	return s
}

// SetIamRole sets the IamRole field's value.
func (s *CreateScheduledActionOutput) SetIamRole(v string) *CreateScheduledActionOutput {
	s.IamRole = &v
	return s
}

// SetNextInvocations sets the NextInvocations field's value.
func (s *CreateScheduledActionOutput) SetNextInvocations(v []*time.Time) *CreateScheduledActionOutput {
	s.NextInvocations = v
	return s
}

// SetSchedule sets the Schedule field's value.
func (s *CreateScheduledActionOutput) SetSchedule(v string) *CreateScheduledActionOutput {
	s.Schedule = &v
	return s
}

// SetScheduledActionDescription sets the ScheduledActionDescription field's value.
func (s *CreateScheduledActionOutput) SetScheduledActionDescription(v string) *CreateScheduledActionOutput {
	s.ScheduledActionDescription = &v
	return s
}

// SetScheduledActionName sets the ScheduledActionName field's value.
func (s *CreateScheduledActionOutput) SetScheduledActionName(v string) *CreateScheduledActionOutput {
	s.ScheduledActionName = &v
	return s
}

// SetStartTime sets the StartTime field's value.
func (s *CreateScheduledActionOutput) SetStartTime(v time.Time) *CreateScheduledActionOutput {
	s.StartTime = &v
	return s
}

// SetState sets the State field's value.
func (s *CreateScheduledActionOutput) SetState(v string) *CreateScheduledActionOutput {
	s.State = &v
	return s
}

// SetTargetAction sets the TargetAction field's value.
func (s *CreateScheduledActionOutput) SetTargetAction(v *ScheduledActionType) *CreateScheduledActionOutput {
	s.TargetAction = v
	return s
}

// The result of the CreateSnapshotCopyGrant action.
type CreateSnapshotCopyGrantInput struct {
	_ struct{} `type:"structure"`

	// The unique identifier of the customer master key (CMK) to which to grant
	// Amazon Redshift permission. If no key is specified, the default key is used.
	KmsKeyId *string `type:"string"`

	// The name of the snapshot copy grant. This name must be unique in the region
	// for the AWS account.
	//
	// Constraints:
	//
	//    * Must contain from 1 to 63 alphanumeric characters or hyphens.
	//
	//    * Alphabetic characters must be lowercase.
	//
	//    * First character must be a letter.
	//
	//    * Cannot end with a hyphen or contain two consecutive hyphens.
	//
	//    * Must be unique for all clusters within an AWS account.
	//
	// SnapshotCopyGrantName is a required field
	SnapshotCopyGrantName *string `type:"string" required:"true"`

	// A list of tag instances.
	Tags []*Tag `locationNameList:"Tag" type:"list"`
}

// String returns the string representation
func (s CreateSnapshotCopyGrantInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateSnapshotCopyGrantInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateSnapshotCopyGrantInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateSnapshotCopyGrantInput"}
	if s.SnapshotCopyGrantName == nil {
		invalidParams.Add(request.NewErrParamRequired("SnapshotCopyGrantName"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetKmsKeyId sets the KmsKeyId field's value.
func (s *CreateSnapshotCopyGrantInput) SetKmsKeyId(v string) *CreateSnapshotCopyGrantInput {
	s.KmsKeyId = &v
	return s
}

// SetSnapshotCopyGrantName sets the SnapshotCopyGrantName field's value.
func (s *CreateSnapshotCopyGrantInput) SetSnapshotCopyGrantName(v string) *CreateSnapshotCopyGrantInput {
	s.SnapshotCopyGrantName = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateSnapshotCopyGrantInput) SetTags(v []*Tag) *CreateSnapshotCopyGrantInput {
	s.Tags = v
	return s
}

type CreateSnapshotCopyGrantOutput struct {
	_ struct{} `type:"structure"`

	// The snapshot copy grant that grants Amazon Redshift permission to encrypt
	// copied snapshots with the specified customer master key (CMK) from AWS KMS
	// in the destination region.
	//
	// For more information about managing snapshot copy grants, go to Amazon Redshift
	// Database Encryption (https://docs.aws.amazon.com/redshift/latest/mgmt/working-with-db-encryption.html)
	// in the Amazon Redshift Cluster Management Guide.
	SnapshotCopyGrant *SnapshotCopyGrant `type:"structure"`
}

// String returns the string representation
func (s CreateSnapshotCopyGrantOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateSnapshotCopyGrantOutput) GoString() string {
	return s.String()
}

// SetSnapshotCopyGrant sets the SnapshotCopyGrant field's value.
func (s *CreateSnapshotCopyGrantOutput) SetSnapshotCopyGrant(v *SnapshotCopyGrant) *CreateSnapshotCopyGrantOutput {
	s.SnapshotCopyGrant = v
	return s
}

type CreateSnapshotScheduleInput struct {
	_ struct{} `type:"structure"`

	DryRun *bool `type:"boolean"`

	NextInvocations *int64 `type:"integer"`

	// The definition of the snapshot schedule. The definition is made up of schedule
	// expressions, for example "cron(30 12 *)" or "rate(12 hours)".
	ScheduleDefinitions []*string `locationNameList:"ScheduleDefinition" type:"list"`

	// The description of the snapshot schedule.
	ScheduleDescription *string `type:"string"`

	// A unique identifier for a snapshot schedule. Only alphanumeric characters
	// are allowed for the identifier.
	ScheduleIdentifier *string `type:"string"`

	// An optional set of tags you can use to search for the schedule.
	Tags []*Tag `locationNameList:"Tag" type:"list"`
}

// String returns the string representation
func (s CreateSnapshotScheduleInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateSnapshotScheduleInput) GoString() string {
	return s.String()
}

// SetDryRun sets the DryRun field's value.
func (s *CreateSnapshotScheduleInput) SetDryRun(v bool) *CreateSnapshotScheduleInput {
	s.DryRun = &v
	return s
}

// SetNextInvocations sets the NextInvocations field's value.
func (s *CreateSnapshotScheduleInput) SetNextInvocations(v int64) *CreateSnapshotScheduleInput {
	s.NextInvocations = &v
	return s
}

// SetScheduleDefinitions sets the ScheduleDefinitions field's value.
func (s *CreateSnapshotScheduleInput) SetScheduleDefinitions(v []*string) *CreateSnapshotScheduleInput {
	s.ScheduleDefinitions = v
	return s
}

// SetScheduleDescription sets the ScheduleDescription field's value.
func (s *CreateSnapshotScheduleInput) SetScheduleDescription(v string) *CreateSnapshotScheduleInput {
	s.ScheduleDescription = &v
	return s
}

// SetScheduleIdentifier sets the ScheduleIdentifier field's value.
func (s *CreateSnapshotScheduleInput) SetScheduleIdentifier(v string) *CreateSnapshotScheduleInput {
	s.ScheduleIdentifier = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateSnapshotScheduleInput) SetTags(v []*Tag) *CreateSnapshotScheduleInput {
	s.Tags = v
	return s
}

// Describes a snapshot schedule. You can set a regular interval for creating
// snapshots of a cluster. You can also schedule snapshots for specific dates.
type CreateSnapshotScheduleOutput struct {
	_ struct{} `type:"structure"`

	// The number of clusters associated with the schedule.
	AssociatedClusterCount *int64 `type:"integer"`

	// A list of clusters associated with the schedule. A maximum of 100 clusters
	// is returned.
	AssociatedClusters []*ClusterAssociatedToSchedule `locationNameList:"ClusterAssociatedToSchedule" type:"list"`

	NextInvocations []*time.Time `locationNameList:"SnapshotTime" type:"list"`

	// A list of ScheduleDefinitions.
	ScheduleDefinitions []*string `locationNameList:"ScheduleDefinition" type:"list"`

	// The description of the schedule.
	ScheduleDescription *string `type:"string"`

	// A unique identifier for the schedule.
	ScheduleIdentifier *string `type:"string"`

	// An optional set of tags describing the schedule.
	Tags []*Tag `locationNameList:"Tag" type:"list"`
}

// String returns the string representation
func (s CreateSnapshotScheduleOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateSnapshotScheduleOutput) GoString() string {
	return s.String()
}

// SetAssociatedClusterCount sets the AssociatedClusterCount field's value.
func (s *CreateSnapshotScheduleOutput) SetAssociatedClusterCount(v int64) *CreateSnapshotScheduleOutput {
	s.AssociatedClusterCount = &v
	return s
}

// SetAssociatedClusters sets the AssociatedClusters field's value.
func (s *CreateSnapshotScheduleOutput) SetAssociatedClusters(v []*ClusterAssociatedToSchedule) *CreateSnapshotScheduleOutput {
	s.AssociatedClusters = v
	return s
}

// SetNextInvocations sets the NextInvocations field's value.
func (s *CreateSnapshotScheduleOutput) SetNextInvocations(v []*time.Time) *CreateSnapshotScheduleOutput {
	s.NextInvocations = v
	return s
}

// SetScheduleDefinitions sets the ScheduleDefinitions field's value.
func (s *CreateSnapshotScheduleOutput) SetScheduleDefinitions(v []*string) *CreateSnapshotScheduleOutput {
	s.ScheduleDefinitions = v
	return s
}

// SetScheduleDescription sets the ScheduleDescription field's value.
func (s *CreateSnapshotScheduleOutput) SetScheduleDescription(v string) *CreateSnapshotScheduleOutput {
	s.ScheduleDescription = &v
	return s
}

// SetScheduleIdentifier sets the ScheduleIdentifier field's value.
func (s *CreateSnapshotScheduleOutput) SetScheduleIdentifier(v string) *CreateSnapshotScheduleOutput {
	s.ScheduleIdentifier = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateSnapshotScheduleOutput) SetTags(v []*Tag) *CreateSnapshotScheduleOutput {
	s.Tags = v
	return s
}

// Contains the output from the CreateTags action.
type CreateTagsInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) to which you want to add the tag or tags.
	// For example, arn:aws:redshift:us-east-2:123456789:cluster:t1.
	//
	// ResourceName is a required field
	ResourceName *string `type:"string" required:"true"`

	// One or more name/value pairs to add as tags to the specified resource. Each
	// tag name is passed in with the parameter Key and the corresponding value
	// is passed in with the parameter Value. The Key and Value parameters are separated
	// by a comma (,). Separate multiple tags with a space. For example, --tags
	// "Key"="owner","Value"="admin" "Key"="environment","Value"="test" "Key"="version","Value"="1.0".
	//
	// Tags is a required field
	Tags []*Tag `locationNameList:"Tag" type:"list" required:"true"`
}

// String returns the string representation
func (s CreateTagsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateTagsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateTagsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateTagsInput"}
	if s.ResourceName == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceName"))
	}
	if s.Tags == nil {
		invalidParams.Add(request.NewErrParamRequired("Tags"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceName sets the ResourceName field's value.
func (s *CreateTagsInput) SetResourceName(v string) *CreateTagsInput {
	s.ResourceName = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateTagsInput) SetTags(v []*Tag) *CreateTagsInput {
	s.Tags = v
	return s
}

type CreateTagsOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s CreateTagsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateTagsOutput) GoString() string {
	return s.String()
}

// Describes the status of a cluster while it is in the process of resizing
// with an incremental resize.
type DataTransferProgress struct {
	_ struct{} `type:"structure"`

	// Describes the data transfer rate in MB's per second.
	CurrentRateInMegaBytesPerSecond *float64 `type:"double"`

	// Describes the total amount of data that has been transfered in MB's.
	DataTransferredInMegaBytes *int64 `type:"long"`

	// Describes the number of seconds that have elapsed during the data transfer.
	ElapsedTimeInSeconds *int64 `type:"long"`

	// Describes the estimated number of seconds remaining to complete the transfer.
	EstimatedTimeToCompletionInSeconds *int64 `type:"long"`

	// Describes the status of the cluster. While the transfer is in progress the
	// status is transferringdata.
	Status *string `type:"string"`

	// Describes the total amount of data to be transfered in megabytes.
	TotalDataInMegaBytes *int64 `type:"long"`
}

// String returns the string representation
func (s DataTransferProgress) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DataTransferProgress) GoString() string {
	return s.String()
}

// SetCurrentRateInMegaBytesPerSecond sets the CurrentRateInMegaBytesPerSecond field's value.
func (s *DataTransferProgress) SetCurrentRateInMegaBytesPerSecond(v float64) *DataTransferProgress {
	s.CurrentRateInMegaBytesPerSecond = &v
	return s
}

// SetDataTransferredInMegaBytes sets the DataTransferredInMegaBytes field's value.
func (s *DataTransferProgress) SetDataTransferredInMegaBytes(v int64) *DataTransferProgress {
	s.DataTransferredInMegaBytes = &v
	return s
}

// SetElapsedTimeInSeconds sets the ElapsedTimeInSeconds field's value.
func (s *DataTransferProgress) SetElapsedTimeInSeconds(v int64) *DataTransferProgress {
	s.ElapsedTimeInSeconds = &v
	return s
}

// SetEstimatedTimeToCompletionInSeconds sets the EstimatedTimeToCompletionInSeconds field's value.
func (s *DataTransferProgress) SetEstimatedTimeToCompletionInSeconds(v int64) *DataTransferProgress {
	s.EstimatedTimeToCompletionInSeconds = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *DataTransferProgress) SetStatus(v string) *DataTransferProgress {
	s.Status = &v
	return s
}

// SetTotalDataInMegaBytes sets the TotalDataInMegaBytes field's value.
func (s *DataTransferProgress) SetTotalDataInMegaBytes(v int64) *DataTransferProgress {
	s.TotalDataInMegaBytes = &v
	return s
}

// Describes the default cluster parameters for a parameter group family.
type DefaultClusterParameters struct {
	_ struct{} `type:"structure"`

	// A value that indicates the starting point for the next set of response records
	// in a subsequent request. If a value is returned in a response, you can retrieve
	// the next set of records by providing this returned marker value in the Marker
	// parameter and retrying the command. If the Marker field is empty, all response
	// records have been retrieved for the request.
	Marker *string `type:"string"`

	// The name of the cluster parameter group family to which the engine default
	// parameters apply.
	ParameterGroupFamily *string `type:"string"`

	// The list of cluster default parameters.
	Parameters []*Parameter `locationNameList:"Parameter" type:"list"`
}

// String returns the string representation
func (s DefaultClusterParameters) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DefaultClusterParameters) GoString() string {
	return s.String()
}

// SetMarker sets the Marker field's value.
func (s *DefaultClusterParameters) SetMarker(v string) *DefaultClusterParameters {
	s.Marker = &v
	return s
}

// SetParameterGroupFamily sets the ParameterGroupFamily field's value.
func (s *DefaultClusterParameters) SetParameterGroupFamily(v string) *DefaultClusterParameters {
	s.ParameterGroupFamily = &v
	return s
}

// SetParameters sets the Parameters field's value.
func (s *DefaultClusterParameters) SetParameters(v []*Parameter) *DefaultClusterParameters {
	s.Parameters = v
	return s
}

// Describes a deferred maintenance window
type DeferredMaintenanceWindow struct {
	_ struct{} `type:"structure"`

	// A timestamp for the end of the time period when we defer maintenance.
	DeferMaintenanceEndTime *time.Time `type:"timestamp"`

	// A unique identifier for the maintenance window.
	DeferMaintenanceIdentifier *string `type:"string"`

	// A timestamp for the beginning of the time period when we defer maintenance.
	DeferMaintenanceStartTime *time.Time `type:"timestamp"`
}

// String returns the string representation
func (s DeferredMaintenanceWindow) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeferredMaintenanceWindow) GoString() string {
	return s.String()
}

// SetDeferMaintenanceEndTime sets the DeferMaintenanceEndTime field's value.
func (s *DeferredMaintenanceWindow) SetDeferMaintenanceEndTime(v time.Time) *DeferredMaintenanceWindow {
	s.DeferMaintenanceEndTime = &v
	return s
}

// SetDeferMaintenanceIdentifier sets the DeferMaintenanceIdentifier field's value.
func (s *DeferredMaintenanceWindow) SetDeferMaintenanceIdentifier(v string) *DeferredMaintenanceWindow {
	s.DeferMaintenanceIdentifier = &v
	return s
}

// SetDeferMaintenanceStartTime sets the DeferMaintenanceStartTime field's value.
func (s *DeferredMaintenanceWindow) SetDeferMaintenanceStartTime(v time.Time) *DeferredMaintenanceWindow {
	s.DeferMaintenanceStartTime = &v
	return s
}

type DeleteClusterInput struct {
	_ struct{} `type:"structure"`

	// The identifier of the cluster to be deleted.
	//
	// Constraints:
	//
	//    * Must contain lowercase characters.
	//
	//    * Must contain from 1 to 63 alphanumeric characters or hyphens.
	//
	//    * First character must be a letter.
	//
	//    * Cannot end with a hyphen or contain two consecutive hyphens.
	//
	// ClusterIdentifier is a required field
	ClusterIdentifier *string `type:"string" required:"true"`

	// The identifier of the final snapshot that is to be created immediately before
	// deleting the cluster. If this parameter is provided, SkipFinalClusterSnapshot
	// must be false.
	//
	// Constraints:
	//
	//    * Must be 1 to 255 alphanumeric characters.
	//
	//    * First character must be a letter.
	//
	//    * Cannot end with a hyphen or contain two consecutive hyphens.
	FinalClusterSnapshotIdentifier *string `type:"string"`

	// The number of days that a manual snapshot is retained. If the value is -1,
	// the manual snapshot is retained indefinitely.
	//
	// The value must be either -1 or an integer between 1 and 3,653.
	//
	// The default value is -1.
	FinalClusterSnapshotRetentionPeriod *int64 `type:"integer"`

	// Determines whether a final snapshot of the cluster is created before Amazon
	// Redshift deletes the cluster. If true, a final cluster snapshot is not created.
	// If false, a final cluster snapshot is created before the cluster is deleted.
	//
	// The FinalClusterSnapshotIdentifier parameter must be specified if SkipFinalClusterSnapshot
	// is false.
	//
	// Default: false
	SkipFinalClusterSnapshot *bool `type:"boolean"`
}

// String returns the string representation
func (s DeleteClusterInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteClusterInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteClusterInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteClusterInput"}
	if s.ClusterIdentifier == nil {
		invalidParams.Add(request.NewErrParamRequired("ClusterIdentifier"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClusterIdentifier sets the ClusterIdentifier field's value.
func (s *DeleteClusterInput) SetClusterIdentifier(v string) *DeleteClusterInput {
	s.ClusterIdentifier = &v
	return s
}

// SetFinalClusterSnapshotIdentifier sets the FinalClusterSnapshotIdentifier field's value.
func (s *DeleteClusterInput) SetFinalClusterSnapshotIdentifier(v string) *DeleteClusterInput {
	s.FinalClusterSnapshotIdentifier = &v
	return s
}

// SetFinalClusterSnapshotRetentionPeriod sets the FinalClusterSnapshotRetentionPeriod field's value.
func (s *DeleteClusterInput) SetFinalClusterSnapshotRetentionPeriod(v int64) *DeleteClusterInput {
	s.FinalClusterSnapshotRetentionPeriod = &v
	return s
}

// SetSkipFinalClusterSnapshot sets the SkipFinalClusterSnapshot field's value.
func (s *DeleteClusterInput) SetSkipFinalClusterSnapshot(v bool) *DeleteClusterInput {
	s.SkipFinalClusterSnapshot = &v
	return s
}

type DeleteClusterOutput struct {
	_ struct{} `type:"structure"`

	// Describes a cluster.
	Cluster *Cluster `type:"structure"`
}

// String returns the string representation
func (s DeleteClusterOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteClusterOutput) GoString() string {
	return s.String()
}

// SetCluster sets the Cluster field's value.
func (s *DeleteClusterOutput) SetCluster(v *Cluster) *DeleteClusterOutput {
	s.Cluster = v
	return s
}

type DeleteClusterParameterGroupInput struct {
	_ struct{} `type:"structure"`

	// The name of the parameter group to be deleted.
	//
	// Constraints:
	//
	//    * Must be the name of an existing cluster parameter group.
	//
	//    * Cannot delete a default cluster parameter group.
	//
	// ParameterGroupName is a required field
	ParameterGroupName *string `type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteClusterParameterGroupInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteClusterParameterGroupInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteClusterParameterGroupInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteClusterParameterGroupInput"}
	if s.ParameterGroupName == nil {
		invalidParams.Add(request.NewErrParamRequired("ParameterGroupName"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetParameterGroupName sets the ParameterGroupName field's value.
func (s *DeleteClusterParameterGroupInput) SetParameterGroupName(v string) *DeleteClusterParameterGroupInput {
	s.ParameterGroupName = &v
	return s
}

type DeleteClusterParameterGroupOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteClusterParameterGroupOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteClusterParameterGroupOutput) GoString() string {
	return s.String()
}

type DeleteClusterSecurityGroupInput struct {
	_ struct{} `type:"structure"`

	// The name of the cluster security group to be deleted.
	//
	// ClusterSecurityGroupName is a required field
	ClusterSecurityGroupName *string `type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteClusterSecurityGroupInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteClusterSecurityGroupInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteClusterSecurityGroupInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteClusterSecurityGroupInput"}
	if s.ClusterSecurityGroupName == nil {
		invalidParams.Add(request.NewErrParamRequired("ClusterSecurityGroupName"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClusterSecurityGroupName sets the ClusterSecurityGroupName field's value.
func (s *DeleteClusterSecurityGroupInput) SetClusterSecurityGroupName(v string) *DeleteClusterSecurityGroupInput {
	s.ClusterSecurityGroupName = &v
	return s
}

type DeleteClusterSecurityGroupOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteClusterSecurityGroupOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteClusterSecurityGroupOutput) GoString() string {
	return s.String()
}

type DeleteClusterSnapshotInput struct {
	_ struct{} `type:"structure"`

	// The unique identifier of the cluster the snapshot was created from. This
	// parameter is required if your IAM user has a policy containing a snapshot
	// resource element that specifies anything other than * for the cluster name.
	//
	// Constraints: Must be the name of valid cluster.
	SnapshotClusterIdentifier *string `type:"string"`

	// The unique identifier of the manual snapshot to be deleted.
	//
	// Constraints: Must be the name of an existing snapshot that is in the available,
	// failed, or cancelled state.
	//
	// SnapshotIdentifier is a required field
	SnapshotIdentifier *string `type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteClusterSnapshotInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteClusterSnapshotInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteClusterSnapshotInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteClusterSnapshotInput"}
	if s.SnapshotIdentifier == nil {
		invalidParams.Add(request.NewErrParamRequired("SnapshotIdentifier"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetSnapshotClusterIdentifier sets the SnapshotClusterIdentifier field's value.
func (s *DeleteClusterSnapshotInput) SetSnapshotClusterIdentifier(v string) *DeleteClusterSnapshotInput {
	s.SnapshotClusterIdentifier = &v
	return s
}

// SetSnapshotIdentifier sets the SnapshotIdentifier field's value.
func (s *DeleteClusterSnapshotInput) SetSnapshotIdentifier(v string) *DeleteClusterSnapshotInput {
	s.SnapshotIdentifier = &v
	return s
}

type DeleteClusterSnapshotMessage struct {
	_ struct{} `type:"structure"`

	// The unique identifier of the cluster the snapshot was created from. This
	// parameter is required if your IAM user has a policy containing a snapshot
	// resource element that specifies anything other than * for the cluster name.
	//
	// Constraints: Must be the name of valid cluster.
	SnapshotClusterIdentifier *string `type:"string"`

	// The unique identifier of the manual snapshot to be deleted.
	//
	// Constraints: Must be the name of an existing snapshot that is in the available,
	// failed, or cancelled state.
	//
	// SnapshotIdentifier is a required field
	SnapshotIdentifier *string `type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteClusterSnapshotMessage) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteClusterSnapshotMessage) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteClusterSnapshotMessage) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteClusterSnapshotMessage"}
	if s.SnapshotIdentifier == nil {
		invalidParams.Add(request.NewErrParamRequired("SnapshotIdentifier"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetSnapshotClusterIdentifier sets the SnapshotClusterIdentifier field's value.
func (s *DeleteClusterSnapshotMessage) SetSnapshotClusterIdentifier(v string) *DeleteClusterSnapshotMessage {
	s.SnapshotClusterIdentifier = &v
	return s
}

// SetSnapshotIdentifier sets the SnapshotIdentifier field's value.
func (s *DeleteClusterSnapshotMessage) SetSnapshotIdentifier(v string) *DeleteClusterSnapshotMessage {
	s.SnapshotIdentifier = &v
	return s
}

type DeleteClusterSnapshotOutput struct {
	_ struct{} `type:"structure"`

	// Describes a snapshot.
	Snapshot *Snapshot `type:"structure"`
}

// String returns the string representation
func (s DeleteClusterSnapshotOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteClusterSnapshotOutput) GoString() string {
	return s.String()
}

// SetSnapshot sets the Snapshot field's value.
func (s *DeleteClusterSnapshotOutput) SetSnapshot(v *Snapshot) *DeleteClusterSnapshotOutput {
	s.Snapshot = v
	return s
}

type DeleteClusterSubnetGroupInput struct {
	_ struct{} `type:"structure"`

	// The name of the cluster subnet group name to be deleted.
	//
	// ClusterSubnetGroupName is a required field
	ClusterSubnetGroupName *string `type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteClusterSubnetGroupInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteClusterSubnetGroupInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteClusterSubnetGroupInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteClusterSubnetGroupInput"}
	if s.ClusterSubnetGroupName == nil {
		invalidParams.Add(request.NewErrParamRequired("ClusterSubnetGroupName"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClusterSubnetGroupName sets the ClusterSubnetGroupName field's value.
func (s *DeleteClusterSubnetGroupInput) SetClusterSubnetGroupName(v string) *DeleteClusterSubnetGroupInput {
	s.ClusterSubnetGroupName = &v
	return s
}

type DeleteClusterSubnetGroupOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteClusterSubnetGroupOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteClusterSubnetGroupOutput) GoString() string {
	return s.String()
}

type DeleteEventSubscriptionInput struct {
	_ struct{} `type:"structure"`

	// The name of the Amazon Redshift event notification subscription to be deleted.
	//
	// SubscriptionName is a required field
	SubscriptionName *string `type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteEventSubscriptionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteEventSubscriptionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteEventSubscriptionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteEventSubscriptionInput"}
	if s.SubscriptionName == nil {
		invalidParams.Add(request.NewErrParamRequired("SubscriptionName"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetSubscriptionName sets the SubscriptionName field's value.
func (s *DeleteEventSubscriptionInput) SetSubscriptionName(v string) *DeleteEventSubscriptionInput {
	s.SubscriptionName = &v
	return s
}

type DeleteEventSubscriptionOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteEventSubscriptionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteEventSubscriptionOutput) GoString() string {
	return s.String()
}

type DeleteHsmClientCertificateInput struct {
	_ struct{} `type:"structure"`

	// The identifier of the HSM client certificate to be deleted.
	//
	// HsmClientCertificateIdentifier is a required field
	HsmClientCertificateIdentifier *string `type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteHsmClientCertificateInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteHsmClientCertificateInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteHsmClientCertificateInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteHsmClientCertificateInput"}
	if s.HsmClientCertificateIdentifier == nil {
		invalidParams.Add(request.NewErrParamRequired("HsmClientCertificateIdentifier"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetHsmClientCertificateIdentifier sets the HsmClientCertificateIdentifier field's value.
func (s *DeleteHsmClientCertificateInput) SetHsmClientCertificateIdentifier(v string) *DeleteHsmClientCertificateInput {
	s.HsmClientCertificateIdentifier = &v
	return s
}

type DeleteHsmClientCertificateOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteHsmClientCertificateOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteHsmClientCertificateOutput) GoString() string {
	return s.String()
}

type DeleteHsmConfigurationInput struct {
	_ struct{} `type:"structure"`

	// The identifier of the Amazon Redshift HSM configuration to be deleted.
	//
	// HsmConfigurationIdentifier is a required field
	HsmConfigurationIdentifier *string `type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteHsmConfigurationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteHsmConfigurationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteHsmConfigurationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteHsmConfigurationInput"}
	if s.HsmConfigurationIdentifier == nil {
		invalidParams.Add(request.NewErrParamRequired("HsmConfigurationIdentifier"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetHsmConfigurationIdentifier sets the HsmConfigurationIdentifier field's value.
func (s *DeleteHsmConfigurationInput) SetHsmConfigurationIdentifier(v string) *DeleteHsmConfigurationInput {
	s.HsmConfigurationIdentifier = &v
	return s
}

type DeleteHsmConfigurationOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteHsmConfigurationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteHsmConfigurationOutput) GoString() string {
	return s.String()
}

type DeleteScheduledActionInput struct {
	_ struct{} `type:"structure"`

	// The name of the scheduled action to delete.
	//
	// ScheduledActionName is a required field
	ScheduledActionName *string `type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteScheduledActionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteScheduledActionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteScheduledActionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteScheduledActionInput"}
	if s.ScheduledActionName == nil {
		invalidParams.Add(request.NewErrParamRequired("ScheduledActionName"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetScheduledActionName sets the ScheduledActionName field's value.
func (s *DeleteScheduledActionInput) SetScheduledActionName(v string) *DeleteScheduledActionInput {
	s.ScheduledActionName = &v
	return s
}

type DeleteScheduledActionOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteScheduledActionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteScheduledActionOutput) GoString() string {
	return s.String()
}

// The result of the DeleteSnapshotCopyGrant action.
type DeleteSnapshotCopyGrantInput struct {
	_ struct{} `type:"structure"`

	// The name of the snapshot copy grant to delete.
	//
	// SnapshotCopyGrantName is a required field
	SnapshotCopyGrantName *string `type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteSnapshotCopyGrantInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteSnapshotCopyGrantInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteSnapshotCopyGrantInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteSnapshotCopyGrantInput"}
	if s.SnapshotCopyGrantName == nil {
		invalidParams.Add(request.NewErrParamRequired("SnapshotCopyGrantName"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetSnapshotCopyGrantName sets the SnapshotCopyGrantName field's value.
func (s *DeleteSnapshotCopyGrantInput) SetSnapshotCopyGrantName(v string) *DeleteSnapshotCopyGrantInput {
	s.SnapshotCopyGrantName = &v
	return s
}

type DeleteSnapshotCopyGrantOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteSnapshotCopyGrantOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteSnapshotCopyGrantOutput) GoString() string {
	return s.String()
}

type DeleteSnapshotScheduleInput struct {
	_ struct{} `type:"structure"`

	// A unique identifier of the snapshot schedule to delete.
	//
	// ScheduleIdentifier is a required field
	ScheduleIdentifier *string `type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteSnapshotScheduleInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteSnapshotScheduleInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteSnapshotScheduleInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteSnapshotScheduleInput"}
	if s.ScheduleIdentifier == nil {
		invalidParams.Add(request.NewErrParamRequired("ScheduleIdentifier"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetScheduleIdentifier sets the ScheduleIdentifier field's value.
func (s *DeleteSnapshotScheduleInput) SetScheduleIdentifier(v string) *DeleteSnapshotScheduleInput {
	s.ScheduleIdentifier = &v
	return s
}

type DeleteSnapshotScheduleOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteSnapshotScheduleOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteSnapshotScheduleOutput) GoString() string {
	return s.String()
}

// Contains the output from the DeleteTags action.
type DeleteTagsInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) from which you want to remove the tag or tags.
	// For example, arn:aws:redshift:us-east-2:123456789:cluster:t1.
	//
	// ResourceName is a required field
	ResourceName *string `type:"string" required:"true"`

	// The tag key that you want to delete.
	//
	// TagKeys is a required field
	TagKeys []*string `locationNameList:"TagKey" type:"list" required:"true"`
}

// String returns the string representation
func (s DeleteTagsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteTagsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteTagsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteTagsInput"}
	if s.ResourceName == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceName"))
	}
	if s.TagKeys == nil {
		invalidParams.Add(request.NewErrParamRequired("TagKeys"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceName sets the ResourceName field's value.
func (s *DeleteTagsInput) SetResourceName(v string) *DeleteTagsInput {
	s.ResourceName = &v
	return s
}

// SetTagKeys sets the TagKeys field's value.
func (s *DeleteTagsInput) SetTagKeys(v []*string) *DeleteTagsInput {
	s.TagKeys = v
	return s
}

type DeleteTagsOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteTagsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteTagsOutput) GoString() string {
	return s.String()
}

type DescribeAccountAttributesInput struct {
	_ struct{} `type:"structure"`

	// A list of attribute names.
	AttributeNames []*string `locationNameList:"AttributeName" type:"list"`
}

// String returns the string representation
func (s DescribeAccountAttributesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeAccountAttributesInput) GoString() string {
	return s.String()
}

// SetAttributeNames sets the AttributeNames field's value.
func (s *DescribeAccountAttributesInput) SetAttributeNames(v []*string) *DescribeAccountAttributesInput {
	s.AttributeNames = v
	return s
}

type DescribeAccountAttributesOutput struct {
	_ struct{} `type:"structure"`

	// A list of attributes assigned to an account.
	AccountAttributes []*AccountAttribute `locationNameList:"AccountAttribute" type:"list"`
}

// String returns the string representation
func (s DescribeAccountAttributesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeAccountAttributesOutput) GoString() string {
	return s.String()
}

// SetAccountAttributes sets the AccountAttributes field's value.
func (s *DescribeAccountAttributesOutput) SetAccountAttributes(v []*AccountAttribute) *DescribeAccountAttributesOutput {
	s.AccountAttributes = v
	return s
}

type DescribeClusterDbRevisionsInput struct {
	_ struct{} `type:"structure"`

	// A unique identifier for a cluster whose ClusterDbRevisions you are requesting.
	// This parameter is case sensitive. All clusters defined for an account are
	// returned by default.
	ClusterIdentifier *string `type:"string"`

	// An optional parameter that specifies the starting point for returning a set
	// of response records. When the results of a DescribeClusterDbRevisions request
	// exceed the value specified in MaxRecords, Amazon Redshift returns a value
	// in the marker field of the response. You can retrieve the next set of response
	// records by providing the returned marker value in the marker parameter and
	// retrying the request.
	//
	// Constraints: You can specify either the ClusterIdentifier parameter, or the
	// marker parameter, but not both.
	Marker *string `type:"string"`

	// The maximum number of response records to return in each call. If the number
	// of remaining response records exceeds the specified MaxRecords value, a value
	// is returned in the marker field of the response. You can retrieve the next
	// set of response records by providing the returned marker value in the marker
	// parameter and retrying the request.
	//
	// Default: 100
	//
	// Constraints: minimum 20, maximum 100.
	MaxRecords *int64 `type:"integer"`
}

// String returns the string representation
func (s DescribeClusterDbRevisionsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeClusterDbRevisionsInput) GoString() string {
	return s.String()
}

// SetClusterIdentifier sets the ClusterIdentifier field's value.
func (s *DescribeClusterDbRevisionsInput) SetClusterIdentifier(v string) *DescribeClusterDbRevisionsInput {
	s.ClusterIdentifier = &v
	return s
}

// SetMarker sets the Marker field's value.
func (s *DescribeClusterDbRevisionsInput) SetMarker(v string) *DescribeClusterDbRevisionsInput {
	s.Marker = &v
	return s
}

// SetMaxRecords sets the MaxRecords field's value.
func (s *DescribeClusterDbRevisionsInput) SetMaxRecords(v int64) *DescribeClusterDbRevisionsInput {
	s.MaxRecords = &v
	return s
}

type DescribeClusterDbRevisionsOutput struct {
	_ struct{} `type:"structure"`

	// A list of revisions.
	ClusterDbRevisions []*ClusterDbRevision `locationNameList:"ClusterDbRevision" type:"list"`

	// A string representing the starting point for the next set of revisions. If
	// a value is returned in a response, you can retrieve the next set of revisions
	// by providing the value in the marker parameter and retrying the command.
	// If the marker field is empty, all revisions have already been returned.
	Marker *string `type:"string"`
}

// String returns the string representation
func (s DescribeClusterDbRevisionsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeClusterDbRevisionsOutput) GoString() string {
	return s.String()
}

// SetClusterDbRevisions sets the ClusterDbRevisions field's value.
func (s *DescribeClusterDbRevisionsOutput) SetClusterDbRevisions(v []*ClusterDbRevision) *DescribeClusterDbRevisionsOutput {
	s.ClusterDbRevisions = v
	return s
}

// SetMarker sets the Marker field's value.
func (s *DescribeClusterDbRevisionsOutput) SetMarker(v string) *DescribeClusterDbRevisionsOutput {
	s.Marker = &v
	return s
}

type DescribeClusterParameterGroupsInput struct {
	_ struct{} `type:"structure"`

	// An optional parameter that specifies the starting point to return a set of
	// response records. When the results of a DescribeClusterParameterGroups request
	// exceed the value specified in MaxRecords, AWS returns a value in the Marker
	// field of the response. You can retrieve the next set of response records
	// by providing the returned marker value in the Marker parameter and retrying
	// the request.
	Marker *string `type:"string"`

	// The maximum number of response records to return in each call. If the number
	// of remaining response records exceeds the specified MaxRecords value, a value
	// is returned in a marker field of the response. You can retrieve the next
	// set of records by retrying the command with the returned marker value.
	//
	// Default: 100
	//
	// Constraints: minimum 20, maximum 100.
	MaxRecords *int64 `type:"integer"`

	// The name of a specific parameter group for which to return details. By default,
	// details about all parameter groups and the default parameter group are returned.
	ParameterGroupName *string `type:"string"`

	// A tag key or keys for which you want to return all matching cluster parameter
	// groups that are associated with the specified key or keys. For example, suppose
	// that you have parameter groups that are tagged with keys called owner and
	// environment. If you specify both of these tag keys in the request, Amazon
	// Redshift returns a response with the parameter groups that have either or
	// both of these tag keys associated with them.
	TagKeys []*string `locationNameList:"TagKey" type:"list"`

	// A tag value or values for which you want to return all matching cluster parameter
	// groups that are associated with the specified tag value or values. For example,
	// suppose that you have parameter groups that are tagged with values called
	// admin and test. If you specify both of these tag values in the request, Amazon
	// Redshift returns a response with the parameter groups that have either or
	// both of these tag values associated with them.
	TagValues []*string `locationNameList:"TagValue" type:"list"`
}

// String returns the string representation
func (s DescribeClusterParameterGroupsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeClusterParameterGroupsInput) GoString() string {
	return s.String()
}

// SetMarker sets the Marker field's value.
func (s *DescribeClusterParameterGroupsInput) SetMarker(v string) *DescribeClusterParameterGroupsInput {
	s.Marker = &v
	return s
}

// SetMaxRecords sets the MaxRecords field's value.
func (s *DescribeClusterParameterGroupsInput) SetMaxRecords(v int64) *DescribeClusterParameterGroupsInput {
	s.MaxRecords = &v
	return s
}

// SetParameterGroupName sets the ParameterGroupName field's value.
func (s *DescribeClusterParameterGroupsInput) SetParameterGroupName(v string) *DescribeClusterParameterGroupsInput {
	s.ParameterGroupName = &v
	return s
}

// SetTagKeys sets the TagKeys field's value.
func (s *DescribeClusterParameterGroupsInput) SetTagKeys(v []*string) *DescribeClusterParameterGroupsInput {
	s.TagKeys = v
	return s
}

// SetTagValues sets the TagValues field's value.
func (s *DescribeClusterParameterGroupsInput) SetTagValues(v []*string) *DescribeClusterParameterGroupsInput {
	s.TagValues = v
	return s
}

// Contains the output from the DescribeClusterParameterGroups action.
type DescribeClusterParameterGroupsOutput struct {
	_ struct{} `type:"structure"`

	// A value that indicates the starting point for the next set of response records
	// in a subsequent request. If a value is returned in a response, you can retrieve
	// the next set of records by providing this returned marker value in the Marker
	// parameter and retrying the command. If the Marker field is empty, all response
	// records have been retrieved for the request.
	Marker *string `type:"string"`

	// A list of ClusterParameterGroup instances. Each instance describes one cluster
	// parameter group.
	ParameterGroups []*ClusterParameterGroup `locationNameList:"ClusterParameterGroup" type:"list"`
}

// String returns the string representation
func (s DescribeClusterParameterGroupsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeClusterParameterGroupsOutput) GoString() string {
	return s.String()
}

// SetMarker sets the Marker field's value.
func (s *DescribeClusterParameterGroupsOutput) SetMarker(v string) *DescribeClusterParameterGroupsOutput {
	s.Marker = &v
	return s
}

// SetParameterGroups sets the ParameterGroups field's value.
func (s *DescribeClusterParameterGroupsOutput) SetParameterGroups(v []*ClusterParameterGroup) *DescribeClusterParameterGroupsOutput {
	s.ParameterGroups = v
	return s
}

type DescribeClusterParametersInput struct {
	_ struct{} `type:"structure"`

	// An optional parameter that specifies the starting point to return a set of
	// response records. When the results of a DescribeClusterParameters request
	// exceed the value specified in MaxRecords, AWS returns a value in the Marker
	// field of the response. You can retrieve the next set of response records
	// by providing the returned marker value in the Marker parameter and retrying
	// the request.
	Marker *string `type:"string"`

	// The maximum number of response records to return in each call. If the number
	// of remaining response records exceeds the specified MaxRecords value, a value
	// is returned in a marker field of the response. You can retrieve the next
	// set of records by retrying the command with the returned marker value.
	//
	// Default: 100
	//
	// Constraints: minimum 20, maximum 100.
	MaxRecords *int64 `type:"integer"`

	// The name of a cluster parameter group for which to return details.
	//
	// ParameterGroupName is a required field
	ParameterGroupName *string `type:"string" required:"true"`

	// The parameter types to return. Specify user to show parameters that are different
	// form the default. Similarly, specify engine-default to show parameters that
	// are the same as the default parameter group.
	//
	// Default: All parameter types returned.
	//
	// Valid Values: user | engine-default
	Source *string `type:"string"`
}

// String returns the string representation
func (s DescribeClusterParametersInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeClusterParametersInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeClusterParametersInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeClusterParametersInput"}
	if s.ParameterGroupName == nil {
		invalidParams.Add(request.NewErrParamRequired("ParameterGroupName"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMarker sets the Marker field's value.
func (s *DescribeClusterParametersInput) SetMarker(v string) *DescribeClusterParametersInput {
	s.Marker = &v
	return s
}

// SetMaxRecords sets the MaxRecords field's value.
func (s *DescribeClusterParametersInput) SetMaxRecords(v int64) *DescribeClusterParametersInput {
	s.MaxRecords = &v
	return s
}

// SetParameterGroupName sets the ParameterGroupName field's value.
func (s *DescribeClusterParametersInput) SetParameterGroupName(v string) *DescribeClusterParametersInput {
	s.ParameterGroupName = &v
	return s
}

// SetSource sets the Source field's value.
func (s *DescribeClusterParametersInput) SetSource(v string) *DescribeClusterParametersInput {
	s.Source = &v
	return s
}

// Contains the output from the DescribeClusterParameters action.
type DescribeClusterParametersOutput struct {
	_ struct{} `type:"structure"`

	// A value that indicates the starting point for the next set of response records
	// in a subsequent request. If a value is returned in a response, you can retrieve
	// the next set of records by providing this returned marker value in the Marker
	// parameter and retrying the command. If the Marker field is empty, all response
	// records have been retrieved for the request.
	Marker *string `type:"string"`

	// A list of Parameter instances. Each instance lists the parameters of one
	// cluster parameter group.
	Parameters []*Parameter `locationNameList:"Parameter" type:"list"`
}

// String returns the string representation
func (s DescribeClusterParametersOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeClusterParametersOutput) GoString() string {
	return s.String()
}

// SetMarker sets the Marker field's value.
func (s *DescribeClusterParametersOutput) SetMarker(v string) *DescribeClusterParametersOutput {
	s.Marker = &v
	return s
}

// SetParameters sets the Parameters field's value.
func (s *DescribeClusterParametersOutput) SetParameters(v []*Parameter) *DescribeClusterParametersOutput {
	s.Parameters = v
	return s
}

type DescribeClusterSecurityGroupsInput struct {
	_ struct{} `type:"structure"`

	// The name of a cluster security group for which you are requesting details.
	// You can specify either the Marker parameter or a ClusterSecurityGroupName
	// parameter, but not both.
	//
	// Example: securitygroup1
	ClusterSecurityGroupName *string `type:"string"`

	// An optional parameter that specifies the starting point to return a set of
	// response records. When the results of a DescribeClusterSecurityGroups request
	// exceed the value specified in MaxRecords, AWS returns a value in the Marker
	// field of the response. You can retrieve the next set of response records
	// by providing the returned marker value in the Marker parameter and retrying
	// the request.
	//
	// Constraints: You can specify either the ClusterSecurityGroupName parameter
	// or the Marker parameter, but not both.
	Marker *string `type:"string"`

	// The maximum number of response records to return in each call. If the number
	// of remaining response records exceeds the specified MaxRecords value, a value
	// is returned in a marker field of the response. You can retrieve the next
	// set of records by retrying the command with the returned marker value.
	//
	// Default: 100
	//
	// Constraints: minimum 20, maximum 100.
	MaxRecords *int64 `type:"integer"`

	// A tag key or keys for which you want to return all matching cluster security
	// groups that are associated with the specified key or keys. For example, suppose
	// that you have security groups that are tagged with keys called owner and
	// environment. If you specify both of these tag keys in the request, Amazon
	// Redshift returns a response with the security groups that have either or
	// both of these tag keys associated with them.
	TagKeys []*string `locationNameList:"TagKey" type:"list"`

	// A tag value or values for which you want to return all matching cluster security
	// groups that are associated with the specified tag value or values. For example,
	// suppose that you have security groups that are tagged with values called
	// admin and test. If you specify both of these tag values in the request, Amazon
	// Redshift returns a response with the security groups that have either or
	// both of these tag values associated with them.
	TagValues []*string `locationNameList:"TagValue" type:"list"`
}

// String returns the string representation
func (s DescribeClusterSecurityGroupsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeClusterSecurityGroupsInput) GoString() string {
	return s.String()
}

// SetClusterSecurityGroupName sets the ClusterSecurityGroupName field's value.
func (s *DescribeClusterSecurityGroupsInput) SetClusterSecurityGroupName(v string) *DescribeClusterSecurityGroupsInput {
	s.ClusterSecurityGroupName = &v
	return s
}

// SetMarker sets the Marker field's value.
func (s *DescribeClusterSecurityGroupsInput) SetMarker(v string) *DescribeClusterSecurityGroupsInput {
	s.Marker = &v
	return s
}

// SetMaxRecords sets the MaxRecords field's value.
func (s *DescribeClusterSecurityGroupsInput) SetMaxRecords(v int64) *DescribeClusterSecurityGroupsInput {
	s.MaxRecords = &v
	return s
}

// SetTagKeys sets the TagKeys field's value.
func (s *DescribeClusterSecurityGroupsInput) SetTagKeys(v []*string) *DescribeClusterSecurityGroupsInput {
	s.TagKeys = v
	return s
}

// SetTagValues sets the TagValues field's value.
func (s *DescribeClusterSecurityGroupsInput) SetTagValues(v []*string) *DescribeClusterSecurityGroupsInput {
	s.TagValues = v
	return s
}

type DescribeClusterSecurityGroupsOutput struct {
	_ struct{} `type:"structure"`

	// A list of ClusterSecurityGroup instances.
	ClusterSecurityGroups []*ClusterSecurityGroup `locationNameList:"ClusterSecurityGroup" type:"list"`

	// A value that indicates the starting point for the next set of response records
	// in a subsequent request. If a value is returned in a response, you can retrieve
	// the next set of records by providing this returned marker value in the Marker
	// parameter and retrying the command. If the Marker field is empty, all response
	// records have been retrieved for the request.
	Marker *string `type:"string"`
}

// String returns the string representation
func (s DescribeClusterSecurityGroupsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeClusterSecurityGroupsOutput) GoString() string {
	return s.String()
}

// SetClusterSecurityGroups sets the ClusterSecurityGroups field's value.
func (s *DescribeClusterSecurityGroupsOutput) SetClusterSecurityGroups(v []*ClusterSecurityGroup) *DescribeClusterSecurityGroupsOutput {
	s.ClusterSecurityGroups = v
	return s
}

// SetMarker sets the Marker field's value.
func (s *DescribeClusterSecurityGroupsOutput) SetMarker(v string) *DescribeClusterSecurityGroupsOutput {
	s.Marker = &v
	return s
}

type DescribeClusterSnapshotsInput struct {
	_ struct{} `type:"structure"`

	// A value that indicates whether to return snapshots only for an existing cluster.
	// You can perform table-level restore only by using a snapshot of an existing
	// cluster, that is, a cluster that has not been deleted. Values for this parameter
	// work as follows:
	//
	//    * If ClusterExists is set to true, ClusterIdentifier is required.
	//
	//    * If ClusterExists is set to false and ClusterIdentifier isn't specified,
	//    all snapshots associated with deleted clusters (orphaned snapshots) are
	//    returned.
	//
	//    * If ClusterExists is set to false and ClusterIdentifier is specified
	//    for a deleted cluster, snapshots associated with that cluster are returned.
	//
	//    * If ClusterExists is set to false and ClusterIdentifier is specified
	//    for an existing cluster, no snapshots are returned.
	ClusterExists *bool `type:"boolean"`

	// The identifier of the cluster which generated the requested snapshots.
	ClusterIdentifier *string `type:"string"`

	// A time value that requests only snapshots created at or before the specified
	// time. The time value is specified in ISO 8601 format. For more information
	// about ISO 8601, go to the ISO8601 Wikipedia page. (http://en.wikipedia.org/wiki/ISO_8601)
	//
	// Example: 2012-07-16T18:00:00Z
	EndTime *time.Time `type:"timestamp"`

	// An optional parameter that specifies the starting point to return a set of
	// response records. When the results of a DescribeClusterSnapshots request
	// exceed the value specified in MaxRecords, AWS returns a value in the Marker
	// field of the response. You can retrieve the next set of response records
	// by providing the returned marker value in the Marker parameter and retrying
	// the request.
	Marker *string `type:"string"`

	// The maximum number of response records to return in each call. If the number
	// of remaining response records exceeds the specified MaxRecords value, a value
	// is returned in a marker field of the response. You can retrieve the next
	// set of records by retrying the command with the returned marker value.
	//
	// Default: 100
	//
	// Constraints: minimum 20, maximum 100.
	MaxRecords *int64 `type:"integer"`

	// The AWS customer account used to create or copy the snapshot. Use this field
	// to filter the results to snapshots owned by a particular account. To describe
	// snapshots you own, either specify your AWS customer account, or do not specify
	// the parameter.
	OwnerAccount *string `type:"string"`

	// The snapshot identifier of the snapshot about which to return information.
	SnapshotIdentifier *string `type:"string"`

	// The type of snapshots for which you are requesting information. By default,
	// snapshots of all types are returned.
	//
	// Valid Values: automated | manual
	SnapshotType *string `type:"string"`

	SortingEntities []*SnapshotSortingEntity `locationNameList:"SnapshotSortingEntity" type:"list"`

	// A value that requests only snapshots created at or after the specified time.
	// The time value is specified in ISO 8601 format. For more information about
	// ISO 8601, go to the ISO8601 Wikipedia page. (http://en.wikipedia.org/wiki/ISO_8601)
	//
	// Example: 2012-07-16T18:00:00Z
	StartTime *time.Time `type:"timestamp"`

	// A tag key or keys for which you want to return all matching cluster snapshots
	// that are associated with the specified key or keys. For example, suppose
	// that you have snapshots that are tagged with keys called owner and environment.
	// If you specify both of these tag keys in the request, Amazon Redshift returns
	// a response with the snapshots that have either or both of these tag keys
	// associated with them.
	TagKeys []*string `locationNameList:"TagKey" type:"list"`

	// A tag value or values for which you want to return all matching cluster snapshots
	// that are associated with the specified tag value or values. For example,
	// suppose that you have snapshots that are tagged with values called admin
	// and test. If you specify both of these tag values in the request, Amazon
	// Redshift returns a response with the snapshots that have either or both of
	// these tag values associated with them.
	TagValues []*string `locationNameList:"TagValue" type:"list"`
}

// String returns the string representation
func (s DescribeClusterSnapshotsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeClusterSnapshotsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeClusterSnapshotsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeClusterSnapshotsInput"}
	if s.SortingEntities != nil {
		for i, v := range s.SortingEntities {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "SortingEntities", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClusterExists sets the ClusterExists field's value.
func (s *DescribeClusterSnapshotsInput) SetClusterExists(v bool) *DescribeClusterSnapshotsInput {
	s.ClusterExists = &v
	return s
}

// SetClusterIdentifier sets the ClusterIdentifier field's value.
func (s *DescribeClusterSnapshotsInput) SetClusterIdentifier(v string) *DescribeClusterSnapshotsInput {
	s.ClusterIdentifier = &v
	return s
}

// SetEndTime sets the EndTime field's value.
func (s *DescribeClusterSnapshotsInput) SetEndTime(v time.Time) *DescribeClusterSnapshotsInput {
	s.EndTime = &v
	return s
}

// SetMarker sets the Marker field's value.
func (s *DescribeClusterSnapshotsInput) SetMarker(v string) *DescribeClusterSnapshotsInput {
	s.Marker = &v
	return s
}

// SetMaxRecords sets the MaxRecords field's value.
func (s *DescribeClusterSnapshotsInput) SetMaxRecords(v int64) *DescribeClusterSnapshotsInput {
	s.MaxRecords = &v
	return s
}

// SetOwnerAccount sets the OwnerAccount field's value.
func (s *DescribeClusterSnapshotsInput) SetOwnerAccount(v string) *DescribeClusterSnapshotsInput {
	s.OwnerAccount = &v
	return s
}

// SetSnapshotIdentifier sets the SnapshotIdentifier field's value.
func (s *DescribeClusterSnapshotsInput) SetSnapshotIdentifier(v string) *DescribeClusterSnapshotsInput {
	s.SnapshotIdentifier = &v
	return s
}

// SetSnapshotType sets the SnapshotType field's value.
func (s *DescribeClusterSnapshotsInput) SetSnapshotType(v string) *DescribeClusterSnapshotsInput {
	s.SnapshotType = &v
	return s
}

// SetSortingEntities sets the SortingEntities field's value.
func (s *DescribeClusterSnapshotsInput) SetSortingEntities(v []*SnapshotSortingEntity) *DescribeClusterSnapshotsInput {
	s.SortingEntities = v
	return s
}

// SetStartTime sets the StartTime field's value.
func (s *DescribeClusterSnapshotsInput) SetStartTime(v time.Time) *DescribeClusterSnapshotsInput {
	s.StartTime = &v
	return s
}

// SetTagKeys sets the TagKeys field's value.
func (s *DescribeClusterSnapshotsInput) SetTagKeys(v []*string) *DescribeClusterSnapshotsInput {
	s.TagKeys = v
	return s
}

// SetTagValues sets the TagValues field's value.
func (s *DescribeClusterSnapshotsInput) SetTagValues(v []*string) *DescribeClusterSnapshotsInput {
	s.TagValues = v
	return s
}

// Contains the output from the DescribeClusterSnapshots action.
type DescribeClusterSnapshotsOutput struct {
	_ struct{} `type:"structure"`

	// A value that indicates the starting point for the next set of response records
	// in a subsequent request. If a value is returned in a response, you can retrieve
	// the next set of records by providing this returned marker value in the Marker
	// parameter and retrying the command. If the Marker field is empty, all response
	// records have been retrieved for the request.
	Marker *string `type:"string"`

	// A list of Snapshot instances.
	Snapshots []*Snapshot `locationNameList:"Snapshot" type:"list"`
}

// String returns the string representation
func (s DescribeClusterSnapshotsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeClusterSnapshotsOutput) GoString() string {
	return s.String()
}

// SetMarker sets the Marker field's value.
func (s *DescribeClusterSnapshotsOutput) SetMarker(v string) *DescribeClusterSnapshotsOutput {
	s.Marker = &v
	return s
}

// SetSnapshots sets the Snapshots field's value.
func (s *DescribeClusterSnapshotsOutput) SetSnapshots(v []*Snapshot) *DescribeClusterSnapshotsOutput {
	s.Snapshots = v
	return s
}

type DescribeClusterSubnetGroupsInput struct {
	_ struct{} `type:"structure"`

	// The name of the cluster subnet group for which information is requested.
	ClusterSubnetGroupName *string `type:"string"`

	// An optional parameter that specifies the starting point to return a set of
	// response records. When the results of a DescribeClusterSubnetGroups request
	// exceed the value specified in MaxRecords, AWS returns a value in the Marker
	// field of the response. You can retrieve the next set of response records
	// by providing the returned marker value in the Marker parameter and retrying
	// the request.
	Marker *string `type:"string"`

	// The maximum number of response records to return in each call. If the number
	// of remaining response records exceeds the specified MaxRecords value, a value
	// is returned in a marker field of the response. You can retrieve the next
	// set of records by retrying the command with the returned marker value.
	//
	// Default: 100
	//
	// Constraints: minimum 20, maximum 100.
	MaxRecords *int64 `type:"integer"`

	// A tag key or keys for which you want to return all matching cluster subnet
	// groups that are associated with the specified key or keys. For example, suppose
	// that you have subnet groups that are tagged with keys called owner and environment.
	// If you specify both of these tag keys in the request, Amazon Redshift returns
	// a response with the subnet groups that have either or both of these tag keys
	// associated with them.
	TagKeys []*string `locationNameList:"TagKey" type:"list"`

	// A tag value or values for which you want to return all matching cluster subnet
	// groups that are associated with the specified tag value or values. For example,
	// suppose that you have subnet groups that are tagged with values called admin
	// and test. If you specify both of these tag values in the request, Amazon
	// Redshift returns a response with the subnet groups that have either or both
	// of these tag values associated with them.
	TagValues []*string `locationNameList:"TagValue" type:"list"`
}

// String returns the string representation
func (s DescribeClusterSubnetGroupsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeClusterSubnetGroupsInput) GoString() string {
	return s.String()
}

// SetClusterSubnetGroupName sets the ClusterSubnetGroupName field's value.
func (s *DescribeClusterSubnetGroupsInput) SetClusterSubnetGroupName(v string) *DescribeClusterSubnetGroupsInput {
	s.ClusterSubnetGroupName = &v
	return s
}

// SetMarker sets the Marker field's value.
func (s *DescribeClusterSubnetGroupsInput) SetMarker(v string) *DescribeClusterSubnetGroupsInput {
	s.Marker = &v
	return s
}

// SetMaxRecords sets the MaxRecords field's value.
func (s *DescribeClusterSubnetGroupsInput) SetMaxRecords(v int64) *DescribeClusterSubnetGroupsInput {
	s.MaxRecords = &v
	return s
}

// SetTagKeys sets the TagKeys field's value.
func (s *DescribeClusterSubnetGroupsInput) SetTagKeys(v []*string) *DescribeClusterSubnetGroupsInput {
	s.TagKeys = v
	return s
}

// SetTagValues sets the TagValues field's value.
func (s *DescribeClusterSubnetGroupsInput) SetTagValues(v []*string) *DescribeClusterSubnetGroupsInput {
	s.TagValues = v
	return s
}

// Contains the output from the DescribeClusterSubnetGroups action.
type DescribeClusterSubnetGroupsOutput struct {
	_ struct{} `type:"structure"`

	// A list of ClusterSubnetGroup instances.
	ClusterSubnetGroups []*ClusterSubnetGroup `locationNameList:"ClusterSubnetGroup" type:"list"`

	// A value that indicates the starting point for the next set of response records
	// in a subsequent request. If a value is returned in a response, you can retrieve
	// the next set of records by providing this returned marker value in the Marker
	// parameter and retrying the command. If the Marker field is empty, all response
	// records have been retrieved for the request.
	Marker *string `type:"string"`
}

// String returns the string representation
func (s DescribeClusterSubnetGroupsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeClusterSubnetGroupsOutput) GoString() string {
	return s.String()
}

// SetClusterSubnetGroups sets the ClusterSubnetGroups field's value.
func (s *DescribeClusterSubnetGroupsOutput) SetClusterSubnetGroups(v []*ClusterSubnetGroup) *DescribeClusterSubnetGroupsOutput {
	s.ClusterSubnetGroups = v
	return s
}

// SetMarker sets the Marker field's value.
func (s *DescribeClusterSubnetGroupsOutput) SetMarker(v string) *DescribeClusterSubnetGroupsOutput {
	s.Marker = &v
	return s
}

type DescribeClusterTracksInput struct {
	_ struct{} `type:"structure"`

	// The name of the maintenance track.
	MaintenanceTrackName *string `type:"string"`

	// An optional parameter that specifies the starting point to return a set of
	// response records. When the results of a DescribeClusterTracks request exceed
	// the value specified in MaxRecords, Amazon Redshift returns a value in the
	// Marker field of the response. You can retrieve the next set of response records
	// by providing the returned marker value in the Marker parameter and retrying
	// the request.
	Marker *string `type:"string"`

	// An integer value for the maximum number of maintenance tracks to return.
	MaxRecords *int64 `type:"integer"`
}

// String returns the string representation
func (s DescribeClusterTracksInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeClusterTracksInput) GoString() string {
	return s.String()
}

// SetMaintenanceTrackName sets the MaintenanceTrackName field's value.
func (s *DescribeClusterTracksInput) SetMaintenanceTrackName(v string) *DescribeClusterTracksInput {
	s.MaintenanceTrackName = &v
	return s
}

// SetMarker sets the Marker field's value.
func (s *DescribeClusterTracksInput) SetMarker(v string) *DescribeClusterTracksInput {
	s.Marker = &v
	return s
}

// SetMaxRecords sets the MaxRecords field's value.
func (s *DescribeClusterTracksInput) SetMaxRecords(v int64) *DescribeClusterTracksInput {
	s.MaxRecords = &v
	return s
}

type DescribeClusterTracksOutput struct {
	_ struct{} `type:"structure"`

	// A list of maintenance tracks output by the DescribeClusterTracks operation.
	MaintenanceTracks []*MaintenanceTrack `locationNameList:"MaintenanceTrack" type:"list"`

	// The starting point to return a set of response tracklist records. You can
	// retrieve the next set of response records by providing the returned marker
	// value in the Marker parameter and retrying the request.
	Marker *string `type:"string"`
}

// String returns the string representation
func (s DescribeClusterTracksOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeClusterTracksOutput) GoString() string {
	return s.String()
}

// SetMaintenanceTracks sets the MaintenanceTracks field's value.
func (s *DescribeClusterTracksOutput) SetMaintenanceTracks(v []*MaintenanceTrack) *DescribeClusterTracksOutput {
	s.MaintenanceTracks = v
	return s
}

// SetMarker sets the Marker field's value.
func (s *DescribeClusterTracksOutput) SetMarker(v string) *DescribeClusterTracksOutput {
	s.Marker = &v
	return s
}

type DescribeClusterVersionsInput struct {
	_ struct{} `type:"structure"`

	// The name of a specific cluster parameter group family to return details for.
	//
	// Constraints:
	//
	//    * Must be 1 to 255 alphanumeric characters
	//
	//    * First character must be a letter
	//
	//    * Cannot end with a hyphen or contain two consecutive hyphens
	ClusterParameterGroupFamily *string `type:"string"`

	// The specific cluster version to return.
	//
	// Example: 1.0
	ClusterVersion *string `type:"string"`

	// An optional parameter that specifies the starting point to return a set of
	// response records. When the results of a DescribeClusterVersions request exceed
	// the value specified in MaxRecords, AWS returns a value in the Marker field
	// of the response. You can retrieve the next set of response records by providing
	// the returned marker value in the Marker parameter and retrying the request.
	Marker *string `type:"string"`

	// The maximum number of response records to return in each call. If the number
	// of remaining response records exceeds the specified MaxRecords value, a value
	// is returned in a marker field of the response. You can retrieve the next
	// set of records by retrying the command with the returned marker value.
	//
	// Default: 100
	//
	// Constraints: minimum 20, maximum 100.
	MaxRecords *int64 `type:"integer"`
}

// String returns the string representation
func (s DescribeClusterVersionsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeClusterVersionsInput) GoString() string {
	return s.String()
}

// SetClusterParameterGroupFamily sets the ClusterParameterGroupFamily field's value.
func (s *DescribeClusterVersionsInput) SetClusterParameterGroupFamily(v string) *DescribeClusterVersionsInput {
	s.ClusterParameterGroupFamily = &v
	return s
}

// SetClusterVersion sets the ClusterVersion field's value.
func (s *DescribeClusterVersionsInput) SetClusterVersion(v string) *DescribeClusterVersionsInput {
	s.ClusterVersion = &v
	return s
}

// SetMarker sets the Marker field's value.
func (s *DescribeClusterVersionsInput) SetMarker(v string) *DescribeClusterVersionsInput {
	s.Marker = &v
	return s
}

// SetMaxRecords sets the MaxRecords field's value.
func (s *DescribeClusterVersionsInput) SetMaxRecords(v int64) *DescribeClusterVersionsInput {
	s.MaxRecords = &v
	return s
}

// Contains the output from the DescribeClusterVersions action.
type DescribeClusterVersionsOutput struct {
	_ struct{} `type:"structure"`

	// A list of Version elements.
	ClusterVersions []*ClusterVersion `locationNameList:"ClusterVersion" type:"list"`

	// A value that indicates the starting point for the next set of response records
	// in a subsequent request. If a value is returned in a response, you can retrieve
	// the next set of records by providing this returned marker value in the Marker
	// parameter and retrying the command. If the Marker field is empty, all response
	// records have been retrieved for the request.
	Marker *string `type:"string"`
}

// String returns the string representation
func (s DescribeClusterVersionsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeClusterVersionsOutput) GoString() string {
	return s.String()
}

// SetClusterVersions sets the ClusterVersions field's value.
func (s *DescribeClusterVersionsOutput) SetClusterVersions(v []*ClusterVersion) *DescribeClusterVersionsOutput {
	s.ClusterVersions = v
	return s
}

// SetMarker sets the Marker field's value.
func (s *DescribeClusterVersionsOutput) SetMarker(v string) *DescribeClusterVersionsOutput {
	s.Marker = &v
	return s
}

type DescribeClustersInput struct {
	_ struct{} `type:"structure"`

	// The unique identifier of a cluster whose properties you are requesting. This
	// parameter is case sensitive.
	//
	// The default is that all clusters defined for an account are returned.
	ClusterIdentifier *string `type:"string"`

	// An optional parameter that specifies the starting point to return a set of
	// response records. When the results of a DescribeClusters request exceed the
	// value specified in MaxRecords, AWS returns a value in the Marker field of
	// the response. You can retrieve the next set of response records by providing
	// the returned marker value in the Marker parameter and retrying the request.
	//
	// Constraints: You can specify either the ClusterIdentifier parameter or the
	// Marker parameter, but not both.
	Marker *string `type:"string"`

	// The maximum number of response records to return in each call. If the number
	// of remaining response records exceeds the specified MaxRecords value, a value
	// is returned in a marker field of the response. You can retrieve the next
	// set of records by retrying the command with the returned marker value.
	//
	// Default: 100
	//
	// Constraints: minimum 20, maximum 100.
	MaxRecords *int64 `type:"integer"`

	// A tag key or keys for which you want to return all matching clusters that
	// are associated with the specified key or keys. For example, suppose that
	// you have clusters that are tagged with keys called owner and environment.
	// If you specify both of these tag keys in the request, Amazon Redshift returns
	// a response with the clusters that have either or both of these tag keys associated
	// with them.
	TagKeys []*string `locationNameList:"TagKey" type:"list"`

	// A tag value or values for which you want to return all matching clusters
	// that are associated with the specified tag value or values. For example,
	// suppose that you have clusters that are tagged with values called admin and
	// test. If you specify both of these tag values in the request, Amazon Redshift
	// returns a response with the clusters that have either or both of these tag
	// values associated with them.
	TagValues []*string `locationNameList:"TagValue" type:"list"`
}

// String returns the string representation
func (s DescribeClustersInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeClustersInput) GoString() string {
	return s.String()
}

// SetClusterIdentifier sets the ClusterIdentifier field's value.
func (s *DescribeClustersInput) SetClusterIdentifier(v string) *DescribeClustersInput {
	s.ClusterIdentifier = &v
	return s
}

// SetMarker sets the Marker field's value.
func (s *DescribeClustersInput) SetMarker(v string) *DescribeClustersInput {
	s.Marker = &v
	return s
}

// SetMaxRecords sets the MaxRecords field's value.
func (s *DescribeClustersInput) SetMaxRecords(v int64) *DescribeClustersInput {
	s.MaxRecords = &v
	return s
}

// SetTagKeys sets the TagKeys field's value.
func (s *DescribeClustersInput) SetTagKeys(v []*string) *DescribeClustersInput {
	s.TagKeys = v
	return s
}

// SetTagValues sets the TagValues field's value.
func (s *DescribeClustersInput) SetTagValues(v []*string) *DescribeClustersInput {
	s.TagValues = v
	return s
}

// Contains the output from the DescribeClusters action.
type DescribeClustersOutput struct {
	_ struct{} `type:"structure"`

	// A list of Cluster objects, where each object describes one cluster.
	Clusters []*Cluster `locationNameList:"Cluster" type:"list"`

	// A value that indicates the starting point for the next set of response records
	// in a subsequent request. If a value is returned in a response, you can retrieve
	// the next set of records by providing this returned marker value in the Marker
	// parameter and retrying the command. If the Marker field is empty, all response
	// records have been retrieved for the request.
	Marker *string `type:"string"`
}

// String returns the string representation
func (s DescribeClustersOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeClustersOutput) GoString() string {
	return s.String()
}

// SetClusters sets the Clusters field's value.
func (s *DescribeClustersOutput) SetClusters(v []*Cluster) *DescribeClustersOutput {
	s.Clusters = v
	return s
}

// SetMarker sets the Marker field's value.
func (s *DescribeClustersOutput) SetMarker(v string) *DescribeClustersOutput {
	s.Marker = &v
	return s
}

type DescribeDefaultClusterParametersInput struct {
	_ struct{} `type:"structure"`

	// An optional parameter that specifies the starting point to return a set of
	// response records. When the results of a DescribeDefaultClusterParameters
	// request exceed the value specified in MaxRecords, AWS returns a value in
	// the Marker field of the response. You can retrieve the next set of response
	// records by providing the returned marker value in the Marker parameter and
	// retrying the request.
	Marker *string `type:"string"`

	// The maximum number of response records to return in each call. If the number
	// of remaining response records exceeds the specified MaxRecords value, a value
	// is returned in a marker field of the response. You can retrieve the next
	// set of records by retrying the command with the returned marker value.
	//
	// Default: 100
	//
	// Constraints: minimum 20, maximum 100.
	MaxRecords *int64 `type:"integer"`

	// The name of the cluster parameter group family.
	//
	// ParameterGroupFamily is a required field
	ParameterGroupFamily *string `type:"string" required:"true"`
}

// String returns the string representation
func (s DescribeDefaultClusterParametersInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeDefaultClusterParametersInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeDefaultClusterParametersInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeDefaultClusterParametersInput"}
	if s.ParameterGroupFamily == nil {
		invalidParams.Add(request.NewErrParamRequired("ParameterGroupFamily"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMarker sets the Marker field's value.
func (s *DescribeDefaultClusterParametersInput) SetMarker(v string) *DescribeDefaultClusterParametersInput {
	s.Marker = &v
	return s
}

// SetMaxRecords sets the MaxRecords field's value.
func (s *DescribeDefaultClusterParametersInput) SetMaxRecords(v int64) *DescribeDefaultClusterParametersInput {
	s.MaxRecords = &v
	return s
}

// SetParameterGroupFamily sets the ParameterGroupFamily field's value.
func (s *DescribeDefaultClusterParametersInput) SetParameterGroupFamily(v string) *DescribeDefaultClusterParametersInput {
	s.ParameterGroupFamily = &v
	return s
}

type DescribeDefaultClusterParametersOutput struct {
	_ struct{} `type:"structure"`

	// Describes the default cluster parameters for a parameter group family.
	DefaultClusterParameters *DefaultClusterParameters `type:"structure"`
}

// String returns the string representation
func (s DescribeDefaultClusterParametersOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeDefaultClusterParametersOutput) GoString() string {
	return s.String()
}

// SetDefaultClusterParameters sets the DefaultClusterParameters field's value.
func (s *DescribeDefaultClusterParametersOutput) SetDefaultClusterParameters(v *DefaultClusterParameters) *DescribeDefaultClusterParametersOutput {
	s.DefaultClusterParameters = v
	return s
}

type DescribeEventCategoriesInput struct {
	_ struct{} `type:"structure"`

	// The source type, such as cluster or parameter group, to which the described
	// event categories apply.
	//
	// Valid values: cluster, cluster-snapshot, cluster-parameter-group, cluster-security-group,
	// and scheduled-action.
	SourceType *string `type:"string"`
}

// String returns the string representation
func (s DescribeEventCategoriesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeEventCategoriesInput) GoString() string {
	return s.String()
}

// SetSourceType sets the SourceType field's value.
func (s *DescribeEventCategoriesInput) SetSourceType(v string) *DescribeEventCategoriesInput {
	s.SourceType = &v
	return s
}

type DescribeEventCategoriesOutput struct {
	_ struct{} `type:"structure"`

	// A list of event categories descriptions.
	EventCategoriesMapList []*EventCategoriesMap `locationNameList:"EventCategoriesMap" type:"list"`
}

// String returns the string representation
func (s DescribeEventCategoriesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeEventCategoriesOutput) GoString() string {
	return s.String()
}

// SetEventCategoriesMapList sets the EventCategoriesMapList field's value.
func (s *DescribeEventCategoriesOutput) SetEventCategoriesMapList(v []*EventCategoriesMap) *DescribeEventCategoriesOutput {
	s.EventCategoriesMapList = v
	return s
}

type DescribeEventSubscriptionsInput struct {
	_ struct{} `type:"structure"`

	// An optional parameter that specifies the starting point to return a set of
	// response records. When the results of a DescribeEventSubscriptions request
	// exceed the value specified in MaxRecords, AWS returns a value in the Marker
	// field of the response. You can retrieve the next set of response records
	// by providing the returned marker value in the Marker parameter and retrying
	// the request.
	Marker *string `type:"string"`

	// The maximum number of response records to return in each call. If the number
	// of remaining response records exceeds the specified MaxRecords value, a value
	// is returned in a marker field of the response. You can retrieve the next
	// set of records by retrying the command with the returned marker value.
	//
	// Default: 100
	//
	// Constraints: minimum 20, maximum 100.
	MaxRecords *int64 `type:"integer"`

	// The name of the Amazon Redshift event notification subscription to be described.
	SubscriptionName *string `type:"string"`

	// A tag key or keys for which you want to return all matching event notification
	// subscriptions that are associated with the specified key or keys. For example,
	// suppose that you have subscriptions that are tagged with keys called owner
	// and environment. If you specify both of these tag keys in the request, Amazon
	// Redshift returns a response with the subscriptions that have either or both
	// of these tag keys associated with them.
	TagKeys []*string `locationNameList:"TagKey" type:"list"`

	// A tag value or values for which you want to return all matching event notification
	// subscriptions that are associated with the specified tag value or values.
	// For example, suppose that you have subscriptions that are tagged with values
	// called admin and test. If you specify both of these tag values in the request,
	// Amazon Redshift returns a response with the subscriptions that have either
	// or both of these tag values associated with them.
	TagValues []*string `locationNameList:"TagValue" type:"list"`
}

// String returns the string representation
func (s DescribeEventSubscriptionsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeEventSubscriptionsInput) GoString() string {
	return s.String()
}

// SetMarker sets the Marker field's value.
func (s *DescribeEventSubscriptionsInput) SetMarker(v string) *DescribeEventSubscriptionsInput {
	s.Marker = &v
	return s
}

// SetMaxRecords sets the MaxRecords field's value.
func (s *DescribeEventSubscriptionsInput) SetMaxRecords(v int64) *DescribeEventSubscriptionsInput {
	s.MaxRecords = &v
	return s
}

// SetSubscriptionName sets the SubscriptionName field's value.
func (s *DescribeEventSubscriptionsInput) SetSubscriptionName(v string) *DescribeEventSubscriptionsInput {
	s.SubscriptionName = &v
	return s
}

// SetTagKeys sets the TagKeys field's value.
func (s *DescribeEventSubscriptionsInput) SetTagKeys(v []*string) *DescribeEventSubscriptionsInput {
	s.TagKeys = v
	return s
}

// SetTagValues sets the TagValues field's value.
func (s *DescribeEventSubscriptionsInput) SetTagValues(v []*string) *DescribeEventSubscriptionsInput {
	s.TagValues = v
	return s
}

type DescribeEventSubscriptionsOutput struct {
	_ struct{} `type:"structure"`

	// A list of event subscriptions.
	EventSubscriptionsList []*EventSubscription `locationNameList:"EventSubscription" type:"list"`

	// A value that indicates the starting point for the next set of response records
	// in a subsequent request. If a value is returned in a response, you can retrieve
	// the next set of records by providing this returned marker value in the Marker
	// parameter and retrying the command. If the Marker field is empty, all response
	// records have been retrieved for the request.
	Marker *string `type:"string"`
}

// String returns the string representation
func (s DescribeEventSubscriptionsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeEventSubscriptionsOutput) GoString() string {
	return s.String()
}

// SetEventSubscriptionsList sets the EventSubscriptionsList field's value.
func (s *DescribeEventSubscriptionsOutput) SetEventSubscriptionsList(v []*EventSubscription) *DescribeEventSubscriptionsOutput {
	s.EventSubscriptionsList = v
	return s
}

// SetMarker sets the Marker field's value.
func (s *DescribeEventSubscriptionsOutput) SetMarker(v string) *DescribeEventSubscriptionsOutput {
	s.Marker = &v
	return s
}

type DescribeEventsInput struct {
	_ struct{} `type:"structure"`

	// The number of minutes prior to the time of the request for which to retrieve
	// events. For example, if the request is sent at 18:00 and you specify a duration
	// of 60, then only events which have occurred after 17:00 will be returned.
	//
	// Default: 60
	Duration *int64 `type:"integer"`

	// The end of the time interval for which to retrieve events, specified in ISO
	// 8601 format. For more information about ISO 8601, go to the ISO8601 Wikipedia
	// page. (http://en.wikipedia.org/wiki/ISO_8601)
	//
	// Example: 2009-07-08T18:00Z
	EndTime *time.Time `type:"timestamp"`

	// An optional parameter that specifies the starting point to return a set of
	// response records. When the results of a DescribeEvents request exceed the
	// value specified in MaxRecords, AWS returns a value in the Marker field of
	// the response. You can retrieve the next set of response records by providing
	// the returned marker value in the Marker parameter and retrying the request.
	Marker *string `type:"string"`

	// The maximum number of response records to return in each call. If the number
	// of remaining response records exceeds the specified MaxRecords value, a value
	// is returned in a marker field of the response. You can retrieve the next
	// set of records by retrying the command with the returned marker value.
	//
	// Default: 100
	//
	// Constraints: minimum 20, maximum 100.
	MaxRecords *int64 `type:"integer"`

	// The identifier of the event source for which events will be returned. If
	// this parameter is not specified, then all sources are included in the response.
	//
	// Constraints:
	//
	// If SourceIdentifier is supplied, SourceType must also be provided.
	//
	//    * Specify a cluster identifier when SourceType is cluster.
	//
	//    * Specify a cluster security group name when SourceType is cluster-security-group.
	//
	//    * Specify a cluster parameter group name when SourceType is cluster-parameter-group.
	//
	//    * Specify a cluster snapshot identifier when SourceType is cluster-snapshot.
	SourceIdentifier *string `type:"string"`

	// The event source to retrieve events for. If no value is specified, all events
	// are returned.
	//
	// Constraints:
	//
	// If SourceType is supplied, SourceIdentifier must also be provided.
	//
	//    * Specify cluster when SourceIdentifier is a cluster identifier.
	//
	//    * Specify cluster-security-group when SourceIdentifier is a cluster security
	//    group name.
	//
	//    * Specify cluster-parameter-group when SourceIdentifier is a cluster parameter
	//    group name.
	//
	//    * Specify cluster-snapshot when SourceIdentifier is a cluster snapshot
	//    identifier.
	SourceType *string `type:"string" enum:"SourceType"`

	// The beginning of the time interval to retrieve events for, specified in ISO
	// 8601 format. For more information about ISO 8601, go to the ISO8601 Wikipedia
	// page. (http://en.wikipedia.org/wiki/ISO_8601)
	//
	// Example: 2009-07-08T18:00Z
	StartTime *time.Time `type:"timestamp"`
}

// String returns the string representation
func (s DescribeEventsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeEventsInput) GoString() string {
	return s.String()
}

// SetDuration sets the Duration field's value.
func (s *DescribeEventsInput) SetDuration(v int64) *DescribeEventsInput {
	s.Duration = &v
	return s
}

// SetEndTime sets the EndTime field's value.
func (s *DescribeEventsInput) SetEndTime(v time.Time) *DescribeEventsInput {
	s.EndTime = &v
	return s
}

// SetMarker sets the Marker field's value.
func (s *DescribeEventsInput) SetMarker(v string) *DescribeEventsInput {
	s.Marker = &v
	return s
}

// SetMaxRecords sets the MaxRecords field's value.
func (s *DescribeEventsInput) SetMaxRecords(v int64) *DescribeEventsInput {
	s.MaxRecords = &v
	return s
}

// SetSourceIdentifier sets the SourceIdentifier field's value.
func (s *DescribeEventsInput) SetSourceIdentifier(v string) *DescribeEventsInput {
	s.SourceIdentifier = &v
	return s
}

// SetSourceType sets the SourceType field's value.
func (s *DescribeEventsInput) SetSourceType(v string) *DescribeEventsInput {
	s.SourceType = &v
	return s
}

// SetStartTime sets the StartTime field's value.
func (s *DescribeEventsInput) SetStartTime(v time.Time) *DescribeEventsInput {
	s.StartTime = &v
	return s
}

type DescribeEventsOutput struct {
	_ struct{} `type:"structure"`

	// A list of Event instances.
	Events []*Event `locationNameList:"Event" type:"list"`

	// A value that indicates the starting point for the next set of response records
	// in a subsequent request. If a value is returned in a response, you can retrieve
	// the next set of records by providing this returned marker value in the Marker
	// parameter and retrying the command. If the Marker field is empty, all response
	// records have been retrieved for the request.
	Marker *string `type:"string"`
}

// String returns the string representation
func (s DescribeEventsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeEventsOutput) GoString() string {
	return s.String()
}

// SetEvents sets the Events field's value.
func (s *DescribeEventsOutput) SetEvents(v []*Event) *DescribeEventsOutput {
	s.Events = v
	return s
}

// SetMarker sets the Marker field's value.
func (s *DescribeEventsOutput) SetMarker(v string) *DescribeEventsOutput {
	s.Marker = &v
	return s
}

type DescribeHsmClientCertificatesInput struct {
	_ struct{} `type:"structure"`

	// The identifier of a specific HSM client certificate for which you want information.
	// If no identifier is specified, information is returned for all HSM client
	// certificates owned by your AWS customer account.
	HsmClientCertificateIdentifier *string `type:"string"`

	// An optional parameter that specifies the starting point to return a set of
	// response records. When the results of a DescribeHsmClientCertificates request
	// exceed the value specified in MaxRecords, AWS returns a value in the Marker
	// field of the response. You can retrieve the next set of response records
	// by providing the returned marker value in the Marker parameter and retrying
	// the request.
	Marker *string `type:"string"`

	// The maximum number of response records to return in each call. If the number
	// of remaining response records exceeds the specified MaxRecords value, a value
	// is returned in a marker field of the response. You can retrieve the next
	// set of records by retrying the command with the returned marker value.
	//
	// Default: 100
	//
	// Constraints: minimum 20, maximum 100.
	MaxRecords *int64 `type:"integer"`

	// A tag key or keys for which you want to return all matching HSM client certificates
	// that are associated with the specified key or keys. For example, suppose
	// that you have HSM client certificates that are tagged with keys called owner
	// and environment. If you specify both of these tag keys in the request, Amazon
	// Redshift returns a response with the HSM client certificates that have either
	// or both of these tag keys associated with them.
	TagKeys []*string `locationNameList:"TagKey" type:"list"`

	// A tag value or values for which you want to return all matching HSM client
	// certificates that are associated with the specified tag value or values.
	// For example, suppose that you have HSM client certificates that are tagged
	// with values called admin and test. If you specify both of these tag values
	// in the request, Amazon Redshift returns a response with the HSM client certificates
	// that have either or both of these tag values associated with them.
	TagValues []*string `locationNameList:"TagValue" type:"list"`
}

// String returns the string representation
func (s DescribeHsmClientCertificatesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeHsmClientCertificatesInput) GoString() string {
	return s.String()
}

// SetHsmClientCertificateIdentifier sets the HsmClientCertificateIdentifier field's value.
func (s *DescribeHsmClientCertificatesInput) SetHsmClientCertificateIdentifier(v string) *DescribeHsmClientCertificatesInput {
	s.HsmClientCertificateIdentifier = &v
	return s
}

// SetMarker sets the Marker field's value.
func (s *DescribeHsmClientCertificatesInput) SetMarker(v string) *DescribeHsmClientCertificatesInput {
	s.Marker = &v
	return s
}

// SetMaxRecords sets the MaxRecords field's value.
func (s *DescribeHsmClientCertificatesInput) SetMaxRecords(v int64) *DescribeHsmClientCertificatesInput {
	s.MaxRecords = &v
	return s
}

// SetTagKeys sets the TagKeys field's value.
func (s *DescribeHsmClientCertificatesInput) SetTagKeys(v []*string) *DescribeHsmClientCertificatesInput {
	s.TagKeys = v
	return s
}

// SetTagValues sets the TagValues field's value.
func (s *DescribeHsmClientCertificatesInput) SetTagValues(v []*string) *DescribeHsmClientCertificatesInput {
	s.TagValues = v
	return s
}

type DescribeHsmClientCertificatesOutput struct {
	_ struct{} `type:"structure"`

	// A list of the identifiers for one or more HSM client certificates used by
	// Amazon Redshift clusters to store and retrieve database encryption keys in
	// an HSM.
	HsmClientCertificates []*HsmClientCertificate `locationNameList:"HsmClientCertificate" type:"list"`

	// A value that indicates the starting point for the next set of response records
	// in a subsequent request. If a value is returned in a response, you can retrieve
	// the next set of records by providing this returned marker value in the Marker
	// parameter and retrying the command. If the Marker field is empty, all response
	// records have been retrieved for the request.
	Marker *string `type:"string"`
}

// String returns the string representation
func (s DescribeHsmClientCertificatesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeHsmClientCertificatesOutput) GoString() string {
	return s.String()
}

// SetHsmClientCertificates sets the HsmClientCertificates field's value.
func (s *DescribeHsmClientCertificatesOutput) SetHsmClientCertificates(v []*HsmClientCertificate) *DescribeHsmClientCertificatesOutput {
	s.HsmClientCertificates = v
	return s
}

// SetMarker sets the Marker field's value.
func (s *DescribeHsmClientCertificatesOutput) SetMarker(v string) *DescribeHsmClientCertificatesOutput {
	s.Marker = &v
	return s
}

type DescribeHsmConfigurationsInput struct {
	_ struct{} `type:"structure"`

	// The identifier of a specific Amazon Redshift HSM configuration to be described.
	// If no identifier is specified, information is returned for all HSM configurations
	// owned by your AWS customer account.
	HsmConfigurationIdentifier *string `type:"string"`

	// An optional parameter that specifies the starting point to return a set of
	// response records. When the results of a DescribeHsmConfigurations request
	// exceed the value specified in MaxRecords, AWS returns a value in the Marker
	// field of the response. You can retrieve the next set of response records
	// by providing the returned marker value in the Marker parameter and retrying
	// the request.
	Marker *string `type:"string"`

	// The maximum number of response records to return in each call. If the number
	// of remaining response records exceeds the specified MaxRecords value, a value
	// is returned in a marker field of the response. You can retrieve the next
	// set of records by retrying the command with the returned marker value.
	//
	// Default: 100
	//
	// Constraints: minimum 20, maximum 100.
	MaxRecords *int64 `type:"integer"`

	// A tag key or keys for which you want to return all matching HSM configurations
	// that are associated with the specified key or keys. For example, suppose
	// that you have HSM configurations that are tagged with keys called owner and
	// environment. If you specify both of these tag keys in the request, Amazon
	// Redshift returns a response with the HSM configurations that have either
	// or both of these tag keys associated with them.
	TagKeys []*string `locationNameList:"TagKey" type:"list"`

	// A tag value or values for which you want to return all matching HSM configurations
	// that are associated with the specified tag value or values. For example,
	// suppose that you have HSM configurations that are tagged with values called
	// admin and test. If you specify both of these tag values in the request, Amazon
	// Redshift returns a response with the HSM configurations that have either
	// or both of these tag values associated with them.
	TagValues []*string `locationNameList:"TagValue" type:"list"`
}

// String returns the string representation
func (s DescribeHsmConfigurationsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeHsmConfigurationsInput) GoString() string {
	return s.String()
}

// SetHsmConfigurationIdentifier sets the HsmConfigurationIdentifier field's value.
func (s *DescribeHsmConfigurationsInput) SetHsmConfigurationIdentifier(v string) *DescribeHsmConfigurationsInput {
	s.HsmConfigurationIdentifier = &v
	return s
}

// SetMarker sets the Marker field's value.
func (s *DescribeHsmConfigurationsInput) SetMarker(v string) *DescribeHsmConfigurationsInput {
	s.Marker = &v
	return s
}

// SetMaxRecords sets the MaxRecords field's value.
func (s *DescribeHsmConfigurationsInput) SetMaxRecords(v int64) *DescribeHsmConfigurationsInput {
	s.MaxRecords = &v
	return s
}

// SetTagKeys sets the TagKeys field's value.
func (s *DescribeHsmConfigurationsInput) SetTagKeys(v []*string) *DescribeHsmConfigurationsInput {
	s.TagKeys = v
	return s
}

// SetTagValues sets the TagValues field's value.
func (s *DescribeHsmConfigurationsInput) SetTagValues(v []*string) *DescribeHsmConfigurationsInput {
	s.TagValues = v
	return s
}

type DescribeHsmConfigurationsOutput struct {
	_ struct{} `type:"structure"`

	// A list of HsmConfiguration objects.
	HsmConfigurations []*HsmConfiguration `locationNameList:"HsmConfiguration" type:"list"`

	// A value that indicates the starting point for the next set of response records
	// in a subsequent request. If a value is returned in a response, you can retrieve
	// the next set of records by providing this returned marker value in the Marker
	// parameter and retrying the command. If the Marker field is empty, all response
	// records have been retrieved for the request.
	Marker *string `type:"string"`
}

// String returns the string representation
func (s DescribeHsmConfigurationsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeHsmConfigurationsOutput) GoString() string {
	return s.String()
}

// SetHsmConfigurations sets the HsmConfigurations field's value.
func (s *DescribeHsmConfigurationsOutput) SetHsmConfigurations(v []*HsmConfiguration) *DescribeHsmConfigurationsOutput {
	s.HsmConfigurations = v
	return s
}

// SetMarker sets the Marker field's value.
func (s *DescribeHsmConfigurationsOutput) SetMarker(v string) *DescribeHsmConfigurationsOutput {
	s.Marker = &v
	return s
}

type DescribeLoggingStatusInput struct {
	_ struct{} `type:"structure"`

	// The identifier of the cluster from which to get the logging status.
	//
	// Example: examplecluster
	//
	// ClusterIdentifier is a required field
	ClusterIdentifier *string `type:"string" required:"true"`
}

// String returns the string representation
func (s DescribeLoggingStatusInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeLoggingStatusInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeLoggingStatusInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeLoggingStatusInput"}
	if s.ClusterIdentifier == nil {
		invalidParams.Add(request.NewErrParamRequired("ClusterIdentifier"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClusterIdentifier sets the ClusterIdentifier field's value.
func (s *DescribeLoggingStatusInput) SetClusterIdentifier(v string) *DescribeLoggingStatusInput {
	s.ClusterIdentifier = &v
	return s
}

type DescribeNodeConfigurationOptionsInput struct {
	_ struct{} `type:"structure"`

	// The action type to evaluate for possible node configurations. Specify "restore-cluster"
	// to get configuration combinations based on an existing snapshot. Specify
	// "recommend-node-config" to get configuration recommendations based on an
	// existing cluster or snapshot.
	//
	// ActionType is a required field
	ActionType *string `type:"string" required:"true" enum:"ActionType"`

	// The identifier of the cluster to evaluate for possible node configurations.
	ClusterIdentifier *string `type:"string"`

	// A set of name, operator, and value items to filter the results.
	Filters []*NodeConfigurationOptionsFilter `locationName:"Filter" locationNameList:"NodeConfigurationOptionsFilter" type:"list"`

	// An optional parameter that specifies the starting point to return a set of
	// response records. When the results of a DescribeNodeConfigurationOptions
	// request exceed the value specified in MaxRecords, AWS returns a value in
	// the Marker field of the response. You can retrieve the next set of response
	// records by providing the returned marker value in the Marker parameter and
	// retrying the request.
	Marker *string `type:"string"`

	// The maximum number of response records to return in each call. If the number
	// of remaining response records exceeds the specified MaxRecords value, a value
	// is returned in a marker field of the response. You can retrieve the next
	// set of records by retrying the command with the returned marker value.
	//
	// Default: 500
	//
	// Constraints: minimum 100, maximum 500.
	MaxRecords *int64 `type:"integer"`

	// The AWS customer account used to create or copy the snapshot. Required if
	// you are restoring a snapshot you do not own, optional if you own the snapshot.
	OwnerAccount *string `type:"string"`

	// The identifier of the snapshot to evaluate for possible node configurations.
	SnapshotIdentifier *string `type:"string"`
}

// String returns the string representation
func (s DescribeNodeConfigurationOptionsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeNodeConfigurationOptionsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeNodeConfigurationOptionsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeNodeConfigurationOptionsInput"}
	if s.ActionType == nil {
		invalidParams.Add(request.NewErrParamRequired("ActionType"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetActionType sets the ActionType field's value.
func (s *DescribeNodeConfigurationOptionsInput) SetActionType(v string) *DescribeNodeConfigurationOptionsInput {
	s.ActionType = &v
	return s
}

// SetClusterIdentifier sets the ClusterIdentifier field's value.
func (s *DescribeNodeConfigurationOptionsInput) SetClusterIdentifier(v string) *DescribeNodeConfigurationOptionsInput {
	s.ClusterIdentifier = &v
	return s
}

// SetFilters sets the Filters field's value.
func (s *DescribeNodeConfigurationOptionsInput) SetFilters(v []*NodeConfigurationOptionsFilter) *DescribeNodeConfigurationOptionsInput {
	s.Filters = v
	return s
}

// SetMarker sets the Marker field's value.
func (s *DescribeNodeConfigurationOptionsInput) SetMarker(v string) *DescribeNodeConfigurationOptionsInput {
	s.Marker = &v
	return s
}

// SetMaxRecords sets the MaxRecords field's value.
func (s *DescribeNodeConfigurationOptionsInput) SetMaxRecords(v int64) *DescribeNodeConfigurationOptionsInput {
	s.MaxRecords = &v
	return s
}

// SetOwnerAccount sets the OwnerAccount field's value.
func (s *DescribeNodeConfigurationOptionsInput) SetOwnerAccount(v string) *DescribeNodeConfigurationOptionsInput {
	s.OwnerAccount = &v
	return s
}

// SetSnapshotIdentifier sets the SnapshotIdentifier field's value.
func (s *DescribeNodeConfigurationOptionsInput) SetSnapshotIdentifier(v string) *DescribeNodeConfigurationOptionsInput {
	s.SnapshotIdentifier = &v
	return s
}

type DescribeNodeConfigurationOptionsOutput struct {
	_ struct{} `type:"structure"`

	// A value that indicates the starting point for the next set of response records
	// in a subsequent request. If a value is returned in a response, you can retrieve
	// the next set of records by providing this returned marker value in the Marker
	// parameter and retrying the command. If the Marker field is empty, all response
	// records have been retrieved for the request.
	Marker *string `type:"string"`

	// A list of valid node configurations.
	NodeConfigurationOptionList []*NodeConfigurationOption `locationNameList:"NodeConfigurationOption" type:"list"`
}

// String returns the string representation
func (s DescribeNodeConfigurationOptionsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeNodeConfigurationOptionsOutput) GoString() string {
	return s.String()
}

// SetMarker sets the Marker field's value.
func (s *DescribeNodeConfigurationOptionsOutput) SetMarker(v string) *DescribeNodeConfigurationOptionsOutput {
	s.Marker = &v
	return s
}

// SetNodeConfigurationOptionList sets the NodeConfigurationOptionList field's value.
func (s *DescribeNodeConfigurationOptionsOutput) SetNodeConfigurationOptionList(v []*NodeConfigurationOption) *DescribeNodeConfigurationOptionsOutput {
	s.NodeConfigurationOptionList = v
	return s
}

type DescribeOrderableClusterOptionsInput struct {
	_ struct{} `type:"structure"`

	// The version filter value. Specify this parameter to show only the available
	// offerings matching the specified version.
	//
	// Default: All versions.
	//
	// Constraints: Must be one of the version returned from DescribeClusterVersions.
	ClusterVersion *string `type:"string"`

	// An optional parameter that specifies the starting point to return a set of
	// response records. When the results of a DescribeOrderableClusterOptions request
	// exceed the value specified in MaxRecords, AWS returns a value in the Marker
	// field of the response. You can retrieve the next set of response records
	// by providing the returned marker value in the Marker parameter and retrying
	// the request.
	Marker *string `type:"string"`

	// The maximum number of response records to return in each call. If the number
	// of remaining response records exceeds the specified MaxRecords value, a value
	// is returned in a marker field of the response. You can retrieve the next
	// set of records by retrying the command with the returned marker value.
	//
	// Default: 100
	//
	// Constraints: minimum 20, maximum 100.
	MaxRecords *int64 `type:"integer"`

	// The node type filter value. Specify this parameter to show only the available
	// offerings matching the specified node type.
	NodeType *string `type:"string"`
}

// String returns the string representation
func (s DescribeOrderableClusterOptionsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeOrderableClusterOptionsInput) GoString() string {
	return s.String()
}

// SetClusterVersion sets the ClusterVersion field's value.
func (s *DescribeOrderableClusterOptionsInput) SetClusterVersion(v string) *DescribeOrderableClusterOptionsInput {
	s.ClusterVersion = &v
	return s
}

// SetMarker sets the Marker field's value.
func (s *DescribeOrderableClusterOptionsInput) SetMarker(v string) *DescribeOrderableClusterOptionsInput {
	s.Marker = &v
	return s
}

// SetMaxRecords sets the MaxRecords field's value.
func (s *DescribeOrderableClusterOptionsInput) SetMaxRecords(v int64) *DescribeOrderableClusterOptionsInput {
	s.MaxRecords = &v
	return s
}

// SetNodeType sets the NodeType field's value.
func (s *DescribeOrderableClusterOptionsInput) SetNodeType(v string) *DescribeOrderableClusterOptionsInput {
	s.NodeType = &v
	return s
}

// Contains the output from the DescribeOrderableClusterOptions action.
type DescribeOrderableClusterOptionsOutput struct {
	_ struct{} `type:"structure"`

	// A value that indicates the starting point for the next set of response records
	// in a subsequent request. If a value is returned in a response, you can retrieve
	// the next set of records by providing this returned marker value in the Marker
	// parameter and retrying the command. If the Marker field is empty, all response
	// records have been retrieved for the request.
	Marker *string `type:"string"`

	// An OrderableClusterOption structure containing information about orderable
	// options for the cluster.
	OrderableClusterOptions []*OrderableClusterOption `locationNameList:"OrderableClusterOption" type:"list"`
}

// String returns the string representation
func (s DescribeOrderableClusterOptionsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeOrderableClusterOptionsOutput) GoString() string {
	return s.String()
}

// SetMarker sets the Marker field's value.
func (s *DescribeOrderableClusterOptionsOutput) SetMarker(v string) *DescribeOrderableClusterOptionsOutput {
	s.Marker = &v
	return s
}

// SetOrderableClusterOptions sets the OrderableClusterOptions field's value.
func (s *DescribeOrderableClusterOptionsOutput) SetOrderableClusterOptions(v []*OrderableClusterOption) *DescribeOrderableClusterOptionsOutput {
	s.OrderableClusterOptions = v
	return s
}

type DescribeReservedNodeOfferingsInput struct {
	_ struct{} `type:"structure"`

	// An optional parameter that specifies the starting point to return a set of
	// response records. When the results of a DescribeReservedNodeOfferings request
	// exceed the value specified in MaxRecords, AWS returns a value in the Marker
	// field of the response. You can retrieve the next set of response records
	// by providing the returned marker value in the Marker parameter and retrying
	// the request.
	Marker *string `type:"string"`

	// The maximum number of response records to return in each call. If the number
	// of remaining response records exceeds the specified MaxRecords value, a value
	// is returned in a marker field of the response. You can retrieve the next
	// set of records by retrying the command with the returned marker value.
	//
	// Default: 100
	//
	// Constraints: minimum 20, maximum 100.
	MaxRecords *int64 `type:"integer"`

	// The unique identifier for the offering.
	ReservedNodeOfferingId *string `type:"string"`
}

// String returns the string representation
func (s DescribeReservedNodeOfferingsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeReservedNodeOfferingsInput) GoString() string {
	return s.String()
}

// SetMarker sets the Marker field's value.
func (s *DescribeReservedNodeOfferingsInput) SetMarker(v string) *DescribeReservedNodeOfferingsInput {
	s.Marker = &v
	return s
}

// SetMaxRecords sets the MaxRecords field's value.
func (s *DescribeReservedNodeOfferingsInput) SetMaxRecords(v int64) *DescribeReservedNodeOfferingsInput {
	s.MaxRecords = &v
	return s
}

// SetReservedNodeOfferingId sets the ReservedNodeOfferingId field's value.
func (s *DescribeReservedNodeOfferingsInput) SetReservedNodeOfferingId(v string) *DescribeReservedNodeOfferingsInput {
	s.ReservedNodeOfferingId = &v
	return s
}

type DescribeReservedNodeOfferingsOutput struct {
	_ struct{} `type:"structure"`

	// A value that indicates the starting point for the next set of response records
	// in a subsequent request. If a value is returned in a response, you can retrieve
	// the next set of records by providing this returned marker value in the Marker
	// parameter and retrying the command. If the Marker field is empty, all response
	// records have been retrieved for the request.
	Marker *string `type:"string"`

	// A list of ReservedNodeOffering objects.
	ReservedNodeOfferings []*ReservedNodeOffering `locationNameList:"ReservedNodeOffering" type:"list"`
}

// String returns the string representation
func (s DescribeReservedNodeOfferingsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeReservedNodeOfferingsOutput) GoString() string {
	return s.String()
}

// SetMarker sets the Marker field's value.
func (s *DescribeReservedNodeOfferingsOutput) SetMarker(v string) *DescribeReservedNodeOfferingsOutput {
	s.Marker = &v
	return s
}

// SetReservedNodeOfferings sets the ReservedNodeOfferings field's value.
func (s *DescribeReservedNodeOfferingsOutput) SetReservedNodeOfferings(v []*ReservedNodeOffering) *DescribeReservedNodeOfferingsOutput {
	s.ReservedNodeOfferings = v
	return s
}

type DescribeReservedNodesInput struct {
	_ struct{} `type:"structure"`

	// An optional parameter that specifies the starting point to return a set of
	// response records. When the results of a DescribeReservedNodes request exceed
	// the value specified in MaxRecords, AWS returns a value in the Marker field
	// of the response. You can retrieve the next set of response records by providing
	// the returned marker value in the Marker parameter and retrying the request.
	Marker *string `type:"string"`

	// The maximum number of response records to return in each call. If the number
	// of remaining response records exceeds the specified MaxRecords value, a value
	// is returned in a marker field of the response. You can retrieve the next
	// set of records by retrying the command with the returned marker value.
	//
	// Default: 100
	//
	// Constraints: minimum 20, maximum 100.
	MaxRecords *int64 `type:"integer"`

	// Identifier for the node reservation.
	ReservedNodeId *string `type:"string"`
}

// String returns the string representation
func (s DescribeReservedNodesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeReservedNodesInput) GoString() string {
	return s.String()
}

// SetMarker sets the Marker field's value.
func (s *DescribeReservedNodesInput) SetMarker(v string) *DescribeReservedNodesInput {
	s.Marker = &v
	return s
}

// SetMaxRecords sets the MaxRecords field's value.
func (s *DescribeReservedNodesInput) SetMaxRecords(v int64) *DescribeReservedNodesInput {
	s.MaxRecords = &v
	return s
}

// SetReservedNodeId sets the ReservedNodeId field's value.
func (s *DescribeReservedNodesInput) SetReservedNodeId(v string) *DescribeReservedNodesInput {
	s.ReservedNodeId = &v
	return s
}

type DescribeReservedNodesOutput struct {
	_ struct{} `type:"structure"`

	// A value that indicates the starting point for the next set of response records
	// in a subsequent request. If a value is returned in a response, you can retrieve
	// the next set of records by providing this returned marker value in the Marker
	// parameter and retrying the command. If the Marker field is empty, all response
	// records have been retrieved for the request.
	Marker *string `type:"string"`

	// The list of ReservedNode objects.
	ReservedNodes []*ReservedNode `locationNameList:"ReservedNode" type:"list"`
}

// String returns the string representation
func (s DescribeReservedNodesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeReservedNodesOutput) GoString() string {
	return s.String()
}

// SetMarker sets the Marker field's value.
func (s *DescribeReservedNodesOutput) SetMarker(v string) *DescribeReservedNodesOutput {
	s.Marker = &v
	return s
}

// SetReservedNodes sets the ReservedNodes field's value.
func (s *DescribeReservedNodesOutput) SetReservedNodes(v []*ReservedNode) *DescribeReservedNodesOutput {
	s.ReservedNodes = v
	return s
}

type DescribeResizeInput struct {
	_ struct{} `type:"structure"`

	// The unique identifier of a cluster whose resize progress you are requesting.
	// This parameter is case-sensitive.
	//
	// By default, resize operations for all clusters defined for an AWS account
	// are returned.
	//
	// ClusterIdentifier is a required field
	ClusterIdentifier *string `type:"string" required:"true"`
}

// String returns the string representation
func (s DescribeResizeInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeResizeInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeResizeInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeResizeInput"}
	if s.ClusterIdentifier == nil {
		invalidParams.Add(request.NewErrParamRequired("ClusterIdentifier"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClusterIdentifier sets the ClusterIdentifier field's value.
func (s *DescribeResizeInput) SetClusterIdentifier(v string) *DescribeResizeInput {
	s.ClusterIdentifier = &v
	return s
}

// Describes the result of a cluster resize operation.
type DescribeResizeOutput struct {
	_ struct{} `type:"structure"`

	// The average rate of the resize operation over the last few minutes, measured
	// in megabytes per second. After the resize operation completes, this value
	// shows the average rate of the entire resize operation.
	AvgResizeRateInMegaBytesPerSecond *float64 `type:"double"`

	// The percent of data transferred from source cluster to target cluster.
	DataTransferProgressPercent *float64 `type:"double"`

	// The amount of seconds that have elapsed since the resize operation began.
	// After the resize operation completes, this value shows the total actual time,
	// in seconds, for the resize operation.
	ElapsedTimeInSeconds *int64 `type:"long"`

	// The estimated time remaining, in seconds, until the resize operation is complete.
	// This value is calculated based on the average resize rate and the estimated
	// amount of data remaining to be processed. Once the resize operation is complete,
	// this value will be 0.
	EstimatedTimeToCompletionInSeconds *int64 `type:"long"`

	// The names of tables that have been completely imported .
	//
	// Valid Values: List of table names.
	ImportTablesCompleted []*string `type:"list"`

	// The names of tables that are being currently imported.
	//
	// Valid Values: List of table names.
	ImportTablesInProgress []*string `type:"list"`

	// The names of tables that have not been yet imported.
	//
	// Valid Values: List of table names
	ImportTablesNotStarted []*string `type:"list"`

	// An optional string to provide additional details about the resize action.
	Message *string `type:"string"`

	// While the resize operation is in progress, this value shows the current amount
	// of data, in megabytes, that has been processed so far. When the resize operation
	// is complete, this value shows the total amount of data, in megabytes, on
	// the cluster, which may be more or less than TotalResizeDataInMegaBytes (the
	// estimated total amount of data before resize).
	ProgressInMegaBytes *int64 `type:"long"`

	// An enum with possible values of ClassicResize and ElasticResize. These values
	// describe the type of resize operation being performed.
	ResizeType *string `type:"string"`

	// The status of the resize operation.
	//
	// Valid Values: NONE | IN_PROGRESS | FAILED | SUCCEEDED | CANCELLING
	Status *string `type:"string"`

	// The cluster type after the resize operation is complete.
	//
	// Valid Values: multi-node | single-node
	TargetClusterType *string `type:"string"`

	// The type of encryption for the cluster after the resize is complete.
	//
	// Possible values are KMS and None. In the China region possible values are:
	// Legacy and None.
	TargetEncryptionType *string `type:"string"`

	// The node type that the cluster will have after the resize operation is complete.
	TargetNodeType *string `type:"string"`

	// The number of nodes that the cluster will have after the resize operation
	// is complete.
	TargetNumberOfNodes *int64 `type:"integer"`

	// The estimated total amount of data, in megabytes, on the cluster before the
	// resize operation began.
	TotalResizeDataInMegaBytes *int64 `type:"long"`
}

// String returns the string representation
func (s DescribeResizeOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeResizeOutput) GoString() string {
	return s.String()
}

// SetAvgResizeRateInMegaBytesPerSecond sets the AvgResizeRateInMegaBytesPerSecond field's value.
func (s *DescribeResizeOutput) SetAvgResizeRateInMegaBytesPerSecond(v float64) *DescribeResizeOutput {
	s.AvgResizeRateInMegaBytesPerSecond = &v
	return s
}

// SetDataTransferProgressPercent sets the DataTransferProgressPercent field's value.
func (s *DescribeResizeOutput) SetDataTransferProgressPercent(v float64) *DescribeResizeOutput {
	s.DataTransferProgressPercent = &v
	return s
}

// SetElapsedTimeInSeconds sets the ElapsedTimeInSeconds field's value.
func (s *DescribeResizeOutput) SetElapsedTimeInSeconds(v int64) *DescribeResizeOutput {
	s.ElapsedTimeInSeconds = &v
	return s
}

// SetEstimatedTimeToCompletionInSeconds sets the EstimatedTimeToCompletionInSeconds field's value.
func (s *DescribeResizeOutput) SetEstimatedTimeToCompletionInSeconds(v int64) *DescribeResizeOutput {
	s.EstimatedTimeToCompletionInSeconds = &v
	return s
}

// SetImportTablesCompleted sets the ImportTablesCompleted field's value.
func (s *DescribeResizeOutput) SetImportTablesCompleted(v []*string) *DescribeResizeOutput {
	s.ImportTablesCompleted = v
	return s
}

// SetImportTablesInProgress sets the ImportTablesInProgress field's value.
func (s *DescribeResizeOutput) SetImportTablesInProgress(v []*string) *DescribeResizeOutput {
	s.ImportTablesInProgress = v
	return s
}

// SetImportTablesNotStarted sets the ImportTablesNotStarted field's value.
func (s *DescribeResizeOutput) SetImportTablesNotStarted(v []*string) *DescribeResizeOutput {
	s.ImportTablesNotStarted = v
	return s
}

// SetMessage sets the Message field's value.
func (s *DescribeResizeOutput) SetMessage(v string) *DescribeResizeOutput {
	s.Message = &v
	return s
}

// SetProgressInMegaBytes sets the ProgressInMegaBytes field's value.
func (s *DescribeResizeOutput) SetProgressInMegaBytes(v int64) *DescribeResizeOutput {
	s.ProgressInMegaBytes = &v
	return s
}

// SetResizeType sets the ResizeType field's value.
func (s *DescribeResizeOutput) SetResizeType(v string) *DescribeResizeOutput {
	s.ResizeType = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *DescribeResizeOutput) SetStatus(v string) *DescribeResizeOutput {
	s.Status = &v
	return s
}

// SetTargetClusterType sets the TargetClusterType field's value.
func (s *DescribeResizeOutput) SetTargetClusterType(v string) *DescribeResizeOutput {
	s.TargetClusterType = &v
	return s
}

// SetTargetEncryptionType sets the TargetEncryptionType field's value.
func (s *DescribeResizeOutput) SetTargetEncryptionType(v string) *DescribeResizeOutput {
	s.TargetEncryptionType = &v
	return s
}

// SetTargetNodeType sets the TargetNodeType field's value.
func (s *DescribeResizeOutput) SetTargetNodeType(v string) *DescribeResizeOutput {
	s.TargetNodeType = &v
	return s
}

// SetTargetNumberOfNodes sets the TargetNumberOfNodes field's value.
func (s *DescribeResizeOutput) SetTargetNumberOfNodes(v int64) *DescribeResizeOutput {
	s.TargetNumberOfNodes = &v
	return s
}

// SetTotalResizeDataInMegaBytes sets the TotalResizeDataInMegaBytes field's value.
func (s *DescribeResizeOutput) SetTotalResizeDataInMegaBytes(v int64) *DescribeResizeOutput {
	s.TotalResizeDataInMegaBytes = &v
	return s
}

type DescribeScheduledActionsInput struct {
	_ struct{} `type:"structure"`

	// If true, retrieve only active scheduled actions. If false, retrieve only
	// disabled scheduled actions.
	Active *bool `type:"boolean"`

	// The end time in UTC of the scheduled action to retrieve. Only active scheduled
	// actions that have invocations before this time are retrieved.
	EndTime *time.Time `type:"timestamp"`

	// List of scheduled action filters.
	Filters []*ScheduledActionFilter `locationNameList:"ScheduledActionFilter" type:"list"`

	// An optional parameter that specifies the starting point to return a set of
	// response records. When the results of a DescribeScheduledActions request
	// exceed the value specified in MaxRecords, AWS returns a value in the Marker
	// field of the response. You can retrieve the next set of response records
	// by providing the returned marker value in the Marker parameter and retrying
	// the request.
	Marker *string `type:"string"`

	// The maximum number of response records to return in each call. If the number
	// of remaining response records exceeds the specified MaxRecords value, a value
	// is returned in a marker field of the response. You can retrieve the next
	// set of records by retrying the command with the returned marker value.
	//
	// Default: 100
	//
	// Constraints: minimum 20, maximum 100.
	MaxRecords *int64 `type:"integer"`

	// The name of the scheduled action to retrieve.
	ScheduledActionName *string `type:"string"`

	// The start time in UTC of the scheduled actions to retrieve. Only active scheduled
	// actions that have invocations after this time are retrieved.
	StartTime *time.Time `type:"timestamp"`

	// The type of the scheduled actions to retrieve.
	TargetActionType *string `type:"string" enum:"ScheduledActionTypeValues"`
}

// String returns the string representation
func (s DescribeScheduledActionsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeScheduledActionsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeScheduledActionsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeScheduledActionsInput"}
	if s.Filters != nil {
		for i, v := range s.Filters {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Filters", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetActive sets the Active field's value.
func (s *DescribeScheduledActionsInput) SetActive(v bool) *DescribeScheduledActionsInput {
	s.Active = &v
	return s
}

// SetEndTime sets the EndTime field's value.
func (s *DescribeScheduledActionsInput) SetEndTime(v time.Time) *DescribeScheduledActionsInput {
	s.EndTime = &v
	return s
}

// SetFilters sets the Filters field's value.
func (s *DescribeScheduledActionsInput) SetFilters(v []*ScheduledActionFilter) *DescribeScheduledActionsInput {
	s.Filters = v
	return s
}

// SetMarker sets the Marker field's value.
func (s *DescribeScheduledActionsInput) SetMarker(v string) *DescribeScheduledActionsInput {
	s.Marker = &v
	return s
}

// SetMaxRecords sets the MaxRecords field's value.
func (s *DescribeScheduledActionsInput) SetMaxRecords(v int64) *DescribeScheduledActionsInput {
	s.MaxRecords = &v
	return s
}

// SetScheduledActionName sets the ScheduledActionName field's value.
func (s *DescribeScheduledActionsInput) SetScheduledActionName(v string) *DescribeScheduledActionsInput {
	s.ScheduledActionName = &v
	return s
}

// SetStartTime sets the StartTime field's value.
func (s *DescribeScheduledActionsInput) SetStartTime(v time.Time) *DescribeScheduledActionsInput {
	s.StartTime = &v
	return s
}

// SetTargetActionType sets the TargetActionType field's value.
func (s *DescribeScheduledActionsInput) SetTargetActionType(v string) *DescribeScheduledActionsInput {
	s.TargetActionType = &v
	return s
}

type DescribeScheduledActionsOutput struct {
	_ struct{} `type:"structure"`

	// An optional parameter that specifies the starting point to return a set of
	// response records. When the results of a DescribeScheduledActions request
	// exceed the value specified in MaxRecords, AWS returns a value in the Marker
	// field of the response. You can retrieve the next set of response records
	// by providing the returned marker value in the Marker parameter and retrying
	// the request.
	Marker *string `type:"string"`

	// List of retrieved scheduled actions.
	ScheduledActions []*ScheduledAction `locationNameList:"ScheduledAction" type:"list"`
}

// String returns the string representation
func (s DescribeScheduledActionsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeScheduledActionsOutput) GoString() string {
	return s.String()
}

// SetMarker sets the Marker field's value.
func (s *DescribeScheduledActionsOutput) SetMarker(v string) *DescribeScheduledActionsOutput {
	s.Marker = &v
	return s
}

// SetScheduledActions sets the ScheduledActions field's value.
func (s *DescribeScheduledActionsOutput) SetScheduledActions(v []*ScheduledAction) *DescribeScheduledActionsOutput {
	s.ScheduledActions = v
	return s
}

// The result of the DescribeSnapshotCopyGrants action.
type DescribeSnapshotCopyGrantsInput struct {
	_ struct{} `type:"structure"`

	// An optional parameter that specifies the starting point to return a set of
	// response records. When the results of a DescribeSnapshotCopyGrant request
	// exceed the value specified in MaxRecords, AWS returns a value in the Marker
	// field of the response. You can retrieve the next set of response records
	// by providing the returned marker value in the Marker parameter and retrying
	// the request.
	//
	// Constraints: You can specify either the SnapshotCopyGrantName parameter or
	// the Marker parameter, but not both.
	Marker *string `type:"string"`

	// The maximum number of response records to return in each call. If the number
	// of remaining response records exceeds the specified MaxRecords value, a value
	// is returned in a marker field of the response. You can retrieve the next
	// set of records by retrying the command with the returned marker value.
	//
	// Default: 100
	//
	// Constraints: minimum 20, maximum 100.
	MaxRecords *int64 `type:"integer"`

	// The name of the snapshot copy grant.
	SnapshotCopyGrantName *string `type:"string"`

	// A tag key or keys for which you want to return all matching resources that
	// are associated with the specified key or keys. For example, suppose that
	// you have resources tagged with keys called owner and environment. If you
	// specify both of these tag keys in the request, Amazon Redshift returns a
	// response with all resources that have either or both of these tag keys associated
	// with them.
	TagKeys []*string `locationNameList:"TagKey" type:"list"`

	// A tag value or values for which you want to return all matching resources
	// that are associated with the specified value or values. For example, suppose
	// that you have resources tagged with values called admin and test. If you
	// specify both of these tag values in the request, Amazon Redshift returns
	// a response with all resources that have either or both of these tag values
	// associated with them.
	TagValues []*string `locationNameList:"TagValue" type:"list"`
}

// String returns the string representation
func (s DescribeSnapshotCopyGrantsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeSnapshotCopyGrantsInput) GoString() string {
	return s.String()
}

// SetMarker sets the Marker field's value.
func (s *DescribeSnapshotCopyGrantsInput) SetMarker(v string) *DescribeSnapshotCopyGrantsInput {
	s.Marker = &v
	return s
}

// SetMaxRecords sets the MaxRecords field's value.
func (s *DescribeSnapshotCopyGrantsInput) SetMaxRecords(v int64) *DescribeSnapshotCopyGrantsInput {
	s.MaxRecords = &v
	return s
}

// SetSnapshotCopyGrantName sets the SnapshotCopyGrantName field's value.
func (s *DescribeSnapshotCopyGrantsInput) SetSnapshotCopyGrantName(v string) *DescribeSnapshotCopyGrantsInput {
	s.SnapshotCopyGrantName = &v
	return s
}

// SetTagKeys sets the TagKeys field's value.
func (s *DescribeSnapshotCopyGrantsInput) SetTagKeys(v []*string) *DescribeSnapshotCopyGrantsInput {
	s.TagKeys = v
	return s
}

// SetTagValues sets the TagValues field's value.
func (s *DescribeSnapshotCopyGrantsInput) SetTagValues(v []*string) *DescribeSnapshotCopyGrantsInput {
	s.TagValues = v
	return s
}

type DescribeSnapshotCopyGrantsOutput struct {
	_ struct{} `type:"structure"`

	// An optional parameter that specifies the starting point to return a set of
	// response records. When the results of a DescribeSnapshotCopyGrant request
	// exceed the value specified in MaxRecords, AWS returns a value in the Marker
	// field of the response. You can retrieve the next set of response records
	// by providing the returned marker value in the Marker parameter and retrying
	// the request.
	//
	// Constraints: You can specify either the SnapshotCopyGrantName parameter or
	// the Marker parameter, but not both.
	Marker *string `type:"string"`

	// The list of SnapshotCopyGrant objects.
	SnapshotCopyGrants []*SnapshotCopyGrant `locationNameList:"SnapshotCopyGrant" type:"list"`
}

// String returns the string representation
func (s DescribeSnapshotCopyGrantsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeSnapshotCopyGrantsOutput) GoString() string {
	return s.String()
}

// SetMarker sets the Marker field's value.
func (s *DescribeSnapshotCopyGrantsOutput) SetMarker(v string) *DescribeSnapshotCopyGrantsOutput {
	s.Marker = &v
	return s
}

// SetSnapshotCopyGrants sets the SnapshotCopyGrants field's value.
func (s *DescribeSnapshotCopyGrantsOutput) SetSnapshotCopyGrants(v []*SnapshotCopyGrant) *DescribeSnapshotCopyGrantsOutput {
	s.SnapshotCopyGrants = v
	return s
}

type DescribeSnapshotSchedulesInput struct {
	_ struct{} `type:"structure"`

	// The unique identifier for the cluster whose snapshot schedules you want to
	// view.
	ClusterIdentifier *string `type:"string"`

	// A value that indicates the starting point for the next set of response records
	// in a subsequent request. If a value is returned in a response, you can retrieve
	// the next set of records by providing this returned marker value in the marker
	// parameter and retrying the command. If the marker field is empty, all response
	// records have been retrieved for the request.
	Marker *string `type:"string"`

	// The maximum number or response records to return in each call. If the number
	// of remaining response records exceeds the specified MaxRecords value, a value
	// is returned in a marker field of the response. You can retrieve the next
	// set of records by retrying the command with the returned marker value.
	MaxRecords *int64 `type:"integer"`

	// A unique identifier for a snapshot schedule.
	ScheduleIdentifier *string `type:"string"`

	// The key value for a snapshot schedule tag.
	TagKeys []*string `locationNameList:"TagKey" type:"list"`

	// The value corresponding to the key of the snapshot schedule tag.
	TagValues []*string `locationNameList:"TagValue" type:"list"`
}

// String returns the string representation
func (s DescribeSnapshotSchedulesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeSnapshotSchedulesInput) GoString() string {
	return s.String()
}

// SetClusterIdentifier sets the ClusterIdentifier field's value.
func (s *DescribeSnapshotSchedulesInput) SetClusterIdentifier(v string) *DescribeSnapshotSchedulesInput {
	s.ClusterIdentifier = &v
	return s
}

// SetMarker sets the Marker field's value.
func (s *DescribeSnapshotSchedulesInput) SetMarker(v string) *DescribeSnapshotSchedulesInput {
	s.Marker = &v
	return s
}

// SetMaxRecords sets the MaxRecords field's value.
func (s *DescribeSnapshotSchedulesInput) SetMaxRecords(v int64) *DescribeSnapshotSchedulesInput {
	s.MaxRecords = &v
	return s
}

// SetScheduleIdentifier sets the ScheduleIdentifier field's value.
func (s *DescribeSnapshotSchedulesInput) SetScheduleIdentifier(v string) *DescribeSnapshotSchedulesInput {
	s.ScheduleIdentifier = &v
	return s
}

// SetTagKeys sets the TagKeys field's value.
func (s *DescribeSnapshotSchedulesInput) SetTagKeys(v []*string) *DescribeSnapshotSchedulesInput {
	s.TagKeys = v
	return s
}

// SetTagValues sets the TagValues field's value.
func (s *DescribeSnapshotSchedulesInput) SetTagValues(v []*string) *DescribeSnapshotSchedulesInput {
	s.TagValues = v
	return s
}

type DescribeSnapshotSchedulesOutput struct {
	_ struct{} `type:"structure"`

	// A value that indicates the starting point for the next set of response records
	// in a subsequent request. If a value is returned in a response, you can retrieve
	// the next set of records by providing this returned marker value in the marker
	// parameter and retrying the command. If the marker field is empty, all response
	// records have been retrieved for the request.
	Marker *string `type:"string"`

	// A list of SnapshotSchedules.
	SnapshotSchedules []*SnapshotSchedule `locationNameList:"SnapshotSchedule" type:"list"`
}

// String returns the string representation
func (s DescribeSnapshotSchedulesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeSnapshotSchedulesOutput) GoString() string {
	return s.String()
}

// SetMarker sets the Marker field's value.
func (s *DescribeSnapshotSchedulesOutput) SetMarker(v string) *DescribeSnapshotSchedulesOutput {
	s.Marker = &v
	return s
}

// SetSnapshotSchedules sets the SnapshotSchedules field's value.
func (s *DescribeSnapshotSchedulesOutput) SetSnapshotSchedules(v []*SnapshotSchedule) *DescribeSnapshotSchedulesOutput {
	s.SnapshotSchedules = v
	return s
}

type DescribeStorageInput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DescribeStorageInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeStorageInput) GoString() string {
	return s.String()
}

type DescribeStorageOutput struct {
	_ struct{} `type:"structure"`

	// The total amount of storage currently used for snapshots.
	TotalBackupSizeInMegaBytes *float64 `type:"double"`

	// The total amount of storage currently provisioned.
	TotalProvisionedStorageInMegaBytes *float64 `type:"double"`
}

// String returns the string representation
func (s DescribeStorageOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeStorageOutput) GoString() string {
	return s.String()
}

// SetTotalBackupSizeInMegaBytes sets the TotalBackupSizeInMegaBytes field's value.
func (s *DescribeStorageOutput) SetTotalBackupSizeInMegaBytes(v float64) *DescribeStorageOutput {
	s.TotalBackupSizeInMegaBytes = &v
	return s
}

// SetTotalProvisionedStorageInMegaBytes sets the TotalProvisionedStorageInMegaBytes field's value.
func (s *DescribeStorageOutput) SetTotalProvisionedStorageInMegaBytes(v float64) *DescribeStorageOutput {
	s.TotalProvisionedStorageInMegaBytes = &v
	return s
}

type DescribeTableRestoreStatusInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Redshift cluster that the table is being restored to.
	ClusterIdentifier *string `type:"string"`

	// An optional pagination token provided by a previous DescribeTableRestoreStatus
	// request. If this parameter is specified, the response includes only records
	// beyond the marker, up to the value specified by the MaxRecords parameter.
	Marker *string `type:"string"`

	// The maximum number of records to include in the response. If more records
	// exist than the specified MaxRecords value, a pagination token called a marker
	// is included in the response so that the remaining results can be retrieved.
	MaxRecords *int64 `type:"integer"`

	// The identifier of the table restore request to return status for. If you
	// don't specify a TableRestoreRequestId value, then DescribeTableRestoreStatus
	// returns the status of all in-progress table restore requests.
	TableRestoreRequestId *string `type:"string"`
}

// String returns the string representation
func (s DescribeTableRestoreStatusInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeTableRestoreStatusInput) GoString() string {
	return s.String()
}

// SetClusterIdentifier sets the ClusterIdentifier field's value.
func (s *DescribeTableRestoreStatusInput) SetClusterIdentifier(v string) *DescribeTableRestoreStatusInput {
	s.ClusterIdentifier = &v
	return s
}

// SetMarker sets the Marker field's value.
func (s *DescribeTableRestoreStatusInput) SetMarker(v string) *DescribeTableRestoreStatusInput {
	s.Marker = &v
	return s
}

// SetMaxRecords sets the MaxRecords field's value.
func (s *DescribeTableRestoreStatusInput) SetMaxRecords(v int64) *DescribeTableRestoreStatusInput {
	s.MaxRecords = &v
	return s
}

// SetTableRestoreRequestId sets the TableRestoreRequestId field's value.
func (s *DescribeTableRestoreStatusInput) SetTableRestoreRequestId(v string) *DescribeTableRestoreStatusInput {
	s.TableRestoreRequestId = &v
	return s
}

type DescribeTableRestoreStatusOutput struct {
	_ struct{} `type:"structure"`

	// A pagination token that can be used in a subsequent DescribeTableRestoreStatus
	// request.
	Marker *string `type:"string"`

	// A list of status details for one or more table restore requests.
	TableRestoreStatusDetails []*TableRestoreStatus `locationNameList:"TableRestoreStatus" type:"list"`
}

// String returns the string representation
func (s DescribeTableRestoreStatusOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeTableRestoreStatusOutput) GoString() string {
	return s.String()
}

// SetMarker sets the Marker field's value.
func (s *DescribeTableRestoreStatusOutput) SetMarker(v string) *DescribeTableRestoreStatusOutput {
	s.Marker = &v
	return s
}

// SetTableRestoreStatusDetails sets the TableRestoreStatusDetails field's value.
func (s *DescribeTableRestoreStatusOutput) SetTableRestoreStatusDetails(v []*TableRestoreStatus) *DescribeTableRestoreStatusOutput {
	s.TableRestoreStatusDetails = v
	return s
}

type DescribeTagsInput struct {
	_ struct{} `type:"structure"`

	// A value that indicates the starting point for the next set of response records
	// in a subsequent request. If a value is returned in a response, you can retrieve
	// the next set of records by providing this returned marker value in the marker
	// parameter and retrying the command. If the marker field is empty, all response
	// records have been retrieved for the request.
	Marker *string `type:"string"`

	// The maximum number or response records to return in each call. If the number
	// of remaining response records exceeds the specified MaxRecords value, a value
	// is returned in a marker field of the response. You can retrieve the next
	// set of records by retrying the command with the returned marker value.
	MaxRecords *int64 `type:"integer"`

	// The Amazon Resource Name (ARN) for which you want to describe the tag or
	// tags. For example, arn:aws:redshift:us-east-2:123456789:cluster:t1.
	ResourceName *string `type:"string"`

	// The type of resource with which you want to view tags. Valid resource types
	// are:
	//
	//    * Cluster
	//
	//    * CIDR/IP
	//
	//    * EC2 security group
	//
	//    * Snapshot
	//
	//    * Cluster security group
	//
	//    * Subnet group
	//
	//    * HSM connection
	//
	//    * HSM certificate
	//
	//    * Parameter group
	//
	//    * Snapshot copy grant
	//
	// For more information about Amazon Redshift resource types and constructing
	// ARNs, go to Specifying Policy Elements: Actions, Effects, Resources, and
	// Principals (https://docs.aws.amazon.com/redshift/latest/mgmt/redshift-iam-access-control-overview.html#redshift-iam-access-control-specify-actions)
	// in the Amazon Redshift Cluster Management Guide.
	ResourceType *string `type:"string"`

	// A tag key or keys for which you want to return all matching resources that
	// are associated with the specified key or keys. For example, suppose that
	// you have resources tagged with keys called owner and environment. If you
	// specify both of these tag keys in the request, Amazon Redshift returns a
	// response with all resources that have either or both of these tag keys associated
	// with them.
	TagKeys []*string `locationNameList:"TagKey" type:"list"`

	// A tag value or values for which you want to return all matching resources
	// that are associated with the specified value or values. For example, suppose
	// that you have resources tagged with values called admin and test. If you
	// specify both of these tag values in the request, Amazon Redshift returns
	// a response with all resources that have either or both of these tag values
	// associated with them.
	TagValues []*string `locationNameList:"TagValue" type:"list"`
}

// String returns the string representation
func (s DescribeTagsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeTagsInput) GoString() string {
	return s.String()
}

// SetMarker sets the Marker field's value.
func (s *DescribeTagsInput) SetMarker(v string) *DescribeTagsInput {
	s.Marker = &v
	return s
}

// SetMaxRecords sets the MaxRecords field's value.
func (s *DescribeTagsInput) SetMaxRecords(v int64) *DescribeTagsInput {
	s.MaxRecords = &v
	return s
}

// SetResourceName sets the ResourceName field's value.
func (s *DescribeTagsInput) SetResourceName(v string) *DescribeTagsInput {
	s.ResourceName = &v
	return s
}

// SetResourceType sets the ResourceType field's value.
func (s *DescribeTagsInput) SetResourceType(v string) *DescribeTagsInput {
	s.ResourceType = &v
	return s
}

// SetTagKeys sets the TagKeys field's value.
func (s *DescribeTagsInput) SetTagKeys(v []*string) *DescribeTagsInput {
	s.TagKeys = v
	return s
}

// SetTagValues sets the TagValues field's value.
func (s *DescribeTagsInput) SetTagValues(v []*string) *DescribeTagsInput {
	s.TagValues = v
	return s
}

type DescribeTagsOutput struct {
	_ struct{} `type:"structure"`

	// A value that indicates the starting point for the next set of response records
	// in a subsequent request. If a value is returned in a response, you can retrieve
	// the next set of records by providing this returned marker value in the Marker
	// parameter and retrying the command. If the Marker field is empty, all response
	// records have been retrieved for the request.
	Marker *string `type:"string"`

	// A list of tags with their associated resources.
	TaggedResources []*TaggedResource `locationNameList:"TaggedResource" type:"list"`
}

// String returns the string representation
func (s DescribeTagsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeTagsOutput) GoString() string {
	return s.String()
}

// SetMarker sets the Marker field's value.
func (s *DescribeTagsOutput) SetMarker(v string) *DescribeTagsOutput {
	s.Marker = &v
	return s
}

// SetTaggedResources sets the TaggedResources field's value.
func (s *DescribeTagsOutput) SetTaggedResources(v []*TaggedResource) *DescribeTagsOutput {
	s.TaggedResources = v
	return s
}

type DisableLoggingInput struct {
	_ struct{} `type:"structure"`

	// The identifier of the cluster on which logging is to be stopped.
	//
	// Example: examplecluster
	//
	// ClusterIdentifier is a required field
	ClusterIdentifier *string `type:"string" required:"true"`
}

// String returns the string representation
func (s DisableLoggingInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DisableLoggingInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DisableLoggingInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DisableLoggingInput"}
	if s.ClusterIdentifier == nil {
		invalidParams.Add(request.NewErrParamRequired("ClusterIdentifier"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClusterIdentifier sets the ClusterIdentifier field's value.
func (s *DisableLoggingInput) SetClusterIdentifier(v string) *DisableLoggingInput {
	s.ClusterIdentifier = &v
	return s
}

type DisableSnapshotCopyInput struct {
	_ struct{} `type:"structure"`

	// The unique identifier of the source cluster that you want to disable copying
	// of snapshots to a destination region.
	//
	// Constraints: Must be the valid name of an existing cluster that has cross-region
	// snapshot copy enabled.
	//
	// ClusterIdentifier is a required field
	ClusterIdentifier *string `type:"string" required:"true"`
}

// String returns the string representation
func (s DisableSnapshotCopyInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DisableSnapshotCopyInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DisableSnapshotCopyInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DisableSnapshotCopyInput"}
	if s.ClusterIdentifier == nil {
		invalidParams.Add(request.NewErrParamRequired("ClusterIdentifier"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClusterIdentifier sets the ClusterIdentifier field's value.
func (s *DisableSnapshotCopyInput) SetClusterIdentifier(v string) *DisableSnapshotCopyInput {
	s.ClusterIdentifier = &v
	return s
}

type DisableSnapshotCopyOutput struct {
	_ struct{} `type:"structure"`

	// Describes a cluster.
	Cluster *Cluster `type:"structure"`
}

// String returns the string representation
func (s DisableSnapshotCopyOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DisableSnapshotCopyOutput) GoString() string {
	return s.String()
}

// SetCluster sets the Cluster field's value.
func (s *DisableSnapshotCopyOutput) SetCluster(v *Cluster) *DisableSnapshotCopyOutput {
	s.Cluster = v
	return s
}

// Describes an Amazon EC2 security group.
type EC2SecurityGroup struct {
	_ struct{} `type:"structure"`

	// The name of the EC2 Security Group.
	EC2SecurityGroupName *string `type:"string"`

	// The AWS ID of the owner of the EC2 security group specified in the EC2SecurityGroupName
	// field.
	EC2SecurityGroupOwnerId *string `type:"string"`

	// The status of the EC2 security group.
	Status *string `type:"string"`

	// The list of tags for the EC2 security group.
	Tags []*Tag `locationNameList:"Tag" type:"list"`
}

// String returns the string representation
func (s EC2SecurityGroup) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s EC2SecurityGroup) GoString() string {
	return s.String()
}

// SetEC2SecurityGroupName sets the EC2SecurityGroupName field's value.
func (s *EC2SecurityGroup) SetEC2SecurityGroupName(v string) *EC2SecurityGroup {
	s.EC2SecurityGroupName = &v
	return s
}

// SetEC2SecurityGroupOwnerId sets the EC2SecurityGroupOwnerId field's value.
func (s *EC2SecurityGroup) SetEC2SecurityGroupOwnerId(v string) *EC2SecurityGroup {
	s.EC2SecurityGroupOwnerId = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *EC2SecurityGroup) SetStatus(v string) *EC2SecurityGroup {
	s.Status = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *EC2SecurityGroup) SetTags(v []*Tag) *EC2SecurityGroup {
	s.Tags = v
	return s
}

// Describes the status of the elastic IP (EIP) address.
type ElasticIpStatus struct {
	_ struct{} `type:"structure"`

	// The elastic IP (EIP) address for the cluster.
	ElasticIp *string `type:"string"`

	// The status of the elastic IP (EIP) address.
	Status *string `type:"string"`
}

// String returns the string representation
func (s ElasticIpStatus) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ElasticIpStatus) GoString() string {
	return s.String()
}

// SetElasticIp sets the ElasticIp field's value.
func (s *ElasticIpStatus) SetElasticIp(v string) *ElasticIpStatus {
	s.ElasticIp = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *ElasticIpStatus) SetStatus(v string) *ElasticIpStatus {
	s.Status = &v
	return s
}

type EnableLoggingInput struct {
	_ struct{} `type:"structure"`

	// The name of an existing S3 bucket where the log files are to be stored.
	//
	// Constraints:
	//
	//    * Must be in the same region as the cluster
	//
	//    * The cluster must have read bucket and put object permissions
	//
	// BucketName is a required field
	BucketName *string `type:"string" required:"true"`

	// The identifier of the cluster on which logging is to be started.
	//
	// Example: examplecluster
	//
	// ClusterIdentifier is a required field
	ClusterIdentifier *string `type:"string" required:"true"`

	// The prefix applied to the log file names.
	//
	// Constraints:
	//
	//    * Cannot exceed 512 characters
	//
	//    * Cannot contain spaces( ), double quotes ("), single quotes ('), a backslash
	//    (\), or control characters. The hexadecimal codes for invalid characters
	//    are: x00 to x20 x22 x27 x5c x7f or larger
	S3KeyPrefix *string `type:"string"`
}

// String returns the string representation
func (s EnableLoggingInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s EnableLoggingInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *EnableLoggingInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "EnableLoggingInput"}
	if s.BucketName == nil {
		invalidParams.Add(request.NewErrParamRequired("BucketName"))
	}
	if s.ClusterIdentifier == nil {
		invalidParams.Add(request.NewErrParamRequired("ClusterIdentifier"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBucketName sets the BucketName field's value.
func (s *EnableLoggingInput) SetBucketName(v string) *EnableLoggingInput {
	s.BucketName = &v
	return s
}

// SetClusterIdentifier sets the ClusterIdentifier field's value.
func (s *EnableLoggingInput) SetClusterIdentifier(v string) *EnableLoggingInput {
	s.ClusterIdentifier = &v
	return s
}

// SetS3KeyPrefix sets the S3KeyPrefix field's value.
func (s *EnableLoggingInput) SetS3KeyPrefix(v string) *EnableLoggingInput {
	s.S3KeyPrefix = &v
	return s
}

type EnableSnapshotCopyInput struct {
	_ struct{} `type:"structure"`

	// The unique identifier of the source cluster to copy snapshots from.
	//
	// Constraints: Must be the valid name of an existing cluster that does not
	// already have cross-region snapshot copy enabled.
	//
	// ClusterIdentifier is a required field
	ClusterIdentifier *string `type:"string" required:"true"`

	// The destination AWS Region that you want to copy snapshots to.
	//
	// Constraints: Must be the name of a valid AWS Region. For more information,
	// see Regions and Endpoints (https://docs.aws.amazon.com/general/latest/gr/rande.html#redshift_region)
	// in the Amazon Web Services General Reference.
	//
	// DestinationRegion is a required field
	DestinationRegion *string `type:"string" required:"true"`

	// The number of days to retain newly copied snapshots in the destination AWS
	// Region after they are copied from the source AWS Region. If the value is
	// -1, the manual snapshot is retained indefinitely.
	//
	// The value must be either -1 or an integer between 1 and 3,653.
	ManualSnapshotRetentionPeriod *int64 `type:"integer"`

	// The number of days to retain automated snapshots in the destination region
	// after they are copied from the source region.
	//
	// Default: 7.
	//
	// Constraints: Must be at least 1 and no more than 35.
	RetentionPeriod *int64 `type:"integer"`

	// The name of the snapshot copy grant to use when snapshots of an AWS KMS-encrypted
	// cluster are copied to the destination region.
	SnapshotCopyGrantName *string `type:"string"`
}

// String returns the string representation
func (s EnableSnapshotCopyInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s EnableSnapshotCopyInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *EnableSnapshotCopyInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "EnableSnapshotCopyInput"}
	if s.ClusterIdentifier == nil {
		invalidParams.Add(request.NewErrParamRequired("ClusterIdentifier"))
	}
	if s.DestinationRegion == nil {
		invalidParams.Add(request.NewErrParamRequired("DestinationRegion"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClusterIdentifier sets the ClusterIdentifier field's value.
func (s *EnableSnapshotCopyInput) SetClusterIdentifier(v string) *EnableSnapshotCopyInput {
	s.ClusterIdentifier = &v
	return s
}

// SetDestinationRegion sets the DestinationRegion field's value.
func (s *EnableSnapshotCopyInput) SetDestinationRegion(v string) *EnableSnapshotCopyInput {
	s.DestinationRegion = &v
	return s
}

// SetManualSnapshotRetentionPeriod sets the ManualSnapshotRetentionPeriod field's value.
func (s *EnableSnapshotCopyInput) SetManualSnapshotRetentionPeriod(v int64) *EnableSnapshotCopyInput {
	s.ManualSnapshotRetentionPeriod = &v
	return s
}

// SetRetentionPeriod sets the RetentionPeriod field's value.
func (s *EnableSnapshotCopyInput) SetRetentionPeriod(v int64) *EnableSnapshotCopyInput {
	s.RetentionPeriod = &v
	return s
}

// SetSnapshotCopyGrantName sets the SnapshotCopyGrantName field's value.
func (s *EnableSnapshotCopyInput) SetSnapshotCopyGrantName(v string) *EnableSnapshotCopyInput {
	s.SnapshotCopyGrantName = &v
	return s
}

type EnableSnapshotCopyOutput struct {
	_ struct{} `type:"structure"`

	// Describes a cluster.
	Cluster *Cluster `type:"structure"`
}

// String returns the string representation
func (s EnableSnapshotCopyOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s EnableSnapshotCopyOutput) GoString() string {
	return s.String()
}

// SetCluster sets the Cluster field's value.
func (s *EnableSnapshotCopyOutput) SetCluster(v *Cluster) *EnableSnapshotCopyOutput {
	s.Cluster = v
	return s
}

// Describes a connection endpoint.
type Endpoint struct {
	_ struct{} `type:"structure"`

	// The DNS address of the Cluster.
	Address *string `type:"string"`

	// The port that the database engine is listening on.
	Port *int64 `type:"integer"`
}

// String returns the string representation
func (s Endpoint) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Endpoint) GoString() string {
	return s.String()
}

// SetAddress sets the Address field's value.
func (s *Endpoint) SetAddress(v string) *Endpoint {
	s.Address = &v
	return s
}

// SetPort sets the Port field's value.
func (s *Endpoint) SetPort(v int64) *Endpoint {
	s.Port = &v
	return s
}

// Describes an event.
type Event struct {
	_ struct{} `type:"structure"`

	// The date and time of the event.
	Date *time.Time `type:"timestamp"`

	// A list of the event categories.
	//
	// Values: Configuration, Management, Monitoring, Security
	EventCategories []*string `locationNameList:"EventCategory" type:"list"`

	// The identifier of the event.
	EventId *string `type:"string"`

	// The text of this event.
	Message *string `type:"string"`

	// The severity of the event.
	//
	// Values: ERROR, INFO
	Severity *string `type:"string"`

	// The identifier for the source of the event.
	SourceIdentifier *string `type:"string"`

	// The source type for this event.
	SourceType *string `type:"string" enum:"SourceType"`
}

// String returns the string representation
func (s Event) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Event) GoString() string {
	return s.String()
}

// SetDate sets the Date field's value.
func (s *Event) SetDate(v time.Time) *Event {
	s.Date = &v
	return s
}

// SetEventCategories sets the EventCategories field's value.
func (s *Event) SetEventCategories(v []*string) *Event {
	s.EventCategories = v
	return s
}

// SetEventId sets the EventId field's value.
func (s *Event) SetEventId(v string) *Event {
	s.EventId = &v
	return s
}

// SetMessage sets the Message field's value.
func (s *Event) SetMessage(v string) *Event {
	s.Message = &v
	return s
}

// SetSeverity sets the Severity field's value.
func (s *Event) SetSeverity(v string) *Event {
	s.Severity = &v
	return s
}

// SetSourceIdentifier sets the SourceIdentifier field's value.
func (s *Event) SetSourceIdentifier(v string) *Event {
	s.SourceIdentifier = &v
	return s
}

// SetSourceType sets the SourceType field's value.
func (s *Event) SetSourceType(v string) *Event {
	s.SourceType = &v
	return s
}

// Describes event categories.
type EventCategoriesMap struct {
	_ struct{} `type:"structure"`

	// The events in the event category.
	Events []*EventInfoMap `locationNameList:"EventInfoMap" type:"list"`

	// The source type, such as cluster or cluster-snapshot, that the returned categories
	// belong to.
	SourceType *string `type:"string"`
}

// String returns the string representation
func (s EventCategoriesMap) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s EventCategoriesMap) GoString() string {
	return s.String()
}

// SetEvents sets the Events field's value.
func (s *EventCategoriesMap) SetEvents(v []*EventInfoMap) *EventCategoriesMap {
	s.Events = v
	return s
}

// SetSourceType sets the SourceType field's value.
func (s *EventCategoriesMap) SetSourceType(v string) *EventCategoriesMap {
	s.SourceType = &v
	return s
}

// Describes event information.
type EventInfoMap struct {
	_ struct{} `type:"structure"`

	// The category of an Amazon Redshift event.
	EventCategories []*string `locationNameList:"EventCategory" type:"list"`

	// The description of an Amazon Redshift event.
	EventDescription *string `type:"string"`

	// The identifier of an Amazon Redshift event.
	EventId *string `type:"string"`

	// The severity of the event.
	//
	// Values: ERROR, INFO
	Severity *string `type:"string"`
}

// String returns the string representation
func (s EventInfoMap) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s EventInfoMap) GoString() string {
	return s.String()
}

// SetEventCategories sets the EventCategories field's value.
func (s *EventInfoMap) SetEventCategories(v []*string) *EventInfoMap {
	s.EventCategories = v
	return s
}

// SetEventDescription sets the EventDescription field's value.
func (s *EventInfoMap) SetEventDescription(v string) *EventInfoMap {
	s.EventDescription = &v
	return s
}

// SetEventId sets the EventId field's value.
func (s *EventInfoMap) SetEventId(v string) *EventInfoMap {
	s.EventId = &v
	return s
}

// SetSeverity sets the Severity field's value.
func (s *EventInfoMap) SetSeverity(v string) *EventInfoMap {
	s.Severity = &v
	return s
}

// Describes event subscriptions.
type EventSubscription struct {
	_ struct{} `type:"structure"`

	// The name of the Amazon Redshift event notification subscription.
	CustSubscriptionId *string `type:"string"`

	// The AWS customer account associated with the Amazon Redshift event notification
	// subscription.
	CustomerAwsId *string `type:"string"`

	// A boolean value indicating whether the subscription is enabled; true indicates
	// that the subscription is enabled.
	Enabled *bool `type:"boolean"`

	// The list of Amazon Redshift event categories specified in the event notification
	// subscription.
	//
	// Values: Configuration, Management, Monitoring, Security
	EventCategoriesList []*string `locationNameList:"EventCategory" type:"list"`

	// The event severity specified in the Amazon Redshift event notification subscription.
	//
	// Values: ERROR, INFO
	Severity *string `type:"string"`

	// The Amazon Resource Name (ARN) of the Amazon SNS topic used by the event
	// notification subscription.
	SnsTopicArn *string `type:"string"`

	// A list of the sources that publish events to the Amazon Redshift event notification
	// subscription.
	SourceIdsList []*string `locationNameList:"SourceId" type:"list"`

	// The source type of the events returned by the Amazon Redshift event notification,
	// such as cluster, cluster-snapshot, cluster-parameter-group, cluster-security-group,
	// or scheduled-action.
	SourceType *string `type:"string"`

	// The status of the Amazon Redshift event notification subscription.
	//
	// Constraints:
	//
	//    * Can be one of the following: active | no-permission | topic-not-exist
	//
	//    * The status "no-permission" indicates that Amazon Redshift no longer
	//    has permission to post to the Amazon SNS topic. The status "topic-not-exist"
	//    indicates that the topic was deleted after the subscription was created.
	Status *string `type:"string"`

	// The date and time the Amazon Redshift event notification subscription was
	// created.
	SubscriptionCreationTime *time.Time `type:"timestamp"`

	// The list of tags for the event subscription.
	Tags []*Tag `locationNameList:"Tag" type:"list"`
}

// String returns the string representation
func (s EventSubscription) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s EventSubscription) GoString() string {
	return s.String()
}

// SetCustSubscriptionId sets the CustSubscriptionId field's value.
func (s *EventSubscription) SetCustSubscriptionId(v string) *EventSubscription {
	s.CustSubscriptionId = &v
	return s
}

// SetCustomerAwsId sets the CustomerAwsId field's value.
func (s *EventSubscription) SetCustomerAwsId(v string) *EventSubscription {
	s.CustomerAwsId = &v
	return s
}

// SetEnabled sets the Enabled field's value.
func (s *EventSubscription) SetEnabled(v bool) *EventSubscription {
	s.Enabled = &v
	return s
}

// SetEventCategoriesList sets the EventCategoriesList field's value.
func (s *EventSubscription) SetEventCategoriesList(v []*string) *EventSubscription {
	s.EventCategoriesList = v
	return s
}

// SetSeverity sets the Severity field's value.
func (s *EventSubscription) SetSeverity(v string) *EventSubscription {
	s.Severity = &v
	return s
}

// SetSnsTopicArn sets the SnsTopicArn field's value.
func (s *EventSubscription) SetSnsTopicArn(v string) *EventSubscription {
	s.SnsTopicArn = &v
	return s
}

// SetSourceIdsList sets the SourceIdsList field's value.
func (s *EventSubscription) SetSourceIdsList(v []*string) *EventSubscription {
	s.SourceIdsList = v
	return s
}

// SetSourceType sets the SourceType field's value.
func (s *EventSubscription) SetSourceType(v string) *EventSubscription {
	s.SourceType = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *EventSubscription) SetStatus(v string) *EventSubscription {
	s.Status = &v
	return s
}

// SetSubscriptionCreationTime sets the SubscriptionCreationTime field's value.
func (s *EventSubscription) SetSubscriptionCreationTime(v time.Time) *EventSubscription {
	s.SubscriptionCreationTime = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *EventSubscription) SetTags(v []*Tag) *EventSubscription {
	s.Tags = v
	return s
}

// The request parameters to get cluster credentials.
type GetClusterCredentialsInput struct {
	_ struct{} `type:"structure"`

	// Create a database user with the name specified for the user named in DbUser
	// if one does not exist.
	AutoCreate *bool `type:"boolean"`

	// The unique identifier of the cluster that contains the database for which
	// your are requesting credentials. This parameter is case sensitive.
	//
	// ClusterIdentifier is a required field
	ClusterIdentifier *string `type:"string" required:"true"`

	// A list of the names of existing database groups that the user named in DbUser
	// will join for the current session, in addition to any group memberships for
	// an existing user. If not specified, a new user is added only to PUBLIC.
	//
	// Database group name constraints
	//
	//    * Must be 1 to 64 alphanumeric characters or hyphens
	//
	//    * Must contain only lowercase letters, numbers, underscore, plus sign,
	//    period (dot), at symbol (@), or hyphen.
	//
	//    * First character must be a letter.
	//
	//    * Must not contain a colon ( : ) or slash ( / ).
	//
	//    * Cannot be a reserved word. A list of reserved words can be found in
	//    Reserved Words (http://docs.aws.amazon.com/redshift/latest/dg/r_pg_keywords.html)
	//    in the Amazon Redshift Database Developer Guide.
	DbGroups []*string `locationNameList:"DbGroup" type:"list"`

	// The name of a database that DbUser is authorized to log on to. If DbName
	// is not specified, DbUser can log on to any existing database.
	//
	// Constraints:
	//
	//    * Must be 1 to 64 alphanumeric characters or hyphens
	//
	//    * Must contain only lowercase letters, numbers, underscore, plus sign,
	//    period (dot), at symbol (@), or hyphen.
	//
	//    * First character must be a letter.
	//
	//    * Must not contain a colon ( : ) or slash ( / ).
	//
	//    * Cannot be a reserved word. A list of reserved words can be found in
	//    Reserved Words (http://docs.aws.amazon.com/redshift/latest/dg/r_pg_keywords.html)
	//    in the Amazon Redshift Database Developer Guide.
	DbName *string `type:"string"`

	// The name of a database user. If a user name matching DbUser exists in the
	// database, the temporary user credentials have the same permissions as the
	// existing user. If DbUser doesn't exist in the database and Autocreate is
	// True, a new user is created using the value for DbUser with PUBLIC permissions.
	// If a database user matching the value for DbUser doesn't exist and Autocreate
	// is False, then the command succeeds but the connection attempt will fail
	// because the user doesn't exist in the database.
	//
	// For more information, see CREATE USER (https://docs.aws.amazon.com/redshift/latest/dg/r_CREATE_USER.html)
	// in the Amazon Redshift Database Developer Guide.
	//
	// Constraints:
	//
	//    * Must be 1 to 64 alphanumeric characters or hyphens. The user name can't
	//    be PUBLIC.
	//
	//    * Must contain only lowercase letters, numbers, underscore, plus sign,
	//    period (dot), at symbol (@), or hyphen.
	//
	//    * First character must be a letter.
	//
	//    * Must not contain a colon ( : ) or slash ( / ).
	//
	//    * Cannot be a reserved word. A list of reserved words can be found in
	//    Reserved Words (http://docs.aws.amazon.com/redshift/latest/dg/r_pg_keywords.html)
	//    in the Amazon Redshift Database Developer Guide.
	//
	// DbUser is a required field
	DbUser *string `type:"string" required:"true"`

	// The number of seconds until the returned temporary password expires.
	//
	// Constraint: minimum 900, maximum 3600.
	//
	// Default: 900
	DurationSeconds *int64 `type:"integer"`
}

// String returns the string representation
func (s GetClusterCredentialsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetClusterCredentialsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetClusterCredentialsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetClusterCredentialsInput"}
	if s.ClusterIdentifier == nil {
		invalidParams.Add(request.NewErrParamRequired("ClusterIdentifier"))
	}
	if s.DbUser == nil {
		invalidParams.Add(request.NewErrParamRequired("DbUser"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAutoCreate sets the AutoCreate field's value.
func (s *GetClusterCredentialsInput) SetAutoCreate(v bool) *GetClusterCredentialsInput {
	s.AutoCreate = &v
	return s
}

// SetClusterIdentifier sets the ClusterIdentifier field's value.
func (s *GetClusterCredentialsInput) SetClusterIdentifier(v string) *GetClusterCredentialsInput {
	s.ClusterIdentifier = &v
	return s
}

// SetDbGroups sets the DbGroups field's value.
func (s *GetClusterCredentialsInput) SetDbGroups(v []*string) *GetClusterCredentialsInput {
	s.DbGroups = v
	return s
}

// SetDbName sets the DbName field's value.
func (s *GetClusterCredentialsInput) SetDbName(v string) *GetClusterCredentialsInput {
	s.DbName = &v
	return s
}

// SetDbUser sets the DbUser field's value.
func (s *GetClusterCredentialsInput) SetDbUser(v string) *GetClusterCredentialsInput {
	s.DbUser = &v
	return s
}

// SetDurationSeconds sets the DurationSeconds field's value.
func (s *GetClusterCredentialsInput) SetDurationSeconds(v int64) *GetClusterCredentialsInput {
	s.DurationSeconds = &v
	return s
}

// Temporary credentials with authorization to log on to an Amazon Redshift
// database.
type GetClusterCredentialsOutput struct {
	_ struct{} `type:"structure"`

	// A temporary password that authorizes the user name returned by DbUser to
	// log on to the database DbName.
	DbPassword *string `type:"string" sensitive:"true"`

	// A database user name that is authorized to log on to the database DbName
	// using the password DbPassword. If the specified DbUser exists in the database,
	// the new user name has the same database privileges as the the user named
	// in DbUser. By default, the user is added to PUBLIC. If the DbGroups parameter
	// is specifed, DbUser is added to the listed groups for any sessions created
	// using these credentials.
	DbUser *string `type:"string"`

	// The date and time the password in DbPassword expires.
	Expiration *time.Time `type:"timestamp"`
}

// String returns the string representation
func (s GetClusterCredentialsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetClusterCredentialsOutput) GoString() string {
	return s.String()
}

// SetDbPassword sets the DbPassword field's value.
func (s *GetClusterCredentialsOutput) SetDbPassword(v string) *GetClusterCredentialsOutput {
	s.DbPassword = &v
	return s
}

// SetDbUser sets the DbUser field's value.
func (s *GetClusterCredentialsOutput) SetDbUser(v string) *GetClusterCredentialsOutput {
	s.DbUser = &v
	return s
}

// SetExpiration sets the Expiration field's value.
func (s *GetClusterCredentialsOutput) SetExpiration(v time.Time) *GetClusterCredentialsOutput {
	s.Expiration = &v
	return s
}

type GetReservedNodeExchangeOfferingsInput struct {
	_ struct{} `type:"structure"`

	// A value that indicates the starting point for the next set of ReservedNodeOfferings.
	Marker *string `type:"string"`

	// An integer setting the maximum number of ReservedNodeOfferings to retrieve.
	MaxRecords *int64 `type:"integer"`

	// A string representing the node identifier for the DC1 Reserved Node to be
	// exchanged.
	//
	// ReservedNodeId is a required field
	ReservedNodeId *string `type:"string" required:"true"`
}

// String returns the string representation
func (s GetReservedNodeExchangeOfferingsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetReservedNodeExchangeOfferingsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetReservedNodeExchangeOfferingsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetReservedNodeExchangeOfferingsInput"}
	if s.ReservedNodeId == nil {
		invalidParams.Add(request.NewErrParamRequired("ReservedNodeId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMarker sets the Marker field's value.
func (s *GetReservedNodeExchangeOfferingsInput) SetMarker(v string) *GetReservedNodeExchangeOfferingsInput {
	s.Marker = &v
	return s
}

// SetMaxRecords sets the MaxRecords field's value.
func (s *GetReservedNodeExchangeOfferingsInput) SetMaxRecords(v int64) *GetReservedNodeExchangeOfferingsInput {
	s.MaxRecords = &v
	return s
}

// SetReservedNodeId sets the ReservedNodeId field's value.
func (s *GetReservedNodeExchangeOfferingsInput) SetReservedNodeId(v string) *GetReservedNodeExchangeOfferingsInput {
	s.ReservedNodeId = &v
	return s
}

type GetReservedNodeExchangeOfferingsOutput struct {
	_ struct{} `type:"structure"`

	// An optional parameter that specifies the starting point for returning a set
	// of response records. When the results of a GetReservedNodeExchangeOfferings
	// request exceed the value specified in MaxRecords, Amazon Redshift returns
	// a value in the marker field of the response. You can retrieve the next set
	// of response records by providing the returned marker value in the marker
	// parameter and retrying the request.
	Marker *string `type:"string"`

	// Returns an array of ReservedNodeOffering objects.
	ReservedNodeOfferings []*ReservedNodeOffering `locationNameList:"ReservedNodeOffering" type:"list"`
}

// String returns the string representation
func (s GetReservedNodeExchangeOfferingsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetReservedNodeExchangeOfferingsOutput) GoString() string {
	return s.String()
}

// SetMarker sets the Marker field's value.
func (s *GetReservedNodeExchangeOfferingsOutput) SetMarker(v string) *GetReservedNodeExchangeOfferingsOutput {
	s.Marker = &v
	return s
}

// SetReservedNodeOfferings sets the ReservedNodeOfferings field's value.
func (s *GetReservedNodeExchangeOfferingsOutput) SetReservedNodeOfferings(v []*ReservedNodeOffering) *GetReservedNodeExchangeOfferingsOutput {
	s.ReservedNodeOfferings = v
	return s
}

// Returns information about an HSM client certificate. The certificate is stored
// in a secure Hardware Storage Module (HSM), and used by the Amazon Redshift
// cluster to encrypt data files.
type HsmClientCertificate struct {
	_ struct{} `type:"structure"`

	// The identifier of the HSM client certificate.
	HsmClientCertificateIdentifier *string `type:"string"`

	// The public key that the Amazon Redshift cluster will use to connect to the
	// HSM. You must register the public key in the HSM.
	HsmClientCertificatePublicKey *string `type:"string"`

	// The list of tags for the HSM client certificate.
	Tags []*Tag `locationNameList:"Tag" type:"list"`
}

// String returns the string representation
func (s HsmClientCertificate) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s HsmClientCertificate) GoString() string {
	return s.String()
}

// SetHsmClientCertificateIdentifier sets the HsmClientCertificateIdentifier field's value.
func (s *HsmClientCertificate) SetHsmClientCertificateIdentifier(v string) *HsmClientCertificate {
	s.HsmClientCertificateIdentifier = &v
	return s
}

// SetHsmClientCertificatePublicKey sets the HsmClientCertificatePublicKey field's value.
func (s *HsmClientCertificate) SetHsmClientCertificatePublicKey(v string) *HsmClientCertificate {
	s.HsmClientCertificatePublicKey = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *HsmClientCertificate) SetTags(v []*Tag) *HsmClientCertificate {
	s.Tags = v
	return s
}

// Returns information about an HSM configuration, which is an object that describes
// to Amazon Redshift clusters the information they require to connect to an
// HSM where they can store database encryption keys.
type HsmConfiguration struct {
	_ struct{} `type:"structure"`

	// A text description of the HSM configuration.
	Description *string `type:"string"`

	// The name of the Amazon Redshift HSM configuration.
	HsmConfigurationIdentifier *string `type:"string"`

	// The IP address that the Amazon Redshift cluster must use to access the HSM.
	HsmIpAddress *string `type:"string"`

	// The name of the partition in the HSM where the Amazon Redshift clusters will
	// store their database encryption keys.
	HsmPartitionName *string `type:"string"`

	// The list of tags for the HSM configuration.
	Tags []*Tag `locationNameList:"Tag" type:"list"`
}

// String returns the string representation
func (s HsmConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s HsmConfiguration) GoString() string {
	return s.String()
}

// SetDescription sets the Description field's value.
func (s *HsmConfiguration) SetDescription(v string) *HsmConfiguration {
	s.Description = &v
	return s
}

// SetHsmConfigurationIdentifier sets the HsmConfigurationIdentifier field's value.
func (s *HsmConfiguration) SetHsmConfigurationIdentifier(v string) *HsmConfiguration {
	s.HsmConfigurationIdentifier = &v
	return s
}

// SetHsmIpAddress sets the HsmIpAddress field's value.
func (s *HsmConfiguration) SetHsmIpAddress(v string) *HsmConfiguration {
	s.HsmIpAddress = &v
	return s
}

// SetHsmPartitionName sets the HsmPartitionName field's value.
func (s *HsmConfiguration) SetHsmPartitionName(v string) *HsmConfiguration {
	s.HsmPartitionName = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *HsmConfiguration) SetTags(v []*Tag) *HsmConfiguration {
	s.Tags = v
	return s
}

// Describes the status of changes to HSM settings.
type HsmStatus struct {
	_ struct{} `type:"structure"`

	// Specifies the name of the HSM client certificate the Amazon Redshift cluster
	// uses to retrieve the data encryption keys stored in an HSM.
	HsmClientCertificateIdentifier *string `type:"string"`

	// Specifies the name of the HSM configuration that contains the information
	// the Amazon Redshift cluster can use to retrieve and store keys in an HSM.
	HsmConfigurationIdentifier *string `type:"string"`

	// Reports whether the Amazon Redshift cluster has finished applying any HSM
	// settings changes specified in a modify cluster command.
	//
	// Values: active, applying
	Status *string `type:"string"`
}

// String returns the string representation
func (s HsmStatus) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s HsmStatus) GoString() string {
	return s.String()
}

// SetHsmClientCertificateIdentifier sets the HsmClientCertificateIdentifier field's value.
func (s *HsmStatus) SetHsmClientCertificateIdentifier(v string) *HsmStatus {
	s.HsmClientCertificateIdentifier = &v
	return s
}

// SetHsmConfigurationIdentifier sets the HsmConfigurationIdentifier field's value.
func (s *HsmStatus) SetHsmConfigurationIdentifier(v string) *HsmStatus {
	s.HsmConfigurationIdentifier = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *HsmStatus) SetStatus(v string) *HsmStatus {
	s.Status = &v
	return s
}

// Describes an IP range used in a security group.
type IPRange struct {
	_ struct{} `type:"structure"`

	// The IP range in Classless Inter-Domain Routing (CIDR) notation.
	CIDRIP *string `type:"string"`

	// The status of the IP range, for example, "authorized".
	Status *string `type:"string"`

	// The list of tags for the IP range.
	Tags []*Tag `locationNameList:"Tag" type:"list"`
}

// String returns the string representation
func (s IPRange) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s IPRange) GoString() string {
	return s.String()
}

// SetCIDRIP sets the CIDRIP field's value.
func (s *IPRange) SetCIDRIP(v string) *IPRange {
	s.CIDRIP = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *IPRange) SetStatus(v string) *IPRange {
	s.Status = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *IPRange) SetTags(v []*Tag) *IPRange {
	s.Tags = v
	return s
}

// Describes the status of logging for a cluster.
type LoggingStatus struct {
	_ struct{} `type:"structure"`

	// The name of the S3 bucket where the log files are stored.
	BucketName *string `type:"string"`

	// The message indicating that logs failed to be delivered.
	LastFailureMessage *string `type:"string"`

	// The last time when logs failed to be delivered.
	LastFailureTime *time.Time `type:"timestamp"`

	// The last time that logs were delivered.
	LastSuccessfulDeliveryTime *time.Time `type:"timestamp"`

	// true if logging is on, false if logging is off.
	LoggingEnabled *bool `type:"boolean"`

	// The prefix applied to the log file names.
	S3KeyPrefix *string `type:"string"`
}

// String returns the string representation
func (s LoggingStatus) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s LoggingStatus) GoString() string {
	return s.String()
}

// SetBucketName sets the BucketName field's value.
func (s *LoggingStatus) SetBucketName(v string) *LoggingStatus {
	s.BucketName = &v
	return s
}

// SetLastFailureMessage sets the LastFailureMessage field's value.
func (s *LoggingStatus) SetLastFailureMessage(v string) *LoggingStatus {
	s.LastFailureMessage = &v
	return s
}

// SetLastFailureTime sets the LastFailureTime field's value.
func (s *LoggingStatus) SetLastFailureTime(v time.Time) *LoggingStatus {
	s.LastFailureTime = &v
	return s
}

// SetLastSuccessfulDeliveryTime sets the LastSuccessfulDeliveryTime field's value.
func (s *LoggingStatus) SetLastSuccessfulDeliveryTime(v time.Time) *LoggingStatus {
	s.LastSuccessfulDeliveryTime = &v
	return s
}

// SetLoggingEnabled sets the LoggingEnabled field's value.
func (s *LoggingStatus) SetLoggingEnabled(v bool) *LoggingStatus {
	s.LoggingEnabled = &v
	return s
}

// SetS3KeyPrefix sets the S3KeyPrefix field's value.
func (s *LoggingStatus) SetS3KeyPrefix(v string) *LoggingStatus {
	s.S3KeyPrefix = &v
	return s
}

// Defines a maintenance track that determines which Amazon Redshift version
// to apply during a maintenance window. If the value for MaintenanceTrack is
// current, the cluster is updated to the most recently certified maintenance
// release. If the value is trailing, the cluster is updated to the previously
// certified maintenance release.
type MaintenanceTrack struct {
	_ struct{} `type:"structure"`

	// The version number for the cluster release.
	DatabaseVersion *string `type:"string"`

	// The name of the maintenance track. Possible values are current and trailing.
	MaintenanceTrackName *string `type:"string"`

	// An array of UpdateTarget objects to update with the maintenance track.
	UpdateTargets []*UpdateTarget `locationNameList:"UpdateTarget" type:"list"`
}

// String returns the string representation
func (s MaintenanceTrack) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s MaintenanceTrack) GoString() string {
	return s.String()
}

// SetDatabaseVersion sets the DatabaseVersion field's value.
func (s *MaintenanceTrack) SetDatabaseVersion(v string) *MaintenanceTrack {
	s.DatabaseVersion = &v
	return s
}

// SetMaintenanceTrackName sets the MaintenanceTrackName field's value.
func (s *MaintenanceTrack) SetMaintenanceTrackName(v string) *MaintenanceTrack {
	s.MaintenanceTrackName = &v
	return s
}

// SetUpdateTargets sets the UpdateTargets field's value.
func (s *MaintenanceTrack) SetUpdateTargets(v []*UpdateTarget) *MaintenanceTrack {
	s.UpdateTargets = v
	return s
}

type ModifyClusterDbRevisionInput struct {
	_ struct{} `type:"structure"`

	// The unique identifier of a cluster whose database revision you want to modify.
	//
	// Example: examplecluster
	//
	// ClusterIdentifier is a required field
	ClusterIdentifier *string `type:"string" required:"true"`

	// The identifier of the database revision. You can retrieve this value from
	// the response to the DescribeClusterDbRevisions request.
	//
	// RevisionTarget is a required field
	RevisionTarget *string `type:"string" required:"true"`
}

// String returns the string representation
func (s ModifyClusterDbRevisionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ModifyClusterDbRevisionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ModifyClusterDbRevisionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ModifyClusterDbRevisionInput"}
	if s.ClusterIdentifier == nil {
		invalidParams.Add(request.NewErrParamRequired("ClusterIdentifier"))
	}
	if s.RevisionTarget == nil {
		invalidParams.Add(request.NewErrParamRequired("RevisionTarget"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClusterIdentifier sets the ClusterIdentifier field's value.
func (s *ModifyClusterDbRevisionInput) SetClusterIdentifier(v string) *ModifyClusterDbRevisionInput {
	s.ClusterIdentifier = &v
	return s
}

// SetRevisionTarget sets the RevisionTarget field's value.
func (s *ModifyClusterDbRevisionInput) SetRevisionTarget(v string) *ModifyClusterDbRevisionInput {
	s.RevisionTarget = &v
	return s
}

type ModifyClusterDbRevisionOutput struct {
	_ struct{} `type:"structure"`

	// Describes a cluster.
	Cluster *Cluster `type:"structure"`
}

// String returns the string representation
func (s ModifyClusterDbRevisionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ModifyClusterDbRevisionOutput) GoString() string {
	return s.String()
}

// SetCluster sets the Cluster field's value.
func (s *ModifyClusterDbRevisionOutput) SetCluster(v *Cluster) *ModifyClusterDbRevisionOutput {
	s.Cluster = v
	return s
}

type ModifyClusterIamRolesInput struct {
	_ struct{} `type:"structure"`

	// Zero or more IAM roles to associate with the cluster. The roles must be in
	// their Amazon Resource Name (ARN) format. You can associate up to 10 IAM roles
	// with a single cluster in a single request.
	AddIamRoles []*string `locationNameList:"IamRoleArn" type:"list"`

	// The unique identifier of the cluster for which you want to associate or disassociate
	// IAM roles.
	//
	// ClusterIdentifier is a required field
	ClusterIdentifier *string `type:"string" required:"true"`

	// Zero or more IAM roles in ARN format to disassociate from the cluster. You
	// can disassociate up to 10 IAM roles from a single cluster in a single request.
	RemoveIamRoles []*string `locationNameList:"IamRoleArn" type:"list"`
}

// String returns the string representation
func (s ModifyClusterIamRolesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ModifyClusterIamRolesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ModifyClusterIamRolesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ModifyClusterIamRolesInput"}
	if s.ClusterIdentifier == nil {
		invalidParams.Add(request.NewErrParamRequired("ClusterIdentifier"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAddIamRoles sets the AddIamRoles field's value.
func (s *ModifyClusterIamRolesInput) SetAddIamRoles(v []*string) *ModifyClusterIamRolesInput {
	s.AddIamRoles = v
	return s
}

// SetClusterIdentifier sets the ClusterIdentifier field's value.
func (s *ModifyClusterIamRolesInput) SetClusterIdentifier(v string) *ModifyClusterIamRolesInput {
	s.ClusterIdentifier = &v
	return s
}

// SetRemoveIamRoles sets the RemoveIamRoles field's value.
func (s *ModifyClusterIamRolesInput) SetRemoveIamRoles(v []*string) *ModifyClusterIamRolesInput {
	s.RemoveIamRoles = v
	return s
}

type ModifyClusterIamRolesOutput struct {
	_ struct{} `type:"structure"`

	// Describes a cluster.
	Cluster *Cluster `type:"structure"`
}

// String returns the string representation
func (s ModifyClusterIamRolesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ModifyClusterIamRolesOutput) GoString() string {
	return s.String()
}

// SetCluster sets the Cluster field's value.
func (s *ModifyClusterIamRolesOutput) SetCluster(v *Cluster) *ModifyClusterIamRolesOutput {
	s.Cluster = v
	return s
}

type ModifyClusterInput struct {
	_ struct{} `type:"structure"`

	// If true, major version upgrades will be applied automatically to the cluster
	// during the maintenance window.
	//
	// Default: false
	AllowVersionUpgrade *bool `type:"boolean"`

	// The number of days that automated snapshots are retained. If the value is
	// 0, automated snapshots are disabled. Even if automated snapshots are disabled,
	// you can still create manual snapshots when you want with CreateClusterSnapshot.
	//
	// If you decrease the automated snapshot retention period from its current
	// value, existing automated snapshots that fall outside of the new retention
	// period will be immediately deleted.
	//
	// Default: Uses existing setting.
	//
	// Constraints: Must be a value from 0 to 35.
	AutomatedSnapshotRetentionPeriod *int64 `type:"integer"`

	// The unique identifier of the cluster to be modified.
	//
	// Example: examplecluster
	//
	// ClusterIdentifier is a required field
	ClusterIdentifier *string `type:"string" required:"true"`

	// The name of the cluster parameter group to apply to this cluster. This change
	// is applied only after the cluster is rebooted. To reboot a cluster use RebootCluster.
	//
	// Default: Uses existing setting.
	//
	// Constraints: The cluster parameter group must be in the same parameter group
	// family that matches the cluster version.
	ClusterParameterGroupName *string `type:"string"`

	// A list of cluster security groups to be authorized on this cluster. This
	// change is asynchronously applied as soon as possible.
	//
	// Security groups currently associated with the cluster, and not in the list
	// of groups to apply, will be revoked from the cluster.
	//
	// Constraints:
	//
	//    * Must be 1 to 255 alphanumeric characters or hyphens
	//
	//    * First character must be a letter
	//
	//    * Cannot end with a hyphen or contain two consecutive hyphens
	ClusterSecurityGroups []*string `locationNameList:"ClusterSecurityGroupName" type:"list"`

	// The new cluster type.
	//
	// When you submit your cluster resize request, your existing cluster goes into
	// a read-only mode. After Amazon Redshift provisions a new cluster based on
	// your resize requirements, there will be outage for a period while the old
	// cluster is deleted and your connection is switched to the new cluster. You
	// can use DescribeResize to track the progress of the resize request.
	//
	// Valid Values: multi-node | single-node
	ClusterType *string `type:"string"`

	// The new version number of the Amazon Redshift engine to upgrade to.
	//
	// For major version upgrades, if a non-default cluster parameter group is currently
	// in use, a new cluster parameter group in the cluster parameter group family
	// for the new version must be specified. The new cluster parameter group can
	// be the default for that cluster parameter group family. For more information
	// about parameters and parameter groups, go to Amazon Redshift Parameter Groups
	// (https://docs.aws.amazon.com/redshift/latest/mgmt/working-with-parameter-groups.html)
	// in the Amazon Redshift Cluster Management Guide.
	//
	// Example: 1.0
	ClusterVersion *string `type:"string"`

	// The Elastic IP (EIP) address for the cluster.
	//
	// Constraints: The cluster must be provisioned in EC2-VPC and publicly-accessible
	// through an Internet gateway. For more information about provisioning clusters
	// in EC2-VPC, go to Supported Platforms to Launch Your Cluster (https://docs.aws.amazon.com/redshift/latest/mgmt/working-with-clusters.html#cluster-platforms)
	// in the Amazon Redshift Cluster Management Guide.
	ElasticIp *string `type:"string"`

	// Indicates whether the cluster is encrypted. If the value is encrypted (true)
	// and you provide a value for the KmsKeyId parameter, we encrypt the cluster
	// with the provided KmsKeyId. If you don't provide a KmsKeyId, we encrypt with
	// the default key. In the China region we use legacy encryption if you specify
	// that the cluster is encrypted.
	//
	// If the value is not encrypted (false), then the cluster is decrypted.
	Encrypted *bool `type:"boolean"`

	// An option that specifies whether to create the cluster with enhanced VPC
	// routing enabled. To create a cluster that uses enhanced VPC routing, the
	// cluster must be in a VPC. For more information, see Enhanced VPC Routing
	// (https://docs.aws.amazon.com/redshift/latest/mgmt/enhanced-vpc-routing.html)
	// in the Amazon Redshift Cluster Management Guide.
	//
	// If this option is true, enhanced VPC routing is enabled.
	//
	// Default: false
	EnhancedVpcRouting *bool `type:"boolean"`

	// Specifies the name of the HSM client certificate the Amazon Redshift cluster
	// uses to retrieve the data encryption keys stored in an HSM.
	HsmClientCertificateIdentifier *string `type:"string"`

	// Specifies the name of the HSM configuration that contains the information
	// the Amazon Redshift cluster can use to retrieve and store keys in an HSM.
	HsmConfigurationIdentifier *string `type:"string"`

	// The AWS Key Management Service (KMS) key ID of the encryption key that you
	// want to use to encrypt data in the cluster.
	KmsKeyId *string `type:"string"`

	// The name for the maintenance track that you want to assign for the cluster.
	// This name change is asynchronous. The new track name stays in the PendingModifiedValues
	// for the cluster until the next maintenance window. When the maintenance track
	// changes, the cluster is switched to the latest cluster release available
	// for the maintenance track. At this point, the maintenance track name is applied.
	MaintenanceTrackName *string `type:"string"`

	// The default for number of days that a newly created manual snapshot is retained.
	// If the value is -1, the manual snapshot is retained indefinitely. This value
	// doesn't retroactively change the retention periods of existing manual snapshots.
	//
	// The value must be either -1 or an integer between 1 and 3,653.
	//
	// The default value is -1.
	ManualSnapshotRetentionPeriod *int64 `type:"integer"`

	// The new password for the cluster master user. This change is asynchronously
	// applied as soon as possible. Between the time of the request and the completion
	// of the request, the MasterUserPassword element exists in the PendingModifiedValues
	// element of the operation response.
	//
	// Operations never return the password, so this operation provides a way to
	// regain access to the master user account for a cluster if the password is
	// lost.
	//
	// Default: Uses existing setting.
	//
	// Constraints:
	//
	//    * Must be between 8 and 64 characters in length.
	//
	//    * Must contain at least one uppercase letter.
	//
	//    * Must contain at least one lowercase letter.
	//
	//    * Must contain one number.
	//
	//    * Can be any printable ASCII character (ASCII code 33 to 126) except '
	//    (single quote), " (double quote), \, /, @, or space.
	MasterUserPassword *string `type:"string"`

	// The new identifier for the cluster.
	//
	// Constraints:
	//
	//    * Must contain from 1 to 63 alphanumeric characters or hyphens.
	//
	//    * Alphabetic characters must be lowercase.
	//
	//    * First character must be a letter.
	//
	//    * Cannot end with a hyphen or contain two consecutive hyphens.
	//
	//    * Must be unique for all clusters within an AWS account.
	//
	// Example: examplecluster
	NewClusterIdentifier *string `type:"string"`

	// The new node type of the cluster. If you specify a new node type, you must
	// also specify the number of nodes parameter.
	//
	// For more information about resizing clusters, go to Resizing Clusters in
	// Amazon Redshift (https://docs.aws.amazon.com/redshift/latest/mgmt/rs-resize-tutorial.html)
	// in the Amazon Redshift Cluster Management Guide.
	//
	// Valid Values: ds2.xlarge | ds2.8xlarge | dc1.large | dc1.8xlarge | dc2.large
	// | dc2.8xlarge | ra3.16xlarge
	NodeType *string `type:"string"`

	// The new number of nodes of the cluster. If you specify a new number of nodes,
	// you must also specify the node type parameter.
	//
	// For more information about resizing clusters, go to Resizing Clusters in
	// Amazon Redshift (https://docs.aws.amazon.com/redshift/latest/mgmt/rs-resize-tutorial.html)
	// in the Amazon Redshift Cluster Management Guide.
	//
	// Valid Values: Integer greater than 0.
	NumberOfNodes *int64 `type:"integer"`

	// The weekly time range (in UTC) during which system maintenance can occur,
	// if necessary. If system maintenance is necessary during the window, it may
	// result in an outage.
	//
	// This maintenance window change is made immediately. If the new maintenance
	// window indicates the current time, there must be at least 120 minutes between
	// the current time and end of the window in order to ensure that pending changes
	// are applied.
	//
	// Default: Uses existing setting.
	//
	// Format: ddd:hh24:mi-ddd:hh24:mi, for example wed:07:30-wed:08:00.
	//
	// Valid Days: Mon | Tue | Wed | Thu | Fri | Sat | Sun
	//
	// Constraints: Must be at least 30 minutes.
	PreferredMaintenanceWindow *string `type:"string"`

	// If true, the cluster can be accessed from a public network. Only clusters
	// in VPCs can be set to be publicly available.
	PubliclyAccessible *bool `type:"boolean"`

	// A list of virtual private cloud (VPC) security groups to be associated with
	// the cluster. This change is asynchronously applied as soon as possible.
	VpcSecurityGroupIds []*string `locationNameList:"VpcSecurityGroupId" type:"list"`
}

// String returns the string representation
func (s ModifyClusterInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ModifyClusterInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ModifyClusterInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ModifyClusterInput"}
	if s.ClusterIdentifier == nil {
		invalidParams.Add(request.NewErrParamRequired("ClusterIdentifier"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAllowVersionUpgrade sets the AllowVersionUpgrade field's value.
func (s *ModifyClusterInput) SetAllowVersionUpgrade(v bool) *ModifyClusterInput {
	s.AllowVersionUpgrade = &v
	return s
}

// SetAutomatedSnapshotRetentionPeriod sets the AutomatedSnapshotRetentionPeriod field's value.
func (s *ModifyClusterInput) SetAutomatedSnapshotRetentionPeriod(v int64) *ModifyClusterInput {
	s.AutomatedSnapshotRetentionPeriod = &v
	return s
}

// SetClusterIdentifier sets the ClusterIdentifier field's value.
func (s *ModifyClusterInput) SetClusterIdentifier(v string) *ModifyClusterInput {
	s.ClusterIdentifier = &v
	return s
}

// SetClusterParameterGroupName sets the ClusterParameterGroupName field's value.
func (s *ModifyClusterInput) SetClusterParameterGroupName(v string) *ModifyClusterInput {
	s.ClusterParameterGroupName = &v
	return s
}

// SetClusterSecurityGroups sets the ClusterSecurityGroups field's value.
func (s *ModifyClusterInput) SetClusterSecurityGroups(v []*string) *ModifyClusterInput {
	s.ClusterSecurityGroups = v
	return s
}

// SetClusterType sets the ClusterType field's value.
func (s *ModifyClusterInput) SetClusterType(v string) *ModifyClusterInput {
	s.ClusterType = &v
	return s
}

// SetClusterVersion sets the ClusterVersion field's value.
func (s *ModifyClusterInput) SetClusterVersion(v string) *ModifyClusterInput {
	s.ClusterVersion = &v
	return s
}

// SetElasticIp sets the ElasticIp field's value.
func (s *ModifyClusterInput) SetElasticIp(v string) *ModifyClusterInput {
	s.ElasticIp = &v
	return s
}

// SetEncrypted sets the Encrypted field's value.
func (s *ModifyClusterInput) SetEncrypted(v bool) *ModifyClusterInput {
	s.Encrypted = &v
	return s
}

// SetEnhancedVpcRouting sets the EnhancedVpcRouting field's value.
func (s *ModifyClusterInput) SetEnhancedVpcRouting(v bool) *ModifyClusterInput {
	s.EnhancedVpcRouting = &v
	return s
}

// SetHsmClientCertificateIdentifier sets the HsmClientCertificateIdentifier field's value.
func (s *ModifyClusterInput) SetHsmClientCertificateIdentifier(v string) *ModifyClusterInput {
	s.HsmClientCertificateIdentifier = &v
	return s
}

// SetHsmConfigurationIdentifier sets the HsmConfigurationIdentifier field's value.
func (s *ModifyClusterInput) SetHsmConfigurationIdentifier(v string) *ModifyClusterInput {
	s.HsmConfigurationIdentifier = &v
	return s
}

// SetKmsKeyId sets the KmsKeyId field's value.
func (s *ModifyClusterInput) SetKmsKeyId(v string) *ModifyClusterInput {
	s.KmsKeyId = &v
	return s
}

// SetMaintenanceTrackName sets the MaintenanceTrackName field's value.
func (s *ModifyClusterInput) SetMaintenanceTrackName(v string) *ModifyClusterInput {
	s.MaintenanceTrackName = &v
	return s
}

// SetManualSnapshotRetentionPeriod sets the ManualSnapshotRetentionPeriod field's value.
func (s *ModifyClusterInput) SetManualSnapshotRetentionPeriod(v int64) *ModifyClusterInput {
	s.ManualSnapshotRetentionPeriod = &v
	return s
}

// SetMasterUserPassword sets the MasterUserPassword field's value.
func (s *ModifyClusterInput) SetMasterUserPassword(v string) *ModifyClusterInput {
	s.MasterUserPassword = &v
	return s
}

// SetNewClusterIdentifier sets the NewClusterIdentifier field's value.
func (s *ModifyClusterInput) SetNewClusterIdentifier(v string) *ModifyClusterInput {
	s.NewClusterIdentifier = &v
	return s
}

// SetNodeType sets the NodeType field's value.
func (s *ModifyClusterInput) SetNodeType(v string) *ModifyClusterInput {
	s.NodeType = &v
	return s
}

// SetNumberOfNodes sets the NumberOfNodes field's value.
func (s *ModifyClusterInput) SetNumberOfNodes(v int64) *ModifyClusterInput {
	s.NumberOfNodes = &v
	return s
}

// SetPreferredMaintenanceWindow sets the PreferredMaintenanceWindow field's value.
func (s *ModifyClusterInput) SetPreferredMaintenanceWindow(v string) *ModifyClusterInput {
	s.PreferredMaintenanceWindow = &v
	return s
}

// SetPubliclyAccessible sets the PubliclyAccessible field's value.
func (s *ModifyClusterInput) SetPubliclyAccessible(v bool) *ModifyClusterInput {
	s.PubliclyAccessible = &v
	return s
}

// SetVpcSecurityGroupIds sets the VpcSecurityGroupIds field's value.
func (s *ModifyClusterInput) SetVpcSecurityGroupIds(v []*string) *ModifyClusterInput {
	s.VpcSecurityGroupIds = v
	return s
}

type ModifyClusterMaintenanceInput struct {
	_ struct{} `type:"structure"`

	// A unique identifier for the cluster.
	//
	// ClusterIdentifier is a required field
	ClusterIdentifier *string `type:"string" required:"true"`

	// A boolean indicating whether to enable the deferred maintenance window.
	DeferMaintenance *bool `type:"boolean"`

	// An integer indicating the duration of the maintenance window in days. If
	// you specify a duration, you can't specify an end time. The duration must
	// be 45 days or less.
	DeferMaintenanceDuration *int64 `type:"integer"`

	// A timestamp indicating end time for the deferred maintenance window. If you
	// specify an end time, you can't specify a duration.
	DeferMaintenanceEndTime *time.Time `type:"timestamp"`

	// A unique identifier for the deferred maintenance window.
	DeferMaintenanceIdentifier *string `type:"string"`

	// A timestamp indicating the start time for the deferred maintenance window.
	DeferMaintenanceStartTime *time.Time `type:"timestamp"`
}

// String returns the string representation
func (s ModifyClusterMaintenanceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ModifyClusterMaintenanceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ModifyClusterMaintenanceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ModifyClusterMaintenanceInput"}
	if s.ClusterIdentifier == nil {
		invalidParams.Add(request.NewErrParamRequired("ClusterIdentifier"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClusterIdentifier sets the ClusterIdentifier field's value.
func (s *ModifyClusterMaintenanceInput) SetClusterIdentifier(v string) *ModifyClusterMaintenanceInput {
	s.ClusterIdentifier = &v
	return s
}

// SetDeferMaintenance sets the DeferMaintenance field's value.
func (s *ModifyClusterMaintenanceInput) SetDeferMaintenance(v bool) *ModifyClusterMaintenanceInput {
	s.DeferMaintenance = &v
	return s
}

// SetDeferMaintenanceDuration sets the DeferMaintenanceDuration field's value.
func (s *ModifyClusterMaintenanceInput) SetDeferMaintenanceDuration(v int64) *ModifyClusterMaintenanceInput {
	s.DeferMaintenanceDuration = &v
	return s
}

// SetDeferMaintenanceEndTime sets the DeferMaintenanceEndTime field's value.
func (s *ModifyClusterMaintenanceInput) SetDeferMaintenanceEndTime(v time.Time) *ModifyClusterMaintenanceInput {
	s.DeferMaintenanceEndTime = &v
	return s
}

// SetDeferMaintenanceIdentifier sets the DeferMaintenanceIdentifier field's value.
func (s *ModifyClusterMaintenanceInput) SetDeferMaintenanceIdentifier(v string) *ModifyClusterMaintenanceInput {
	s.DeferMaintenanceIdentifier = &v
	return s
}

// SetDeferMaintenanceStartTime sets the DeferMaintenanceStartTime field's value.
func (s *ModifyClusterMaintenanceInput) SetDeferMaintenanceStartTime(v time.Time) *ModifyClusterMaintenanceInput {
	s.DeferMaintenanceStartTime = &v
	return s
}

type ModifyClusterMaintenanceOutput struct {
	_ struct{} `type:"structure"`

	// Describes a cluster.
	Cluster *Cluster `type:"structure"`
}

// String returns the string representation
func (s ModifyClusterMaintenanceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ModifyClusterMaintenanceOutput) GoString() string {
	return s.String()
}

// SetCluster sets the Cluster field's value.
func (s *ModifyClusterMaintenanceOutput) SetCluster(v *Cluster) *ModifyClusterMaintenanceOutput {
	s.Cluster = v
	return s
}

type ModifyClusterOutput struct {
	_ struct{} `type:"structure"`

	// Describes a cluster.
	Cluster *Cluster `type:"structure"`
}

// String returns the string representation
func (s ModifyClusterOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ModifyClusterOutput) GoString() string {
	return s.String()
}

// SetCluster sets the Cluster field's value.
func (s *ModifyClusterOutput) SetCluster(v *Cluster) *ModifyClusterOutput {
	s.Cluster = v
	return s
}

type ModifyClusterParameterGroupInput struct {
	_ struct{} `type:"structure"`

	// The name of the parameter group to be modified.
	//
	// ParameterGroupName is a required field
	ParameterGroupName *string `type:"string" required:"true"`

	// An array of parameters to be modified. A maximum of 20 parameters can be
	// modified in a single request.
	//
	// For each parameter to be modified, you must supply at least the parameter
	// name and parameter value; other name-value pairs of the parameter are optional.
	//
	// For the workload management (WLM) configuration, you must supply all the
	// name-value pairs in the wlm_json_configuration parameter.
	//
	// Parameters is a required field
	Parameters []*Parameter `locationNameList:"Parameter" type:"list" required:"true"`
}

// String returns the string representation
func (s ModifyClusterParameterGroupInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ModifyClusterParameterGroupInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ModifyClusterParameterGroupInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ModifyClusterParameterGroupInput"}
	if s.ParameterGroupName == nil {
		invalidParams.Add(request.NewErrParamRequired("ParameterGroupName"))
	}
	if s.Parameters == nil {
		invalidParams.Add(request.NewErrParamRequired("Parameters"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetParameterGroupName sets the ParameterGroupName field's value.
func (s *ModifyClusterParameterGroupInput) SetParameterGroupName(v string) *ModifyClusterParameterGroupInput {
	s.ParameterGroupName = &v
	return s
}

// SetParameters sets the Parameters field's value.
func (s *ModifyClusterParameterGroupInput) SetParameters(v []*Parameter) *ModifyClusterParameterGroupInput {
	s.Parameters = v
	return s
}

type ModifyClusterSnapshotInput struct {
	_ struct{} `type:"structure"`

	// A Boolean option to override an exception if the retention period has already
	// passed.
	Force *bool `type:"boolean"`

	// The number of days that a manual snapshot is retained. If the value is -1,
	// the manual snapshot is retained indefinitely.
	//
	// If the manual snapshot falls outside of the new retention period, you can
	// specify the force option to immediately delete the snapshot.
	//
	// The value must be either -1 or an integer between 1 and 3,653.
	ManualSnapshotRetentionPeriod *int64 `type:"integer"`

	// The identifier of the snapshot whose setting you want to modify.
	//
	// SnapshotIdentifier is a required field
	SnapshotIdentifier *string `type:"string" required:"true"`
}

// String returns the string representation
func (s ModifyClusterSnapshotInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ModifyClusterSnapshotInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ModifyClusterSnapshotInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ModifyClusterSnapshotInput"}
	if s.SnapshotIdentifier == nil {
		invalidParams.Add(request.NewErrParamRequired("SnapshotIdentifier"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetForce sets the Force field's value.
func (s *ModifyClusterSnapshotInput) SetForce(v bool) *ModifyClusterSnapshotInput {
	s.Force = &v
	return s
}

// SetManualSnapshotRetentionPeriod sets the ManualSnapshotRetentionPeriod field's value.
func (s *ModifyClusterSnapshotInput) SetManualSnapshotRetentionPeriod(v int64) *ModifyClusterSnapshotInput {
	s.ManualSnapshotRetentionPeriod = &v
	return s
}

// SetSnapshotIdentifier sets the SnapshotIdentifier field's value.
func (s *ModifyClusterSnapshotInput) SetSnapshotIdentifier(v string) *ModifyClusterSnapshotInput {
	s.SnapshotIdentifier = &v
	return s
}

type ModifyClusterSnapshotOutput struct {
	_ struct{} `type:"structure"`

	// Describes a snapshot.
	Snapshot *Snapshot `type:"structure"`
}

// String returns the string representation
func (s ModifyClusterSnapshotOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ModifyClusterSnapshotOutput) GoString() string {
	return s.String()
}

// SetSnapshot sets the Snapshot field's value.
func (s *ModifyClusterSnapshotOutput) SetSnapshot(v *Snapshot) *ModifyClusterSnapshotOutput {
	s.Snapshot = v
	return s
}

type ModifyClusterSnapshotScheduleInput struct {
	_ struct{} `type:"structure"`

	// A unique identifier for the cluster whose snapshot schedule you want to modify.
	//
	// ClusterIdentifier is a required field
	ClusterIdentifier *string `type:"string" required:"true"`

	// A boolean to indicate whether to remove the assoiciation between the cluster
	// and the schedule.
	DisassociateSchedule *bool `type:"boolean"`

	// A unique alphanumeric identifier for the schedule that you want to associate
	// with the cluster.
	ScheduleIdentifier *string `type:"string"`
}

// String returns the string representation
func (s ModifyClusterSnapshotScheduleInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ModifyClusterSnapshotScheduleInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ModifyClusterSnapshotScheduleInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ModifyClusterSnapshotScheduleInput"}
	if s.ClusterIdentifier == nil {
		invalidParams.Add(request.NewErrParamRequired("ClusterIdentifier"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClusterIdentifier sets the ClusterIdentifier field's value.
func (s *ModifyClusterSnapshotScheduleInput) SetClusterIdentifier(v string) *ModifyClusterSnapshotScheduleInput {
	s.ClusterIdentifier = &v
	return s
}

// SetDisassociateSchedule sets the DisassociateSchedule field's value.
func (s *ModifyClusterSnapshotScheduleInput) SetDisassociateSchedule(v bool) *ModifyClusterSnapshotScheduleInput {
	s.DisassociateSchedule = &v
	return s
}

// SetScheduleIdentifier sets the ScheduleIdentifier field's value.
func (s *ModifyClusterSnapshotScheduleInput) SetScheduleIdentifier(v string) *ModifyClusterSnapshotScheduleInput {
	s.ScheduleIdentifier = &v
	return s
}

type ModifyClusterSnapshotScheduleOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s ModifyClusterSnapshotScheduleOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ModifyClusterSnapshotScheduleOutput) GoString() string {
	return s.String()
}

type ModifyClusterSubnetGroupInput struct {
	_ struct{} `type:"structure"`

	// The name of the subnet group to be modified.
	//
	// ClusterSubnetGroupName is a required field
	ClusterSubnetGroupName *string `type:"string" required:"true"`

	// A text description of the subnet group to be modified.
	Description *string `type:"string"`

	// An array of VPC subnet IDs. A maximum of 20 subnets can be modified in a
	// single request.
	//
	// SubnetIds is a required field
	SubnetIds []*string `locationNameList:"SubnetIdentifier" type:"list" required:"true"`
}

// String returns the string representation
func (s ModifyClusterSubnetGroupInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ModifyClusterSubnetGroupInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ModifyClusterSubnetGroupInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ModifyClusterSubnetGroupInput"}
	if s.ClusterSubnetGroupName == nil {
		invalidParams.Add(request.NewErrParamRequired("ClusterSubnetGroupName"))
	}
	if s.SubnetIds == nil {
		invalidParams.Add(request.NewErrParamRequired("SubnetIds"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClusterSubnetGroupName sets the ClusterSubnetGroupName field's value.
func (s *ModifyClusterSubnetGroupInput) SetClusterSubnetGroupName(v string) *ModifyClusterSubnetGroupInput {
	s.ClusterSubnetGroupName = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *ModifyClusterSubnetGroupInput) SetDescription(v string) *ModifyClusterSubnetGroupInput {
	s.Description = &v
	return s
}

// SetSubnetIds sets the SubnetIds field's value.
func (s *ModifyClusterSubnetGroupInput) SetSubnetIds(v []*string) *ModifyClusterSubnetGroupInput {
	s.SubnetIds = v
	return s
}

type ModifyClusterSubnetGroupOutput struct {
	_ struct{} `type:"structure"`

	// Describes a subnet group.
	ClusterSubnetGroup *ClusterSubnetGroup `type:"structure"`
}

// String returns the string representation
func (s ModifyClusterSubnetGroupOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ModifyClusterSubnetGroupOutput) GoString() string {
	return s.String()
}

// SetClusterSubnetGroup sets the ClusterSubnetGroup field's value.
func (s *ModifyClusterSubnetGroupOutput) SetClusterSubnetGroup(v *ClusterSubnetGroup) *ModifyClusterSubnetGroupOutput {
	s.ClusterSubnetGroup = v
	return s
}

type ModifyEventSubscriptionInput struct {
	_ struct{} `type:"structure"`

	// A Boolean value indicating if the subscription is enabled. true indicates
	// the subscription is enabled
	Enabled *bool `type:"boolean"`

	// Specifies the Amazon Redshift event categories to be published by the event
	// notification subscription.
	//
	// Values: configuration, management, monitoring, security
	EventCategories []*string `locationNameList:"EventCategory" type:"list"`

	// Specifies the Amazon Redshift event severity to be published by the event
	// notification subscription.
	//
	// Values: ERROR, INFO
	Severity *string `type:"string"`

	// The Amazon Resource Name (ARN) of the SNS topic to be used by the event notification
	// subscription.
	SnsTopicArn *string `type:"string"`

	// A list of one or more identifiers of Amazon Redshift source objects. All
	// of the objects must be of the same type as was specified in the source type
	// parameter. The event subscription will return only events generated by the
	// specified objects. If not specified, then events are returned for all objects
	// within the source type specified.
	//
	// Example: my-cluster-1, my-cluster-2
	//
	// Example: my-snapshot-20131010
	SourceIds []*string `locationNameList:"SourceId" type:"list"`

	// The type of source that will be generating the events. For example, if you
	// want to be notified of events generated by a cluster, you would set this
	// parameter to cluster. If this value is not specified, events are returned
	// for all Amazon Redshift objects in your AWS account. You must specify a source
	// type in order to specify source IDs.
	//
	// Valid values: cluster, cluster-parameter-group, cluster-security-group, cluster-snapshot,
	// and scheduled-action.
	SourceType *string `type:"string"`

	// The name of the modified Amazon Redshift event notification subscription.
	//
	// SubscriptionName is a required field
	SubscriptionName *string `type:"string" required:"true"`
}

// String returns the string representation
func (s ModifyEventSubscriptionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ModifyEventSubscriptionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ModifyEventSubscriptionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ModifyEventSubscriptionInput"}
	if s.SubscriptionName == nil {
		invalidParams.Add(request.NewErrParamRequired("SubscriptionName"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetEnabled sets the Enabled field's value.
func (s *ModifyEventSubscriptionInput) SetEnabled(v bool) *ModifyEventSubscriptionInput {
	s.Enabled = &v
	return s
}

// SetEventCategories sets the EventCategories field's value.
func (s *ModifyEventSubscriptionInput) SetEventCategories(v []*string) *ModifyEventSubscriptionInput {
	s.EventCategories = v
	return s
}

// SetSeverity sets the Severity field's value.
func (s *ModifyEventSubscriptionInput) SetSeverity(v string) *ModifyEventSubscriptionInput {
	s.Severity = &v
	return s
}

// SetSnsTopicArn sets the SnsTopicArn field's value.
func (s *ModifyEventSubscriptionInput) SetSnsTopicArn(v string) *ModifyEventSubscriptionInput {
	s.SnsTopicArn = &v
	return s
}

// SetSourceIds sets the SourceIds field's value.
func (s *ModifyEventSubscriptionInput) SetSourceIds(v []*string) *ModifyEventSubscriptionInput {
	s.SourceIds = v
	return s
}

// SetSourceType sets the SourceType field's value.
func (s *ModifyEventSubscriptionInput) SetSourceType(v string) *ModifyEventSubscriptionInput {
	s.SourceType = &v
	return s
}

// SetSubscriptionName sets the SubscriptionName field's value.
func (s *ModifyEventSubscriptionInput) SetSubscriptionName(v string) *ModifyEventSubscriptionInput {
	s.SubscriptionName = &v
	return s
}

type ModifyEventSubscriptionOutput struct {
	_ struct{} `type:"structure"`

	// Describes event subscriptions.
	EventSubscription *EventSubscription `type:"structure"`
}

// String returns the string representation
func (s ModifyEventSubscriptionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ModifyEventSubscriptionOutput) GoString() string {
	return s.String()
}

// SetEventSubscription sets the EventSubscription field's value.
func (s *ModifyEventSubscriptionOutput) SetEventSubscription(v *EventSubscription) *ModifyEventSubscriptionOutput {
	s.EventSubscription = v
	return s
}

type ModifyScheduledActionInput struct {
	_ struct{} `type:"structure"`

	// A modified enable flag of the scheduled action. If true, the scheduled action
	// is active. If false, the scheduled action is disabled.
	Enable *bool `type:"boolean"`

	// A modified end time of the scheduled action. For more information about this
	// parameter, see ScheduledAction.
	EndTime *time.Time `type:"timestamp"`

	// A different IAM role to assume to run the target action. For more information
	// about this parameter, see ScheduledAction.
	IamRole *string `type:"string"`

	// A modified schedule in either at( ) or cron( ) format. For more information
	// about this parameter, see ScheduledAction.
	Schedule *string `type:"string"`

	// A modified description of the scheduled action.
	ScheduledActionDescription *string `type:"string"`

	// The name of the scheduled action to modify.
	//
	// ScheduledActionName is a required field
	ScheduledActionName *string `type:"string" required:"true"`

	// A modified start time of the scheduled action. For more information about
	// this parameter, see ScheduledAction.
	StartTime *time.Time `type:"timestamp"`

	// A modified JSON format of the scheduled action. For more information about
	// this parameter, see ScheduledAction.
	TargetAction *ScheduledActionType `type:"structure"`
}

// String returns the string representation
func (s ModifyScheduledActionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ModifyScheduledActionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ModifyScheduledActionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ModifyScheduledActionInput"}
	if s.ScheduledActionName == nil {
		invalidParams.Add(request.NewErrParamRequired("ScheduledActionName"))
	}
	if s.TargetAction != nil {
		if err := s.TargetAction.Validate(); err != nil {
			invalidParams.AddNested("TargetAction", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetEnable sets the Enable field's value.
func (s *ModifyScheduledActionInput) SetEnable(v bool) *ModifyScheduledActionInput {
	s.Enable = &v
	return s
}

// SetEndTime sets the EndTime field's value.
func (s *ModifyScheduledActionInput) SetEndTime(v time.Time) *ModifyScheduledActionInput {
	s.EndTime = &v
	return s
}

// SetIamRole sets the IamRole field's value.
func (s *ModifyScheduledActionInput) SetIamRole(v string) *ModifyScheduledActionInput {
	s.IamRole = &v
	return s
}

// SetSchedule sets the Schedule field's value.
func (s *ModifyScheduledActionInput) SetSchedule(v string) *ModifyScheduledActionInput {
	s.Schedule = &v
	return s
}

// SetScheduledActionDescription sets the ScheduledActionDescription field's value.
func (s *ModifyScheduledActionInput) SetScheduledActionDescription(v string) *ModifyScheduledActionInput {
	s.ScheduledActionDescription = &v
	return s
}

// SetScheduledActionName sets the ScheduledActionName field's value.
func (s *ModifyScheduledActionInput) SetScheduledActionName(v string) *ModifyScheduledActionInput {
	s.ScheduledActionName = &v
	return s
}

// SetStartTime sets the StartTime field's value.
func (s *ModifyScheduledActionInput) SetStartTime(v time.Time) *ModifyScheduledActionInput {
	s.StartTime = &v
	return s
}

// SetTargetAction sets the TargetAction field's value.
func (s *ModifyScheduledActionInput) SetTargetAction(v *ScheduledActionType) *ModifyScheduledActionInput {
	s.TargetAction = v
	return s
}

// Describes a scheduled action. You can use a scheduled action to trigger some
// Amazon Redshift API operations on a schedule. For information about which
// API operations can be scheduled, see ScheduledActionType.
type ModifyScheduledActionOutput struct {
	_ struct{} `type:"structure"`

	// The end time in UTC when the schedule is no longer active. After this time,
	// the scheduled action does not trigger.
	EndTime *time.Time `type:"timestamp"`

	// The IAM role to assume to run the scheduled action. This IAM role must have
	// permission to run the Amazon Redshift API operation in the scheduled action.
	// This IAM role must allow the Amazon Redshift scheduler (Principal scheduler.redshift.amazonaws.com)
	// to assume permissions on your behalf. For more information about the IAM
	// role to use with the Amazon Redshift scheduler, see Using Identity-Based
	// Policies for Amazon Redshift (https://docs.aws.amazon.com/redshift/latest/mgmt/redshift-iam-access-control-identity-based.html)
	// in the Amazon Redshift Cluster Management Guide.
	IamRole *string `type:"string"`

	// List of times when the scheduled action will run.
	NextInvocations []*time.Time `locationNameList:"ScheduledActionTime" type:"list"`

	// The schedule for a one-time (at format) or recurring (cron format) scheduled
	// action. Schedule invocations must be separated by at least one hour.
	//
	// Format of at expressions is "at(yyyy-mm-ddThh:mm:ss)". For example, "at(2016-03-04T17:27:00)".
	//
	// Format of cron expressions is "cron(Minutes Hours Day-of-month Month Day-of-week
	// Year)". For example, "cron(0, 10, *, *, MON, *)". For more information, see
	// Cron Expressions (https://docs.aws.amazon.com/AmazonCloudWatch/latest/events/ScheduledEvents.html#CronExpressions)
	// in the Amazon CloudWatch Events User Guide.
	Schedule *string `type:"string"`

	// The description of the scheduled action.
	ScheduledActionDescription *string `type:"string"`

	// The name of the scheduled action.
	ScheduledActionName *string `type:"string"`

	// The start time in UTC when the schedule is active. Before this time, the
	// scheduled action does not trigger.
	StartTime *time.Time `type:"timestamp"`

	// The state of the scheduled action. For example, DISABLED.
	State *string `type:"string" enum:"ScheduledActionState"`

	// A JSON format string of the Amazon Redshift API operation with input parameters.
	//
	// "{\"ResizeCluster\":{\"NodeType\":\"ds2.8xlarge\",\"ClusterIdentifier\":\"my-test-cluster\",\"NumberOfNodes\":3}}".
	TargetAction *ScheduledActionType `type:"structure"`
}

// String returns the string representation
func (s ModifyScheduledActionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ModifyScheduledActionOutput) GoString() string {
	return s.String()
}

// SetEndTime sets the EndTime field's value.
func (s *ModifyScheduledActionOutput) SetEndTime(v time.Time) *ModifyScheduledActionOutput {
	s.EndTime = &v
	return s
}

// SetIamRole sets the IamRole field's value.
func (s *ModifyScheduledActionOutput) SetIamRole(v string) *ModifyScheduledActionOutput {
	s.IamRole = &v
	return s
}

// SetNextInvocations sets the NextInvocations field's value.
func (s *ModifyScheduledActionOutput) SetNextInvocations(v []*time.Time) *ModifyScheduledActionOutput {
	s.NextInvocations = v
	return s
}

// SetSchedule sets the Schedule field's value.
func (s *ModifyScheduledActionOutput) SetSchedule(v string) *ModifyScheduledActionOutput {
	s.Schedule = &v
	return s
}

// SetScheduledActionDescription sets the ScheduledActionDescription field's value.
func (s *ModifyScheduledActionOutput) SetScheduledActionDescription(v string) *ModifyScheduledActionOutput {
	s.ScheduledActionDescription = &v
	return s
}

// SetScheduledActionName sets the ScheduledActionName field's value.
func (s *ModifyScheduledActionOutput) SetScheduledActionName(v string) *ModifyScheduledActionOutput {
	s.ScheduledActionName = &v
	return s
}

// SetStartTime sets the StartTime field's value.
func (s *ModifyScheduledActionOutput) SetStartTime(v time.Time) *ModifyScheduledActionOutput {
	s.StartTime = &v
	return s
}

// SetState sets the State field's value.
func (s *ModifyScheduledActionOutput) SetState(v string) *ModifyScheduledActionOutput {
	s.State = &v
	return s
}

// SetTargetAction sets the TargetAction field's value.
func (s *ModifyScheduledActionOutput) SetTargetAction(v *ScheduledActionType) *ModifyScheduledActionOutput {
	s.TargetAction = v
	return s
}

type ModifySnapshotCopyRetentionPeriodInput struct {
	_ struct{} `type:"structure"`

	// The unique identifier of the cluster for which you want to change the retention
	// period for either automated or manual snapshots that are copied to a destination
	// AWS Region.
	//
	// Constraints: Must be the valid name of an existing cluster that has cross-region
	// snapshot copy enabled.
	//
	// ClusterIdentifier is a required field
	ClusterIdentifier *string `type:"string" required:"true"`

	// Indicates whether to apply the snapshot retention period to newly copied
	// manual snapshots instead of automated snapshots.
	Manual *bool `type:"boolean"`

	// The number of days to retain automated snapshots in the destination AWS Region
	// after they are copied from the source AWS Region.
	//
	// By default, this only changes the retention period of copied automated snapshots.
	//
	// If you decrease the retention period for automated snapshots that are copied
	// to a destination AWS Region, Amazon Redshift deletes any existing automated
	// snapshots that were copied to the destination AWS Region and that fall outside
	// of the new retention period.
	//
	// Constraints: Must be at least 1 and no more than 35 for automated snapshots.
	//
	// If you specify the manual option, only newly copied manual snapshots will
	// have the new retention period.
	//
	// If you specify the value of -1 newly copied manual snapshots are retained
	// indefinitely.
	//
	// Constraints: The number of days must be either -1 or an integer between 1
	// and 3,653 for manual snapshots.
	//
	// RetentionPeriod is a required field
	RetentionPeriod *int64 `type:"integer" required:"true"`
}

// String returns the string representation
func (s ModifySnapshotCopyRetentionPeriodInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ModifySnapshotCopyRetentionPeriodInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ModifySnapshotCopyRetentionPeriodInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ModifySnapshotCopyRetentionPeriodInput"}
	if s.ClusterIdentifier == nil {
		invalidParams.Add(request.NewErrParamRequired("ClusterIdentifier"))
	}
	if s.RetentionPeriod == nil {
		invalidParams.Add(request.NewErrParamRequired("RetentionPeriod"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClusterIdentifier sets the ClusterIdentifier field's value.
func (s *ModifySnapshotCopyRetentionPeriodInput) SetClusterIdentifier(v string) *ModifySnapshotCopyRetentionPeriodInput {
	s.ClusterIdentifier = &v
	return s
}

// SetManual sets the Manual field's value.
func (s *ModifySnapshotCopyRetentionPeriodInput) SetManual(v bool) *ModifySnapshotCopyRetentionPeriodInput {
	s.Manual = &v
	return s
}

// SetRetentionPeriod sets the RetentionPeriod field's value.
func (s *ModifySnapshotCopyRetentionPeriodInput) SetRetentionPeriod(v int64) *ModifySnapshotCopyRetentionPeriodInput {
	s.RetentionPeriod = &v
	return s
}

type ModifySnapshotCopyRetentionPeriodOutput struct {
	_ struct{} `type:"structure"`

	// Describes a cluster.
	Cluster *Cluster `type:"structure"`
}

// String returns the string representation
func (s ModifySnapshotCopyRetentionPeriodOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ModifySnapshotCopyRetentionPeriodOutput) GoString() string {
	return s.String()
}

// SetCluster sets the Cluster field's value.
func (s *ModifySnapshotCopyRetentionPeriodOutput) SetCluster(v *Cluster) *ModifySnapshotCopyRetentionPeriodOutput {
	s.Cluster = v
	return s
}

type ModifySnapshotScheduleInput struct {
	_ struct{} `type:"structure"`

	// An updated list of schedule definitions. A schedule definition is made up
	// of schedule expressions, for example, "cron(30 12 *)" or "rate(12 hours)".
	//
	// ScheduleDefinitions is a required field
	ScheduleDefinitions []*string `locationNameList:"ScheduleDefinition" type:"list" required:"true"`

	// A unique alphanumeric identifier of the schedule to modify.
	//
	// ScheduleIdentifier is a required field
	ScheduleIdentifier *string `type:"string" required:"true"`
}

// String returns the string representation
func (s ModifySnapshotScheduleInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ModifySnapshotScheduleInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ModifySnapshotScheduleInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ModifySnapshotScheduleInput"}
	if s.ScheduleDefinitions == nil {
		invalidParams.Add(request.NewErrParamRequired("ScheduleDefinitions"))
	}
	if s.ScheduleIdentifier == nil {
		invalidParams.Add(request.NewErrParamRequired("ScheduleIdentifier"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetScheduleDefinitions sets the ScheduleDefinitions field's value.
func (s *ModifySnapshotScheduleInput) SetScheduleDefinitions(v []*string) *ModifySnapshotScheduleInput {
	s.ScheduleDefinitions = v
	return s
}

// SetScheduleIdentifier sets the ScheduleIdentifier field's value.
func (s *ModifySnapshotScheduleInput) SetScheduleIdentifier(v string) *ModifySnapshotScheduleInput {
	s.ScheduleIdentifier = &v
	return s
}

// Describes a snapshot schedule. You can set a regular interval for creating
// snapshots of a cluster. You can also schedule snapshots for specific dates.
type ModifySnapshotScheduleOutput struct {
	_ struct{} `type:"structure"`

	// The number of clusters associated with the schedule.
	AssociatedClusterCount *int64 `type:"integer"`

	// A list of clusters associated with the schedule. A maximum of 100 clusters
	// is returned.
	AssociatedClusters []*ClusterAssociatedToSchedule `locationNameList:"ClusterAssociatedToSchedule" type:"list"`

	NextInvocations []*time.Time `locationNameList:"SnapshotTime" type:"list"`

	// A list of ScheduleDefinitions.
	ScheduleDefinitions []*string `locationNameList:"ScheduleDefinition" type:"list"`

	// The description of the schedule.
	ScheduleDescription *string `type:"string"`

	// A unique identifier for the schedule.
	ScheduleIdentifier *string `type:"string"`

	// An optional set of tags describing the schedule.
	Tags []*Tag `locationNameList:"Tag" type:"list"`
}

// String returns the string representation
func (s ModifySnapshotScheduleOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ModifySnapshotScheduleOutput) GoString() string {
	return s.String()
}

// SetAssociatedClusterCount sets the AssociatedClusterCount field's value.
func (s *ModifySnapshotScheduleOutput) SetAssociatedClusterCount(v int64) *ModifySnapshotScheduleOutput {
	s.AssociatedClusterCount = &v
	return s
}

// SetAssociatedClusters sets the AssociatedClusters field's value.
func (s *ModifySnapshotScheduleOutput) SetAssociatedClusters(v []*ClusterAssociatedToSchedule) *ModifySnapshotScheduleOutput {
	s.AssociatedClusters = v
	return s
}

// SetNextInvocations sets the NextInvocations field's value.
func (s *ModifySnapshotScheduleOutput) SetNextInvocations(v []*time.Time) *ModifySnapshotScheduleOutput {
	s.NextInvocations = v
	return s
}

// SetScheduleDefinitions sets the ScheduleDefinitions field's value.
func (s *ModifySnapshotScheduleOutput) SetScheduleDefinitions(v []*string) *ModifySnapshotScheduleOutput {
	s.ScheduleDefinitions = v
	return s
}

// SetScheduleDescription sets the ScheduleDescription field's value.
func (s *ModifySnapshotScheduleOutput) SetScheduleDescription(v string) *ModifySnapshotScheduleOutput {
	s.ScheduleDescription = &v
	return s
}

// SetScheduleIdentifier sets the ScheduleIdentifier field's value.
func (s *ModifySnapshotScheduleOutput) SetScheduleIdentifier(v string) *ModifySnapshotScheduleOutput {
	s.ScheduleIdentifier = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *ModifySnapshotScheduleOutput) SetTags(v []*Tag) *ModifySnapshotScheduleOutput {
	s.Tags = v
	return s
}

// A list of node configurations.
type NodeConfigurationOption struct {
	_ struct{} `type:"structure"`

	// The estimated disk utilizaton percentage.
	EstimatedDiskUtilizationPercent *float64 `type:"double"`

	// The category of the node configuration recommendation.
	Mode *string `type:"string" enum:"Mode"`

	// The node type, such as, "ds2.8xlarge".
	NodeType *string `type:"string"`

	// The number of nodes.
	NumberOfNodes *int64 `type:"integer"`
}

// String returns the string representation
func (s NodeConfigurationOption) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s NodeConfigurationOption) GoString() string {
	return s.String()
}

// SetEstimatedDiskUtilizationPercent sets the EstimatedDiskUtilizationPercent field's value.
func (s *NodeConfigurationOption) SetEstimatedDiskUtilizationPercent(v float64) *NodeConfigurationOption {
	s.EstimatedDiskUtilizationPercent = &v
	return s
}

// SetMode sets the Mode field's value.
func (s *NodeConfigurationOption) SetMode(v string) *NodeConfigurationOption {
	s.Mode = &v
	return s
}

// SetNodeType sets the NodeType field's value.
func (s *NodeConfigurationOption) SetNodeType(v string) *NodeConfigurationOption {
	s.NodeType = &v
	return s
}

// SetNumberOfNodes sets the NumberOfNodes field's value.
func (s *NodeConfigurationOption) SetNumberOfNodes(v int64) *NodeConfigurationOption {
	s.NumberOfNodes = &v
	return s
}

// A set of elements to filter the returned node configurations.
type NodeConfigurationOptionsFilter struct {
	_ struct{} `type:"structure"`

	// The name of the element to filter.
	Name *string `type:"string" enum:"NodeConfigurationOptionsFilterName"`

	// The filter operator. If filter Name is NodeType only the 'in' operator is
	// supported. Provide one value to evaluate for 'eq', 'lt', 'le', 'gt', and
	// 'ge'. Provide two values to evaluate for 'between'. Provide a list of values
	// for 'in'.
	Operator *string `type:"string" enum:"OperatorType"`

	// List of values. Compare Name using Operator to Values. If filter Name is
	// NumberOfNodes, then values can range from 0 to 200. If filter Name is EstimatedDiskUtilizationPercent,
	// then values can range from 0 to 100. For example, filter NumberOfNodes (name)
	// GT (operator) 3 (values).
	Values []*string `locationName:"Value" locationNameList:"item" type:"list"`
}

// String returns the string representation
func (s NodeConfigurationOptionsFilter) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s NodeConfigurationOptionsFilter) GoString() string {
	return s.String()
}

// SetName sets the Name field's value.
func (s *NodeConfigurationOptionsFilter) SetName(v string) *NodeConfigurationOptionsFilter {
	s.Name = &v
	return s
}

// SetOperator sets the Operator field's value.
func (s *NodeConfigurationOptionsFilter) SetOperator(v string) *NodeConfigurationOptionsFilter {
	s.Operator = &v
	return s
}

// SetValues sets the Values field's value.
func (s *NodeConfigurationOptionsFilter) SetValues(v []*string) *NodeConfigurationOptionsFilter {
	s.Values = v
	return s
}

// Describes an orderable cluster option.
type OrderableClusterOption struct {
	_ struct{} `type:"structure"`

	// A list of availability zones for the orderable cluster.
	AvailabilityZones []*AvailabilityZone `locationNameList:"AvailabilityZone" type:"list"`

	// The cluster type, for example multi-node.
	ClusterType *string `type:"string"`

	// The version of the orderable cluster.
	ClusterVersion *string `type:"string"`

	// The node type for the orderable cluster.
	NodeType *string `type:"string"`
}

// String returns the string representation
func (s OrderableClusterOption) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s OrderableClusterOption) GoString() string {
	return s.String()
}

// SetAvailabilityZones sets the AvailabilityZones field's value.
func (s *OrderableClusterOption) SetAvailabilityZones(v []*AvailabilityZone) *OrderableClusterOption {
	s.AvailabilityZones = v
	return s
}

// SetClusterType sets the ClusterType field's value.
func (s *OrderableClusterOption) SetClusterType(v string) *OrderableClusterOption {
	s.ClusterType = &v
	return s
}

// SetClusterVersion sets the ClusterVersion field's value.
func (s *OrderableClusterOption) SetClusterVersion(v string) *OrderableClusterOption {
	s.ClusterVersion = &v
	return s
}

// SetNodeType sets the NodeType field's value.
func (s *OrderableClusterOption) SetNodeType(v string) *OrderableClusterOption {
	s.NodeType = &v
	return s
}

// Describes a parameter in a cluster parameter group.
type Parameter struct {
	_ struct{} `type:"structure"`

	// The valid range of values for the parameter.
	AllowedValues *string `type:"string"`

	// Specifies how to apply the WLM configuration parameter. Some properties can
	// be applied dynamically, while other properties require that any associated
	// clusters be rebooted for the configuration changes to be applied. For more
	// information about parameters and parameter groups, go to Amazon Redshift
	// Parameter Groups (https://docs.aws.amazon.com/redshift/latest/mgmt/working-with-parameter-groups.html)
	// in the Amazon Redshift Cluster Management Guide.
	ApplyType *string `type:"string" enum:"ParameterApplyType"`

	// The data type of the parameter.
	DataType *string `type:"string"`

	// A description of the parameter.
	Description *string `type:"string"`

	// If true, the parameter can be modified. Some parameters have security or
	// operational implications that prevent them from being changed.
	IsModifiable *bool `type:"boolean"`

	// The earliest engine version to which the parameter can apply.
	MinimumEngineVersion *string `type:"string"`

	// The name of the parameter.
	ParameterName *string `type:"string"`

	// The value of the parameter.
	ParameterValue *string `type:"string"`

	// The source of the parameter value, such as "engine-default" or "user".
	Source *string `type:"string"`
}

// String returns the string representation
func (s Parameter) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Parameter) GoString() string {
	return s.String()
}

// SetAllowedValues sets the AllowedValues field's value.
func (s *Parameter) SetAllowedValues(v string) *Parameter {
	s.AllowedValues = &v
	return s
}

// SetApplyType sets the ApplyType field's value.
func (s *Parameter) SetApplyType(v string) *Parameter {
	s.ApplyType = &v
	return s
}

// SetDataType sets the DataType field's value.
func (s *Parameter) SetDataType(v string) *Parameter {
	s.DataType = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *Parameter) SetDescription(v string) *Parameter {
	s.Description = &v
	return s
}

// SetIsModifiable sets the IsModifiable field's value.
func (s *Parameter) SetIsModifiable(v bool) *Parameter {
	s.IsModifiable = &v
	return s
}

// SetMinimumEngineVersion sets the MinimumEngineVersion field's value.
func (s *Parameter) SetMinimumEngineVersion(v string) *Parameter {
	s.MinimumEngineVersion = &v
	return s
}

// SetParameterName sets the ParameterName field's value.
func (s *Parameter) SetParameterName(v string) *Parameter {
	s.ParameterName = &v
	return s
}

// SetParameterValue sets the ParameterValue field's value.
func (s *Parameter) SetParameterValue(v string) *Parameter {
	s.ParameterValue = &v
	return s
}

// SetSource sets the Source field's value.
func (s *Parameter) SetSource(v string) *Parameter {
	s.Source = &v
	return s
}

// Describes cluster attributes that are in a pending state. A change to one
// or more the attributes was requested and is in progress or will be applied.
type PendingModifiedValues struct {
	_ struct{} `type:"structure"`

	// The pending or in-progress change of the automated snapshot retention period.
	AutomatedSnapshotRetentionPeriod *int64 `type:"integer"`

	// The pending or in-progress change of the new identifier for the cluster.
	ClusterIdentifier *string `type:"string"`

	// The pending or in-progress change of the cluster type.
	ClusterType *string `type:"string"`

	// The pending or in-progress change of the service version.
	ClusterVersion *string `type:"string"`

	// The encryption type for a cluster. Possible values are: KMS and None. For
	// the China region the possible values are None, and Legacy.
	EncryptionType *string `type:"string"`

	// An option that specifies whether to create the cluster with enhanced VPC
	// routing enabled. To create a cluster that uses enhanced VPC routing, the
	// cluster must be in a VPC. For more information, see Enhanced VPC Routing
	// (https://docs.aws.amazon.com/redshift/latest/mgmt/enhanced-vpc-routing.html)
	// in the Amazon Redshift Cluster Management Guide.
	//
	// If this option is true, enhanced VPC routing is enabled.
	//
	// Default: false
	EnhancedVpcRouting *bool `type:"boolean"`

	// The name of the maintenance track that the cluster will change to during
	// the next maintenance window.
	MaintenanceTrackName *string `type:"string"`

	// The pending or in-progress change of the master user password for the cluster.
	MasterUserPassword *string `type:"string"`

	// The pending or in-progress change of the cluster's node type.
	NodeType *string `type:"string"`

	// The pending or in-progress change of the number of nodes in the cluster.
	NumberOfNodes *int64 `type:"integer"`

	// The pending or in-progress change of the ability to connect to the cluster
	// from the public network.
	PubliclyAccessible *bool `type:"boolean"`
}

// String returns the string representation
func (s PendingModifiedValues) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PendingModifiedValues) GoString() string {
	return s.String()
}

// SetAutomatedSnapshotRetentionPeriod sets the AutomatedSnapshotRetentionPeriod field's value.
func (s *PendingModifiedValues) SetAutomatedSnapshotRetentionPeriod(v int64) *PendingModifiedValues {
	s.AutomatedSnapshotRetentionPeriod = &v
	return s
}

// SetClusterIdentifier sets the ClusterIdentifier field's value.
func (s *PendingModifiedValues) SetClusterIdentifier(v string) *PendingModifiedValues {
	s.ClusterIdentifier = &v
	return s
}

// SetClusterType sets the ClusterType field's value.
func (s *PendingModifiedValues) SetClusterType(v string) *PendingModifiedValues {
	s.ClusterType = &v
	return s
}

// SetClusterVersion sets the ClusterVersion field's value.
func (s *PendingModifiedValues) SetClusterVersion(v string) *PendingModifiedValues {
	s.ClusterVersion = &v
	return s
}

// SetEncryptionType sets the EncryptionType field's value.
func (s *PendingModifiedValues) SetEncryptionType(v string) *PendingModifiedValues {
	s.EncryptionType = &v
	return s
}

// SetEnhancedVpcRouting sets the EnhancedVpcRouting field's value.
func (s *PendingModifiedValues) SetEnhancedVpcRouting(v bool) *PendingModifiedValues {
	s.EnhancedVpcRouting = &v
	return s
}

// SetMaintenanceTrackName sets the MaintenanceTrackName field's value.
func (s *PendingModifiedValues) SetMaintenanceTrackName(v string) *PendingModifiedValues {
	s.MaintenanceTrackName = &v
	return s
}

// SetMasterUserPassword sets the MasterUserPassword field's value.
func (s *PendingModifiedValues) SetMasterUserPassword(v string) *PendingModifiedValues {
	s.MasterUserPassword = &v
	return s
}

// SetNodeType sets the NodeType field's value.
func (s *PendingModifiedValues) SetNodeType(v string) *PendingModifiedValues {
	s.NodeType = &v
	return s
}

// SetNumberOfNodes sets the NumberOfNodes field's value.
func (s *PendingModifiedValues) SetNumberOfNodes(v int64) *PendingModifiedValues {
	s.NumberOfNodes = &v
	return s
}

// SetPubliclyAccessible sets the PubliclyAccessible field's value.
func (s *PendingModifiedValues) SetPubliclyAccessible(v bool) *PendingModifiedValues {
	s.PubliclyAccessible = &v
	return s
}

type PurchaseReservedNodeOfferingInput struct {
	_ struct{} `type:"structure"`

	// The number of reserved nodes that you want to purchase.
	//
	// Default: 1
	NodeCount *int64 `type:"integer"`

	// The unique identifier of the reserved node offering you want to purchase.
	//
	// ReservedNodeOfferingId is a required field
	ReservedNodeOfferingId *string `type:"string" required:"true"`
}

// String returns the string representation
func (s PurchaseReservedNodeOfferingInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PurchaseReservedNodeOfferingInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PurchaseReservedNodeOfferingInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "PurchaseReservedNodeOfferingInput"}
	if s.ReservedNodeOfferingId == nil {
		invalidParams.Add(request.NewErrParamRequired("ReservedNodeOfferingId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetNodeCount sets the NodeCount field's value.
func (s *PurchaseReservedNodeOfferingInput) SetNodeCount(v int64) *PurchaseReservedNodeOfferingInput {
	s.NodeCount = &v
	return s
}

// SetReservedNodeOfferingId sets the ReservedNodeOfferingId field's value.
func (s *PurchaseReservedNodeOfferingInput) SetReservedNodeOfferingId(v string) *PurchaseReservedNodeOfferingInput {
	s.ReservedNodeOfferingId = &v
	return s
}

type PurchaseReservedNodeOfferingOutput struct {
	_ struct{} `type:"structure"`

	// Describes a reserved node. You can call the DescribeReservedNodeOfferings
	// API to obtain the available reserved node offerings.
	ReservedNode *ReservedNode `type:"structure"`
}

// String returns the string representation
func (s PurchaseReservedNodeOfferingOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PurchaseReservedNodeOfferingOutput) GoString() string {
	return s.String()
}

// SetReservedNode sets the ReservedNode field's value.
func (s *PurchaseReservedNodeOfferingOutput) SetReservedNode(v *ReservedNode) *PurchaseReservedNodeOfferingOutput {
	s.ReservedNode = v
	return s
}

type RebootClusterInput struct {
	_ struct{} `type:"structure"`

	// The cluster identifier.
	//
	// ClusterIdentifier is a required field
	ClusterIdentifier *string `type:"string" required:"true"`
}

// String returns the string representation
func (s RebootClusterInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RebootClusterInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *RebootClusterInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "RebootClusterInput"}
	if s.ClusterIdentifier == nil {
		invalidParams.Add(request.NewErrParamRequired("ClusterIdentifier"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClusterIdentifier sets the ClusterIdentifier field's value.
func (s *RebootClusterInput) SetClusterIdentifier(v string) *RebootClusterInput {
	s.ClusterIdentifier = &v
	return s
}

type RebootClusterOutput struct {
	_ struct{} `type:"structure"`

	// Describes a cluster.
	Cluster *Cluster `type:"structure"`
}

// String returns the string representation
func (s RebootClusterOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RebootClusterOutput) GoString() string {
	return s.String()
}

// SetCluster sets the Cluster field's value.
func (s *RebootClusterOutput) SetCluster(v *Cluster) *RebootClusterOutput {
	s.Cluster = v
	return s
}

// Describes a recurring charge.
type RecurringCharge struct {
	_ struct{} `type:"structure"`

	// The amount charged per the period of time specified by the recurring charge
	// frequency.
	RecurringChargeAmount *float64 `type:"double"`

	// The frequency at which the recurring charge amount is applied.
	RecurringChargeFrequency *string `type:"string"`
}

// String returns the string representation
func (s RecurringCharge) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RecurringCharge) GoString() string {
	return s.String()
}

// SetRecurringChargeAmount sets the RecurringChargeAmount field's value.
func (s *RecurringCharge) SetRecurringChargeAmount(v float64) *RecurringCharge {
	s.RecurringChargeAmount = &v
	return s
}

// SetRecurringChargeFrequency sets the RecurringChargeFrequency field's value.
func (s *RecurringCharge) SetRecurringChargeFrequency(v string) *RecurringCharge {
	s.RecurringChargeFrequency = &v
	return s
}

// Describes a reserved node. You can call the DescribeReservedNodeOfferings
// API to obtain the available reserved node offerings.
type ReservedNode struct {
	_ struct{} `type:"structure"`

	// The currency code for the reserved cluster.
	CurrencyCode *string `type:"string"`

	// The duration of the node reservation in seconds.
	Duration *int64 `type:"integer"`

	// The fixed cost Amazon Redshift charges you for this reserved node.
	FixedPrice *float64 `type:"double"`

	// The number of reserved compute nodes.
	NodeCount *int64 `type:"integer"`

	// The node type of the reserved node.
	NodeType *string `type:"string"`

	// The anticipated utilization of the reserved node, as defined in the reserved
	// node offering.
	OfferingType *string `type:"string"`

	// The recurring charges for the reserved node.
	RecurringCharges []*RecurringCharge `locationNameList:"RecurringCharge" type:"list"`

	// The unique identifier for the reservation.
	ReservedNodeId *string `type:"string"`

	// The identifier for the reserved node offering.
	ReservedNodeOfferingId *string `type:"string"`

	ReservedNodeOfferingType *string `type:"string" enum:"ReservedNodeOfferingType"`

	// The time the reservation started. You purchase a reserved node offering for
	// a duration. This is the start time of that duration.
	StartTime *time.Time `type:"timestamp"`

	// The state of the reserved compute node.
	//
	// Possible Values:
	//
	//    * pending-payment-This reserved node has recently been purchased, and
	//    the sale has been approved, but payment has not yet been confirmed.
	//
	//    * active-This reserved node is owned by the caller and is available for
	//    use.
	//
	//    * payment-failed-Payment failed for the purchase attempt.
	//
	//    * retired-The reserved node is no longer available.
	//
	//    * exchanging-The owner is exchanging the reserved node for another reserved
	//    node.
	State *string `type:"string"`

	// The hourly rate Amazon Redshift charges you for this reserved node.
	UsagePrice *float64 `type:"double"`
}

// String returns the string representation
func (s ReservedNode) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ReservedNode) GoString() string {
	return s.String()
}

// SetCurrencyCode sets the CurrencyCode field's value.
func (s *ReservedNode) SetCurrencyCode(v string) *ReservedNode {
	s.CurrencyCode = &v
	return s
}

// SetDuration sets the Duration field's value.
func (s *ReservedNode) SetDuration(v int64) *ReservedNode {
	s.Duration = &v
	return s
}

// SetFixedPrice sets the FixedPrice field's value.
func (s *ReservedNode) SetFixedPrice(v float64) *ReservedNode {
	s.FixedPrice = &v
	return s
}

// SetNodeCount sets the NodeCount field's value.
func (s *ReservedNode) SetNodeCount(v int64) *ReservedNode {
	s.NodeCount = &v
	return s
}

// SetNodeType sets the NodeType field's value.
func (s *ReservedNode) SetNodeType(v string) *ReservedNode {
	s.NodeType = &v
	return s
}

// SetOfferingType sets the OfferingType field's value.
func (s *ReservedNode) SetOfferingType(v string) *ReservedNode {
	s.OfferingType = &v
	return s
}

// SetRecurringCharges sets the RecurringCharges field's value.
func (s *ReservedNode) SetRecurringCharges(v []*RecurringCharge) *ReservedNode {
	s.RecurringCharges = v
	return s
}

// SetReservedNodeId sets the ReservedNodeId field's value.
func (s *ReservedNode) SetReservedNodeId(v string) *ReservedNode {
	s.ReservedNodeId = &v
	return s
}

// SetReservedNodeOfferingId sets the ReservedNodeOfferingId field's value.
func (s *ReservedNode) SetReservedNodeOfferingId(v string) *ReservedNode {
	s.ReservedNodeOfferingId = &v
	return s
}

// SetReservedNodeOfferingType sets the ReservedNodeOfferingType field's value.
func (s *ReservedNode) SetReservedNodeOfferingType(v string) *ReservedNode {
	s.ReservedNodeOfferingType = &v
	return s
}

// SetStartTime sets the StartTime field's value.
func (s *ReservedNode) SetStartTime(v time.Time) *ReservedNode {
	s.StartTime = &v
	return s
}

// SetState sets the State field's value.
func (s *ReservedNode) SetState(v string) *ReservedNode {
	s.State = &v
	return s
}

// SetUsagePrice sets the UsagePrice field's value.
func (s *ReservedNode) SetUsagePrice(v float64) *ReservedNode {
	s.UsagePrice = &v
	return s
}

// Describes a reserved node offering.
type ReservedNodeOffering struct {
	_ struct{} `type:"structure"`

	// The currency code for the compute nodes offering.
	CurrencyCode *string `type:"string"`

	// The duration, in seconds, for which the offering will reserve the node.
	Duration *int64 `type:"integer"`

	// The upfront fixed charge you will pay to purchase the specific reserved node
	// offering.
	FixedPrice *float64 `type:"double"`

	// The node type offered by the reserved node offering.
	NodeType *string `type:"string"`

	// The anticipated utilization of the reserved node, as defined in the reserved
	// node offering.
	OfferingType *string `type:"string"`

	// The charge to your account regardless of whether you are creating any clusters
	// using the node offering. Recurring charges are only in effect for heavy-utilization
	// reserved nodes.
	RecurringCharges []*RecurringCharge `locationNameList:"RecurringCharge" type:"list"`

	// The offering identifier.
	ReservedNodeOfferingId *string `type:"string"`

	ReservedNodeOfferingType *string `type:"string" enum:"ReservedNodeOfferingType"`

	// The rate you are charged for each hour the cluster that is using the offering
	// is running.
	UsagePrice *float64 `type:"double"`
}

// String returns the string representation
func (s ReservedNodeOffering) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ReservedNodeOffering) GoString() string {
	return s.String()
}

// SetCurrencyCode sets the CurrencyCode field's value.
func (s *ReservedNodeOffering) SetCurrencyCode(v string) *ReservedNodeOffering {
	s.CurrencyCode = &v
	return s
}

// SetDuration sets the Duration field's value.
func (s *ReservedNodeOffering) SetDuration(v int64) *ReservedNodeOffering {
	s.Duration = &v
	return s
}

// SetFixedPrice sets the FixedPrice field's value.
func (s *ReservedNodeOffering) SetFixedPrice(v float64) *ReservedNodeOffering {
	s.FixedPrice = &v
	return s
}

// SetNodeType sets the NodeType field's value.
func (s *ReservedNodeOffering) SetNodeType(v string) *ReservedNodeOffering {
	s.NodeType = &v
	return s
}

// SetOfferingType sets the OfferingType field's value.
func (s *ReservedNodeOffering) SetOfferingType(v string) *ReservedNodeOffering {
	s.OfferingType = &v
	return s
}

// SetRecurringCharges sets the RecurringCharges field's value.
func (s *ReservedNodeOffering) SetRecurringCharges(v []*RecurringCharge) *ReservedNodeOffering {
	s.RecurringCharges = v
	return s
}

// SetReservedNodeOfferingId sets the ReservedNodeOfferingId field's value.
func (s *ReservedNodeOffering) SetReservedNodeOfferingId(v string) *ReservedNodeOffering {
	s.ReservedNodeOfferingId = &v
	return s
}

// SetReservedNodeOfferingType sets the ReservedNodeOfferingType field's value.
func (s *ReservedNodeOffering) SetReservedNodeOfferingType(v string) *ReservedNodeOffering {
	s.ReservedNodeOfferingType = &v
	return s
}

// SetUsagePrice sets the UsagePrice field's value.
func (s *ReservedNodeOffering) SetUsagePrice(v float64) *ReservedNodeOffering {
	s.UsagePrice = &v
	return s
}

type ResetClusterParameterGroupInput struct {
	_ struct{} `type:"structure"`

	// The name of the cluster parameter group to be reset.
	//
	// ParameterGroupName is a required field
	ParameterGroupName *string `type:"string" required:"true"`

	// An array of names of parameters to be reset. If ResetAllParameters option
	// is not used, then at least one parameter name must be supplied.
	//
	// Constraints: A maximum of 20 parameters can be reset in a single request.
	Parameters []*Parameter `locationNameList:"Parameter" type:"list"`

	// If true, all parameters in the specified parameter group will be reset to
	// their default values.
	//
	// Default: true
	ResetAllParameters *bool `type:"boolean"`
}

// String returns the string representation
func (s ResetClusterParameterGroupInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ResetClusterParameterGroupInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ResetClusterParameterGroupInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ResetClusterParameterGroupInput"}
	if s.ParameterGroupName == nil {
		invalidParams.Add(request.NewErrParamRequired("ParameterGroupName"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetParameterGroupName sets the ParameterGroupName field's value.
func (s *ResetClusterParameterGroupInput) SetParameterGroupName(v string) *ResetClusterParameterGroupInput {
	s.ParameterGroupName = &v
	return s
}

// SetParameters sets the Parameters field's value.
func (s *ResetClusterParameterGroupInput) SetParameters(v []*Parameter) *ResetClusterParameterGroupInput {
	s.Parameters = v
	return s
}

// SetResetAllParameters sets the ResetAllParameters field's value.
func (s *ResetClusterParameterGroupInput) SetResetAllParameters(v bool) *ResetClusterParameterGroupInput {
	s.ResetAllParameters = &v
	return s
}

type ResizeClusterInput struct {
	_ struct{} `type:"structure"`

	// A boolean value indicating whether the resize operation is using the classic
	// resize process. If you don't provide this parameter or set the value to false,
	// the resize type is elastic.
	Classic *bool `type:"boolean"`

	// The unique identifier for the cluster to resize.
	//
	// ClusterIdentifier is a required field
	ClusterIdentifier *string `type:"string" required:"true"`

	// The new cluster type for the specified cluster.
	ClusterType *string `type:"string"`

	// The new node type for the nodes you are adding. If not specified, the cluster's
	// current node type is used.
	NodeType *string `type:"string"`

	// The new number of nodes for the cluster.
	//
	// NumberOfNodes is a required field
	NumberOfNodes *int64 `type:"integer" required:"true"`
}

// String returns the string representation
func (s ResizeClusterInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ResizeClusterInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ResizeClusterInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ResizeClusterInput"}
	if s.ClusterIdentifier == nil {
		invalidParams.Add(request.NewErrParamRequired("ClusterIdentifier"))
	}
	if s.NumberOfNodes == nil {
		invalidParams.Add(request.NewErrParamRequired("NumberOfNodes"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClassic sets the Classic field's value.
func (s *ResizeClusterInput) SetClassic(v bool) *ResizeClusterInput {
	s.Classic = &v
	return s
}

// SetClusterIdentifier sets the ClusterIdentifier field's value.
func (s *ResizeClusterInput) SetClusterIdentifier(v string) *ResizeClusterInput {
	s.ClusterIdentifier = &v
	return s
}

// SetClusterType sets the ClusterType field's value.
func (s *ResizeClusterInput) SetClusterType(v string) *ResizeClusterInput {
	s.ClusterType = &v
	return s
}

// SetNodeType sets the NodeType field's value.
func (s *ResizeClusterInput) SetNodeType(v string) *ResizeClusterInput {
	s.NodeType = &v
	return s
}

// SetNumberOfNodes sets the NumberOfNodes field's value.
func (s *ResizeClusterInput) SetNumberOfNodes(v int64) *ResizeClusterInput {
	s.NumberOfNodes = &v
	return s
}

type ResizeClusterMessage struct {
	_ struct{} `type:"structure"`

	// A boolean value indicating whether the resize operation is using the classic
	// resize process. If you don't provide this parameter or set the value to false,
	// the resize type is elastic.
	Classic *bool `type:"boolean"`

	// The unique identifier for the cluster to resize.
	//
	// ClusterIdentifier is a required field
	ClusterIdentifier *string `type:"string" required:"true"`

	// The new cluster type for the specified cluster.
	ClusterType *string `type:"string"`

	// The new node type for the nodes you are adding. If not specified, the cluster's
	// current node type is used.
	NodeType *string `type:"string"`

	// The new number of nodes for the cluster.
	//
	// NumberOfNodes is a required field
	NumberOfNodes *int64 `type:"integer" required:"true"`
}

// String returns the string representation
func (s ResizeClusterMessage) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ResizeClusterMessage) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ResizeClusterMessage) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ResizeClusterMessage"}
	if s.ClusterIdentifier == nil {
		invalidParams.Add(request.NewErrParamRequired("ClusterIdentifier"))
	}
	if s.NumberOfNodes == nil {
		invalidParams.Add(request.NewErrParamRequired("NumberOfNodes"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClassic sets the Classic field's value.
func (s *ResizeClusterMessage) SetClassic(v bool) *ResizeClusterMessage {
	s.Classic = &v
	return s
}

// SetClusterIdentifier sets the ClusterIdentifier field's value.
func (s *ResizeClusterMessage) SetClusterIdentifier(v string) *ResizeClusterMessage {
	s.ClusterIdentifier = &v
	return s
}

// SetClusterType sets the ClusterType field's value.
func (s *ResizeClusterMessage) SetClusterType(v string) *ResizeClusterMessage {
	s.ClusterType = &v
	return s
}

// SetNodeType sets the NodeType field's value.
func (s *ResizeClusterMessage) SetNodeType(v string) *ResizeClusterMessage {
	s.NodeType = &v
	return s
}

// SetNumberOfNodes sets the NumberOfNodes field's value.
func (s *ResizeClusterMessage) SetNumberOfNodes(v int64) *ResizeClusterMessage {
	s.NumberOfNodes = &v
	return s
}

type ResizeClusterOutput struct {
	_ struct{} `type:"structure"`

	// Describes a cluster.
	Cluster *Cluster `type:"structure"`
}

// String returns the string representation
func (s ResizeClusterOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ResizeClusterOutput) GoString() string {
	return s.String()
}

// SetCluster sets the Cluster field's value.
func (s *ResizeClusterOutput) SetCluster(v *Cluster) *ResizeClusterOutput {
	s.Cluster = v
	return s
}

// Describes a resize operation.
type ResizeInfo struct {
	_ struct{} `type:"structure"`

	// A boolean value indicating if the resize operation can be cancelled.
	AllowCancelResize *bool `type:"boolean"`

	// Returns the value ClassicResize.
	ResizeType *string `type:"string"`
}

// String returns the string representation
func (s ResizeInfo) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ResizeInfo) GoString() string {
	return s.String()
}

// SetAllowCancelResize sets the AllowCancelResize field's value.
func (s *ResizeInfo) SetAllowCancelResize(v bool) *ResizeInfo {
	s.AllowCancelResize = &v
	return s
}

// SetResizeType sets the ResizeType field's value.
func (s *ResizeInfo) SetResizeType(v string) *ResizeInfo {
	s.ResizeType = &v
	return s
}

type RestoreFromClusterSnapshotInput struct {
	_ struct{} `type:"structure"`

	// Reserved.
	AdditionalInfo *string `type:"string"`

	// If true, major version upgrades can be applied during the maintenance window
	// to the Amazon Redshift engine that is running on the cluster.
	//
	// Default: true
	AllowVersionUpgrade *bool `type:"boolean"`

	// The number of days that automated snapshots are retained. If the value is
	// 0, automated snapshots are disabled. Even if automated snapshots are disabled,
	// you can still create manual snapshots when you want with CreateClusterSnapshot.
	//
	// Default: The value selected for the cluster from which the snapshot was taken.
	//
	// Constraints: Must be a value from 0 to 35.
	AutomatedSnapshotRetentionPeriod *int64 `type:"integer"`

	// The Amazon EC2 Availability Zone in which to restore the cluster.
	//
	// Default: A random, system-chosen Availability Zone.
	//
	// Example: us-east-2a
	AvailabilityZone *string `type:"string"`

	// The identifier of the cluster that will be created from restoring the snapshot.
	//
	// Constraints:
	//
	//    * Must contain from 1 to 63 alphanumeric characters or hyphens.
	//
	//    * Alphabetic characters must be lowercase.
	//
	//    * First character must be a letter.
	//
	//    * Cannot end with a hyphen or contain two consecutive hyphens.
	//
	//    * Must be unique for all clusters within an AWS account.
	//
	// ClusterIdentifier is a required field
	ClusterIdentifier *string `type:"string" required:"true"`

	// The name of the parameter group to be associated with this cluster.
	//
	// Default: The default Amazon Redshift cluster parameter group. For information
	// about the default parameter group, go to Working with Amazon Redshift Parameter
	// Groups (https://docs.aws.amazon.com/redshift/latest/mgmt/working-with-parameter-groups.html).
	//
	// Constraints:
	//
	//    * Must be 1 to 255 alphanumeric characters or hyphens.
	//
	//    * First character must be a letter.
	//
	//    * Cannot end with a hyphen or contain two consecutive hyphens.
	ClusterParameterGroupName *string `type:"string"`

	// A list of security groups to be associated with this cluster.
	//
	// Default: The default cluster security group for Amazon Redshift.
	//
	// Cluster security groups only apply to clusters outside of VPCs.
	ClusterSecurityGroups []*string `locationNameList:"ClusterSecurityGroupName" type:"list"`

	// The name of the subnet group where you want to cluster restored.
	//
	// A snapshot of cluster in VPC can be restored only in VPC. Therefore, you
	// must provide subnet group name where you want the cluster restored.
	ClusterSubnetGroupName *string `type:"string"`

	// The elastic IP (EIP) address for the cluster.
	ElasticIp *string `type:"string"`

	// An option that specifies whether to create the cluster with enhanced VPC
	// routing enabled. To create a cluster that uses enhanced VPC routing, the
	// cluster must be in a VPC. For more information, see Enhanced VPC Routing
	// (https://docs.aws.amazon.com/redshift/latest/mgmt/enhanced-vpc-routing.html)
	// in the Amazon Redshift Cluster Management Guide.
	//
	// If this option is true, enhanced VPC routing is enabled.
	//
	// Default: false
	EnhancedVpcRouting *bool `type:"boolean"`

	// Specifies the name of the HSM client certificate the Amazon Redshift cluster
	// uses to retrieve the data encryption keys stored in an HSM.
	HsmClientCertificateIdentifier *string `type:"string"`

	// Specifies the name of the HSM configuration that contains the information
	// the Amazon Redshift cluster can use to retrieve and store keys in an HSM.
	HsmConfigurationIdentifier *string `type:"string"`

	// A list of AWS Identity and Access Management (IAM) roles that can be used
	// by the cluster to access other AWS services. You must supply the IAM roles
	// in their Amazon Resource Name (ARN) format. You can supply up to 10 IAM roles
	// in a single request.
	//
	// A cluster can have up to 10 IAM roles associated at any time.
	IamRoles []*string `locationNameList:"IamRoleArn" type:"list"`

	// The AWS Key Management Service (KMS) key ID of the encryption key that you
	// want to use to encrypt data in the cluster that you restore from a shared
	// snapshot.
	KmsKeyId *string `type:"string"`

	// The name of the maintenance track for the restored cluster. When you take
	// a snapshot, the snapshot inherits the MaintenanceTrack value from the cluster.
	// The snapshot might be on a different track than the cluster that was the
	// source for the snapshot. For example, suppose that you take a snapshot of
	// a cluster that is on the current track and then change the cluster to be
	// on the trailing track. In this case, the snapshot and the source cluster
	// are on different tracks.
	MaintenanceTrackName *string `type:"string"`

	// The default number of days to retain a manual snapshot. If the value is -1,
	// the snapshot is retained indefinitely. This setting doesn't change the retention
	// period of existing snapshots.
	//
	// The value must be either -1 or an integer between 1 and 3,653.
	ManualSnapshotRetentionPeriod *int64 `type:"integer"`

	// The node type that the restored cluster will be provisioned with.
	//
	// Default: The node type of the cluster from which the snapshot was taken.
	// You can modify this if you are using any DS node type. In that case, you
	// can choose to restore into another DS node type of the same size. For example,
	// you can restore ds1.8xlarge into ds2.8xlarge, or ds1.xlarge into ds2.xlarge.
	// If you have a DC instance type, you must restore into that same instance
	// type and size. In other words, you can only restore a dc1.large instance
	// type into another dc1.large instance type or dc2.large instance type. You
	// can't restore dc1.8xlarge to dc2.8xlarge. First restore to a dc1.8xlareg
	// cluster, then resize to a dc2.8large cluster. For more information about
	// node types, see About Clusters and Nodes (https://docs.aws.amazon.com/redshift/latest/mgmt/working-with-clusters.html#rs-about-clusters-and-nodes)
	// in the Amazon Redshift Cluster Management Guide.
	NodeType *string `type:"string"`

	// The number of nodes specified when provisioning the restored cluster.
	NumberOfNodes *int64 `type:"integer"`

	// The AWS customer account used to create or copy the snapshot. Required if
	// you are restoring a snapshot you do not own, optional if you own the snapshot.
	OwnerAccount *string `type:"string"`

	// The port number on which the cluster accepts connections.
	//
	// Default: The same port as the original cluster.
	//
	// Constraints: Must be between 1115 and 65535.
	Port *int64 `type:"integer"`

	// The weekly time range (in UTC) during which automated cluster maintenance
	// can occur.
	//
	// Format: ddd:hh24:mi-ddd:hh24:mi
	//
	// Default: The value selected for the cluster from which the snapshot was taken.
	// For more information about the time blocks for each region, see Maintenance
	// Windows (https://docs.aws.amazon.com/redshift/latest/mgmt/working-with-clusters.html#rs-maintenance-windows)
	// in Amazon Redshift Cluster Management Guide.
	//
	// Valid Days: Mon | Tue | Wed | Thu | Fri | Sat | Sun
	//
	// Constraints: Minimum 30-minute window.
	PreferredMaintenanceWindow *string `type:"string"`

	// If true, the cluster can be accessed from a public network.
	PubliclyAccessible *bool `type:"boolean"`

	// The name of the cluster the source snapshot was created from. This parameter
	// is required if your IAM user has a policy containing a snapshot resource
	// element that specifies anything other than * for the cluster name.
	SnapshotClusterIdentifier *string `type:"string"`

	// The name of the snapshot from which to create the new cluster. This parameter
	// isn't case sensitive.
	//
	// Example: my-snapshot-id
	//
	// SnapshotIdentifier is a required field
	SnapshotIdentifier *string `type:"string" required:"true"`

	// A unique identifier for the snapshot schedule.
	SnapshotScheduleIdentifier *string `type:"string"`

	// A list of Virtual Private Cloud (VPC) security groups to be associated with
	// the cluster.
	//
	// Default: The default VPC security group is associated with the cluster.
	//
	// VPC security groups only apply to clusters in VPCs.
	VpcSecurityGroupIds []*string `locationNameList:"VpcSecurityGroupId" type:"list"`
}

// String returns the string representation
func (s RestoreFromClusterSnapshotInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RestoreFromClusterSnapshotInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *RestoreFromClusterSnapshotInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "RestoreFromClusterSnapshotInput"}
	if s.ClusterIdentifier == nil {
		invalidParams.Add(request.NewErrParamRequired("ClusterIdentifier"))
	}
	if s.SnapshotIdentifier == nil {
		invalidParams.Add(request.NewErrParamRequired("SnapshotIdentifier"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAdditionalInfo sets the AdditionalInfo field's value.
func (s *RestoreFromClusterSnapshotInput) SetAdditionalInfo(v string) *RestoreFromClusterSnapshotInput {
	s.AdditionalInfo = &v
	return s
}

// SetAllowVersionUpgrade sets the AllowVersionUpgrade field's value.
func (s *RestoreFromClusterSnapshotInput) SetAllowVersionUpgrade(v bool) *RestoreFromClusterSnapshotInput {
	s.AllowVersionUpgrade = &v
	return s
}

// SetAutomatedSnapshotRetentionPeriod sets the AutomatedSnapshotRetentionPeriod field's value.
func (s *RestoreFromClusterSnapshotInput) SetAutomatedSnapshotRetentionPeriod(v int64) *RestoreFromClusterSnapshotInput {
	s.AutomatedSnapshotRetentionPeriod = &v
	return s
}

// SetAvailabilityZone sets the AvailabilityZone field's value.
func (s *RestoreFromClusterSnapshotInput) SetAvailabilityZone(v string) *RestoreFromClusterSnapshotInput {
	s.AvailabilityZone = &v
	return s
}

// SetClusterIdentifier sets the ClusterIdentifier field's value.
func (s *RestoreFromClusterSnapshotInput) SetClusterIdentifier(v string) *RestoreFromClusterSnapshotInput {
	s.ClusterIdentifier = &v
	return s
}

// SetClusterParameterGroupName sets the ClusterParameterGroupName field's value.
func (s *RestoreFromClusterSnapshotInput) SetClusterParameterGroupName(v string) *RestoreFromClusterSnapshotInput {
	s.ClusterParameterGroupName = &v
	return s
}

// SetClusterSecurityGroups sets the ClusterSecurityGroups field's value.
func (s *RestoreFromClusterSnapshotInput) SetClusterSecurityGroups(v []*string) *RestoreFromClusterSnapshotInput {
	s.ClusterSecurityGroups = v
	return s
}

// SetClusterSubnetGroupName sets the ClusterSubnetGroupName field's value.
func (s *RestoreFromClusterSnapshotInput) SetClusterSubnetGroupName(v string) *RestoreFromClusterSnapshotInput {
	s.ClusterSubnetGroupName = &v
	return s
}

// SetElasticIp sets the ElasticIp field's value.
func (s *RestoreFromClusterSnapshotInput) SetElasticIp(v string) *RestoreFromClusterSnapshotInput {
	s.ElasticIp = &v
	return s
}

// SetEnhancedVpcRouting sets the EnhancedVpcRouting field's value.
func (s *RestoreFromClusterSnapshotInput) SetEnhancedVpcRouting(v bool) *RestoreFromClusterSnapshotInput {
	s.EnhancedVpcRouting = &v
	return s
}

// SetHsmClientCertificateIdentifier sets the HsmClientCertificateIdentifier field's value.
func (s *RestoreFromClusterSnapshotInput) SetHsmClientCertificateIdentifier(v string) *RestoreFromClusterSnapshotInput {
	s.HsmClientCertificateIdentifier = &v
	return s
}

// SetHsmConfigurationIdentifier sets the HsmConfigurationIdentifier field's value.
func (s *RestoreFromClusterSnapshotInput) SetHsmConfigurationIdentifier(v string) *RestoreFromClusterSnapshotInput {
	s.HsmConfigurationIdentifier = &v
	return s
}

// SetIamRoles sets the IamRoles field's value.
func (s *RestoreFromClusterSnapshotInput) SetIamRoles(v []*string) *RestoreFromClusterSnapshotInput {
	s.IamRoles = v
	return s
}

// SetKmsKeyId sets the KmsKeyId field's value.
func (s *RestoreFromClusterSnapshotInput) SetKmsKeyId(v string) *RestoreFromClusterSnapshotInput {
	s.KmsKeyId = &v
	return s
}

// SetMaintenanceTrackName sets the MaintenanceTrackName field's value.
func (s *RestoreFromClusterSnapshotInput) SetMaintenanceTrackName(v string) *RestoreFromClusterSnapshotInput {
	s.MaintenanceTrackName = &v
	return s
}

// SetManualSnapshotRetentionPeriod sets the ManualSnapshotRetentionPeriod field's value.
func (s *RestoreFromClusterSnapshotInput) SetManualSnapshotRetentionPeriod(v int64) *RestoreFromClusterSnapshotInput {
	s.ManualSnapshotRetentionPeriod = &v
	return s
}

// SetNodeType sets the NodeType field's value.
func (s *RestoreFromClusterSnapshotInput) SetNodeType(v string) *RestoreFromClusterSnapshotInput {
	s.NodeType = &v
	return s
}

// SetNumberOfNodes sets the NumberOfNodes field's value.
func (s *RestoreFromClusterSnapshotInput) SetNumberOfNodes(v int64) *RestoreFromClusterSnapshotInput {
	s.NumberOfNodes = &v
	return s
}

// SetOwnerAccount sets the OwnerAccount field's value.
func (s *RestoreFromClusterSnapshotInput) SetOwnerAccount(v string) *RestoreFromClusterSnapshotInput {
	s.OwnerAccount = &v
	return s
}

// SetPort sets the Port field's value.
func (s *RestoreFromClusterSnapshotInput) SetPort(v int64) *RestoreFromClusterSnapshotInput {
	s.Port = &v
	return s
}

// SetPreferredMaintenanceWindow sets the PreferredMaintenanceWindow field's value.
func (s *RestoreFromClusterSnapshotInput) SetPreferredMaintenanceWindow(v string) *RestoreFromClusterSnapshotInput {
	s.PreferredMaintenanceWindow = &v
	return s
}

// SetPubliclyAccessible sets the PubliclyAccessible field's value.
func (s *RestoreFromClusterSnapshotInput) SetPubliclyAccessible(v bool) *RestoreFromClusterSnapshotInput {
	s.PubliclyAccessible = &v
	return s
}

// SetSnapshotClusterIdentifier sets the SnapshotClusterIdentifier field's value.
func (s *RestoreFromClusterSnapshotInput) SetSnapshotClusterIdentifier(v string) *RestoreFromClusterSnapshotInput {
	s.SnapshotClusterIdentifier = &v
	return s
}

// SetSnapshotIdentifier sets the SnapshotIdentifier field's value.
func (s *RestoreFromClusterSnapshotInput) SetSnapshotIdentifier(v string) *RestoreFromClusterSnapshotInput {
	s.SnapshotIdentifier = &v
	return s
}

// SetSnapshotScheduleIdentifier sets the SnapshotScheduleIdentifier field's value.
func (s *RestoreFromClusterSnapshotInput) SetSnapshotScheduleIdentifier(v string) *RestoreFromClusterSnapshotInput {
	s.SnapshotScheduleIdentifier = &v
	return s
}

// SetVpcSecurityGroupIds sets the VpcSecurityGroupIds field's value.
func (s *RestoreFromClusterSnapshotInput) SetVpcSecurityGroupIds(v []*string) *RestoreFromClusterSnapshotInput {
	s.VpcSecurityGroupIds = v
	return s
}

type RestoreFromClusterSnapshotOutput struct {
	_ struct{} `type:"structure"`

	// Describes a cluster.
	Cluster *Cluster `type:"structure"`
}

// String returns the string representation
func (s RestoreFromClusterSnapshotOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RestoreFromClusterSnapshotOutput) GoString() string {
	return s.String()
}

// SetCluster sets the Cluster field's value.
func (s *RestoreFromClusterSnapshotOutput) SetCluster(v *Cluster) *RestoreFromClusterSnapshotOutput {
	s.Cluster = v
	return s
}

// Describes the status of a cluster restore action. Returns null if the cluster
// was not created by restoring a snapshot.
type RestoreStatus struct {
	_ struct{} `type:"structure"`

	// The number of megabytes per second being transferred from the backup storage.
	// Returns the average rate for a completed backup. This field is only updated
	// when you restore to DC2 and DS2 node types.
	CurrentRestoreRateInMegaBytesPerSecond *float64 `type:"double"`

	// The amount of time an in-progress restore has been running, or the amount
	// of time it took a completed restore to finish. This field is only updated
	// when you restore to DC2 and DS2 node types.
	ElapsedTimeInSeconds *int64 `type:"long"`

	// The estimate of the time remaining before the restore will complete. Returns
	// 0 for a completed restore. This field is only updated when you restore to
	// DC2 and DS2 node types.
	EstimatedTimeToCompletionInSeconds *int64 `type:"long"`

	// The number of megabytes that have been transferred from snapshot storage.
	// This field is only updated when you restore to DC2 and DS2 node types.
	ProgressInMegaBytes *int64 `type:"long"`

	// The size of the set of snapshot data used to restore the cluster. This field
	// is only updated when you restore to DC2 and DS2 node types.
	SnapshotSizeInMegaBytes *int64 `type:"long"`

	// The status of the restore action. Returns starting, restoring, completed,
	// or failed.
	Status *string `type:"string"`
}

// String returns the string representation
func (s RestoreStatus) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RestoreStatus) GoString() string {
	return s.String()
}

// SetCurrentRestoreRateInMegaBytesPerSecond sets the CurrentRestoreRateInMegaBytesPerSecond field's value.
func (s *RestoreStatus) SetCurrentRestoreRateInMegaBytesPerSecond(v float64) *RestoreStatus {
	s.CurrentRestoreRateInMegaBytesPerSecond = &v
	return s
}

// SetElapsedTimeInSeconds sets the ElapsedTimeInSeconds field's value.
func (s *RestoreStatus) SetElapsedTimeInSeconds(v int64) *RestoreStatus {
	s.ElapsedTimeInSeconds = &v
	return s
}

// SetEstimatedTimeToCompletionInSeconds sets the EstimatedTimeToCompletionInSeconds field's value.
func (s *RestoreStatus) SetEstimatedTimeToCompletionInSeconds(v int64) *RestoreStatus {
	s.EstimatedTimeToCompletionInSeconds = &v
	return s
}

// SetProgressInMegaBytes sets the ProgressInMegaBytes field's value.
func (s *RestoreStatus) SetProgressInMegaBytes(v int64) *RestoreStatus {
	s.ProgressInMegaBytes = &v
	return s
}

// SetSnapshotSizeInMegaBytes sets the SnapshotSizeInMegaBytes field's value.
func (s *RestoreStatus) SetSnapshotSizeInMegaBytes(v int64) *RestoreStatus {
	s.SnapshotSizeInMegaBytes = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *RestoreStatus) SetStatus(v string) *RestoreStatus {
	s.Status = &v
	return s
}

type RestoreTableFromClusterSnapshotInput struct {
	_ struct{} `type:"structure"`

	// The identifier of the Amazon Redshift cluster to restore the table to.
	//
	// ClusterIdentifier is a required field
	ClusterIdentifier *string `type:"string" required:"true"`

	// The name of the table to create as a result of the current request.
	//
	// NewTableName is a required field
	NewTableName *string `type:"string" required:"true"`

	// The identifier of the snapshot to restore the table from. This snapshot must
	// have been created from the Amazon Redshift cluster specified by the ClusterIdentifier
	// parameter.
	//
	// SnapshotIdentifier is a required field
	SnapshotIdentifier *string `type:"string" required:"true"`

	// The name of the source database that contains the table to restore from.
	//
	// SourceDatabaseName is a required field
	SourceDatabaseName *string `type:"string" required:"true"`

	// The name of the source schema that contains the table to restore from. If
	// you do not specify a SourceSchemaName value, the default is public.
	SourceSchemaName *string `type:"string"`

	// The name of the source table to restore from.
	//
	// SourceTableName is a required field
	SourceTableName *string `type:"string" required:"true"`

	// The name of the database to restore the table to.
	TargetDatabaseName *string `type:"string"`

	// The name of the schema to restore the table to.
	TargetSchemaName *string `type:"string"`
}

// String returns the string representation
func (s RestoreTableFromClusterSnapshotInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RestoreTableFromClusterSnapshotInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *RestoreTableFromClusterSnapshotInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "RestoreTableFromClusterSnapshotInput"}
	if s.ClusterIdentifier == nil {
		invalidParams.Add(request.NewErrParamRequired("ClusterIdentifier"))
	}
	if s.NewTableName == nil {
		invalidParams.Add(request.NewErrParamRequired("NewTableName"))
	}
	if s.SnapshotIdentifier == nil {
		invalidParams.Add(request.NewErrParamRequired("SnapshotIdentifier"))
	}
	if s.SourceDatabaseName == nil {
		invalidParams.Add(request.NewErrParamRequired("SourceDatabaseName"))
	}
	if s.SourceTableName == nil {
		invalidParams.Add(request.NewErrParamRequired("SourceTableName"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClusterIdentifier sets the ClusterIdentifier field's value.
func (s *RestoreTableFromClusterSnapshotInput) SetClusterIdentifier(v string) *RestoreTableFromClusterSnapshotInput {
	s.ClusterIdentifier = &v
	return s
}

// SetNewTableName sets the NewTableName field's value.
func (s *RestoreTableFromClusterSnapshotInput) SetNewTableName(v string) *RestoreTableFromClusterSnapshotInput {
	s.NewTableName = &v
	return s
}

// SetSnapshotIdentifier sets the SnapshotIdentifier field's value.
func (s *RestoreTableFromClusterSnapshotInput) SetSnapshotIdentifier(v string) *RestoreTableFromClusterSnapshotInput {
	s.SnapshotIdentifier = &v
	return s
}

// SetSourceDatabaseName sets the SourceDatabaseName field's value.
func (s *RestoreTableFromClusterSnapshotInput) SetSourceDatabaseName(v string) *RestoreTableFromClusterSnapshotInput {
	s.SourceDatabaseName = &v
	return s
}

// SetSourceSchemaName sets the SourceSchemaName field's value.
func (s *RestoreTableFromClusterSnapshotInput) SetSourceSchemaName(v string) *RestoreTableFromClusterSnapshotInput {
	s.SourceSchemaName = &v
	return s
}

// SetSourceTableName sets the SourceTableName field's value.
func (s *RestoreTableFromClusterSnapshotInput) SetSourceTableName(v string) *RestoreTableFromClusterSnapshotInput {
	s.SourceTableName = &v
	return s
}

// SetTargetDatabaseName sets the TargetDatabaseName field's value.
func (s *RestoreTableFromClusterSnapshotInput) SetTargetDatabaseName(v string) *RestoreTableFromClusterSnapshotInput {
	s.TargetDatabaseName = &v
	return s
}

// SetTargetSchemaName sets the TargetSchemaName field's value.
func (s *RestoreTableFromClusterSnapshotInput) SetTargetSchemaName(v string) *RestoreTableFromClusterSnapshotInput {
	s.TargetSchemaName = &v
	return s
}

type RestoreTableFromClusterSnapshotOutput struct {
	_ struct{} `type:"structure"`

	// Describes the status of a RestoreTableFromClusterSnapshot operation.
	TableRestoreStatus *TableRestoreStatus `type:"structure"`
}

// String returns the string representation
func (s RestoreTableFromClusterSnapshotOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RestoreTableFromClusterSnapshotOutput) GoString() string {
	return s.String()
}

// SetTableRestoreStatus sets the TableRestoreStatus field's value.
func (s *RestoreTableFromClusterSnapshotOutput) SetTableRestoreStatus(v *TableRestoreStatus) *RestoreTableFromClusterSnapshotOutput {
	s.TableRestoreStatus = v
	return s
}

// Describes a RevisionTarget.
type RevisionTarget struct {
	_ struct{} `type:"structure"`

	// A unique string that identifies the version to update the cluster to. You
	// can use this value in ModifyClusterDbRevision.
	DatabaseRevision *string `type:"string"`

	// The date on which the database revision was released.
	DatabaseRevisionReleaseDate *time.Time `type:"timestamp"`

	// A string that describes the changes and features that will be applied to
	// the cluster when it is updated to the corresponding ClusterDbRevision.
	Description *string `type:"string"`
}

// String returns the string representation
func (s RevisionTarget) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RevisionTarget) GoString() string {
	return s.String()
}

// SetDatabaseRevision sets the DatabaseRevision field's value.
func (s *RevisionTarget) SetDatabaseRevision(v string) *RevisionTarget {
	s.DatabaseRevision = &v
	return s
}

// SetDatabaseRevisionReleaseDate sets the DatabaseRevisionReleaseDate field's value.
func (s *RevisionTarget) SetDatabaseRevisionReleaseDate(v time.Time) *RevisionTarget {
	s.DatabaseRevisionReleaseDate = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *RevisionTarget) SetDescription(v string) *RevisionTarget {
	s.Description = &v
	return s
}

type RevokeClusterSecurityGroupIngressInput struct {
	_ struct{} `type:"structure"`

	// The IP range for which to revoke access. This range must be a valid Classless
	// Inter-Domain Routing (CIDR) block of IP addresses. If CIDRIP is specified,
	// EC2SecurityGroupName and EC2SecurityGroupOwnerId cannot be provided.
	CIDRIP *string `type:"string"`

	// The name of the security Group from which to revoke the ingress rule.
	//
	// ClusterSecurityGroupName is a required field
	ClusterSecurityGroupName *string `type:"string" required:"true"`

	// The name of the EC2 Security Group whose access is to be revoked. If EC2SecurityGroupName
	// is specified, EC2SecurityGroupOwnerId must also be provided and CIDRIP cannot
	// be provided.
	EC2SecurityGroupName *string `type:"string"`

	// The AWS account number of the owner of the security group specified in the
	// EC2SecurityGroupName parameter. The AWS access key ID is not an acceptable
	// value. If EC2SecurityGroupOwnerId is specified, EC2SecurityGroupName must
	// also be provided. and CIDRIP cannot be provided.
	//
	// Example: 111122223333
	EC2SecurityGroupOwnerId *string `type:"string"`
}

// String returns the string representation
func (s RevokeClusterSecurityGroupIngressInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RevokeClusterSecurityGroupIngressInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *RevokeClusterSecurityGroupIngressInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "RevokeClusterSecurityGroupIngressInput"}
	if s.ClusterSecurityGroupName == nil {
		invalidParams.Add(request.NewErrParamRequired("ClusterSecurityGroupName"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCIDRIP sets the CIDRIP field's value.
func (s *RevokeClusterSecurityGroupIngressInput) SetCIDRIP(v string) *RevokeClusterSecurityGroupIngressInput {
	s.CIDRIP = &v
	return s
}

// SetClusterSecurityGroupName sets the ClusterSecurityGroupName field's value.
func (s *RevokeClusterSecurityGroupIngressInput) SetClusterSecurityGroupName(v string) *RevokeClusterSecurityGroupIngressInput {
	s.ClusterSecurityGroupName = &v
	return s
}

// SetEC2SecurityGroupName sets the EC2SecurityGroupName field's value.
func (s *RevokeClusterSecurityGroupIngressInput) SetEC2SecurityGroupName(v string) *RevokeClusterSecurityGroupIngressInput {
	s.EC2SecurityGroupName = &v
	return s
}

// SetEC2SecurityGroupOwnerId sets the EC2SecurityGroupOwnerId field's value.
func (s *RevokeClusterSecurityGroupIngressInput) SetEC2SecurityGroupOwnerId(v string) *RevokeClusterSecurityGroupIngressInput {
	s.EC2SecurityGroupOwnerId = &v
	return s
}

type RevokeClusterSecurityGroupIngressOutput struct {
	_ struct{} `type:"structure"`

	// Describes a security group.
	ClusterSecurityGroup *ClusterSecurityGroup `type:"structure"`
}

// String returns the string representation
func (s RevokeClusterSecurityGroupIngressOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RevokeClusterSecurityGroupIngressOutput) GoString() string {
	return s.String()
}

// SetClusterSecurityGroup sets the ClusterSecurityGroup field's value.
func (s *RevokeClusterSecurityGroupIngressOutput) SetClusterSecurityGroup(v *ClusterSecurityGroup) *RevokeClusterSecurityGroupIngressOutput {
	s.ClusterSecurityGroup = v
	return s
}

type RevokeSnapshotAccessInput struct {
	_ struct{} `type:"structure"`

	// The identifier of the AWS customer account that can no longer restore the
	// specified snapshot.
	//
	// AccountWithRestoreAccess is a required field
	AccountWithRestoreAccess *string `type:"string" required:"true"`

	// The identifier of the cluster the snapshot was created from. This parameter
	// is required if your IAM user has a policy containing a snapshot resource
	// element that specifies anything other than * for the cluster name.
	SnapshotClusterIdentifier *string `type:"string"`

	// The identifier of the snapshot that the account can no longer access.
	//
	// SnapshotIdentifier is a required field
	SnapshotIdentifier *string `type:"string" required:"true"`
}

// String returns the string representation
func (s RevokeSnapshotAccessInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RevokeSnapshotAccessInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *RevokeSnapshotAccessInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "RevokeSnapshotAccessInput"}
	if s.AccountWithRestoreAccess == nil {
		invalidParams.Add(request.NewErrParamRequired("AccountWithRestoreAccess"))
	}
	if s.SnapshotIdentifier == nil {
		invalidParams.Add(request.NewErrParamRequired("SnapshotIdentifier"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAccountWithRestoreAccess sets the AccountWithRestoreAccess field's value.
func (s *RevokeSnapshotAccessInput) SetAccountWithRestoreAccess(v string) *RevokeSnapshotAccessInput {
	s.AccountWithRestoreAccess = &v
	return s
}

// SetSnapshotClusterIdentifier sets the SnapshotClusterIdentifier field's value.
func (s *RevokeSnapshotAccessInput) SetSnapshotClusterIdentifier(v string) *RevokeSnapshotAccessInput {
	s.SnapshotClusterIdentifier = &v
	return s
}

// SetSnapshotIdentifier sets the SnapshotIdentifier field's value.
func (s *RevokeSnapshotAccessInput) SetSnapshotIdentifier(v string) *RevokeSnapshotAccessInput {
	s.SnapshotIdentifier = &v
	return s
}

type RevokeSnapshotAccessOutput struct {
	_ struct{} `type:"structure"`

	// Describes a snapshot.
	Snapshot *Snapshot `type:"structure"`
}

// String returns the string representation
func (s RevokeSnapshotAccessOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RevokeSnapshotAccessOutput) GoString() string {
	return s.String()
}

// SetSnapshot sets the Snapshot field's value.
func (s *RevokeSnapshotAccessOutput) SetSnapshot(v *Snapshot) *RevokeSnapshotAccessOutput {
	s.Snapshot = v
	return s
}

type RotateEncryptionKeyInput struct {
	_ struct{} `type:"structure"`

	// The unique identifier of the cluster that you want to rotate the encryption
	// keys for.
	//
	// Constraints: Must be the name of valid cluster that has encryption enabled.
	//
	// ClusterIdentifier is a required field
	ClusterIdentifier *string `type:"string" required:"true"`
}

// String returns the string representation
func (s RotateEncryptionKeyInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RotateEncryptionKeyInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *RotateEncryptionKeyInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "RotateEncryptionKeyInput"}
	if s.ClusterIdentifier == nil {
		invalidParams.Add(request.NewErrParamRequired("ClusterIdentifier"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClusterIdentifier sets the ClusterIdentifier field's value.
func (s *RotateEncryptionKeyInput) SetClusterIdentifier(v string) *RotateEncryptionKeyInput {
	s.ClusterIdentifier = &v
	return s
}

type RotateEncryptionKeyOutput struct {
	_ struct{} `type:"structure"`

	// Describes a cluster.
	Cluster *Cluster `type:"structure"`
}

// String returns the string representation
func (s RotateEncryptionKeyOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RotateEncryptionKeyOutput) GoString() string {
	return s.String()
}

// SetCluster sets the Cluster field's value.
func (s *RotateEncryptionKeyOutput) SetCluster(v *Cluster) *RotateEncryptionKeyOutput {
	s.Cluster = v
	return s
}

// Describes a scheduled action. You can use a scheduled action to trigger some
// Amazon Redshift API operations on a schedule. For information about which
// API operations can be scheduled, see ScheduledActionType.
type ScheduledAction struct {
	_ struct{} `type:"structure"`

	// The end time in UTC when the schedule is no longer active. After this time,
	// the scheduled action does not trigger.
	EndTime *time.Time `type:"timestamp"`

	// The IAM role to assume to run the scheduled action. This IAM role must have
	// permission to run the Amazon Redshift API operation in the scheduled action.
	// This IAM role must allow the Amazon Redshift scheduler (Principal scheduler.redshift.amazonaws.com)
	// to assume permissions on your behalf. For more information about the IAM
	// role to use with the Amazon Redshift scheduler, see Using Identity-Based
	// Policies for Amazon Redshift (https://docs.aws.amazon.com/redshift/latest/mgmt/redshift-iam-access-control-identity-based.html)
	// in the Amazon Redshift Cluster Management Guide.
	IamRole *string `type:"string"`

	// List of times when the scheduled action will run.
	NextInvocations []*time.Time `locationNameList:"ScheduledActionTime" type:"list"`

	// The schedule for a one-time (at format) or recurring (cron format) scheduled
	// action. Schedule invocations must be separated by at least one hour.
	//
	// Format of at expressions is "at(yyyy-mm-ddThh:mm:ss)". For example, "at(2016-03-04T17:27:00)".
	//
	// Format of cron expressions is "cron(Minutes Hours Day-of-month Month Day-of-week
	// Year)". For example, "cron(0, 10, *, *, MON, *)". For more information, see
	// Cron Expressions (https://docs.aws.amazon.com/AmazonCloudWatch/latest/events/ScheduledEvents.html#CronExpressions)
	// in the Amazon CloudWatch Events User Guide.
	Schedule *string `type:"string"`

	// The description of the scheduled action.
	ScheduledActionDescription *string `type:"string"`

	// The name of the scheduled action.
	ScheduledActionName *string `type:"string"`

	// The start time in UTC when the schedule is active. Before this time, the
	// scheduled action does not trigger.
	StartTime *time.Time `type:"timestamp"`

	// The state of the scheduled action. For example, DISABLED.
	State *string `type:"string" enum:"ScheduledActionState"`

	// A JSON format string of the Amazon Redshift API operation with input parameters.
	//
	// "{\"ResizeCluster\":{\"NodeType\":\"ds2.8xlarge\",\"ClusterIdentifier\":\"my-test-cluster\",\"NumberOfNodes\":3}}".
	TargetAction *ScheduledActionType `type:"structure"`
}

// String returns the string representation
func (s ScheduledAction) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ScheduledAction) GoString() string {
	return s.String()
}

// SetEndTime sets the EndTime field's value.
func (s *ScheduledAction) SetEndTime(v time.Time) *ScheduledAction {
	s.EndTime = &v
	return s
}

// SetIamRole sets the IamRole field's value.
func (s *ScheduledAction) SetIamRole(v string) *ScheduledAction {
	s.IamRole = &v
	return s
}

// SetNextInvocations sets the NextInvocations field's value.
func (s *ScheduledAction) SetNextInvocations(v []*time.Time) *ScheduledAction {
	s.NextInvocations = v
	return s
}

// SetSchedule sets the Schedule field's value.
func (s *ScheduledAction) SetSchedule(v string) *ScheduledAction {
	s.Schedule = &v
	return s
}

// SetScheduledActionDescription sets the ScheduledActionDescription field's value.
func (s *ScheduledAction) SetScheduledActionDescription(v string) *ScheduledAction {
	s.ScheduledActionDescription = &v
	return s
}

// SetScheduledActionName sets the ScheduledActionName field's value.
func (s *ScheduledAction) SetScheduledActionName(v string) *ScheduledAction {
	s.ScheduledActionName = &v
	return s
}

// SetStartTime sets the StartTime field's value.
func (s *ScheduledAction) SetStartTime(v time.Time) *ScheduledAction {
	s.StartTime = &v
	return s
}

// SetState sets the State field's value.
func (s *ScheduledAction) SetState(v string) *ScheduledAction {
	s.State = &v
	return s
}

// SetTargetAction sets the TargetAction field's value.
func (s *ScheduledAction) SetTargetAction(v *ScheduledActionType) *ScheduledAction {
	s.TargetAction = v
	return s
}

// A set of elements to filter the returned scheduled actions.
type ScheduledActionFilter struct {
	_ struct{} `type:"structure"`

	// The type of element to filter.
	//
	// Name is a required field
	Name *string `type:"string" required:"true" enum:"ScheduledActionFilterName"`

	// List of values. Compare if the value (of type defined by Name) equals an
	// item in the list of scheduled actions.
	//
	// Values is a required field
	Values []*string `locationNameList:"item" type:"list" required:"true"`
}

// String returns the string representation
func (s ScheduledActionFilter) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ScheduledActionFilter) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ScheduledActionFilter) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ScheduledActionFilter"}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Values == nil {
		invalidParams.Add(request.NewErrParamRequired("Values"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetName sets the Name field's value.
func (s *ScheduledActionFilter) SetName(v string) *ScheduledActionFilter {
	s.Name = &v
	return s
}

// SetValues sets the Values field's value.
func (s *ScheduledActionFilter) SetValues(v []*string) *ScheduledActionFilter {
	s.Values = v
	return s
}

// The action type that specifies an Amazon Redshift API operation that is supported
// by the Amazon Redshift scheduler.
type ScheduledActionType struct {
	_ struct{} `type:"structure"`

	// An action that runs a ResizeCluster API operation.
	ResizeCluster *ResizeClusterMessage `type:"structure"`
}

// String returns the string representation
func (s ScheduledActionType) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ScheduledActionType) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ScheduledActionType) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ScheduledActionType"}
	if s.ResizeCluster != nil {
		if err := s.ResizeCluster.Validate(); err != nil {
			invalidParams.AddNested("ResizeCluster", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResizeCluster sets the ResizeCluster field's value.
func (s *ScheduledActionType) SetResizeCluster(v *ResizeClusterMessage) *ScheduledActionType {
	s.ResizeCluster = v
	return s
}

// Describes a snapshot.
type Snapshot struct {
	_ struct{} `type:"structure"`

	// A list of the AWS customer accounts authorized to restore the snapshot. Returns
	// null if no accounts are authorized. Visible only to the snapshot owner.
	AccountsWithRestoreAccess []*AccountWithRestoreAccess `locationNameList:"AccountWithRestoreAccess" type:"list"`

	// The size of the incremental backup.
	ActualIncrementalBackupSizeInMegaBytes *float64 `type:"double"`

	// The Availability Zone in which the cluster was created.
	AvailabilityZone *string `type:"string"`

	// The number of megabytes that have been transferred to the snapshot backup.
	BackupProgressInMegaBytes *float64 `type:"double"`

	// The time (UTC) when the cluster was originally created.
	ClusterCreateTime *time.Time `type:"timestamp"`

	// The identifier of the cluster for which the snapshot was taken.
	ClusterIdentifier *string `type:"string"`

	// The version ID of the Amazon Redshift engine that is running on the cluster.
	ClusterVersion *string `type:"string"`

	// The number of megabytes per second being transferred to the snapshot backup.
	// Returns 0 for a completed backup.
	CurrentBackupRateInMegaBytesPerSecond *float64 `type:"double"`

	// The name of the database that was created when the cluster was created.
	DBName *string `type:"string"`

	// The amount of time an in-progress snapshot backup has been running, or the
	// amount of time it took a completed backup to finish.
	ElapsedTimeInSeconds *int64 `type:"long"`

	// If true, the data in the snapshot is encrypted at rest.
	Encrypted *bool `type:"boolean"`

	// A boolean that indicates whether the snapshot data is encrypted using the
	// HSM keys of the source cluster. true indicates that the data is encrypted
	// using HSM keys.
	EncryptedWithHSM *bool `type:"boolean"`

	// An option that specifies whether to create the cluster with enhanced VPC
	// routing enabled. To create a cluster that uses enhanced VPC routing, the
	// cluster must be in a VPC. For more information, see Enhanced VPC Routing
	// (https://docs.aws.amazon.com/redshift/latest/mgmt/enhanced-vpc-routing.html)
	// in the Amazon Redshift Cluster Management Guide.
	//
	// If this option is true, enhanced VPC routing is enabled.
	//
	// Default: false
	EnhancedVpcRouting *bool `type:"boolean"`

	// The estimate of the time remaining before the snapshot backup will complete.
	// Returns 0 for a completed backup.
	EstimatedSecondsToCompletion *int64 `type:"long"`

	// The AWS Key Management Service (KMS) key ID of the encryption key that was
	// used to encrypt data in the cluster from which the snapshot was taken.
	KmsKeyId *string `type:"string"`

	// The name of the maintenance track for the snapshot.
	MaintenanceTrackName *string `type:"string"`

	// The number of days until a manual snapshot will pass its retention period.
	ManualSnapshotRemainingDays *int64 `type:"integer"`

	// The number of days that a manual snapshot is retained. If the value is -1,
	// the manual snapshot is retained indefinitely.
	//
	// The value must be either -1 or an integer between 1 and 3,653.
	ManualSnapshotRetentionPeriod *int64 `type:"integer"`

	// The master user name for the cluster.
	MasterUsername *string `type:"string"`

	// The node type of the nodes in the cluster.
	NodeType *string `type:"string"`

	// The number of nodes in the cluster.
	NumberOfNodes *int64 `type:"integer"`

	// For manual snapshots, the AWS customer account used to create or copy the
	// snapshot. For automatic snapshots, the owner of the cluster. The owner can
	// perform all snapshot actions, such as sharing a manual snapshot.
	OwnerAccount *string `type:"string"`

	// The port that the cluster is listening on.
	Port *int64 `type:"integer"`

	// The list of node types that this cluster snapshot is able to restore into.
	RestorableNodeTypes []*string `locationNameList:"NodeType" type:"list"`

	// The time (in UTC format) when Amazon Redshift began the snapshot. A snapshot
	// contains a copy of the cluster data as of this exact time.
	SnapshotCreateTime *time.Time `type:"timestamp"`

	// The snapshot identifier that is provided in the request.
	SnapshotIdentifier *string `type:"string"`

	// A timestamp representing the start of the retention period for the snapshot.
	SnapshotRetentionStartTime *time.Time `type:"timestamp"`

	// The snapshot type. Snapshots created using CreateClusterSnapshot and CopyClusterSnapshot
	// are of type "manual".
	SnapshotType *string `type:"string"`

	// The source region from which the snapshot was copied.
	SourceRegion *string `type:"string"`

	// The snapshot status. The value of the status depends on the API operation
	// used:
	//
	//    * CreateClusterSnapshot and CopyClusterSnapshot returns status as "creating".
	//
	//    * DescribeClusterSnapshots returns status as "creating", "available",
	//    "final snapshot", or "failed".
	//
	//    * DeleteClusterSnapshot returns status as "deleted".
	Status *string `type:"string"`

	// The list of tags for the cluster snapshot.
	Tags []*Tag `locationNameList:"Tag" type:"list"`

	// The size of the complete set of backup data that would be used to restore
	// the cluster.
	TotalBackupSizeInMegaBytes *float64 `type:"double"`

	// The VPC identifier of the cluster if the snapshot is from a cluster in a
	// VPC. Otherwise, this field is not in the output.
	VpcId *string `type:"string"`
}

// String returns the string representation
func (s Snapshot) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Snapshot) GoString() string {
	return s.String()
}

// SetAccountsWithRestoreAccess sets the AccountsWithRestoreAccess field's value.
func (s *Snapshot) SetAccountsWithRestoreAccess(v []*AccountWithRestoreAccess) *Snapshot {
	s.AccountsWithRestoreAccess = v
	return s
}

// SetActualIncrementalBackupSizeInMegaBytes sets the ActualIncrementalBackupSizeInMegaBytes field's value.
func (s *Snapshot) SetActualIncrementalBackupSizeInMegaBytes(v float64) *Snapshot {
	s.ActualIncrementalBackupSizeInMegaBytes = &v
	return s
}

// SetAvailabilityZone sets the AvailabilityZone field's value.
func (s *Snapshot) SetAvailabilityZone(v string) *Snapshot {
	s.AvailabilityZone = &v
	return s
}

// SetBackupProgressInMegaBytes sets the BackupProgressInMegaBytes field's value.
func (s *Snapshot) SetBackupProgressInMegaBytes(v float64) *Snapshot {
	s.BackupProgressInMegaBytes = &v
	return s
}

// SetClusterCreateTime sets the ClusterCreateTime field's value.
func (s *Snapshot) SetClusterCreateTime(v time.Time) *Snapshot {
	s.ClusterCreateTime = &v
	return s
}

// SetClusterIdentifier sets the ClusterIdentifier field's value.
func (s *Snapshot) SetClusterIdentifier(v string) *Snapshot {
	s.ClusterIdentifier = &v
	return s
}

// SetClusterVersion sets the ClusterVersion field's value.
func (s *Snapshot) SetClusterVersion(v string) *Snapshot {
	s.ClusterVersion = &v
	return s
}

// SetCurrentBackupRateInMegaBytesPerSecond sets the CurrentBackupRateInMegaBytesPerSecond field's value.
func (s *Snapshot) SetCurrentBackupRateInMegaBytesPerSecond(v float64) *Snapshot {
	s.CurrentBackupRateInMegaBytesPerSecond = &v
	return s
}

// SetDBName sets the DBName field's value.
func (s *Snapshot) SetDBName(v string) *Snapshot {
	s.DBName = &v
	return s
}

// SetElapsedTimeInSeconds sets the ElapsedTimeInSeconds field's value.
func (s *Snapshot) SetElapsedTimeInSeconds(v int64) *Snapshot {
	s.ElapsedTimeInSeconds = &v
	return s
}

// SetEncrypted sets the Encrypted field's value.
func (s *Snapshot) SetEncrypted(v bool) *Snapshot {
	s.Encrypted = &v
	return s
}

// SetEncryptedWithHSM sets the EncryptedWithHSM field's value.
func (s *Snapshot) SetEncryptedWithHSM(v bool) *Snapshot {
	s.EncryptedWithHSM = &v
	return s
}

// SetEnhancedVpcRouting sets the EnhancedVpcRouting field's value.
func (s *Snapshot) SetEnhancedVpcRouting(v bool) *Snapshot {
	s.EnhancedVpcRouting = &v
	return s
}

// SetEstimatedSecondsToCompletion sets the EstimatedSecondsToCompletion field's value.
func (s *Snapshot) SetEstimatedSecondsToCompletion(v int64) *Snapshot {
	s.EstimatedSecondsToCompletion = &v
	return s
}

// SetKmsKeyId sets the KmsKeyId field's value.
func (s *Snapshot) SetKmsKeyId(v string) *Snapshot {
	s.KmsKeyId = &v
	return s
}

// SetMaintenanceTrackName sets the MaintenanceTrackName field's value.
func (s *Snapshot) SetMaintenanceTrackName(v string) *Snapshot {
	s.MaintenanceTrackName = &v
	return s
}

// SetManualSnapshotRemainingDays sets the ManualSnapshotRemainingDays field's value.
func (s *Snapshot) SetManualSnapshotRemainingDays(v int64) *Snapshot {
	s.ManualSnapshotRemainingDays = &v
	return s
}

// SetManualSnapshotRetentionPeriod sets the ManualSnapshotRetentionPeriod field's value.
func (s *Snapshot) SetManualSnapshotRetentionPeriod(v int64) *Snapshot {
	s.ManualSnapshotRetentionPeriod = &v
	return s
}

// SetMasterUsername sets the MasterUsername field's value.
func (s *Snapshot) SetMasterUsername(v string) *Snapshot {
	s.MasterUsername = &v
	return s
}

// SetNodeType sets the NodeType field's value.
func (s *Snapshot) SetNodeType(v string) *Snapshot {
	s.NodeType = &v
	return s
}

// SetNumberOfNodes sets the NumberOfNodes field's value.
func (s *Snapshot) SetNumberOfNodes(v int64) *Snapshot {
	s.NumberOfNodes = &v
	return s
}

// SetOwnerAccount sets the OwnerAccount field's value.
func (s *Snapshot) SetOwnerAccount(v string) *Snapshot {
	s.OwnerAccount = &v
	return s
}

// SetPort sets the Port field's value.
func (s *Snapshot) SetPort(v int64) *Snapshot {
	s.Port = &v
	return s
}

// SetRestorableNodeTypes sets the RestorableNodeTypes field's value.
func (s *Snapshot) SetRestorableNodeTypes(v []*string) *Snapshot {
	s.RestorableNodeTypes = v
	return s
}

// SetSnapshotCreateTime sets the SnapshotCreateTime field's value.
func (s *Snapshot) SetSnapshotCreateTime(v time.Time) *Snapshot {
	s.SnapshotCreateTime = &v
	return s
}

// SetSnapshotIdentifier sets the SnapshotIdentifier field's value.
func (s *Snapshot) SetSnapshotIdentifier(v string) *Snapshot {
	s.SnapshotIdentifier = &v
	return s
}

// SetSnapshotRetentionStartTime sets the SnapshotRetentionStartTime field's value.
func (s *Snapshot) SetSnapshotRetentionStartTime(v time.Time) *Snapshot {
	s.SnapshotRetentionStartTime = &v
	return s
}

// SetSnapshotType sets the SnapshotType field's value.
func (s *Snapshot) SetSnapshotType(v string) *Snapshot {
	s.SnapshotType = &v
	return s
}

// SetSourceRegion sets the SourceRegion field's value.
func (s *Snapshot) SetSourceRegion(v string) *Snapshot {
	s.SourceRegion = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *Snapshot) SetStatus(v string) *Snapshot {
	s.Status = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *Snapshot) SetTags(v []*Tag) *Snapshot {
	s.Tags = v
	return s
}

// SetTotalBackupSizeInMegaBytes sets the TotalBackupSizeInMegaBytes field's value.
func (s *Snapshot) SetTotalBackupSizeInMegaBytes(v float64) *Snapshot {
	s.TotalBackupSizeInMegaBytes = &v
	return s
}

// SetVpcId sets the VpcId field's value.
func (s *Snapshot) SetVpcId(v string) *Snapshot {
	s.VpcId = &v
	return s
}

// The snapshot copy grant that grants Amazon Redshift permission to encrypt
// copied snapshots with the specified customer master key (CMK) from AWS KMS
// in the destination region.
//
// For more information about managing snapshot copy grants, go to Amazon Redshift
// Database Encryption (https://docs.aws.amazon.com/redshift/latest/mgmt/working-with-db-encryption.html)
// in the Amazon Redshift Cluster Management Guide.
type SnapshotCopyGrant struct {
	_ struct{} `type:"structure"`

	// The unique identifier of the customer master key (CMK) in AWS KMS to which
	// Amazon Redshift is granted permission.
	KmsKeyId *string `type:"string"`

	// The name of the snapshot copy grant.
	SnapshotCopyGrantName *string `type:"string"`

	// A list of tag instances.
	Tags []*Tag `locationNameList:"Tag" type:"list"`
}

// String returns the string representation
func (s SnapshotCopyGrant) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SnapshotCopyGrant) GoString() string {
	return s.String()
}

// SetKmsKeyId sets the KmsKeyId field's value.
func (s *SnapshotCopyGrant) SetKmsKeyId(v string) *SnapshotCopyGrant {
	s.KmsKeyId = &v
	return s
}

// SetSnapshotCopyGrantName sets the SnapshotCopyGrantName field's value.
func (s *SnapshotCopyGrant) SetSnapshotCopyGrantName(v string) *SnapshotCopyGrant {
	s.SnapshotCopyGrantName = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *SnapshotCopyGrant) SetTags(v []*Tag) *SnapshotCopyGrant {
	s.Tags = v
	return s
}

// Describes the errors returned by a snapshot.
type SnapshotErrorMessage struct {
	_ struct{} `type:"structure"`

	// The failure code for the error.
	FailureCode *string `type:"string"`

	// The text message describing the error.
	FailureReason *string `type:"string"`

	// A unique identifier for the cluster.
	SnapshotClusterIdentifier *string `type:"string"`

	// A unique identifier for the snapshot returning the error.
	SnapshotIdentifier *string `type:"string"`
}

// String returns the string representation
func (s SnapshotErrorMessage) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SnapshotErrorMessage) GoString() string {
	return s.String()
}

// SetFailureCode sets the FailureCode field's value.
func (s *SnapshotErrorMessage) SetFailureCode(v string) *SnapshotErrorMessage {
	s.FailureCode = &v
	return s
}

// SetFailureReason sets the FailureReason field's value.
func (s *SnapshotErrorMessage) SetFailureReason(v string) *SnapshotErrorMessage {
	s.FailureReason = &v
	return s
}

// SetSnapshotClusterIdentifier sets the SnapshotClusterIdentifier field's value.
func (s *SnapshotErrorMessage) SetSnapshotClusterIdentifier(v string) *SnapshotErrorMessage {
	s.SnapshotClusterIdentifier = &v
	return s
}

// SetSnapshotIdentifier sets the SnapshotIdentifier field's value.
func (s *SnapshotErrorMessage) SetSnapshotIdentifier(v string) *SnapshotErrorMessage {
	s.SnapshotIdentifier = &v
	return s
}

// Describes a snapshot schedule. You can set a regular interval for creating
// snapshots of a cluster. You can also schedule snapshots for specific dates.
type SnapshotSchedule struct {
	_ struct{} `type:"structure"`

	// The number of clusters associated with the schedule.
	AssociatedClusterCount *int64 `type:"integer"`

	// A list of clusters associated with the schedule. A maximum of 100 clusters
	// is returned.
	AssociatedClusters []*ClusterAssociatedToSchedule `locationNameList:"ClusterAssociatedToSchedule" type:"list"`

	NextInvocations []*time.Time `locationNameList:"SnapshotTime" type:"list"`

	// A list of ScheduleDefinitions.
	ScheduleDefinitions []*string `locationNameList:"ScheduleDefinition" type:"list"`

	// The description of the schedule.
	ScheduleDescription *string `type:"string"`

	// A unique identifier for the schedule.
	ScheduleIdentifier *string `type:"string"`

	// An optional set of tags describing the schedule.
	Tags []*Tag `locationNameList:"Tag" type:"list"`
}

// String returns the string representation
func (s SnapshotSchedule) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SnapshotSchedule) GoString() string {
	return s.String()
}

// SetAssociatedClusterCount sets the AssociatedClusterCount field's value.
func (s *SnapshotSchedule) SetAssociatedClusterCount(v int64) *SnapshotSchedule {
	s.AssociatedClusterCount = &v
	return s
}

// SetAssociatedClusters sets the AssociatedClusters field's value.
func (s *SnapshotSchedule) SetAssociatedClusters(v []*ClusterAssociatedToSchedule) *SnapshotSchedule {
	s.AssociatedClusters = v
	return s
}

// SetNextInvocations sets the NextInvocations field's value.
func (s *SnapshotSchedule) SetNextInvocations(v []*time.Time) *SnapshotSchedule {
	s.NextInvocations = v
	return s
}

// SetScheduleDefinitions sets the ScheduleDefinitions field's value.
func (s *SnapshotSchedule) SetScheduleDefinitions(v []*string) *SnapshotSchedule {
	s.ScheduleDefinitions = v
	return s
}

// SetScheduleDescription sets the ScheduleDescription field's value.
func (s *SnapshotSchedule) SetScheduleDescription(v string) *SnapshotSchedule {
	s.ScheduleDescription = &v
	return s
}

// SetScheduleIdentifier sets the ScheduleIdentifier field's value.
func (s *SnapshotSchedule) SetScheduleIdentifier(v string) *SnapshotSchedule {
	s.ScheduleIdentifier = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *SnapshotSchedule) SetTags(v []*Tag) *SnapshotSchedule {
	s.Tags = v
	return s
}

// Describes a sorting entity
type SnapshotSortingEntity struct {
	_ struct{} `type:"structure"`

	// The category for sorting the snapshots.
	//
	// Attribute is a required field
	Attribute *string `type:"string" required:"true" enum:"SnapshotAttributeToSortBy"`

	// The order for listing the attributes.
	SortOrder *string `type:"string" enum:"SortByOrder"`
}

// String returns the string representation
func (s SnapshotSortingEntity) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SnapshotSortingEntity) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *SnapshotSortingEntity) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "SnapshotSortingEntity"}
	if s.Attribute == nil {
		invalidParams.Add(request.NewErrParamRequired("Attribute"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAttribute sets the Attribute field's value.
func (s *SnapshotSortingEntity) SetAttribute(v string) *SnapshotSortingEntity {
	s.Attribute = &v
	return s
}

// SetSortOrder sets the SortOrder field's value.
func (s *SnapshotSortingEntity) SetSortOrder(v string) *SnapshotSortingEntity {
	s.SortOrder = &v
	return s
}

// Describes a subnet.
type Subnet struct {
	_ struct{} `type:"structure"`

	// Describes an availability zone.
	SubnetAvailabilityZone *AvailabilityZone `type:"structure"`

	// The identifier of the subnet.
	SubnetIdentifier *string `type:"string"`

	// The status of the subnet.
	SubnetStatus *string `type:"string"`
}

// String returns the string representation
func (s Subnet) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Subnet) GoString() string {
	return s.String()
}

// SetSubnetAvailabilityZone sets the SubnetAvailabilityZone field's value.
func (s *Subnet) SetSubnetAvailabilityZone(v *AvailabilityZone) *Subnet {
	s.SubnetAvailabilityZone = v
	return s
}

// SetSubnetIdentifier sets the SubnetIdentifier field's value.
func (s *Subnet) SetSubnetIdentifier(v string) *Subnet {
	s.SubnetIdentifier = &v
	return s
}

// SetSubnetStatus sets the SubnetStatus field's value.
func (s *Subnet) SetSubnetStatus(v string) *Subnet {
	s.SubnetStatus = &v
	return s
}

// Describes the operations that are allowed on a maintenance track.
type SupportedOperation struct {
	_ struct{} `type:"structure"`

	// A list of the supported operations.
	OperationName *string `type:"string"`
}

// String returns the string representation
func (s SupportedOperation) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SupportedOperation) GoString() string {
	return s.String()
}

// SetOperationName sets the OperationName field's value.
func (s *SupportedOperation) SetOperationName(v string) *SupportedOperation {
	s.OperationName = &v
	return s
}

// A list of supported platforms for orderable clusters.
type SupportedPlatform struct {
	_ struct{} `type:"structure"`

	Name *string `type:"string"`
}

// String returns the string representation
func (s SupportedPlatform) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SupportedPlatform) GoString() string {
	return s.String()
}

// SetName sets the Name field's value.
func (s *SupportedPlatform) SetName(v string) *SupportedPlatform {
	s.Name = &v
	return s
}

// Describes the status of a RestoreTableFromClusterSnapshot operation.
type TableRestoreStatus struct {
	_ struct{} `type:"structure"`

	// The identifier of the Amazon Redshift cluster that the table is being restored
	// to.
	ClusterIdentifier *string `type:"string"`

	// A description of the status of the table restore request. Status values include
	// SUCCEEDED, FAILED, CANCELED, PENDING, IN_PROGRESS.
	Message *string `type:"string"`

	// The name of the table to create as a result of the table restore request.
	NewTableName *string `type:"string"`

	// The amount of data restored to the new table so far, in megabytes (MB).
	ProgressInMegaBytes *int64 `type:"long"`

	// The time that the table restore request was made, in Universal Coordinated
	// Time (UTC).
	RequestTime *time.Time `type:"timestamp"`

	// The identifier of the snapshot that the table is being restored from.
	SnapshotIdentifier *string `type:"string"`

	// The name of the source database that contains the table being restored.
	SourceDatabaseName *string `type:"string"`

	// The name of the source schema that contains the table being restored.
	SourceSchemaName *string `type:"string"`

	// The name of the source table being restored.
	SourceTableName *string `type:"string"`

	// A value that describes the current state of the table restore request.
	//
	// Valid Values: SUCCEEDED, FAILED, CANCELED, PENDING, IN_PROGRESS
	Status *string `type:"string" enum:"TableRestoreStatusType"`

	// The unique identifier for the table restore request.
	TableRestoreRequestId *string `type:"string"`

	// The name of the database to restore the table to.
	TargetDatabaseName *string `type:"string"`

	// The name of the schema to restore the table to.
	TargetSchemaName *string `type:"string"`

	// The total amount of data to restore to the new table, in megabytes (MB).
	TotalDataInMegaBytes *int64 `type:"long"`
}

// String returns the string representation
func (s TableRestoreStatus) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s TableRestoreStatus) GoString() string {
	return s.String()
}

// SetClusterIdentifier sets the ClusterIdentifier field's value.
func (s *TableRestoreStatus) SetClusterIdentifier(v string) *TableRestoreStatus {
	s.ClusterIdentifier = &v
	return s
}

// SetMessage sets the Message field's value.
func (s *TableRestoreStatus) SetMessage(v string) *TableRestoreStatus {
	s.Message = &v
	return s
}

// SetNewTableName sets the NewTableName field's value.
func (s *TableRestoreStatus) SetNewTableName(v string) *TableRestoreStatus {
	s.NewTableName = &v
	return s
}

// SetProgressInMegaBytes sets the ProgressInMegaBytes field's value.
func (s *TableRestoreStatus) SetProgressInMegaBytes(v int64) *TableRestoreStatus {
	s.ProgressInMegaBytes = &v
	return s
}

// SetRequestTime sets the RequestTime field's value.
func (s *TableRestoreStatus) SetRequestTime(v time.Time) *TableRestoreStatus {
	s.RequestTime = &v
	return s
}

// SetSnapshotIdentifier sets the SnapshotIdentifier field's value.
func (s *TableRestoreStatus) SetSnapshotIdentifier(v string) *TableRestoreStatus {
	s.SnapshotIdentifier = &v
	return s
}

// SetSourceDatabaseName sets the SourceDatabaseName field's value.
func (s *TableRestoreStatus) SetSourceDatabaseName(v string) *TableRestoreStatus {
	s.SourceDatabaseName = &v
	return s
}

// SetSourceSchemaName sets the SourceSchemaName field's value.
func (s *TableRestoreStatus) SetSourceSchemaName(v string) *TableRestoreStatus {
	s.SourceSchemaName = &v
	return s
}

// SetSourceTableName sets the SourceTableName field's value.
func (s *TableRestoreStatus) SetSourceTableName(v string) *TableRestoreStatus {
	s.SourceTableName = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *TableRestoreStatus) SetStatus(v string) *TableRestoreStatus {
	s.Status = &v
	return s
}

// SetTableRestoreRequestId sets the TableRestoreRequestId field's value.
func (s *TableRestoreStatus) SetTableRestoreRequestId(v string) *TableRestoreStatus {
	s.TableRestoreRequestId = &v
	return s
}

// SetTargetDatabaseName sets the TargetDatabaseName field's value.
func (s *TableRestoreStatus) SetTargetDatabaseName(v string) *TableRestoreStatus {
	s.TargetDatabaseName = &v
	return s
}

// SetTargetSchemaName sets the TargetSchemaName field's value.
func (s *TableRestoreStatus) SetTargetSchemaName(v string) *TableRestoreStatus {
	s.TargetSchemaName = &v
	return s
}

// SetTotalDataInMegaBytes sets the TotalDataInMegaBytes field's value.
func (s *TableRestoreStatus) SetTotalDataInMegaBytes(v int64) *TableRestoreStatus {
	s.TotalDataInMegaBytes = &v
	return s
}

// A tag consisting of a name/value pair for a resource.
type Tag struct {
	_ struct{} `type:"structure"`

	// The key, or name, for the resource tag.
	Key *string `type:"string"`

	// The value for the resource tag.
	Value *string `type:"string"`
}

// String returns the string representation
func (s Tag) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Tag) GoString() string {
	return s.String()
}

// SetKey sets the Key field's value.
func (s *Tag) SetKey(v string) *Tag {
	s.Key = &v
	return s
}

// SetValue sets the Value field's value.
func (s *Tag) SetValue(v string) *Tag {
	s.Value = &v
	return s
}

// A tag and its associated resource.
type TaggedResource struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) with which the tag is associated, for example:
	// arn:aws:redshift:us-east-2:123456789:cluster:t1.
	ResourceName *string `type:"string"`

	// The type of resource with which the tag is associated. Valid resource types
	// are:
	//
	//    * Cluster
	//
	//    * CIDR/IP
	//
	//    * EC2 security group
	//
	//    * Snapshot
	//
	//    * Cluster security group
	//
	//    * Subnet group
	//
	//    * HSM connection
	//
	//    * HSM certificate
	//
	//    * Parameter group
	//
	// For more information about Amazon Redshift resource types and constructing
	// ARNs, go to Constructing an Amazon Redshift Amazon Resource Name (ARN) (https://docs.aws.amazon.com/redshift/latest/mgmt/redshift-iam-access-control-overview.html#redshift-iam-access-control-specify-actions)
	// in the Amazon Redshift Cluster Management Guide.
	ResourceType *string `type:"string"`

	// The tag for the resource.
	Tag *Tag `type:"structure"`
}

// String returns the string representation
func (s TaggedResource) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s TaggedResource) GoString() string {
	return s.String()
}

// SetResourceName sets the ResourceName field's value.
func (s *TaggedResource) SetResourceName(v string) *TaggedResource {
	s.ResourceName = &v
	return s
}

// SetResourceType sets the ResourceType field's value.
func (s *TaggedResource) SetResourceType(v string) *TaggedResource {
	s.ResourceType = &v
	return s
}

// SetTag sets the Tag field's value.
func (s *TaggedResource) SetTag(v *Tag) *TaggedResource {
	s.Tag = v
	return s
}

// A maintenance track that you can switch the current track to.
type UpdateTarget struct {
	_ struct{} `type:"structure"`

	// The cluster version for the new maintenance track.
	DatabaseVersion *string `type:"string"`

	// The name of the new maintenance track.
	MaintenanceTrackName *string `type:"string"`

	// A list of operations supported by the maintenance track.
	SupportedOperations []*SupportedOperation `locationNameList:"SupportedOperation" type:"list"`
}

// String returns the string representation
func (s UpdateTarget) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateTarget) GoString() string {
	return s.String()
}

// SetDatabaseVersion sets the DatabaseVersion field's value.
func (s *UpdateTarget) SetDatabaseVersion(v string) *UpdateTarget {
	s.DatabaseVersion = &v
	return s
}

// SetMaintenanceTrackName sets the MaintenanceTrackName field's value.
func (s *UpdateTarget) SetMaintenanceTrackName(v string) *UpdateTarget {
	s.MaintenanceTrackName = &v
	return s
}

// SetSupportedOperations sets the SupportedOperations field's value.
func (s *UpdateTarget) SetSupportedOperations(v []*SupportedOperation) *UpdateTarget {
	s.SupportedOperations = v
	return s
}

// Describes the members of a VPC security group.
type VpcSecurityGroupMembership struct {
	_ struct{} `type:"structure"`

	// The status of the VPC security group.
	Status *string `type:"string"`

	// The identifier of the VPC security group.
	VpcSecurityGroupId *string `type:"string"`
}

// String returns the string representation
func (s VpcSecurityGroupMembership) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s VpcSecurityGroupMembership) GoString() string {
	return s.String()
}

// SetStatus sets the Status field's value.
func (s *VpcSecurityGroupMembership) SetStatus(v string) *VpcSecurityGroupMembership {
	s.Status = &v
	return s
}

// SetVpcSecurityGroupId sets the VpcSecurityGroupId field's value.
func (s *VpcSecurityGroupMembership) SetVpcSecurityGroupId(v string) *VpcSecurityGroupMembership {
	s.VpcSecurityGroupId = &v
	return s
}

const (
	// ActionTypeRestoreCluster is a ActionType enum value
	ActionTypeRestoreCluster = "restore-cluster"

	// ActionTypeRecommendNodeConfig is a ActionType enum value
	ActionTypeRecommendNodeConfig = "recommend-node-config"
)

const (
	// ModeStandard is a Mode enum value
	ModeStandard = "standard"

	// ModeHighPerformance is a Mode enum value
	ModeHighPerformance = "high-performance"
)

const (
	// NodeConfigurationOptionsFilterNameNodeType is a NodeConfigurationOptionsFilterName enum value
	NodeConfigurationOptionsFilterNameNodeType = "NodeType"

	// NodeConfigurationOptionsFilterNameNumberOfNodes is a NodeConfigurationOptionsFilterName enum value
	NodeConfigurationOptionsFilterNameNumberOfNodes = "NumberOfNodes"

	// NodeConfigurationOptionsFilterNameEstimatedDiskUtilizationPercent is a NodeConfigurationOptionsFilterName enum value
	NodeConfigurationOptionsFilterNameEstimatedDiskUtilizationPercent = "EstimatedDiskUtilizationPercent"

	// NodeConfigurationOptionsFilterNameMode is a NodeConfigurationOptionsFilterName enum value
	NodeConfigurationOptionsFilterNameMode = "Mode"
)

const (
	// OperatorTypeEq is a OperatorType enum value
	OperatorTypeEq = "eq"

	// OperatorTypeLt is a OperatorType enum value
	OperatorTypeLt = "lt"

	// OperatorTypeGt is a OperatorType enum value
	OperatorTypeGt = "gt"

	// OperatorTypeLe is a OperatorType enum value
	OperatorTypeLe = "le"

	// OperatorTypeGe is a OperatorType enum value
	OperatorTypeGe = "ge"

	// OperatorTypeIn is a OperatorType enum value
	OperatorTypeIn = "in"

	// OperatorTypeBetween is a OperatorType enum value
	OperatorTypeBetween = "between"
)

const (
	// ParameterApplyTypeStatic is a ParameterApplyType enum value
	ParameterApplyTypeStatic = "static"

	// ParameterApplyTypeDynamic is a ParameterApplyType enum value
	ParameterApplyTypeDynamic = "dynamic"
)

const (
	// ReservedNodeOfferingTypeRegular is a ReservedNodeOfferingType enum value
	ReservedNodeOfferingTypeRegular = "Regular"

	// ReservedNodeOfferingTypeUpgradable is a ReservedNodeOfferingType enum value
	ReservedNodeOfferingTypeUpgradable = "Upgradable"
)

const (
	// ScheduleStateModifying is a ScheduleState enum value
	ScheduleStateModifying = "MODIFYING"

	// ScheduleStateActive is a ScheduleState enum value
	ScheduleStateActive = "ACTIVE"

	// ScheduleStateFailed is a ScheduleState enum value
	ScheduleStateFailed = "FAILED"
)

const (
	// ScheduledActionFilterNameClusterIdentifier is a ScheduledActionFilterName enum value
	ScheduledActionFilterNameClusterIdentifier = "cluster-identifier"

	// ScheduledActionFilterNameIamRole is a ScheduledActionFilterName enum value
	ScheduledActionFilterNameIamRole = "iam-role"
)

const (
	// ScheduledActionStateActive is a ScheduledActionState enum value
	ScheduledActionStateActive = "ACTIVE"

	// ScheduledActionStateDisabled is a ScheduledActionState enum value
	ScheduledActionStateDisabled = "DISABLED"
)

const (
	// ScheduledActionTypeValuesResizeCluster is a ScheduledActionTypeValues enum value
	ScheduledActionTypeValuesResizeCluster = "ResizeCluster"
)

const (
	// SnapshotAttributeToSortBySourceType is a SnapshotAttributeToSortBy enum value
	SnapshotAttributeToSortBySourceType = "SOURCE_TYPE"

	// SnapshotAttributeToSortByTotalSize is a SnapshotAttributeToSortBy enum value
	SnapshotAttributeToSortByTotalSize = "TOTAL_SIZE"

	// SnapshotAttributeToSortByCreateTime is a SnapshotAttributeToSortBy enum value
	SnapshotAttributeToSortByCreateTime = "CREATE_TIME"
)

const (
	// SortByOrderAsc is a SortByOrder enum value
	SortByOrderAsc = "ASC"

	// SortByOrderDesc is a SortByOrder enum value
	SortByOrderDesc = "DESC"
)

const (
	// SourceTypeCluster is a SourceType enum value
	SourceTypeCluster = "cluster"

	// SourceTypeClusterParameterGroup is a SourceType enum value
	SourceTypeClusterParameterGroup = "cluster-parameter-group"

	// SourceTypeClusterSecurityGroup is a SourceType enum value
	SourceTypeClusterSecurityGroup = "cluster-security-group"

	// SourceTypeClusterSnapshot is a SourceType enum value
	SourceTypeClusterSnapshot = "cluster-snapshot"

	// SourceTypeScheduledAction is a SourceType enum value
	SourceTypeScheduledAction = "scheduled-action"
)

const (
	// TableRestoreStatusTypePending is a TableRestoreStatusType enum value
	TableRestoreStatusTypePending = "PENDING"

	// TableRestoreStatusTypeInProgress is a TableRestoreStatusType enum value
	TableRestoreStatusTypeInProgress = "IN_PROGRESS"

	// TableRestoreStatusTypeSucceeded is a TableRestoreStatusType enum value
	TableRestoreStatusTypeSucceeded = "SUCCEEDED"

	// TableRestoreStatusTypeFailed is a TableRestoreStatusType enum value
	TableRestoreStatusTypeFailed = "FAILED"

	// TableRestoreStatusTypeCanceled is a TableRestoreStatusType enum value
	TableRestoreStatusTypeCanceled = "CANCELED"
)
