package api

/************************************************
  generated by IDE. for [ProxyLBAPI]
************************************************/

import (
	"github.com/sacloud/libsacloud/sacloud"
)

/************************************************
   To support fluent interface for Find()
************************************************/

// Reset 検索条件のリセット
func (api *ProxyLBAPI) Reset() *ProxyLBAPI {
	api.reset()
	return api
}

// Offset オフセット
func (api *ProxyLBAPI) Offset(offset int) *ProxyLBAPI {
	api.offset(offset)
	return api
}

// Limit リミット
func (api *ProxyLBAPI) Limit(limit int) *ProxyLBAPI {
	api.limit(limit)
	return api
}

// Include 取得する項目
func (api *ProxyLBAPI) Include(key string) *ProxyLBAPI {
	api.include(key)
	return api
}

// Exclude 除外する項目
func (api *ProxyLBAPI) Exclude(key string) *ProxyLBAPI {
	api.exclude(key)
	return api
}

// FilterBy 指定キーでのフィルター
func (api *ProxyLBAPI) FilterBy(key string, value interface{}) *ProxyLBAPI {
	api.filterBy(key, value, false)
	return api
}

// FilterMultiBy 任意項目でのフィルタ(完全一致 OR条件)
func (api *ProxyLBAPI) FilterMultiBy(key string, value interface{}) *ProxyLBAPI {
	api.filterBy(key, value, true)
	return api
}

// WithNameLike 名称条件
func (api *ProxyLBAPI) WithNameLike(name string) *ProxyLBAPI {
	return api.FilterBy("Name", name)
}

// WithTag タグ条件
func (api *ProxyLBAPI) WithTag(tag string) *ProxyLBAPI {
	return api.FilterBy("Tags.Name", tag)
}

// WithTags タグ(複数)条件
func (api *ProxyLBAPI) WithTags(tags []string) *ProxyLBAPI {
	return api.FilterBy("Tags.Name", []interface{}{tags})
}

// func (api *ProxyLBAPI) WithSizeGib(size int) *ProxyLBAPI {
// 	api.FilterBy("SizeMB", size*1024)
// 	return api
// }

// func (api *ProxyLBAPI) WithSharedScope() *ProxyLBAPI {
// 	api.FilterBy("Scope", "shared")
// 	return api
// }

// func (api *ProxyLBAPI) WithUserScope() *ProxyLBAPI {
// 	api.FilterBy("Scope", "user")
// 	return api
// }

// SortBy 指定キーでのソート
func (api *ProxyLBAPI) SortBy(key string, reverse bool) *ProxyLBAPI {
	api.sortBy(key, reverse)
	return api
}

// SortByName 名称でのソート
func (api *ProxyLBAPI) SortByName(reverse bool) *ProxyLBAPI {
	api.sortByName(reverse)
	return api
}

// func (api *ProxyLBAPI) SortBySize(reverse bool) *ProxyLBAPI {
// 	api.sortBy("SizeMB", reverse)
// 	return api
// }

/************************************************
   To support Setxxx interface for Find()
************************************************/

// SetEmpty 検索条件のリセット
func (api *ProxyLBAPI) SetEmpty() {
	api.reset()
}

// SetOffset オフセット
func (api *ProxyLBAPI) SetOffset(offset int) {
	api.offset(offset)
}

// SetLimit リミット
func (api *ProxyLBAPI) SetLimit(limit int) {
	api.limit(limit)
}

// SetInclude 取得する項目
func (api *ProxyLBAPI) SetInclude(key string) {
	api.include(key)
}

// SetExclude 除外する項目
func (api *ProxyLBAPI) SetExclude(key string) {
	api.exclude(key)
}

// SetFilterBy 指定キーでのフィルター
func (api *ProxyLBAPI) SetFilterBy(key string, value interface{}) {
	api.filterBy(key, value, false)
}

// SetFilterMultiBy 任意項目でのフィルタ(完全一致 OR条件)
func (api *ProxyLBAPI) SetFilterMultiBy(key string, value interface{}) {
	api.filterBy(key, value, true)
}

// SetNameLike 名称条件
func (api *ProxyLBAPI) SetNameLike(name string) {
	api.FilterBy("Name", name)
}

// SetTag タグ条件
func (api *ProxyLBAPI) SetTag(tag string) {
	api.FilterBy("Tags.Name", tag)
}

// SetTags タグ(複数)条件
func (api *ProxyLBAPI) SetTags(tags []string) {
	api.FilterBy("Tags.Name", []interface{}{tags})
}

// func (api *ProxyLBAPI) SetSizeGib(size int)  {
// 	api.FilterBy("SizeMB", size*1024)
// }

// func (api *ProxyLBAPI) SetSharedScope() {
// 	api.FilterBy("Scope", "shared")
// }

// func (api *ProxyLBAPI) SetUserScope()  {
// 	api.FilterBy("Scope", "user")
// }

// SetSortBy 指定キーでのソート
func (api *ProxyLBAPI) SetSortBy(key string, reverse bool) {
	api.sortBy(key, reverse)
}

// SetSortByName 名称でのソート
func (api *ProxyLBAPI) SetSortByName(reverse bool) {
	api.sortByName(reverse)
}

// func (api *ProxyLBAPI) SetSortBySize(reverse bool)  {
// 	api.sortBy("SizeMB", reverse)
// }

/************************************************
  To support CRUD(Create/Read/Update/Delete)
************************************************/

// func (api *ProxyLBAPI) New() *sacloud.ProxyLB {
// 	return &sacloud.ProxyLB{}
// }

// func (api *ProxyLBAPI) Create(value *sacloud.ProxyLB) (*sacloud.ProxyLB, error) {
// 	return api.request(func(res *sacloud.Response) error {
// 		return api.create(api.createRequest(value), res)
// 	})
// }

// func (api *ProxyLBAPI) Read(id string) (*sacloud.ProxyLB, error) {
// 	return api.request(func(res *sacloud.Response) error {
// 		return api.read(id, nil, res)
// 	})
// }

// func (api *ProxyLBAPI) Update(id string, value *sacloud.ProxyLB) (*sacloud.ProxyLB, error) {
// 	return api.request(func(res *sacloud.Response) error {
// 		return api.update(id, api.createRequest(value), res)
// 	})
// }

// func (api *ProxyLBAPI) Delete(id string) (*sacloud.ProxyLB, error) {
// 	return api.request(func(res *sacloud.Response) error {
// 		return api.delete(id, nil, res)
// 	})
// }

/************************************************
  Inner functions
************************************************/

func (api *ProxyLBAPI) setStateValue(setFunc func(*sacloud.Request)) *ProxyLBAPI {
	api.baseAPI.setStateValue(setFunc)
	return api
}

//func (api *ProxyLBAPI) request(f func(*sacloud.Response) error) (*sacloud.ProxyLB, error) {
//	res := &sacloud.Response{}
//	err := f(res)
//	if err != nil {
//		return nil, err
//	}
//	return res.ProxyLB, nil
//}
//
//func (api *ProxyLBAPI) createRequest(value *sacloud.ProxyLB) *sacloud.Request {
//	req := &sacloud.Request{}
//	req.ProxyLB = value
//	return req
//}
