package api

/************************************************
  generated by IDE. for [ProductDiskAPI]
************************************************/

import (
	"github.com/sacloud/libsacloud/sacloud"
)

/************************************************
   To support fluent interface for Find()
************************************************/

// Reset 検索条件のリセット
func (api *ProductDiskAPI) Reset() *ProductDiskAPI {
	api.reset()
	return api
}

// Offset オフセット
func (api *ProductDiskAPI) Offset(offset int) *ProductDiskAPI {
	api.offset(offset)
	return api
}

// Limit リミット
func (api *ProductDiskAPI) Limit(limit int) *ProductDiskAPI {
	api.limit(limit)
	return api
}

// Include 取得する項目
func (api *ProductDiskAPI) Include(key string) *ProductDiskAPI {
	api.include(key)
	return api
}

// Exclude 除外する項目
func (api *ProductDiskAPI) Exclude(key string) *ProductDiskAPI {
	api.exclude(key)
	return api
}

// FilterBy 指定キーでのフィルター
func (api *ProductDiskAPI) FilterBy(key string, value interface{}) *ProductDiskAPI {
	api.filterBy(key, value, false)
	return api
}

// FilterMultiBy 任意項目でのフィルタ(完全一致 OR条件)
func (api *ProductDiskAPI) FilterMultiBy(key string, value interface{}) *ProductDiskAPI {
	api.filterBy(key, value, true)
	return api
}

// WithNameLike 名称条件
func (api *ProductDiskAPI) WithNameLike(name string) *ProductDiskAPI {
	return api.FilterBy("Name", name)
}

// WithTag タグ条件
func (api *ProductDiskAPI) WithTag(tag string) *ProductDiskAPI {
	return api.FilterBy("Tags.Name", tag)
}

// WithTags タグ(複数)条件
func (api *ProductDiskAPI) WithTags(tags []string) *ProductDiskAPI {
	return api.FilterBy("Tags.Name", []interface{}{tags})
}

// func (api *ProductDiskAPI) WithSizeGib(size int) *ProductDiskAPI {
// 	api.FilterBy("SizeMB", size*1024)
// 	return api
// }

// func (api *ProductDiskAPI) WithSharedScope() *ProductDiskAPI {
// 	api.FilterBy("Scope", "shared")
// 	return api
// }

// func (api *ProductDiskAPI) WithUserScope() *ProductDiskAPI {
// 	api.FilterBy("Scope", "user")
// 	return api
// }

// SortBy 指定キーでのソート
func (api *ProductDiskAPI) SortBy(key string, reverse bool) *ProductDiskAPI {
	api.sortBy(key, reverse)
	return api
}

// SortByName 名称でのソート
func (api *ProductDiskAPI) SortByName(reverse bool) *ProductDiskAPI {
	api.sortByName(reverse)
	return api
}

// func (api *ProductDiskAPI) SortBySize(reverse bool) *ProductDiskAPI {
// 	api.sortBy("SizeMB", reverse)
// 	return api
// }

/************************************************
   To support Setxxx interface for Find()
************************************************/

// SetEmpty 検索条件のリセット
func (api *ProductDiskAPI) SetEmpty() {
	api.reset()
}

// SetOffset オフセット
func (api *ProductDiskAPI) SetOffset(offset int) {
	api.offset(offset)
}

// SetLimit リミット
func (api *ProductDiskAPI) SetLimit(limit int) {
	api.limit(limit)
}

// SetInclude 取得する項目
func (api *ProductDiskAPI) SetInclude(key string) {
	api.include(key)
}

// SetExclude 除外する項目
func (api *ProductDiskAPI) SetExclude(key string) {
	api.exclude(key)
}

// SetFilterBy 指定キーでのフィルター
func (api *ProductDiskAPI) SetFilterBy(key string, value interface{}) {
	api.filterBy(key, value, false)
}

// SetFilterMultiBy 任意項目でのフィルタ(完全一致 OR条件)
func (api *ProductDiskAPI) SetFilterMultiBy(key string, value interface{}) {
	api.filterBy(key, value, true)
}

// SetNameLike 名称条件
func (api *ProductDiskAPI) SetNameLike(name string) {
	api.FilterBy("Name", name)
}

// SetTag タグ条件
func (api *ProductDiskAPI) SetTag(tag string) {
	api.FilterBy("Tags.Name", tag)
}

// SetTags タグ(複数)条件
func (api *ProductDiskAPI) SetTags(tags []string) {
	api.FilterBy("Tags.Name", []interface{}{tags})
}

// func (api *ProductDiskAPI) SetSizeGib(size int) {
// 	api.FilterBy("SizeMB", size*1024)
// }

// func (api *ProductDiskAPI) SetSharedScope() {
// 	api.FilterBy("Scope", "shared")
// }

// func (api *ProductDiskAPI) SetUserScope() {
// 	api.FilterBy("Scope", "user")
// }

// SetSortBy 指定キーでのソート
func (api *ProductDiskAPI) SetSortBy(key string, reverse bool) {
	api.sortBy(key, reverse)
}

// SetSortByName 名称でのソート
func (api *ProductDiskAPI) SetSortByName(reverse bool) {
	api.sortByName(reverse)
}

// func (api *ProductDiskAPI) SetSortBySize(reverse bool) {
// 	api.sortBy("SizeMB", reverse)
// }

/************************************************
  To support CRUD(Create/Read/Update/Delete)
************************************************/

// func (api *ProductDiskAPI) New() *sacloud.ProductDisk {
// 	return &sacloud.ProductDisk{}
// }

// func (api *ProductDiskAPI) Create(value *sacloud.ProductDisk) (*sacloud.ProductDisk, error) {
// 	return api.request(func(res *sacloud.Response) error {
// 		return api.create(api.createRequest(value), res)
// 	})
// }

// Read 読み取り
func (api *ProductDiskAPI) Read(id int64) (*sacloud.ProductDisk, error) {
	return api.request(func(res *sacloud.Response) error {
		return api.read(id, nil, res)
	})
}

// func (api *ProductDiskAPI) Update(id int64, value *sacloud.ProductDisk) (*sacloud.ProductDisk, error) {
// 	return api.request(func(res *sacloud.Response) error {
// 		return api.update(id, api.createRequest(value), res)
// 	})
// }

// func (api *ProductDiskAPI) Delete(id int64) (*sacloud.ProductDisk, error) {
// 	return api.request(func(res *sacloud.Response) error {
// 		return api.delete(id, nil, res)
// 	})
// }

/************************************************
  Inner functions
************************************************/

func (api *ProductDiskAPI) setStateValue(setFunc func(*sacloud.Request)) *ProductDiskAPI {
	api.baseAPI.setStateValue(setFunc)
	return api
}

func (api *ProductDiskAPI) request(f func(*sacloud.Response) error) (*sacloud.ProductDisk, error) {
	res := &sacloud.Response{}
	err := f(res)
	if err != nil {
		return nil, err
	}
	return res.DiskPlan, nil
}

func (api *ProductDiskAPI) createRequest(value *sacloud.ProductDisk) *sacloud.Request {
	req := &sacloud.Request{}
	req.DiskPlan = value
	return req
}
