/*
 * Copyright 2020 The Kubernetes Authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
import { Common, CLI, ReplExpect, Selectors } from '@kui-shell/test';
describe(`copy command input ${process.env.MOCHA_RUN_TARGET || ''}`, function () {
    before(Common.before(this));
    after(Common.after(this));
    const echoText = 'roadhouse';
    const command = `echo ${echoText}`;
    it(`should ${command} then copy that input`, () => __awaiter(this, void 0, void 0, function* () {
        try {
            const res = yield CLI.command(command, this.app);
            yield ReplExpect.okWithPtyOutput(echoText)(res);
            const N = res.count;
            yield this.app.client.$(Selectors.PROMPT_N(N)).then(_ => _.moveTo());
            const copyButton = yield this.app.client.$(Selectors.COMMAND_COPY_BUTTON(N));
            yield copyButton.waitForDisplayed();
            yield copyButton.click();
            yield this.app.client.$(Selectors.COMMAND_COPY_DONE_BUTTON(N)).then(_ => _.waitForDisplayed());
            yield this.app.client.$(Selectors.COMMAND_COPY_DONE_BUTTON(N)).then(_ => _.waitForDisplayed());
        }
        catch (err) {
            yield Common.oops(this, true)(err);
        }
    }));
    it(`should past the command: ${command} in the next block`, () => __awaiter(this, void 0, void 0, function* () {
        try {
            yield this.app.client.$(Selectors.CURRENT_PROMPT_BLOCK).then((_) => __awaiter(this, void 0, void 0, function* () {
                yield _.waitForExist();
                yield _.click();
            }));
            yield this.app.client.execute(() => document.execCommand('paste'));
            let idx = 0;
            yield this.app.client.waitUntil(() => __awaiter(this, void 0, void 0, function* () {
                const actualValue = yield this.app.client.$(Selectors.CURRENT_PROMPT).then(_ => _.getValue());
                if (++idx > 5) {
                    console.error(`still waiting for text actualValue=${actualValue} expectedValue=${command}`);
                }
                return command === actualValue;
            }), { timeout: CLI.waitTimeout });
        }
        catch (err) {
            yield Common.oops(this, true)(err);
        }
    }));
});
//# sourceMappingURL=copy-input.js.map