/**
 * This file offers a thin facade over path.posix. Webpack at least as
 * of 4.44, does not browserify path in a way that preserves the
 * path posix API.
 *
 * Luckily, its default behavior does what we need. Hence all of the
 * inBrowser checks that dispatch to the default impl.
 *
 */
/** @return path.basename behavior */
export declare function basename(filepath: string): string;
/** @return path.dirname behavior */
export declare function dirname(filepath: string): string;
/** @return path.join behavior */
export declare function join(a: string, b: string): string;
