/// <reference types="node" />
import { FStat, VFS } from '@kui-shell/plugin-bash-like/fs';
import { Arguments } from '@kui-shell/core';
export declare class NotebookVFS implements VFS {
    readonly mountPath: string;
    readonly isLocal = false;
    readonly isVirtual = true;
    protected readonly prefix: RegExp;
    private readonly trie;
    constructor(mountPath?: string);
    /** Turn an ls-style glob into a nodejs-style regexp */
    private glob2RegExp;
    private dirPattern;
    /** Looks in the trie for any matches for the given filepath, handling the "contents of directory" case */
    private find;
    /** Looks in the trie for a single precise match */
    private findExact;
    private enumerate;
    ls({ parsedOptions }: Parameters<VFS['ls']>[0], filepaths: string[]): Promise<{
        name: string;
        nameForDisplay: string;
        path: string;
        stats: {
            size: number;
            mtimeMs: number;
            mode: number;
            uid: number;
            gid: number;
        };
        dirent: {
            mount: {
                isLocal: boolean;
            };
            isFile: boolean;
            isDirectory: boolean;
            isSymbolicLink: boolean;
            isSpecial: boolean;
            isExecutable: boolean;
            permissions: string;
            username: string;
        };
    }[]>;
    /** Insert filepath into directory */
    cp(_: any, srcFilepaths: string[], dstFilepath: string): Promise<string>;
    /** Remove filepath */
    rm(): ReturnType<VFS['rm']>;
    /** Fetch contents */
    fstat(opts: Pick<Arguments, 'REPL' | 'parsedOptions'>, filepath: string, withData: boolean, enoentOk: boolean): Promise<FStat>;
    fwrite(opts: Pick<Arguments, 'REPL'>, filepath: string, data: string | Buffer): Promise<void>;
    /** Fetch content slice */
    fslice(filename: string, offset: number, length: number): Promise<string>;
    /** Create a directory/bucket */
    mkdir(opts: Pick<Arguments, 'argvNoOptions'>): Promise<void>;
    /** Remove a directory/bucket */
    rmdir(): Promise<void>;
}
declare const vfs: NotebookVFS;
export default vfs;
export declare function preload(): void;
