"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.basename = basename;
exports.dirname = dirname;
exports.join = join;

var _core = require("@kui-shell/core");

var _path = require("path");

/*
 * Copyright 2020 The Kubernetes Authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * This file offers a thin facade over path.posix. Webpack at least as
 * of 4.44, does not browserify path in a way that preserves the
 * path posix API.
 *
 * Luckily, its default behavior does what we need. Hence all of the
 * inBrowser checks that dispatch to the default impl.
 *
 */

/** @return path.basename behavior */
function basename(filepath) {
  return (0, _core.inBrowser)() ? (0, _path.basename)(filepath) : _path.posix.basename(filepath);
}
/** @return path.dirname behavior */


function dirname(filepath) {
  return (0, _core.inBrowser)() ? (0, _path.dirname)(filepath) : _path.posix.dirname(filepath);
}
/** @return path.join behavior */


function join(a, b) {
  return (0, _core.inBrowser)() ? (0, _path.join)(a, b) : _path.posix.join(a, b);
}