/*
 * Copyright 2020 The Kubernetes Authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/** @return the selected text in the current window window */
export function getSelectionText() {
    let text = '';
    if (window.getSelection) {
        text = window.getSelection().toString();
    }
    return text;
}
/** Invoke the given handler only if there is no text selection */
export default function whenNothingIsSelected(handler) {
    return (evt) => {
        if (getSelectionText().length === 0) {
            return handler(evt);
        }
    };
}
//# sourceMappingURL=selection.js.map