/// <reference types="react" />
export declare type SelectOptions = {
    label: string;
    command?: string;
    description?: React.ReactNode;
    isSelected?: boolean;
    isDisabled?: boolean;
};
declare type BaseProps = {
    /** Variant of rendered Select */
    variant: 'single' | 'checkbox' | 'typeahead' | 'typeaheadmulti';
    /** extra css classes */
    className?: string;
    /** Flag to indicate if select is open. Default: false */
    isOpen?: boolean;
    /** Flag to indicate whether we should allow the select to be closed. Default: true */
    isClosable?: boolean;
    /** selected item */
    selected?: string;
    /** max height of the select options */
    maxHeight?: string;
    /** Flag to indicate if select options are grouped */
    isGrouped?: boolean;
    /** Flag to indicate if select option is disabled */
    isDisabled?: boolean;
};
declare type Divider = {
    divider: true;
};
declare type Group = {
    label: string;
    options: SelectOptions[];
};
declare type GroupedProps = BaseProps & {
    /** select groups */
    groups: (Divider | Group)[];
};
export declare function isDivider(group: Divider | Group): group is Divider;
declare type NonGroupedProps = BaseProps & {
    /** select options */
    options: SelectOptions[];
};
declare type Props = GroupedProps | NonGroupedProps;
export declare function isGrouped(props: Props): props is GroupedProps;
export default Props;
