import React from 'react';
import { Props, SupportedIcon } from '.';
declare type TwoFaceProps<A extends SupportedIcon, B extends SupportedIcon> = Pick<Props, 'className'> & {
    /** The primary icon */
    a: A;
    /** The icon to display transiently after a click */
    b: B;
    /** Optional className for the B face */
    classNameB?: string;
    /** After a click transition from a to b, millis to wait before auto-toggling back to a */
    delay?: number;
    /** Underlying click handler. This component will add its own wrapper handler, to handle the face toggle */
    onClick?: (evt: React.MouseEvent) => void;
    /** Tooltip */
    title?: string;
};
declare type TwoFaceState = {
    face: 'a' | 'b';
};
export default class TwoFaceIcon<A extends SupportedIcon, B extends SupportedIcon, Props extends TwoFaceProps<A, B>> extends React.PureComponent<Props, TwoFaceState> {
    private readonly toggle;
    constructor(props: Props);
    private toggleState;
    private onToggle;
    render(): JSX.Element;
}
export {};
