/// <reference types="react" />
import { Tab as KuiTab, NewSplitRequest } from '@kui-shell/core';
import Block from './Block';
import { BlockModel } from './Block/BlockModel';
export declare type Cleaner = () => void;
export declare type ScrollbackOptions = NewSplitRequest['options'];
declare type ScrollbackState = ScrollbackOptions & {
    uuid: string;
    blocks: BlockModel[];
    forceMiniSplit: boolean;
    /** tab facade */
    facade?: KuiTab;
    /** grab a ref to the active block, to help us maintain focus */
    _activeBlock?: Block;
    /** Has the user clicked to focus on a block? */
    focusedBlockIdx?: number;
    /** cleanup routines for this split */
    cleaners: Cleaner[];
    /**
     * Block index (into this.blocks) to show in a MiniSplit. Must be a
     * negative number, interpreted as an index from the end.
     */
    showThisIdxInMiniSplit: number;
    /** Memoized handlers */
    remove: () => void;
    clear: () => void;
    onClick: (evt: React.MouseEvent<HTMLElement, MouseEvent>) => void;
    onMouseDown: (evt: React.MouseEvent<HTMLElement, MouseEvent>) => void;
    onFocus: (evt: React.FocusEvent) => void;
    onOutputRender: () => void;
    navigateTo: (dir: 'first' | 'last' | 'previous' | 'next') => void;
    setActiveBlock: (c: Block) => void;
    willFocusBlock: (evt: React.SyntheticEvent) => void;
    willRemoveBlock: (evt: React.SyntheticEvent, idx?: number) => void;
    willUpdateCommand: (idx: number, command: string) => void;
    tabRefFor: (ref: HTMLElement) => void;
};
export default ScrollbackState;
