import ScrollableTerminal from './ScrollableTerminal';
export declare function isClipboardTransferString(data: string): boolean;
/** The target of a clipboard operation */
interface Target {
    insertionIdx: number;
    scrollbackIdx: number;
    execUUID: string;
}
/**
 * User has initiated a paste. First, we check that a block is
 * focused. We use this block to determine the insertion index. In
 * the future, we probably need to generalize this, so that we can
 * support pasting in the active block as well. Second, we make sure that
 *
 */
export declare function onPaste(this: ScrollableTerminal, evt: ClipboardEvent): void;
/**
 * User has initiated a clipboard copy. As with paste, we confirm
 * first that this event is relevant to `this` Terminal. If so, we
 * collect the relevant blocks, and then write a `ClipboardTransfer`
 * object to the clipboard.
 *
 */
export declare function onCopy(this: ScrollableTerminal, evt: ClipboardEvent, onSuccess?: (target: Target) => void): void;
/**
 * User has initated a cut. First copy. If that succeeded, the remove
 * the block.
 *
 */
export declare function onCut(this: ScrollableTerminal, evt: ClipboardEvent): void;
export {};
