import React from 'react';
import { Tab as KuiTab } from '@kui-shell/core';
import { TabCompletionState } from './TabCompletion';
import ActiveISearch from './ActiveISearch';
import { BlockModel } from './BlockModel';
import { BlockViewTraits, BlockOperationTraits } from './';
export interface InputOptions extends BlockOperationTraits {
    /** Optional: placeholder value for prompt */
    promptPlaceholder?: string;
    /** Optional: do not display prompt context, e.g. current working directory */
    noPromptContext?: boolean;
    /** Optional: onChange handler */
    onInputChange?: (event: React.ChangeEvent<HTMLInputElement>) => void;
    /** Optional: onClick handler */
    onInputClick?: (event: React.MouseEvent<HTMLInputElement>) => void;
    /** Optional: onKeyDown handler */
    onInputKeyDown?: (event: React.KeyboardEvent<HTMLInputElement>) => void;
    /** Optional: onKeyPress handler */
    onInputKeyPress?: (event: React.KeyboardEvent<HTMLInputElement>) => void;
    /** Optional: onKeyUp handler */
    onInputKeyUp?: (event: React.KeyboardEvent<HTMLInputElement>) => void;
    /** Optional: onMouseDown handler */
    onInputMouseDown?: (event: React.MouseEvent<HTMLInputElement>) => void;
    /** Optional: onMouseMove handler */
    onInputMouseMove?: (event: React.MouseEvent<HTMLInputElement>) => void;
    /** Optional: onBlur handler */
    onInputBlur?: (event: React.FocusEvent<HTMLInputElement>) => void;
    /** Optional: onFocus handler */
    onInputFocus?: (event: React.FocusEvent<HTMLInputElement>) => void;
    /** Capture a screenshot of the enclosing block */
    willScreenshot?: () => void;
    /** Navigation controller */
    navigateTo?(dir: 'first' | 'last' | 'previous' | 'next'): void;
}
declare type InputProps = {
    /** Block ordinal */
    idx?: number;
    /** Block ordinal to be displayed to user */
    displayedIdx?: number;
    /** needed temporarily to make pty/client happy */
    _block?: HTMLElement;
    /** tab UUID */
    uuid?: string;
    /** for key handlers, which may go away soon */
    tab?: KuiTab;
    /** state of the Block, e.g. Processing? Active/accepting input? */
    model?: BlockModel;
    /** is the command experimental? */
    isExperimental?: boolean;
};
export declare type Props = InputOptions & InputProps & BlockViewTraits;
export interface State {
    /** Copy from props; to help with getDerivedStateFromProps */
    model: BlockModel;
    /** did user click to re-edit the input? */
    isReEdit?: boolean;
    /** the execution ID for this prompt, if any */
    execUUID?: string;
    /** DOM element for prompt; set via `ref` in render() below */
    prompt?: HTMLInputElement;
    /** state of active reverse-i-search */
    isearch?: ActiveISearch;
    /** state of tab completion */
    tabCompletion?: TabCompletionState;
    /** durationDom, used for counting up duration while Processing */
    counter?: ReturnType<typeof setInterval>;
    durationDom?: HTMLSpanElement;
    /** typeahead completion? */
    typeahead?: string;
}
export declare abstract class InputProvider<S extends State = State> extends React.PureComponent<Props, S> {
    /** this is what the InputProvider needs to provide, minimially */
    protected abstract input(): any;
    /** rendered to the left of the input element */
    protected status(): void;
    protected cancelReEdit(): void;
    private readonly _cancelReEdit;
    protected contextContent(insideBrackets?: React.ReactNode): React.ReactNode;
    /** the "xxx" part of "xxx >" of the prompt */
    protected promptLeft(): JSX.Element;
    /** the ">" part of "xxx >" of the prompt */
    protected promptRight(): JSX.Element;
    protected isearchPrompt(): JSX.Element;
    protected normalPrompt(): JSX.Element;
    /** the "xxx >" prompt part of the input section */
    protected prompt(): JSX.Element;
    render(): JSX.Element;
}
export default class Input extends InputProvider {
    constructor(props: Props);
    /** @return the current value of the prompt */
    value(): string;
    /** @return the value to be added to the prompt */
    protected static valueToBeDisplayed(props: Props): string;
    /** Owner wants us to focus on the current prompt */
    doFocus(): void;
    protected contextContent(): React.ReactNode;
    private static newCountup;
    private static updateCountup;
    static getDerivedStateFromProps(props: Props, state: State): State | {
        model: {
            state: import("./BlockModel").BlockState.Active;
        } & {
            cwd: string;
        } & Partial<{
            value: string;
        }>;
        prompt: any;
        counter: number;
        execUUID: any;
    };
    private onKeyPress;
    private readonly _onKeyPress;
    private onKeyDown;
    private readonly _onKeyDown;
    private onKeyUp;
    private readonly _onKeyUp;
    private onPaste;
    private readonly _onPaste;
    private onRef;
    private readonly _onRef;
    private willFocusBlock;
    /** This is the onFocus property of the active prompt */
    private readonly _onFocus;
    /** This is the onBLur property of the active prompt */
    private readonly _onBlur;
    /** This is the onClick property of the prompt for Active blocks */
    private readonly _onClickActive;
    /** This is the onClick property of the prompt for Finished blocks */
    private readonly _onClickFinished;
    /** For Processing blocks, we use an overlay <input/> element. We need to manage focus, since it has pointer-events: none */
    private readonly _restoreFocusToOverlayInput;
    /** This is the input overlay for Processing blocks */
    private inputOverlayForProcessingBlocks;
    /** the element that represents the command being/having been/going to be executed */
    protected input(): JSX.Element;
    /**
     * Turn the value part of the input into a fancier form,
     * e.g. rendering pipelines or command names in a better way.
     *
     */
    private fancyValue;
    componentDidCatch(error: Error, errorInfo: React.ErrorInfo): void;
    /** render a tag for experimental command */
    private experimentalTag;
    /** render the time the block started processing */
    private timestamp;
    /** spinner for processing blocks */
    private spinner;
    /** error icon for error blocks */
    /** DropDown menu for completed blocks */
    private actions;
    /**
     * Status elements associated with the block as a whole; even though
     * these also pertain to the Output part of a Block, these are
     * currently housed in this Input component.
     *
     */
    protected status(): JSX.Element;
    /** Should we show the spinner in the In[...] context area, or in the [<input/> ...] area? */
    private showSpinnerInContext;
    /** Status elements placed in with <input> part of the block */
    protected inputStatus(input: string): JSX.Element;
}
export {};
