/*
 * Copyright 2020 The Kubernetes Authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
import React from 'react';
import { isPopup } from '@kui-shell/core';
import TitleBar from './TitleBar';
import '../../../../web/css/static/sidecar.scss';
import '../../../../web/css/static/sidecar-main.css';
import '../../../../web/scss/components/Sidecar/_index.scss';
export default class BaseSidecar extends React.PureComponent {
    constructor() {
        super(...arguments);
        /** screenshotable region */
        this.dom = React.createRef();
        this._preventDefault = (evt) => evt.preventDefault();
        this._stopPropagation = (evt) => evt.stopPropagation();
    }
    get current() {
        return this.state;
    }
    defaultWidth() {
        return this.props.defaultWidth || "60%" /* Split60 */;
    }
    /** Escape key toggles sidecar visibility */
    onEscape(evt) {
        if (evt.key === 'Escape' &&
            this.props.active &&
            !document.getElementById('confirm-dialog') &&
            !isPopup() &&
            this.current) {
            if (this.props.willChangeSize) {
                this.props.willChangeSize(this.props.width === "0%" /* Closed */ ? this.defaultWidth() : "0%" /* Closed */);
            }
        }
    }
    onMaximize() {
        if (this.props.willChangeSize) {
            this.props.willChangeSize("100%" /* Maximized */);
        }
        this.setState({ isMaximized: true });
    }
    onRestore() {
        if (this.props.willChangeSize) {
            this.props.willChangeSize(this.defaultWidth());
        }
        this.setState({ isMaximized: false });
    }
    onClose() {
        if (this.props.onClose) {
            this.props.onClose();
        }
        if (this.props.willChangeSize) {
            this.props.willChangeSize("0%" /* Closed */);
        }
    }
    isFixedWidth() {
        return false;
    }
    width() {
        return 'visible' + (this.state.isMaximized ? ' maximized' : '');
    }
    title(props) {
        return (React.createElement(TitleBar, Object.assign({}, props, { notCloseable: true, repl: this.props.tab.REPL, width: this.defaultWidth(), onClose: this.onClose.bind(this) })));
    }
}
//# sourceMappingURL=BaseSidecarV2.js.map