import React from 'react';
import { KResponse, Tab as KuiTab, ParsedOptions } from '@kui-shell/core';
import Width from './width';
import LocationProps from './Location';
import { Props as TitleBarProps } from './TitleBar';
import '../../../../web/css/static/sidecar.scss';
import '../../../../web/css/static/sidecar-main.css';
import '../../../../web/scss/components/Sidecar/_index.scss';
export interface SidecarOptions {
    defaultWidth?: Width;
    onClose?: () => void;
    /** Current presentation of the sidecar; e.g. Maximized or Closed or Default width? */
    width?: Width;
    willChangeSize?: (width: Width) => void;
    willLoseFocus?: () => void;
}
export declare type BaseProps = {
    uuid?: string;
    tab?: KuiTab;
    active?: boolean;
};
export declare type Props<R extends KResponse> = SidecarOptions & BaseProps & LocationProps & {
    response?: R;
    argvNoOptions?: string[];
    parsedOptions?: ParsedOptions;
    onRender?: (hasContent: boolean) => void;
};
export interface State {
    /** maximized? */
    isMaximized?: boolean;
}
export default class BaseSidecar<R extends KResponse, S extends State> extends React.PureComponent<Props<R>, S> {
    /** screenshotable region */
    protected readonly dom: React.RefObject<HTMLDivElement>;
    protected readonly _preventDefault: (evt: React.SyntheticEvent) => void;
    protected readonly _stopPropagation: (evt: React.SyntheticEvent) => void;
    protected get current(): Readonly<S>;
    protected defaultWidth(): Width;
    /** Escape key toggles sidecar visibility */
    private onEscape;
    protected onMaximize(): void;
    protected onRestore(): void;
    protected onClose(): void;
    protected isFixedWidth(): boolean;
    protected width(): Required<string>;
    protected title(props?: Omit<TitleBarProps, 'width' | 'fixedWidth' | 'onClose' | 'onRestore' | 'onMaximize' | 'onMinimize' | 'willScreenshot' | 'repl'>): JSX.Element;
}
