import React from 'react';
import { Props as BreadcrumbProps } from '../../spi/Breadcrumb';
import '../../../../web/css/static/ToolbarButton.scss';
import '../../../../web/scss/components/Table/Events.scss';
import '../../../../web/scss/components/Table/Toolbar.scss';
export declare type Props = Partial<GridProps> & Partial<SequenceProps> & Partial<TimelineProps> & Partial<HistogramProps> & Partial<PaginationProps> & Partial<BreadcrumbProps> & Partial<CaptionProps> & Partial<StreamProps> & {
    framed?: boolean;
    className?: string;
};
interface CaptionProps {
    caption: string | React.ReactElement;
}
interface GridProps {
    gridableColumn: number;
    asGrid?: boolean;
    setAsGrid: (asGrid: boolean) => void;
}
interface SequenceProps {
    hasSequenceButton?: boolean;
    asSequence: boolean;
    setAsSequence: (asSequence: boolean) => void;
}
interface TimelineProps {
    hasTimelineButton?: boolean;
    asTimeline: boolean;
    setAsTimeline: (asTimeline: boolean) => void;
}
interface HistogramProps {
    hasHistogramButton?: boolean;
    asHistogram: boolean;
    setAsHistogram: (asHistogram: boolean) => void;
}
interface PaginationProps {
    paginate: boolean;
    page: number;
    totalItems: number;
    pageSize: number;
    setPage: (page: number) => void;
}
interface StreamProps {
    stream: string[];
}
export default class Toolbar extends React.PureComponent<Props> {
    private hasGridButtons;
    private hasButtons;
    private viewController;
    private previousPage;
    private nextPage;
    private paginationController;
    private breadcrumbs;
    private buttons;
    /** so that buttons are flush-left and pagination is flush-right */
    private filler;
    private messageStream;
    private caption;
    render(): JSX.Element;
}
export {};
