import React from 'react';
import { REPL, Tab, Table } from '@kui-shell/core';
import DefaultColoring, { Coloring } from './Coloring';
import '../../../../web/scss/components/Table/Timeline.scss';
interface Bucket {
    startMillis: number;
    endMillis: number;
    coldStart: number;
    execution: number;
    durationSplit: {
        coldStart: number;
        execution: number;
    }[];
}
interface Props {
    response: Table;
    tab: Tab;
    repl: REPL;
    nBuckets?: number;
}
interface State {
    bucketTimeRange: number;
    maxBucketOccupancy: number;
    buckets: Bucket[];
    coloring: Coloring;
}
export default class Timeline extends React.PureComponent<Props, State> {
    /**
     * Default number of buckets in the timeline
     *
     */
    private static readonly defaultNBuckets;
    constructor(props: Props);
    static getDerivedStateFromProps(props: Props): {
        bucketTimeRange: number;
        maxBucketOccupancy: number;
        coloring: DefaultColoring;
        buckets: Bucket[];
    };
    private static computeBuckets;
    private getFraction;
    private bar;
    private buckets;
    private yAxis;
    private xAxis;
    render(): JSX.Element;
}
export {};
