import { Tab, REPL, Table as KuiTable, Row as KuiRow } from '@kui-shell/core';
import React from 'react';
import { SortByDirection } from '@patternfly/react-table';
import { Props as ToolbarProps } from './Toolbar';
import { BreadcrumbView } from '../../spi/Breadcrumb';
import KuiConfiguration from '../../Client/KuiConfiguration';
/** import the kui theme alignment */
import '../../../../web/scss/components/Table/PatternFly.scss';
import '../../../../web/scss/components/Table/carbon-kui-theme-alignment.scss';
interface PaginationConfiguration {
    pageSize?: number;
}
/** parameters to PaginatedTable component */
export declare type Props<T extends KuiTable = KuiTable> = PaginationConfiguration & {
    tab: Tab;
    config: KuiConfiguration;
    repl: REPL;
    response: T;
    /**
     * paginate: true -> always paginate
     * paginate: false -> never paginate
     * paginate: number -> paginate if above the threshold of rows
     */
    paginate: boolean | number;
    /** use toolbars? */
    toolbars: boolean;
    /** use title? */
    title: boolean;
    /** Is this table being rendered in a minisplit? */
    isPartOfMiniSplit: boolean;
    /** Is the Sidecar visible in this Tab? or some other width constraint? */
    isWidthConstrained: boolean;
    /** display as grid (versus as regular table)? */
    asGrid: boolean;
    /** prefix breadcrumbs? */
    prefixBreadcrumbs?: BreadcrumbView[];
    onRender: (hasContent: boolean) => void;
};
/** state of PaginatedTable component */
export declare type State<T extends KuiTable = KuiTable> = ToolbarProps & {
    response: T;
    header: KuiRow;
    body: KuiRow[];
    footer: string[];
    page: number;
    pageSize: number;
    activeSortIdx: number;
    activeSortDir: SortByDirection;
};
export declare function getBreadcrumbsFromTable(response: KuiTable, prefixBreadcrumbs: BreadcrumbView[]): BreadcrumbView[];
/**
 * A DataTable/Pagination pair
 *
 */
export default class PaginatedTable<P extends Props, S extends State> extends React.PureComponent<P, S> {
    private readonly defaultPageSize;
    /**
     * A lock that governs the --kui--table-max-height
     * initialization. See https://github.com/IBM/kui/issues/5206
     *
     */
    private static oneTimeInit;
    constructor(props: P);
    static getDerivedStateFromProps(props: Props, currentState?: State): {
        page: number;
        pageSize: number;
        asTimeline: boolean;
    } & {
        body: KuiRow[];
        asGrid: boolean;
        footer: string[];
        header: KuiRow & {
            isSortable?: boolean;
        };
        asSequence: boolean;
        asHistogram: boolean;
        activeSortIdx: number;
        activeSortDir: any;
        response: KuiTable<KuiRow>;
        pageSize: number;
    };
    private topToolbar;
    private isPaginated;
    private hasFooterLines;
    private footerLines;
    private static hasSequenceButton;
    private static hasHistogramButton;
    private bottomToolbar;
    /** E.g. last updated time for live tables */
    protected caption(): ToolbarProps['caption'] | void;
    private grid;
    private justUpdatedMap;
    private table;
    private sequence;
    private histogram;
    private timeline;
    /** @return whether the table is currently "live", and responding to updates from the controller */
    protected isWatching(): boolean;
    private content;
    protected dataAttrs(): {};
    render(): JSX.Element;
}
export {};
