/*
 * Copyright 2020 The Kubernetes Authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
import React from 'react';
import { ansiToJson } from 'anser';
const decos = {
    dim: 'sub-text semi-transparent',
    strikethrough: 'strikethrough',
    italic: 'italic'
};
function tagOf(entry) {
    return entry.decorations.find(_ => _ === 'bold') ? 'strong' : 'span';
}
function classOf(entry) {
    const fg = entry.fg ? entry.fg.replace(/^ansi-(.*)/, 'ansi-$1-fg') : '';
    const bg = entry.bg ? entry.bg.replace(/^ansi-(.*)/, 'ansi-$1-bg') : '';
    const deco = entry.decorations.map(_ => decos[_] || '');
    return `${fg} ${bg} ${deco.join(' ')}`;
}
export default function Ansi(props) {
    // eslint-disable-next-line @typescript-eslint/camelcase
    const model = ansiToJson(props.children, { use_classes: true });
    return (React.createElement("pre", null, model.map((_, idx) => _.content && React.createElement(tagOf(_), { key: idx, className: classOf(_) }, _.content))));
}
//# sourceMappingURL=Ansi.js.map