import React from 'react';
import { CommentaryResponse, REPL } from '@kui-shell/core';
interface State {
    isEdit: boolean;
    textValue: string;
    lastAppliedTextValue: string;
    repl?: REPL;
}
declare type Props = CommentaryResponse['props'] & {
    tabUUID: string;
    isPartOfMiniSplit: boolean;
    willUpdateResponse?: (text: string) => void;
    willRemove?: () => void;
    willUpdateCommand?: (command: string) => void;
    onRender: () => void;
};
export default class Commentary extends React.PureComponent<Props, State> {
    constructor(props: Props);
    /** update state to cancel any edits and close the editor */
    private onCancel;
    private readonly _onCancel;
    /** cancel button */
    private cancel;
    /** Update state to cancel any updates, but leave editor open */
    private onRevert;
    private readonly _onRevert;
    /** revert button */
    private revert;
    /** If the user clicks Done or Cancel and there is no text, remove ourselves */
    private removeOurselvesIfEmpty;
    /** Update state to reflect lastAppliedTextValue, and close the editor */
    private onDone;
    private readonly _onDone;
    /** done button removes the editor  */
    private done;
    /** toolbar hosts editor actions */
    private toolbar;
    /** Enter isEdit mode */
    private setEdit;
    private readonly _setEdit;
    private card;
    /** Percolate `SimpleEditor` edits up to the Preview view */
    private onContentChange;
    private readonly _onContentChange;
    /** User has requested to save changes via keyboard shortcut, from within `SimpleEditor` */
    private onSaveFromEditor;
    private readonly _onSaveFromEditor;
    /** User has requested to cancel changes via keyboard shortcut, from within `SimpleEditor` */
    private onCancelFromEditor;
    private readonly _onCancelFromEditor;
    /** @return the initial content to display, before any editing */
    private initialTextValue;
    private editor;
    render(): JSX.Element;
}
export {};
