/// <reference types="node" />
import React from 'react';
import { Tab as KuiTab, TabState } from '@kui-shell/core';
import { TopTabButton } from './TabModel';
import ScrollableTerminal, { TerminalOptions } from '../Views/Terminal/ScrollableTerminal';
interface WithTabUUID {
    uuid: string;
}
interface WithTab {
    tab: KuiTab;
    tabClassList: Record<string, boolean>;
}
export declare type TabContentOptions = TerminalOptions & {
    /** [Optional] elements to be placed below the Terminal */
    bottom?: React.ReactElement<WithTabUUID & WithTab>;
    onTabReady?: (tab: KuiTab) => void;
};
declare type Props = TabContentOptions & WithTabUUID & {
    active: boolean;
    state: TabState;
    snapshot?: Buffer;
    tabTitle?: string;
    willUpdateTopTabButtons?: (buttons: TopTabButton[]) => void;
};
declare type SessionInitStatus = 'NotYet' | 'InProgress' | 'Reinit' | 'Done' | 'Error';
declare type State = Partial<WithTab> & {
    sessionInit: SessionInitStatus;
    sessionInitError?: Error;
    showSessionInitDone: boolean;
    /** grab a ref (below) so that we can maintain focus */
    _terminal: ScrollableTerminal;
};
/**
 *
 * TabContent
 * ----------------  <Tab/> from here down
 * | ST  |        |
 * |     |        |
 * |     |        |
 * |     |        |
 * |     |        |
 * |     |        |
 * ----------------
 *  ST: <ScrollableTerminal/>
 *
 */
export default class TabContent extends React.PureComponent<Props, State> {
    private readonly cleaners;
    /** switching back or away from this tab */
    private activateHandlers;
    constructor(props: Props);
    componentDidMount(): void;
    private onOffline;
    private static onSessionInitError;
    /** emit /tab/new event, if we have now a tab, but have not yet
     * emitted the event */
    static getDerivedStateFromProps(props: Props, state: State): State | {
        sessionInit: string;
    };
    componentWillUnmount(): void;
    private defaultLoading;
    private terminal;
    private graft;
    /** Graft on the REPL focus management */
    private children;
    /** Graft on the tab uuid */
    private bottom;
    /** Construct the `className` property of the tab element */
    private tabClassName;
    render(): JSX.Element;
}
export {};
