import React from 'react';
import { StatusStripeChangeEvent } from '@kui-shell/core';
import '../../../../web/scss/components/StatusStripe/StatusStripe.scss';
declare type State = StatusStripeChangeEvent;
export declare type Props = Partial<State> & {
    noHelp?: boolean;
    noSettings?: boolean;
};
export default class StatusStripe extends React.PureComponent<Props, State> {
    private readonly helpRef;
    constructor(props: Props);
    /** Overlay default values for required state variables */
    private withStateDefaults;
    /** Status Stripe change request */
    private onChangeRequest;
    /**
     * User has clicked on the Settings icon.
     *
     */
    private doAbout;
    /**
     * If the Client offers no status stripe widgets, we should insert a
     * filler, so that the Settings icon is presented flush-right.
     *
     */
    private filler;
    /**
     * Render the current State.message, if any
     *
     */
    private message;
    /**
     * Render any widgets specified by the client. Note how we don't
     * show widgets if we were given a message. See
     * https://github.com/IBM/kui/issues/5490
     *
     */
    private widgets;
    private className;
    render(): JSX.Element;
}
export {};
