"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = PatternFlyButton;

var _react = _interopRequireDefault(require("react"));

var _reactCore = require("@patternfly/react-core");

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

/*
 * Copyright 2020 The Kubernetes Authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
function PatternFlyButton(props) {
  return _react.default.createElement(_reactCore.Button, {
    id: props.id,
    type: props.type,
    onClick: props.onClick,
    variant: props.kind,
    isDisabled: props.isDisabled,
    isSmall: props.size === 'small',
    tabIndex: props.tabIndex,
    className: ['kui--button', 'kui--tag', props.className].join(' ')
  }, props.children);
}