"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _react = _interopRequireDefault(require("react"));

var _core = require("@kui-shell/core");

var _Icons = _interopRequireDefault(require("../../spi/Icons"));

var _Tooltip = _interopRequireDefault(require("../../spi/Tooltip"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

/*
 * Copyright 2021 The Kubernetes Authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
const strings = (0, _core.i18n)('plugin-client-common');
/** Render a header for the given split */

class SplitHeader extends _react.default.PureComponent {
  constructor() {
    super(...arguments);

    this.stopFocusStealing = evt => evt.preventDefault();
  }

  closeButton() {
    return _react.default.createElement(_Tooltip.default, {
      markdown: strings('Close this split pane')
    }, _react.default.createElement("a", {
      href: "#",
      className: "kui--split-close-button kui--tab-navigatable",
      onMouseDown: this.stopFocusStealing,
      onClick: this.props.onRemove
    }, "\u2A2F"));
  }

  clearButton() {
    return _react.default.createElement(_Tooltip.default, {
      markdown: strings('Clear this split pane')
    }, _react.default.createElement("a", {
      href: "#",
      className: "kui--tab-navigatable",
      onMouseDown: this.stopFocusStealing,
      onClick: this.props.onClear
    }, _react.default.createElement(_Icons.default, {
      className: "kui--split-clear-button",
      icon: "Clear"
    })));
  }

  render() {
    return _react.default.createElement("div", {
      className: "kui--split-header flex-layout kui--inverted-color-context"
    }, _react.default.createElement("div", {
      className: "flex-fill"
    }), this.clearButton(), this.closeButton());
  }

}

exports.default = SplitHeader;