"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _react = _interopRequireDefault(require("react"));

var _path = require("path");

var _core = require("@kui-shell/core");

var _BlockModel = require("./Block/BlockModel");

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

/*
 * Copyright 2021 The Kubernetes Authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
const Accordion = _react.default.lazy(() => Promise.resolve().then(() => require('../../spi/Accordion')));

const SimpleEditor = _react.default.lazy(() => Promise.resolve().then(() => require('../../Content/Editor/SimpleEditor')));

class SourceRef extends _react.default.PureComponent {
  /** render sourceRef content. Currently only use SimpleEditor. */
  sourceRefContent(content, contentType) {
    return () => _react.default.createElement(_react.default.Suspense, {
      fallback: _react.default.createElement("div", null)
    }, _react.default.createElement(SimpleEditor, {
      tabUUID: (0, _core.getPrimaryTabId)(this.props.tab),
      content: content.replace(/\n$/, ''),
      contentType: contentType,
      className: "kui--source-ref-editor kui--inverted-color-context",
      fontSize: 12,
      simple: true
    }));
  }

  render() {
    const {
      model
    } = this.props;

    if (model && (0, _BlockModel.isWithCompleteEvent)(model) && (0, _core.isTable)(model.response) && (0, _core.hasSourceReferences)(model.response)) {
      // Note that we currently do not render source refs in
      // minisplit. See https://github.com/IBM/kui/issues/6750
      if (!this.props.isPartOfMiniSplit) {
        const sourceRef = model.response.kuiSourceRef;
        const names = sourceRef.templates.concat(sourceRef.customization || []).map(_ => (0, _path.basename)(_.filepath));
        const content = sourceRef.templates.map(_ => this.sourceRefContent(_.data, _.contentType)).concat(sourceRef.customization ? this.sourceRefContent(sourceRef.customization.data, 'yaml') : []);
        return _react.default.createElement("div", {
          className: "repl-input-sourceref"
        }, _react.default.createElement("div", {
          className: "repl-context"
        }), _react.default.createElement(Accordion, {
          names: names,
          isWidthConstrained: this.props.isWidthConstrained,
          tab: this.props.tab,
          content: content
        }));
      } else {
        return _react.default.createElement(_react.default.Fragment, null);
      }
    } else {
      return _react.default.createElement(_react.default.Fragment, null);
    }
  }

}

exports.default = SourceRef;