"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _react = _interopRequireDefault(require("react"));

var _core = require("@kui-shell/core");

var _BlockModel = require("./BlockModel");

var _Actions = _interopRequireDefault(require("./Actions"));

var _Scalar = _interopRequireDefault(require("../../../Content/Scalar/"));

var _context = _interopRequireDefault(require("../../../Client/context"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

/*
 * Copyright 2020 The Kubernetes Authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
var __awaiter = void 0 && (void 0).__awaiter || function (thisArg, _arguments, P, generator) {
  function adopt(value) {
    return value instanceof P ? value : new P(function (resolve) {
      resolve(value);
    });
  }

  return new (P || (P = Promise))(function (resolve, reject) {
    function fulfilled(value) {
      try {
        step(generator.next(value));
      } catch (e) {
        reject(e);
      }
    }

    function rejected(value) {
      try {
        step(generator["throw"](value));
      } catch (e) {
        reject(e);
      }
    }

    function step(result) {
      result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected);
    }

    step((generator = generator.apply(thisArg, _arguments || [])).next());
  });
};

const Ansi = _react.default.lazy(() => Promise.resolve().then(() => require('../../../Content/Scalar/Ansi')));

const strings = (0, _core.i18n)('plugin-client-common');

class Output extends _react.default.PureComponent {
  constructor(props) {
    super(props);

    this._willRemove = () => this.props.willRemove(undefined, this.props.idx);

    this._willUpdateCommand = command => this.props.willUpdateCommand(this.props.idx, command);

    this.streamingOutput = [];
    this._onRender = this.onRender.bind(this);
    const streamingConsumer = this.streamingConsumer.bind(this);
    this.state = {
      alreadyListen: false,
      isResultRendered: false,
      nStreamingOutputs: 0,
      streamingConsumer
    };
  } // eslint-disable-next-line @typescript-eslint/no-unused-vars


  streamingConsumer(part) {
    return __awaiter(this, void 0, void 0, function* () {
      if ((0, _BlockModel.hasUUID)(this.props.model)) {
        const tabUUID = this.props.uuid;
        const execUUID = this.props.model.execUUID;

        const done = () => {
          this.props.onRender();

          _core.eventChannelUnsafe.emit(`/command/stdout/done/${tabUUID}/${execUUID}`);
        }; // part === null: the controller wants to clear any prior output


        if (part === null) {
          this.streamingOutput = [];
          done();
          return {
            // remove all output
            nStreamingOutputs: 0
          };
        } else {
          this.streamingOutput.push(part);
          setTimeout(() => {
            this.setState({
              nStreamingOutputs: this.streamingOutput.length
            });
            setTimeout(done, 10);
          }, 10);
        }
      }
    });
  }

  static getDerivedStateFromProps(props, state) {
    if (((0, _BlockModel.isProcessing)(props.model) || (0, _BlockModel.isBeingRerun)(props.model)) && !state.alreadyListen) {
      const tabUUID = props.uuid;

      _core.eventChannelUnsafe.on(`/command/stdout/${tabUUID}/${props.model.execUUID}`, state.streamingConsumer);

      return {
        alreadyListen: true,
        isResultRendered: false,
        streamingOutput: []
      };
    } else if ((0, _BlockModel.isFinished)(props.model) && !state.isResultRendered) {
      const tabUUID = props.uuid;

      if (!(0, _BlockModel.isEmpty)(props.model)) {
        _core.eventChannelUnsafe.off(`/command/stdout/${tabUUID}/${props.model.execUUID}`, state.streamingConsumer);
      }

      return {
        alreadyListen: false,
        isResultRendered: true
      };
    } else {
      return state;
    }
  }

  onRender(assertHasContent) {
    if (this.props.onRender && !this.props.isBeingRerun && !(0, _BlockModel.hasBeenRerun)(this.props.model)) {
      // we don't want reruns to trigger any scrolling behavior
      this.props.onRender();
    }

    this.setState({
      assertHasContent
    });
  }

  hasStreamingOutput() {
    return this.state.nStreamingOutputs > 0;
  }

  outputWillOverflow() {
    // RadioTable currently uses the Dropdown component that will overflow
    return (0, _BlockModel.isWithCompleteEvent)(this.props.model) && (0, _core.isRadioTable)(this.props.model.response);
  }

  stream() {
    if (this.hasStreamingOutput()) {
      if (this.streamingOutput.every(_ => typeof _ === 'string')) {
        const combined = this.streamingOutput.join('');
        return _react.default.createElement("div", {
          className: "repl-result-like result-vertical",
          "data-stream": true
        }, _react.default.createElement(_react.default.Suspense, {
          fallback: _react.default.createElement("div", null)
        }, _react.default.createElement(Ansi, null, combined)));
      }

      return _react.default.createElement("div", {
        className: "repl-result-like result-vertical",
        "data-stream": true
      }, this.streamingOutput.map((part, idx) => _react.default.createElement(_react.default.Suspense, {
        fallback: _react.default.createElement("div", null),
        key: idx
      }, _react.default.createElement(_Scalar.default, {
        tab: this.props.tab,
        execUUID: (0, _BlockModel.hasUUID)(this.props.model) && this.props.model.execUUID,
        response: part,
        isPartOfMiniSplit: this.props.isPartOfMiniSplit,
        isWidthConstrained: this.props.isWidthConstrained,
        willChangeSize: this.props.willChangeSize,
        willUpdateCommand: this._willUpdateCommand,
        onRender: this._onRender
      }))));
    }
  }

  result() {
    if ((0, _BlockModel.isProcessing)(this.props.model)) {
      return _react.default.createElement("div", {
        className: "repl-result"
      });
    } else if ((0, _BlockModel.isEmpty)(this.props.model)) {
      // no result to display for these cases
      return _react.default.createElement(_react.default.Fragment, null);
    } else {
      const statusCode = (0, _BlockModel.isOops)(this.props.model) ? (0, _core.isCodedError)(this.props.model.response) ? this.props.model.response.code || this.props.model.response.statusCode : 500 : (0, _BlockModel.isFinished)(this.props.model) ? 0 : undefined;
      return _react.default.createElement("div", {
        className: 'repl-result' + ((0, _BlockModel.isOops)(this.props.model) ? ' oops' : '') + ((0, _BlockModel.isWithCompleteEvent)(this.props.model) && (0, _core.isMixedResponse)(this.props.model.response) ? ' flex-column' : '') + (this.outputWillOverflow() ? ' overflow-visible' : ''),
        "data-status-code": statusCode
      }, (0, _BlockModel.isCancelled)(this.props.model) ? _react.default.createElement(_react.default.Fragment, null) : _react.default.createElement(_react.default.Suspense, {
        fallback: _react.default.createElement("div", null)
      }, _react.default.createElement(_Scalar.default, {
        tab: this.props.tab,
        execUUID: (0, _BlockModel.hasUUID)(this.props.model) && this.props.model.execUUID,
        response: this.props.model.response,
        completeEvent: this.props.model.completeEvent,
        isPartOfMiniSplit: this.props.isPartOfMiniSplit,
        isWidthConstrained: this.props.isWidthConstrained,
        willChangeSize: this.props.willChangeSize,
        willFocusBlock: this.props.willFocusBlock,
        willRemove: this._willRemove,
        willUpdateCommand: this._willUpdateCommand,
        onRender: this._onRender
      })));
    }
  }

  cursor() {
    /* if (isProcessing(this.props.model)) {
      return (
        <div className="repl-result-spinner">
          <div className="repl-result-spinner-inner"></div>
        </div>
      )
    } */
  }

  isShowingSomethingInTerminal(block) {
    if ((0, _BlockModel.isProcessing)(this.props.model)) {
      return this.hasStreamingOutput();
    } else if ((0, _BlockModel.isFinished)(block) && !(0, _BlockModel.isCancelled)(block) && !(0, _BlockModel.isEmpty)(block)) {
      const {
        response
      } = block;
      return (0, _BlockModel.isOops)(block) || (0, _core.isAbortableResponse)(response) || (0, _core.isMultiModalResponse)(response) || (0, _core.isNavResponse)(response) || (0, _core.isCommentaryResponse)(response) || (0, _core.isTabLayoutModificationResponse)(response) || (0, _core.isReactResponse)(response) || (0, _core.isHTML)(response) || (0, _core.isMarkdownResponse)(response) || typeof response === 'string' && response.length > 0 || typeof response === 'number' || (0, _core.isTable)(response) || (0, _core.isMixedResponse)(response) || (0, _core.isXtermResponse)(response) && response.rows && response.rows.length !== 0 || this.hasStreamingOutput();
    } else {
      return false;
    }
  }

  ok(hasContent) {
    if ((0, _BlockModel.isOk)(this.props.model)) {
      if (hasContent) {
        return _react.default.createElement("div", {
          className: "ok"
        });
      } else {
        return _react.default.createElement("div", {
          className: "ok"
        }, strings('ok'));
      }
    }
  }

  ctx()
  /* insideBrackets: React.ReactNode = this.props.displayedIdx || this.props.idx + 1 */
  {
    return _react.default.createElement(_context.default.Consumer, null, config => !config.noPromptContext && _react.default.createElement("span", {
      className: "repl-context",
      onClick: this.props.willFocusBlock,
      "data-input-count": this.props.idx,
      "data-custom-prompt": !!config.prompt || undefined
    }));
  }
  /** For output-only blocks, render the Block Actions */


  actions() {
    if ((0, _BlockModel.isOutputOnly)(this.props.model)) {
      return _react.default.createElement(_Actions.default, Object.assign({}, this.props, {
        command: (0, _BlockModel.hasCommand)(this.props.model) && this.props.model.command
      }));
    }
  }

  render() {
    const hasContent = this.state.assertHasContent !== undefined ? this.state.assertHasContent : this.isShowingSomethingInTerminal(this.props.model);
    return _react.default.createElement("div", {
      className: 'repl-output ' + (hasContent ? ' repl-result-has-content' : '')
    }, !this.props.isPartOfMiniSplit && hasContent && this.ctx(), _react.default.createElement("div", {
      className: "result-vertical"
    }, this.stream(), this.result(), this.cursor(), this.ok(hasContent)), this.actions());
  }

}

exports.default = Output;