"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = cssForStatus;

var _TrafficLight = _interopRequireDefault(require("./TrafficLight"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

/*
 * Copyright 2018 The Kubernetes Authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * Decorate certain values specially
 *
 */
const map = {
  // helm lifecycle
  UNKNOWN: '',
  DEPLOYED: _TrafficLight.default.Green,
  DELETED: '',
  SUPERSEDED: _TrafficLight.default.Yellow,
  FAILED: _TrafficLight.default.Red,
  DELETING: _TrafficLight.default.Yellow,
  // kui manufactured; see formatTable.ts withNotFounds()
  Offline: _TrafficLight.default.Red,
  // pod lifecycle
  'Init:0/1': _TrafficLight.default.Yellow,
  PodScheduled: _TrafficLight.default.Yellow,
  PodInitializing: _TrafficLight.default.Yellow,
  Initialized: _TrafficLight.default.Yellow,
  Terminating: _TrafficLight.default.Yellow,
  ImagePullBackOff: _TrafficLight.default.Red,
  ErrImagePull: _TrafficLight.default.Red,
  Error: _TrafficLight.default.Red,
  UnexpectedAdmissionError: _TrafficLight.default.Red,
  OOMKilled: _TrafficLight.default.Red,
  // 1/0 status
  1: _TrafficLight.default.Green,
  0: _TrafficLight.default.Red,
  '<none>': _TrafficLight.default.Yellow,
  // kube lifecycle
  CrashLoopBackOff: _TrafficLight.default.Red,
  Failed: _TrafficLight.default.Red,
  PropagationFailed: _TrafficLight.default.Red,
  fail: _TrafficLight.default.Red,
  Fail: _TrafficLight.default.Red,
  Running: _TrafficLight.default.Green,
  Pending: _TrafficLight.default.Yellow,
  ok: _TrafficLight.default.Green,
  Ok: _TrafficLight.default.Green,
  Success: _TrafficLight.default.Green,
  Succeeded: _TrafficLight.default.Blue,
  Completed: _TrafficLight.default.Gray,
  Unknown: '',
  Propagated: _TrafficLight.default.Green,
  Subscribed: _TrafficLight.default.Green,
  // AWS events
  Ready: _TrafficLight.default.Green,
  ProvisionedSuccessfully: _TrafficLight.default.Green,
  // kube events
  Active: _TrafficLight.default.Green,
  Online: _TrafficLight.default.Green,
  NodeReady: _TrafficLight.default.Green,
  Pulled: _TrafficLight.default.Green,
  Rebooted: _TrafficLight.default.Green,
  Started: _TrafficLight.default.Green,
  Created: _TrafficLight.default.Green,
  Scheduled: _TrafficLight.default.Green,
  SuccessfulCreate: _TrafficLight.default.Green,
  SuccessfulMountVol: _TrafficLight.default.Green,
  ContainerCreating: _TrafficLight.default.Yellow,
  Starting: _TrafficLight.default.Yellow,
  NodeNotReady: _TrafficLight.default.Yellow,
  Killing: _TrafficLight.default.Red,
  Deleting: _TrafficLight.default.Red,
  Pulling: _TrafficLight.default.Yellow,
  BackOff: _TrafficLight.default.Yellow,
  Unhealthy: _TrafficLight.default.Red,
  FailedScheduling: _TrafficLight.default.Red,
  FailedKillPod: _TrafficLight.default.Red
};
/** Given the table cell for a status attribute, return a corresponding traffic light color */

function cssForStatus(cell) {
  return cell && map[cell.value] || _TrafficLight.default.Gray;
}