"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = renderBody;

var _core = require("@kui-shell/core");

var _react = _interopRequireDefault(require("react"));

var _reactTable = require("@patternfly/react-table");

var _reactCore = require("@patternfly/react-core");

var _reactIcons = require("@patternfly/react-icons");

var _TableCell = _interopRequireDefault(require("./TableCell"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

/*
 * Copyright 2020 The Kubernetes Authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
const strings = (0, _core.i18n)('plugin-client-common');
/**
 * Render the TableBody part
 *
 * @param offset offset into the kuiTable.body model
 *
 */

function renderBody(kuiTable, justUpdated, // rowKey index
tab, repl, offset) {
  const emptyState = () => {
    return _react.default.createElement(_reactTable.Tr, null, _react.default.createElement(_reactTable.Td, {
      "data-is-empty": true,
      colSpan: kuiTable.header ? kuiTable.header.attributes.length + 1 : 0
    }, _react.default.createElement(_reactCore.Bullseye, null, _react.default.createElement(_reactCore.EmptyState, {
      variant: _reactCore.EmptyStateVariant.small
    }, _react.default.createElement(_reactCore.EmptyStateIcon, {
      icon: _reactIcons.SearchIcon
    }), _react.default.createElement(_reactCore.Title, {
      headingLevel: "h2",
      size: "lg"
    }, strings('No results found'))))));
  };

  return _react.default.createElement(_reactTable.Tbody, null, kuiTable.body.length === 0 ? emptyState() : kuiTable.body.map((kuiRow, ridx) => {
    const updated = justUpdated[kuiRow.rowKey || kuiRow.name];
    const cell = (0, _TableCell.default)(kuiTable, kuiRow, updated, tab, repl);
    const key = kuiRow.key || (kuiTable.header ? kuiTable.header.key || kuiTable.header.name : undefined);
    return _react.default.createElement(_reactTable.Tr, {
      key: ridx,
      "data-row-key": kuiRow.rowKey,
      "data-name": kuiTable.body[offset + ridx].name
    }, cell(key, kuiRow.name, undefined, kuiRow.outerCSS, kuiRow.css, kuiRow.onclick, 0), kuiRow.attributes && kuiRow.attributes.map((attr, idx) => cell(attr.key, attr.value, attr.tag, attr.outerCSS, attr.css, attr.onclick, idx + 1)));
  }));
}