"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getBreadcrumbsFromTable = getBreadcrumbsFromTable;
exports.default = void 0;

var _core = require("@kui-shell/core");

var _react = _interopRequireDefault(require("react"));

var _reactTable = require("@patternfly/react-table");

var _sort = _interopRequireDefault(require("./sort"));

var _Card = _interopRequireDefault(require("../../spi/Card"));

var _Timeline = _interopRequireDefault(require("./Timeline"));

var _TableBody = _interopRequireDefault(require("./TableBody"));

var _TableHeader = _interopRequireDefault(require("./TableHeader"));

var _SequenceDiagram = _interopRequireDefault(require("./SequenceDiagram"));

var _Histogram = _interopRequireDefault(require("./Histogram"));

var _kuiHeaderFromBody = _interopRequireDefault(require("./kuiHeaderFromBody"));

var _Toolbar = _interopRequireDefault(require("./Toolbar"));

var _Grid = _interopRequireWildcard(require("./Grid"));

function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }

function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

/*
 * Copyright 2020 The Kubernetes Authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
const strings = (0, _core.i18n)('plugin-client-common');

function getBreadcrumbsFromTable(response, prefixBreadcrumbs) {
  const titleBreadcrumb = response.title ? [{
    label: response.title,
    className: 'kui--data-table-title kui--sidecar-kind',
    isCurrentPage: true
  }] : [];

  const _responseCrumbs = typeof response.breadcrumbs === 'function' ? response.breadcrumbs() : response.breadcrumbs;

  const responseCrumbs = !_responseCrumbs ? [] : _responseCrumbs.map(_ => Object.assign({}, _, {
    className: 'kui--secondary-breadcrumb'
  }));
  const breadcrumbs = (prefixBreadcrumbs || []).concat(responseCrumbs).concat(titleBreadcrumb);
  return breadcrumbs;
}
/**
 * A DataTable/Pagination pair
 *
 */


class PaginatedTable extends _react.default.PureComponent {
  constructor(props) {
    super(props);
    this.defaultPageSize = props.pageSize || 10;
    /** Manage the --kui--table-max-height css variable */

    if (!PaginatedTable.oneTimeInit) {
      PaginatedTable.oneTimeInit = true;

      const adjustMaxHeight = () => {
        const maxHeight = ~~(0.66 * document.body.getBoundingClientRect().height);
        document.body.style.setProperty('--kui--table-max-height', `${maxHeight}px`);
      };

      adjustMaxHeight();
      window.addEventListener('resize', adjustMaxHeight);
    }

    this.state = PaginatedTable.getDerivedStateFromProps(props);
  }

  static getDerivedStateFromProps(props, currentState) {
    try {
      const {
        header = (0, _kuiHeaderFromBody.default)(props.response.body),
        body,
        footer,
        defaultPresentation
      } = props.response;
      props.response.header = header;

      if (props.config && props.config.drilldownTo) {
        props.response.drilldownTo = props.config.drilldownTo;
      }

      const asGrid = (!defaultPresentation || defaultPresentation === 'grid') && props.asGrid && (0, _Grid.findGridableColumn)(props.response) >= 0 || defaultPresentation === 'grid';
      const asSequence = !asGrid && PaginatedTable.hasSequenceButton(props) && props.response.body.length > 1 || defaultPresentation === 'sequence-diagram';
      const defaults = {
        page: 1,
        pageSize: 10,
        asTimeline: false
      };
      const newState = {
        body,
        asGrid,
        footer,
        header,
        asSequence,
        asHistogram: defaultPresentation === 'histogram',
        activeSortIdx: -1,
        activeSortDir: undefined,
        response: props.response,
        pageSize: props.pageSize || defaults.pageSize
      };

      if (!currentState) {
        // new instance of this component
        return Object.assign(defaults, newState);
      } else if (newState.response !== currentState.response) {
        // user made changes to the existing props instance
        return Object.assign(defaults, currentState, newState);
      } else {
        // different props
        return Object.assign(defaults, newState, currentState);
      }
    } catch (err) {
      console.error('Internal error preparing PaginatedTable', err);
    }
  }

  topToolbar(lightweightTables = false) {
    // 1) If we started as a table, and are now a grid, then show
    // "Status Grid", otherwise:
    // 2) only for client w/o disableTableTitle, show a breadcrumb
    const breadcrumbs = !lightweightTables && !this.props.asGrid && this.state.asGrid ? [{
      label: strings('Status Grid')
    }] : !this.props.asGrid && !this.props.title ? [] : getBreadcrumbsFromTable(this.props.response, this.props.prefixBreadcrumbs); // ... except when we're displaying asGrid by default

    if (!(!lightweightTables && !this.props.asGrid && this.state.asGrid)) {
      const nRows = this.props.response.body.length;

      if (!lightweightTables && breadcrumbs.length > 0 && (nRows > 1 || (0, _core.isWatchable)(this.props.response))) {
        breadcrumbs.push({
          label: nRows === 1 ? strings('nRows1') : strings('nRows', nRows),
          className: 'kui--secondary-breadcrumb kui--nrows-breadcrumb'
        });
      }
    }

    if (breadcrumbs.length > 0) {
      return _react.default.createElement(_Toolbar.default, {
        className: "kui--data-table-toolbar-top",
        breadcrumbs: breadcrumbs.length > 0 && breadcrumbs,
        repl: this.props.repl
      });
    }
  }

  isPaginated() {
    return false;
    /**
     * return (
     * this.props.paginate !== undefined &&
     * this.props.paginate !== false &&
     * !this.state.asGrid &&
     * (this.props.paginate === true || this.state.rows.length > this.props.paginate)
     * )
     */
  }

  hasFooterLines() {
    return this.state.footer && this.state.footer.length > 0;
  }

  footerLines() {
    const nRows = this.props.isPartOfMiniSplit ? -1 : -6;
    return this.state.footer ? this.state.footer.slice(nRows) : undefined;
  }

  static hasSequenceButton(props) {
    return (0, _core.isTableWithTimestamp)(props.response);
  }

  static hasHistogramButton(props) {
    return (0, _core.isTableWithCount)(props.response);
  } // eslint-disable-next-line @typescript-eslint/no-unused-vars


  bottomToolbar(lightweightTables = false) {
    const gridableColumn = (0, _Grid.findGridableColumn)(this.props.response);
    const hasSequenceButton = PaginatedTable.hasSequenceButton(this.props);
    const hasHistogramButton = PaginatedTable.hasHistogramButton(this.props);
    const hasTimelineButton = false; // disabled for now, see https://github.com/IBM/kui/issues/5864

    const needsBottomToolbar = this.caption() || this.isPaginated() || gridableColumn >= 0 && (this.props.response.body.length > 1 || (0, _core.isWatchable)(this.props.response)) || (0, _core.isTableWithTimestamp)(this.props.response) || (0, _core.isTableWithCount)(this.props.response);
    return _react.default.createElement(_react.default.Fragment, null, this.hasFooterLines() && _react.default.createElement(_Toolbar.default, {
      stream: this.footerLines(),
      repl: this.props.repl
    }), this.props.toolbars && needsBottomToolbar && _react.default.createElement(_Toolbar.default, {
      className: "kui--data-table-toolbar-bottom",
      repl: this.props.repl,
      asGrid: this.state.asGrid,
      gridableColumn: gridableColumn,
      setAsGrid: asGrid => {
        this.setState({
          asGrid
        });

        if (asGrid) {
          this.props.response.defaultPresentation = 'grid';
        }
      },
      paginate: this.isPaginated(),
      setPage: page => this.setState({
        page
      }),
      page: this.state.page,
      totalItems: this.state.body.length,
      pageSize: this.state.pageSize,
      hasSequenceButton: hasSequenceButton,
      asSequence: this.state.asSequence,
      setAsSequence: asSequence => {
        this.setState({
          asSequence
        });

        if (asSequence) {
          this.props.response.defaultPresentation = 'sequence-diagram';
        }
      },
      hasHistogramButton: hasHistogramButton,
      asHistogram: this.state.asHistogram,
      setAsHistogram: asHistogram => {
        this.setState({
          asHistogram
        });

        if (asHistogram) {
          this.props.response.defaultPresentation = 'histogram';
        }
      },
      hasTimelineButton: hasTimelineButton,
      asTimeline: this.state.asTimeline,
      caption: this.caption() || undefined,
      setAsTimeline: asTimeline => {
        this.setState({
          asTimeline
        });

        if (asTimeline) {
          this.props.response.defaultPresentation = 'timeline';
        }
      }
    }));
  }
  /** E.g. last updated time for live tables */
  // eslint-disable-next-line @typescript-eslint/no-empty-function


  caption() {}

  grid(visibleRows) {
    return _react.default.createElement(_Grid.default, {
      tab: this.props.tab,
      repl: this.props.repl,
      response: this.props.response,
      visibleRows: visibleRows,
      justUpdated: this.justUpdatedMap()
    });
  }

  justUpdatedMap() {
    return this.state.body.reduce(M => {
      // FIXME if (_.justUpdated) M[_.rowKey] = true
      return M;
    }, {});
  }

  table() {
    const {
      tab,
      repl
    } = this.props;
    const {
      page
    } = this.state;
    const response = this.props.response;
    const {
      body,
      header
    } = this.state;
    const variant = 'compact';
    /* this.props.response.style === TableStyle.Heavy
      ? null
      : this.props.response.style === undefined || this.props.response.style === TableStyle.Medium
      ? null
      : 'compact' */

    const isSortable = response.body.length > 1;

    const onSort = (key, cidx, clickColIdx, clickDir) => {
      response.body.sort((a, b) => (0, _sort.default)(a, b, key, cidx, clickDir));
      this.setState({
        body,
        activeSortDir: clickDir,
        activeSortIdx: clickColIdx
      });
    };

    const dataTable = (visibleRows, offset = 0) => _react.default.createElement("div", {
      className: 'kui--data-table-container' + (this.props.title ? ' kui--data-table-container-with-toolbars' : '') + (this.props.response.title || this.props.response.breadcrumbs ? ' kui--data-table-container-with-title' : '') + (isSortable ? ' kui--data-table-sortable' : ''),
      "data-is-empty": response.body.length === 0
    }, _react.default.createElement(_reactTable.TableComposable, {
      className: "kui--table-like-wrapper",
      variant: variant,
      isStickyHeader: true,
      gridBreakPoint: ""
    }, header && (0, _TableHeader.default)(header, isSortable, this.state.activeSortIdx, this.state.activeSortDir, onSort.bind(this)), (0, _TableBody.default)(response, this.justUpdatedMap(), tab, repl, offset)));

    const paginated = this.isPaginated();
    return dataTable(!paginated ? body : body.slice((page - 1) * this.state.pageSize, page * this.state.pageSize), !paginated ? 0 : (page - 1) * this.state.pageSize);
  }

  sequence() {
    return _react.default.createElement(_SequenceDiagram.default, Object.assign({}, this.props, {
      isWatching: this.isWatching()
    }));
  }

  histogram() {
    return _react.default.createElement(_Histogram.default, Object.assign({}, this.props, {
      isWatching: this.isWatching()
    }));
  }

  timeline() {
    return _react.default.createElement(_Timeline.default, Object.assign({}, this.props));
  }
  /** @return whether the table is currently "live", and responding to updates from the controller */


  isWatching() {
    return false;
  }

  content(includeToolbars = false, lightweightTables = false) {
    if (this.props.onRender) {
      this.props.onRender(true);
    }

    return _react.default.createElement(_react.default.Fragment, null, includeToolbars && this.topToolbar(lightweightTables), this.state.asGrid ? this.grid(this.state.body) : this.state.asSequence ? this.sequence() : this.state.asHistogram ? this.histogram() : this.state.asTimeline ? this.timeline() : this.table(), includeToolbars && this.bottomToolbar(lightweightTables));
  }

  dataAttrs() {
    return {};
  }

  render() {
    if (!this.state) {
      return _react.default.createElement("div", {
        className: "oops"
      }, "Internal Error");
    } else {
      const lightweightTables = this.props.response.style === _core.TableStyle.Light;
      const className = 'kui--data-table-wrapper' + (this.state.asGrid ? ' kui--data-table-as-grid' : '') + (this.state.asSequence ? ' kui--data-table-as-sequence' : '') + (this.state.asTimeline ? ' kui--data-table-as-timeline' : '') + (lightweightTables ? ' kui--data-table-wrapper-lightweight flex-fill' : '');
      return _react.default.createElement("div", Object.assign({
        className: className
      }, this.dataAttrs()), _react.default.createElement("div", {
        className: "kui--screenshotable"
      }, lightweightTables ? this.content(true, true) : _react.default.createElement(_Card.default, {
        header: this.topToolbar(),
        footer: this.bottomToolbar(),
        className: "kui--table-card"
      }, this.content())));
    }
  }

}
/**
 * A lock that governs the --kui--table-max-height
 * initialization. See https://github.com/IBM/kui/issues/5206
 *
 */


exports.default = PaginatedTable;
PaginatedTable.oneTimeInit = false;