"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _react = _interopRequireDefault(require("react"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

/*
 * Copyright 2020 The Kubernetes Authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/** for html pre-rendered dom content */
class HTMLDom extends _react.default.PureComponent {
  constructor(props) {
    super(props);
    this.state = {
      isRendered: false,
      dom: undefined
    };
  }

  static getDerivedStateFromProps(props, state) {
    if (state.dom && !state.isRendered) {
      state.dom.appendChild(props.content);
      return {
        isRendered: true
      };
    } else {
      return state;
    }
  }

  render() {
    return !this.props.content ? _react.default.createElement(_react.default.Fragment, null) : _react.default.createElement("div", {
      className: 'padding-content scrollable scrollable-auto page-content' + (this.props.className ? ` ${this.props.className}` : ''),
      style: {
        display: 'flex',
        flex: 1
      }
    }, _react.default.createElement("div", {
      className: "kui--ignore-if-empty",
      ref: dom => this.setState({
        dom
      })
    }));
  }

}

exports.default = HTMLDom;