"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _react = _interopRequireDefault(require("react"));

var _core = require("@kui-shell/core");

var _Icons = _interopRequireDefault(require("../../spi/Icons"));

var _Tooltip = _interopRequireDefault(require("../../spi/Tooltip"));

var _ctrlOrMeta = _interopRequireDefault(require("./ctrlOrMeta"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

/*
 * Copyright 2020 The Kubernetes Authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
const strings = (0, _core.i18n)('plugin-client-common');

class NewTabButton extends _react.default.PureComponent {
  constructor() {
    super(...arguments);
    this.ref = _react.default.createRef();

    this._onNewTab = () => this.props.onNewTab();
  }

  tooltip() {
    return _react.default.createElement(_Tooltip.default, {
      reference: this.ref,
      position: "bottom"
    }, strings('New Tab', (0, _core.inBrowser)() ? '' : (0, _ctrlOrMeta.default)('T')));
  }

  button() {
    return _react.default.createElement("a", {
      href: "#",
      className: "kui--tab-navigatable kui--top-tab-button kui-new-tab",
      id: "new-tab-button",
      "aria-label": "Open a new tab",
      tabIndex: 0,
      ref: this.ref,
      onClick: this._onNewTab
    }, _react.default.createElement(_Icons.default, {
      icon: "Add",
      className: "kui-new-tab__plus"
    }));
  }

  render() {
    return _react.default.createElement(_react.default.Fragment, null, this.button(), this.tooltip());
  }

}

exports.default = NewTabButton;