import _objectWithoutPropertiesLoose from "@babel/runtime/helpers/esm/objectWithoutPropertiesLoose";
import _extends from "@babel/runtime/helpers/esm/extends";
import * as React from 'react';
import PropTypes from 'prop-types';
import clsx from 'clsx';
import { chainPropTypes } from '@material-ui/utils';
import withStyles from '../styles/withStyles';
import TableContext from './TableContext';
export const styles = theme => ({
  /* Styles applied to the root element. */
  root: {
    display: 'table',
    width: '100%',
    borderCollapse: 'collapse',
    borderSpacing: 0,
    '& caption': _extends({}, theme.typography.body2, {
      padding: theme.spacing(2),
      color: theme.palette.text.secondary,
      textAlign: 'left',
      captionSide: 'bottom'
    })
  },

  /* Styles applied to the root element if `stickyHeader={true}`. */
  stickyHeader: {
    borderCollapse: 'separate'
  }
});
const defaultComponent = 'table';
const Table = /*#__PURE__*/React.forwardRef(function Table(props, ref) {
  const {
    classes,
    className,
    component: Component = defaultComponent,
    padding = 'normal',
    size = 'medium',
    stickyHeader = false
  } = props,
        other = _objectWithoutPropertiesLoose(props, ["classes", "className", "component", "padding", "size", "stickyHeader"]);

  const table = React.useMemo(() => ({
    padding,
    size,
    stickyHeader
  }), [padding, size, stickyHeader]);
  return /*#__PURE__*/React.createElement(TableContext.Provider, {
    value: table
  }, /*#__PURE__*/React.createElement(Component, _extends({
    role: Component === defaultComponent ? null : 'table',
    ref: ref,
    className: clsx(classes.root, className, stickyHeader && classes.stickyHeader)
  }, other)));
});
process.env.NODE_ENV !== "production" ? Table.propTypes = {
  /**
   * The content of the table, normally `TableHead` and `TableBody`.
   */
  children: PropTypes.node.isRequired,

  /**
   * Override or extend the styles applied to the component.
   * See [CSS API](#css) below for more details.
   */
  classes: PropTypes.object.isRequired,

  /**
   * @ignore
   */
  className: PropTypes.string,

  /**
   * The component used for the root node.
   * Either a string to use a HTML element or a component.
   */
  component: PropTypes
  /* @typescript-to-proptypes-ignore */
  .elementType,

  /**
   * Allows TableCells to inherit padding of the Table.
   * `default` is deprecated, use `normal` instead.
   */
  padding: chainPropTypes(PropTypes.oneOf(['normal', 'checkbox', 'none', 'default']), props => {
    if (props.padding === 'default') {
      return new Error('Material-UI: padding="default" was renamed to padding="normal" for consistency.');
    }

    return null;
  }),

  /**
   * Allows TableCells to inherit size of the Table.
   */
  size: PropTypes.oneOf(['small', 'medium']),

  /**
   * Set the header sticky.
   *
   * ⚠️ It doesn't work with IE 11.
   */
  stickyHeader: PropTypes.bool
} : void 0;
export default withStyles(styles, {
  name: 'MuiTable'
})(Table);