/*
 * Copyright 2020 The Kubernetes Authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
import { Common, CLI, ReplExpect, Selectors } from '@kui-shell/test';
describe(`watch directory listing ${process.env.MOCHA_RUN_TARGET || ''}`, function () {
    before(Common.before(this));
    after(Common.after(this));
    const names = ['ls1foo', 'ls2foo'];
    it('should watch ls /tmp', () => CLI.command(`watch ls /tmp`, this.app)
        .then(ReplExpect.ok)
        .then((res) => __awaiter(this, void 0, void 0, function* () {
        const fileName = names[0];
        yield CLI.command(`touch /tmp/${fileName}`, this.app).then(ReplExpect.ok);
        let iter = 0;
        yield this.app.client.waitUntil(() => __awaiter(this, void 0, void 0, function* () {
            const texts = yield this.app.client.$(Selectors.OUTPUT_N(res.count)).then(_ => _.getText());
            if (++iter > 5) {
                console.error(`still waiting for actualText=${texts} expectedText=${fileName}`);
            }
            return texts.includes(fileName);
        }));
    }))
        .catch(Common.oops(this)));
    it('should watch ls -l /tmp', () => CLI.command(`watch ls -l /tmp`, this.app)
        .then((res) => __awaiter(this, void 0, void 0, function* () {
        yield ReplExpect.okWith(names[0])(res);
        const fileName = names[1];
        yield CLI.command(`touch /tmp/${fileName}`, this.app).then(ReplExpect.ok);
        let iter = 0;
        yield this.app.client.waitUntil(() => __awaiter(this, void 0, void 0, function* () {
            if (++iter > 5) {
                console.error(`still waiting for table to have expectedText=${fileName}`);
            }
            return this.app.client.$(`${Selectors.LIST_RESULT_BY_N_FOR_NAME(res.count, fileName)}`).then(() => true);
        }));
    }))
        .catch(Common.oops(this)));
    names.forEach(_ => {
        it('should remove the created file', () => CLI.command(`rm ${_}`, this.app)
            .then(ReplExpect.ok)
            .catch(Common.oops(this)));
    });
});
//# sourceMappingURL=watch-ls.js.map