import { Arguments } from '@kui-shell/core';
import { DirEntry, VFS } from '.';
/**
 * ls delegate
 *
 */
export declare function ls(...parameters: Parameters<VFS['ls']>): Promise<DirEntry[]>;
/**
 * cp delegate
 *
 */
export declare function cp(opts: Pick<Arguments, 'command' | 'REPL' | 'parsedOptions' | 'execOptions'>, srcFilepaths: string[], dstFilepath: string): ReturnType<VFS['cp']>;
/**
 * rm delegate
 *
 */
export declare function rm(...parameters: Parameters<VFS['rm']>): ReturnType<VFS['rm']>;
/**
 * fstat delegate
 *
 */
export declare function fstat(...parameters: Parameters<VFS['fstat']>): ReturnType<VFS['fstat']>;
/**
 * fwrite delegate
 *
 */
export declare function fwrite(...parameters: Parameters<VFS['fwrite']>): ReturnType<VFS['fwrite']>;
/**
 * fslice delegate
 *
 */
export declare function fslice(filepath: string, offsetAsProvided: number, length: number, unit?: 'bytes' | 'lines', end?: number): ReturnType<VFS['fslice']>;
/**
 * mkdir delegate
 *
 */
export declare function mkdir(...parameters: Parameters<VFS['mkdir']>): ReturnType<VFS['mkdir']>;
/**
 * rmdir delegate
 *
 */
export declare function rmdir(...parameters: Parameters<VFS['rmdir']>): ReturnType<VFS['rmdir']>;
