/// <reference types="node" />
import { Stats } from 'fs';
import { VFS } from '../vfs';
import { Arguments, ParsedOptions } from '@kui-shell/core';
/** Just the bits of fs.Stats that we need */
declare type PartialStats = Pick<Stats, 'size' | 'mtimeMs' | 'uid' | 'gid' | 'mode'>;
interface BaseStats {
    name: string;
    path: string;
    stats: PartialStats;
}
interface DirentStats {
    isFile: boolean;
    isDirectory: boolean;
    isSymbolicLink: boolean;
    isSpecial: boolean;
    isExecutable: boolean;
    permissions: string;
    username: string;
    mount: Pick<VFS, 'isLocal' | 'tags'>;
}
export interface GlobStats extends BaseStats {
    nameForDisplay: string;
    dirent: DirentStats;
}
export interface KuiGlobOptions extends ParsedOptions {
    a?: boolean;
    all?: boolean;
    d?: boolean;
    l?: boolean;
    C?: boolean;
}
/**
 * Kui command for globbing readdir
 *
 */
export declare function kuiglob({ tab, argvNoOptions, parsedOptions }: Pick<Arguments<KuiGlobOptions>, 'tab' | 'argvNoOptions' | 'parsedOptions'>): Promise<GlobStats[]>;
export {};
