"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.mkTemp = mkTemp;
exports.default = void 0;

/*
 * Copyright 2020 The Kubernetes Authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
var __awaiter = void 0 && (void 0).__awaiter || function (thisArg, _arguments, P, generator) {
  function adopt(value) {
    return value instanceof P ? value : new P(function (resolve) {
      resolve(value);
    });
  }

  return new (P || (P = Promise))(function (resolve, reject) {
    function fulfilled(value) {
      try {
        step(generator.next(value));
      } catch (e) {
        reject(e);
      }
    }

    function rejected(value) {
      try {
        step(generator["throw"](value));
      } catch (e) {
        reject(e);
      }
    }

    function step(result) {
      result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected);
    }

    step((generator = generator.apply(thisArg, _arguments || [])).next());
  });
};

function mkTemp() {
  return __awaiter(this, void 0, void 0, function* () {
    const {
      file: tmpFile
    } = yield Promise.resolve().then(() => require('tmp'));
    return new Promise((resolve, reject) => {
      tmpFile({
        prefix: 'kui-'
      }, (err, tmp) => {
        if (err) {
          reject(err);
        } else {
          resolve({
            mode: 'raw',
            content: tmp
          });
        }
      });
    });
  });
}

function rmTemp(args) {
  return __awaiter(this, void 0, void 0, function* () {
    const {
      unlink
    } = yield Promise.resolve().then(() => require('fs'));
    return new Promise((resolve, reject) => {
      unlink(args.argvNoOptions[1], err => {
        if (err) {
          reject(err);
        } else {
          resolve(true);
        }
      });
    });
  });
}
/**
 * Register command handlers
 *
 */


var _default = registrar => {
  registrar.listen('/mkTemp', mkTemp, {
    hidden: true,
    requiresLocal: true
  });
  registrar.listen('/rmTemp', rmTemp, {
    hidden: true,
    requiresLocal: true
  });
};

exports.default = _default;