"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _core = require("@kui-shell/core");

var _catchall = require("./catchall");

/*
 * Copyright 2019 The Kubernetes Authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
var __awaiter = void 0 && (void 0).__awaiter || function (thisArg, _arguments, P, generator) {
  function adopt(value) {
    return value instanceof P ? value : new P(function (resolve) {
      resolve(value);
    });
  }

  return new (P || (P = Promise))(function (resolve, reject) {
    function fulfilled(value) {
      try {
        step(generator.next(value));
      } catch (e) {
        reject(e);
      }
    }

    function rejected(value) {
      try {
        step(generator["throw"](value));
      } catch (e) {
        reject(e);
      }
    }

    function step(result) {
      result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected);
    }

    step((generator = generator.apply(thisArg, _arguments || [])).next());
  });
};

/**
 * export command
 *
 */
const exportCommand = args => __awaiter(void 0, void 0, void 0, function* () {
  const {
    command,
    tab,
    parsedOptions
  } = args;

  const curDic = _core.SymbolTable.read(tab);

  const toBeParsed = parsedOptions._[1];
  const arr = toBeParsed.split('=');
  const key = arr[0];
  const myArgs = Object.assign({}, args, {
    command: `${command}; echo -n $${key}`
  });
  const value = yield (0, _catchall.doExecWithStdoutViaPty)(myArgs);
  curDic[key] = value;

  _core.SymbolTable.write(tab, curDic);

  _core.eventBus.emitEnvUpdate(key, value);

  return true;
});

const usage = {
  command: 'export',
  strict: 'export',
  docs: 'Export a variable or function to the environment of all the child processes running in the current shell',
  required: [{
    name: 'key=value',
    docs: 'an assignment of key to value'
  }]
};
/**
 * Register command handlers
 *
 */

var _default = commandTree => {
  commandTree.listen('/export', exportCommand, {
    usage
  });
};

exports.default = _default;