/** the latest apiVersion */
export declare const apiVersion = "v2";
/** all known Theme apiVersions */
export declare type ThemeApiVersion = 'v1' | 'v2';
/** Properties that can be associated with <Kui/> component */
export interface ThemeProperties {
    components: 'patternfly';
    topTabNames: 'command' | 'fixed';
}
declare type Theme = ThemeProperties & {
    apiVersion?: ThemeApiVersion;
    name: string;
    description?: string;
    /** Source files */
    css: string | string[];
    /** Body attributes */
    attrs?: string[];
    /** Is this theme a light (e.g. black text on white background), or the inverse? */
    style: 'light' | 'dark';
    /** Present in a more terminal-like way (versus a more console-like way)? */
    lightweight?: boolean;
};
export default Theme;
export interface ThemeSet {
    /** import path prefix for all themes */
    plugin: string;
    /** theme definitions */
    themes: Theme[];
}
