import REPL from '../models/repl';
import TabState from '../models/tab-state';
export interface Tab extends HTMLDivElement {
    uuid: string;
    REPL: REPL;
    state: TabState;
    queueListener: EventListener;
    _kui_session: Promise<any>;
    onActivate(handler: (isActive: boolean) => void): void;
    offActivate(handler: (isActive: boolean) => void): void;
    addClass(cls: string): void;
    removeClass(cls: string): void;
    scrollToTop(): void;
    scrollToBottom(): void;
    getSize(): {
        width: number;
        height: number;
    };
    splitCount(): number;
    hasSideBySideTerminals(): boolean;
}
export declare function isTab(node: Element | Tab): node is Tab;
/**
 * Return the unique identifier for the given tab
 *
 */
export declare function getTabId(tab: Pick<Tab, 'uuid'>): string;
export declare function getTabIds(tab: Pick<Tab, 'uuid'>): string[];
export declare function getPrimaryTabId(tab: Pick<Tab, 'uuid'>): string;
export declare function isTopLevelTab(tab: Pick<Tab, 'uuid'>): boolean;
export declare const sameTab: (tab1: Tab, tab2: Tab) => boolean;
export declare const getCurrentTab: () => Tab;
export declare const getTab: (idx: Tab | number) => Tab;
/**
 * We need to find the instance of the Split that has a REPL controller
 *   - if given a `topLevelTab` that is already a Split, then we're "good to go"
 *   - if we are given an actual top-level tab (i.e. not a split), then we need to find the first Split child of that given tab
 *   - if we aren't given a tab as input, then we search from `document`
 *
 */
export declare function splitFor(topLevelTab: Tab): Tab;
/**
 * Execute the given command in the current (or given) tab.
 *
 * @param isInternalCallPath This is one plugin calling another
 * @param incognito Execute the command quietly but do not display the result in the Terminal
 *
 */
export declare function pexecInCurrentTab(command: string, topLevelTab?: Tab, isInternalCallpath?: boolean, incognito?: boolean): Promise<import("..").KResponse<any>>;
export default Tab;
