import { ReactElement } from 'react';
import { Breadcrumb } from '../../models/NavResponse';
import { MetadataBearing, MetadataNamedResource, Entity } from '../../models/entity';
export declare class Row {
    attributes?: Cell[];
    /** uniquely identifies this row in a given table; if not defined, we will use the name field as the row key */
    rowKey?: string;
    /** optional associated metadata for the corresponding resource */
    object?: Pick<MetadataNamedResource, 'metadata'> & {
        spec?: {
            selector?: {
                matchLabels?: Record<string, string>;
            };
        };
    };
    /** the key-value pair for the first column */
    key?: string;
    name: string;
    nameDom?: Element;
    /** does this row represent a recently deleted resource? */
    isDeleted?: boolean;
    type?: string;
    packageName?: string;
    prettyType?: string;
    fontawesome?: string;
    fontawesomeCSS?: string;
    setSelected?: () => void;
    setUnselected?: () => void;
    nameCss?: string | string[];
    prettyName?: string;
    fullName?: string;
    kind?: string;
    prettyKind?: string;
    status?: string;
    version?: string;
    prettyVersion?: string;
    beforeAttributes?: Cell[];
    rowCSS?: string | string[];
    onclickIdempotent?: boolean;
    onclickExec?: 'pexec' | 'qexec';
    onclick?: any;
    css?: string;
    outerCSS?: string;
    done?: boolean;
    constructor(row: Row);
}
export declare class Cell {
    value: string;
    valueDom?: ReactElement;
    css?: string;
    outerCSS?: string;
    onclick?: any;
    key?: string;
    fontawesome?: string[] | string;
    tag?: string;
    tagClass?: string;
    innerClassName?: string;
    className?: string;
    constructor(cell: Cell);
}
export interface Button {
    name: string;
    fontawesome: string;
    balloon?: string;
    onclick: (evt: Event) => void | string;
}
export declare enum TableStyle {
    Light = 0,
    Medium = 1,
    Heavy = 2
}
declare type PresentationStyle = 'table' | 'grid' | 'sequence-diagram' | 'timeline' | 'histogram';
export declare class Table<RowType extends Row = Row> {
    body: RowType[];
    /** Markdown cells? */
    markdown?: boolean;
    /** This field helps with watching/paginating */
    resourceVersion?: number | string;
    /**
     * Should drilldowns go to a side split, or to this split? Default:
     * `side-split`, unless the user chords the click with the Meta key
     * (which is Command on macOS, and Option on Linux/Windows
     */
    drilldownTo?: 'side-split' | 'this-split' | 'new-window';
    /** Default presentation? */
    defaultPresentation?: PresentationStyle;
    /** Allowed presentations? */
    allowedPresentations?: PresentationStyle[];
    /** Column index to be interpreted as a status column */
    statusColumnIdx?: number;
    /** Column index to be interpreted as a duration column */
    durationColumnIdx?: number;
    /** Column index to be interpreted as a time to initialize the computation */
    coldStartColumnIdx?: number;
    /** Column index to be interpreted as a start timestamp column */
    startColumnIdx?: number;
    /** Column index to be interpreted as a complete timestamp column */
    completeColumnIdx?: number;
    /** Coloring strategy for e.g. 'grid' and 'sequence-diagram' and 'histogram' */
    colorBy?: 'status' | 'duration' | 'default';
    style?: TableStyle;
    header?: RowType & {
        isSortable?: boolean;
    };
    footer?: string[];
    noSort?: boolean;
    title?: string;
    breadcrumbs?: Breadcrumb[] | (() => Breadcrumb[]);
    flexWrap?: number | boolean;
    tableCSS?: string;
    fontawesome?: string;
    fontawesomeCSS?: string;
    fontawesomeBalloon?: string;
    constructor(table: Table);
}
export declare function isTableWithTimestamp(table: Table): boolean;
export declare function isTableWithCount(table: Table): boolean;
export declare function isTable<C>(model: MetadataBearing<C> | Entity): model is Table;
/** Are the two Rows the same? */
export declare function sameRow(A: Row, B: Row): boolean;
export declare class Icon {
    fontawesome: string;
    onclick?: (evt: Event) => void;
    balloon?: string;
    balloonLength?: string;
    balloonPos?: string;
    constructor(icon: Icon);
}
export {};
