import { RawResponse } from '../models/entity';
import { Executor, ReplEval } from './types';
import { KResponse } from '../models/command';
import REPL from '../models/repl';
import { ExecOptions, ExecOptionsWithUUID } from '../models/execOptions';
import { CodedError } from '../models/errors';
import { Tab } from '../webapp/tab';
import { Block } from '../webapp/models/block';
export declare const setEvaluatorImpl: (impl: ReplEval) => void;
export declare const exec: (commandUntrimmed: string, execOptions?: ExecOptions) => Promise<KResponse<any> | CodedError<number>>;
/**
 * User hit enter in the REPL
 *
 * @param execUUID for command re-execution
 *
 */
export declare const doEval: (_tab: Tab, block: Block, command: string, execUUID?: string) => Promise<KResponse<any> | CodedError<number>>;
/**
 * If, while evaluating a command, it needs to evaluate a sub-command...
 *
 */
export declare const qexec: <T extends KResponse<any>>(command: string, block?: HTMLElement | boolean, contextChangeOK?: boolean, execOptions?: ExecOptions, nextBlock?: HTMLElement) => Promise<T>;
export declare const qfexec: (command: string, block?: HTMLElement, nextBlock?: HTMLElement, execOptions?: ExecOptions) => Promise<any>;
/**
 * "raw" exec, where we want the data model back directly
 *
 */
export declare const rexec: <Raw extends unknown>(command: string, execOptions?: ExecOptions) => Promise<RawResponse<Raw>>;
/**
 * Evaluate a command and place the result in the current active view for the given tab
 *
 */
export declare const reexec: <T extends KResponse<any>>(command: string, execOptions: ExecOptionsWithUUID) => Promise<T>;
/**
 * Programmatic exec, as opposed to human typing and hitting enter
 *
 */
export declare const pexec: <T extends KResponse<any>>(command: string, execOptions?: ExecOptions) => Promise<T>;
/**
 * Execute a command in response to an in-view click
 *
 */
export declare function click(command: string | (() => Promise<string>), evt: MouseEvent): Promise<void>;
/**
 * Update the executor impl
 *
 */
export declare const setExecutorImpl: (impl: Executor) => void;
/**
 * @return an instance that obeys the REPL interface
 *
 */
export declare function getImpl(tab: Tab): REPL;
