import Tab from '../webapp/tab';
import ExecOptions from '../models/execOptions';
import { CommandLine, CommandOptions, ExecType, KResponse, ParsedOptions } from '../models/command';
export interface CommandStartEvent {
    tab: Tab;
    startTime: number;
    route: string;
    command: string;
    execUUID: string;
    execType: ExecType;
    execOptions: ExecOptions;
    echo: boolean;
    evaluatorOptions: CommandOptions;
    pipeStages: CommandLine['pipeStages'];
}
export declare type ResponseType = 'MultiModalResponse' | 'NavResponse' | 'ScalarResponse' | 'Incomplete' | 'Error';
export interface CommandCompleteEvent<R extends KResponse = KResponse, T extends ResponseType = ResponseType> {
    tab: Tab;
    completeTime: number;
    command: string;
    argvNoOptions: string[];
    parsedOptions: ParsedOptions;
    execOptions: ExecOptions;
    pipeStages: CommandLine['pipeStages'];
    execUUID: string;
    execType: ExecType;
    cancelled: boolean;
    echo: boolean;
    evaluatorOptions: CommandOptions;
    response: R;
    responseType: T;
    historyIdx: number;
}
export declare type CommandStartHandler = (event: CommandStartEvent) => void;
export declare type CommandCompleteHandler<R extends KResponse = KResponse, T extends ResponseType = ResponseType> = (event: CommandCompleteEvent<R, T>) => void;
/** In order to snapshot an event, we'll need to remember just the tab uuid */
export declare type SnapshottedEvent<E extends CommandStartEvent | CommandCompleteEvent> = Omit<E, 'tab'> & {
    tab: E['tab']['uuid'];
};
export interface Notebook {
    apiVersion: 'kui-shell/v1';
    kind: 'Notebook';
    metadata?: {
        name?: string;
        description?: string;
        preferReExecute?: boolean;
    };
}
/** @return wether or not the given `raw` json is an instance of Notebook */
export declare function isNotebook(raw: Record<string, any>): raw is Notebook;
