import { KResponse } from './command';
import CellShould from './CellShould';
interface RadioTable {
    apiVersion: 'kui-shell/v1';
    kind: 'RadioTable';
    title: string;
    header: RadioTableRow;
    body: (RadioTableRow & Selectable)[];
    defaultSelectedIdx: number;
}
export interface RadioTableRow {
    nameIdx?: number;
    cells: RadioTableCell[];
}
export interface Selectable {
    /**
     * Handler for change of selection. This will be interpreted as a
     * Kui command line to be executed when the user clicks on the
     * corresponding row in the UI.
     *
     */
    onSelect: string;
    onSelectExec?: 'qexec' | 'pexec';
}
export declare function radioTableHintsAsCss(cell: RadioTableCell): string;
/** Project the string value of the given `cell` */
export declare function radioTableCellToString(cell: RadioTableCell, useTitle?: boolean): string;
/** Should the cell be rendered with a traffic light badge? */
export declare function cellShouldHaveBadge(cell: RadioTableCell): void | CellShould;
/** Add the hint to the given RadioTableCell */
export declare function radioTableAddHint(row: RadioTableRow, cidx: number, newHints: CellShould[]): void;
export declare type RadioTableCell = string | {
    key?: string;
    value: string;
    /** tooltip? */
    title?: string;
    /** optional hints to improve rendering of the cells */
    hints?: CellShould | CellShould[];
};
export declare function isRadioTable(response: KResponse): response is RadioTable;
export default RadioTable;
