/*
 * Copyright 2018 The Kubernetes Authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
import Debug from 'debug';
const debug = Debug('core/main/headless-support');
debug('loading');
/**
 * This supports commads streaming their output to the console
 *
 * @see repl.ts for use of createOutputStream
 * @see cli.ts for the webapp implementation
 *
 */
export const streamTo = (which) => __awaiter(void 0, void 0, void 0, function* () {
    const [{ clearLine, cursorTo }, { print }] = yield Promise.all([
        import('readline'),
        import('./headless-pretty-print')
    ]);
    const stdout = process[which];
    return (response, killLine) => {
        debug('streaming response', killLine);
        if (killLine) {
            clearLine(stdout, 0);
            cursorTo(stdout, 0, null);
        }
        print(response, which === 'stdout' ? console.log : console.error, process[which]);
        if (!killLine) {
            if (typeof response !== 'string' || !/\n$/.test(response)) {
                if (which === 'stdout') {
                    // why only stdout? a legacy of an earlier bad decision.
                    // see https://github.com/kubernetes-sigs/kui/issues/7297
                    stdout.write('\n');
                }
            }
        }
        return Promise.resolve();
    };
});
//# sourceMappingURL=headless-support.js.map