import { CommandHandler, CommandOverrideHandler, CommandRegistrar, CommandTree, CommandTreeResolution, CatchAllOffer, Command, CommandOptions, KResponse, ParsedOptions } from '../models/command';
import { ExecOptions } from '../models/execOptions';
import { PluginResolver } from '../plugins/resolver';
export declare const setPluginResolver: (_: PluginResolver) => void;
/**
 * Look up a command handler for the given `argv`. This is the main
 * Read part of a REPL.
 *
 */
export declare const read: <T extends KResponse<any>, O extends ParsedOptions>(root: CommandTree, argv: string[], noRetry: boolean, execOptions: ExecOptions, tryCatchalls?: boolean) => Promise<CommandTreeResolution<T, O>>;
/**
 * The model we present to plugins, a `CommandRegistrar`
 *
 */
export declare class ImplForPlugins implements CommandRegistrar {
    protected readonly plugin: string;
    constructor(plugin: string);
    catchall<T extends KResponse, O extends ParsedOptions>(offer: CatchAllOffer, handler: CommandHandler<T, O>, prio?: number, options?: CommandOptions): number;
    listen<T extends KResponse, O extends ParsedOptions>(route: string, handler: CommandHandler<T, O>, options?: CommandOptions): Command<T, O>;
    synonym<T extends KResponse, O extends ParsedOptions>(route: string, handler: CommandHandler<T, O>, master: Command<T, O>, options: CommandOptions): void;
    subtree<T extends KResponse, O extends ParsedOptions>(route: string, options: CommandOptions): Command<T, O>;
    subtreeSynonym<T extends KResponse, O extends ParsedOptions>(route: string, master: Command<T, O>, options?: CommandOptions): void;
    override<T extends KResponse, O extends ParsedOptions>(route: string, fromPlugin: string, overrideHandler: CommandOverrideHandler<T, O>, options?: CommandOptions): Promise<Command<T, O>>;
    find<T extends KResponse, O extends ParsedOptions>(route: string, fromPlugin?: string, noOverride?: boolean): Promise<Command<T, O>>;
}
/**
 * Create a `CommandRegistrar` facade, for use by plugins in
 * registering commands.
 *
 * This method is named "proxy" because it mostly delegates to the
 * underlying implementation, with extra help in:
 *
 * - remembering from which plugin calls to listen emanate.
 * - consolidating the tree model across separately-installed @kui-shell/core
 *
 */
export declare function proxy(plugin: string): CommandRegistrar;
