"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.install = void 0;

var _name = require("@kui-shell/client/config.d/name.json");

var _electron = require("electron");

var _open = _interopRequireDefault(require("./open"));

var _save = _interopRequireDefault(require("./save"));

var _tell = _interopRequireDefault(require("./tell"));

var _notebooks = require("./notebooks");

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

/*
 * Copyright 2017 The Kubernetes Authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// require('electron-is-dev');
const isDev = false;
/**
 * tell the current window to open a new tab
 *
 */

const newTab = () => (0, _tell.default)('tab new');
/**
 * tell the current window to open a new split
 *
 */


const newSplit = () => (0, _tell.default)('split');
/**
 * tell the current window to close the current tab
 *
 */


const closeTab = () => (0, _tell.default)('tab close -A');

const isDarwin = process.platform === 'darwin';
const closeAccelerator = isDarwin ? 'Command+W' : 'Control+Shift+W';

const install = createWindow => {
  if (!isDev) {
    const notebook = _notebooks.openNotebook.bind(undefined, createWindow);

    const notebookMenuItem = (0, _notebooks.clientNotebooksDefinitionToElectron)((0, _notebooks.loadClientNotebooksMenuDefinition)(), notebook);
    const fileMenuItems = [{
      label: 'New Split',
      click: () => newSplit(),
      accelerator: 'CommandOrControl+Y'
    }, {
      label: 'New Tab',
      click: () => newTab(),
      accelerator: 'CommandOrControl+T'
    }, {
      label: 'New Window',
      click: () => createWindow(),
      accelerator: 'CommandOrControl+N'
    }, {
      label: 'Open',
      click: () => (0, _open.default)(createWindow),
      accelerator: 'CommandOrControl+O'
    }, {
      label: 'Open Recent',
      role: 'recentdocuments',
      submenu: [{
        label: 'Clear Recent',
        role: 'clearrecentdocuments' // ibid

      }]
    }, {
      type: 'separator'
    }, {
      label: 'Save as Notebook...',
      click: _save.default,
      accelerator: 'CommandOrControl+S'
    }, {
      type: 'separator'
    }, {
      label: 'Close Tab',
      click: closeTab,
      accelerator: closeAccelerator
    }, {
      role: 'close',
      accelerator: undefined
    }];

    if (process.platform !== 'darwin') {
      fileMenuItems.push({
        type: 'separator'
      });
      fileMenuItems.push({
        role: 'quit'
      });
    }

    const themeMenuItem = {
      label: 'Choose a Theme',
      click: () => {
        try {
          (0, _tell.default)('themes', 'pexec');
        } catch (err) {
          console.log(err);
        }
      }
    };
    const helpMenuItems = [{
      label: `Getting Started with ${_name.productName}`,
      click: () => {
        try {
          (0, _tell.default)('getting started', 'pexec');
        } catch (err) {
          console.log(err);
        }
      }
    }, {
      type: 'separator'
    }, {
      label: 'Report Issue...',

      click() {
        require('electron').shell.openExternal('https://github.com/IBM/kui/issues/new');
      }

    }];
    const fileMenu = [{
      label: 'File',
      submenu: fileMenuItems
    }, {
      label: 'Edit',
      submenu: [{
        role: 'undo'
      }, {
        role: 'redo'
      }, {
        type: 'separator'
      }, {
        role: 'cut'
      }, {
        role: 'copy'
      }, {
        role: 'paste'
      }, {
        role: 'pasteAndMatchStyle'
      }, {
        role: 'delete'
      }, {
        role: 'selectAll'
      }]
    }];
    const viewMenu = [{
      label: 'View',
      submenu: [themeMenuItem, {
        type: 'separator'
      }, {
        accelerator: process.platform === 'darwin' ? 'Meta+R' : 'Shift+CmdOrCtrl+R',
        role: 'reload'
      }, //          { role: 'forcereload' },
      {
        role: 'toggleDevTools'
      }, {
        type: 'separator'
      }, {
        role: 'resetZoom'
      }, {
        role: 'zoomIn'
      }, {
        role: 'zoomOut'
      }, {
        type: 'separator'
      }, {
        role: 'togglefullscreen'
      }]
    }];
    const windowMenu = [{
      role: 'window',
      submenu: [{
        role: 'minimize'
      }, {
        role: 'close',
        accelerator: closeAccelerator
      }]
    }, {
      role: 'help',
      submenu: helpMenuItems
    }];
    const menuTemplate = fileMenu.concat(viewMenu).concat(notebookMenuItem ? [notebookMenuItem] : []).concat(windowMenu);
    const about = {
      label: `About ${_name.productName}`,
      click: () => {
        try {
          (0, _tell.default)('about', 'pexec');
        } catch (err) {
          console.log(err);
        }
      }
    };
    const separator = {
      type: 'separator'
    };
    const submenu = [about, separator, {
      role: 'services',
      submenu: []
    }, separator, {
      role: 'hide'
    }, {
      role: 'hideOthers'
    }, {
      role: 'unhide'
    }, separator, {
      role: 'quit'
    }];

    if (process.platform === 'darwin') {
      menuTemplate.unshift({
        label: _name.productName,
        submenu
      });
    } else {
      // for windows and linux, put About in the Help menu
      helpMenuItems.push({
        type: 'separator'
      });
      helpMenuItems.push(about);
    }

    const menu = _electron.Menu.buildFromTemplate(menuTemplate);

    _electron.Menu.setApplicationMenu(menu);
  }
};

exports.install = install;